/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.neoevent.playerpatch.PlayerKilledEvent;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class StaminaPillagerSkill
extends PassiveSkill {
    protected float regenRate;

    public StaminaPillagerSkill(SkillBuilder<?> builder) {
        super((SkillBuilder<? extends SkillBuilder>)builder);
    }

    @Override
    public void loadDatapackParameters(CompoundTag parameters) {
        super.loadDatapackParameters(parameters);
        this.regenRate = parameters.getFloat("regen_rate");
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void playerKilled(PlayerKilledEvent event, SkillContainer skillContainer) {
        float currentStamina = ((ServerPlayerPatch)event.getPlayerPatch()).getStamina();
        float staminaLoss = ((ServerPlayerPatch)event.getPlayerPatch()).getMaxStamina() - currentStamina;
        ((ServerPlayerPatch)event.getPlayerPatch()).setStamina(currentStamina + Math.min(staminaLoss * this.regenRate * 0.01f, 2.0f));
        event.getKilledEntity().playSound((SoundEvent)EpicFightSounds.STAMINA_PILLAGER_DEATH.get());
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPEntityPairingPacket(event.getKilledEntity().getId(), EntityPairingPacketTypes.STAMINA_PILLAGER_BODY_ASHES), (Entity)event.getKilledEntity(), new CustomPacketPayload[0]);
        SPEntityPairingPacket pairingPacket = new SPEntityPairingPacket(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getId(), EntityPairingPacketTypes.FLASH_WHITE);
        pairingPacket.buffer().writeInt(8);
        pairingPacket.buffer().writeInt(3);
        pairingPacket.buffer().writeInt(6);
        pairingPacket.buffer().writeBoolean(false);
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(pairingPacket, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal(), new CustomPacketPayload[0]);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%.0f", Float.valueOf(this.regenRate)));
        return list;
    }
}

