/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.weaponinnate;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.neoevent.playerpatch.DealDamageEvent;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.weaponinnate.SimpleWeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public class GuillotineAxeSkill
extends SimpleWeaponInnateSkill {
    public GuillotineAxeSkill(SimpleWeaponInnateSkill.Builder builder) {
        super(builder);
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void dealDamagePre(DealDamageEvent.Pre event, SkillContainer skillContainer) {
        if (event.getDamageSource().getAnimation() == Animations.THE_GUILLOTINE) {
            ValueModifier.ResultCalculator executionMinHealth = ValueModifier.calculator();
            GuillotineAxeSkill.getProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Map)this.properties.get(0)).ifPresent(executionMinHealth::attach);
            executionMinHealth.multiply(0.8f);
            float health = event.getTarget().getHealth();
            float baseDamage = (float)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getAttributeValue(Attributes.ATTACK_DAMAGE);
            float modifiedBaseDamage = ((ServerPlayerPatch)event.getPlayerPatch()).getModifiedBaseDamage(baseDamage);
            float executionHealth = executionMinHealth.getResult(modifiedBaseDamage);
            if (health < executionHealth && event.getDamageSource() != null) {
                event.getDamageSource().setExecute();
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getTooltipOnItem(ItemStack itemstack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        ArrayList<Component> list = new ArrayList<Component>();
        ArrayList<CallSite> tooltipArgs = new ArrayList<CallSite>();
        String traslatableText = this.getTranslationKey();
        double itemBaseDamage = ((Player)playerpatch.getOriginal()).getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue();
        HashSet<AttributeModifier> attributeModifiers = new HashSet<AttributeModifier>();
        attributeModifiers.addAll(((Player)playerpatch.getOriginal()).getAttribute(Attributes.ATTACK_DAMAGE).getModifiers());
        attributeModifiers.addAll(CapabilityItem.getAttributeModifiersAsWeapon((Holder<Attribute>)Attributes.ATTACK_DAMAGE, EquipmentSlot.MAINHAND, itemstack, playerpatch));
        for (AttributeModifier modifier : attributeModifiers) {
            itemBaseDamage += modifier.amount();
        }
        ValueModifier.ResultCalculator executionMinHealth = ValueModifier.calculator();
        GuillotineAxeSkill.getProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Map)this.properties.get(0)).ifPresent(executionMinHealth::attach);
        executionMinHealth.multiply(0.8f);
        tooltipArgs.add((CallSite)((Object)(String.valueOf(ChatFormatting.RED) + ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(executionMinHealth.getResult((float)itemBaseDamage)))));
        list.add((Component)Component.translatable((String)traslatableText).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)String.format("[%.0f]", Float.valueOf(this.consumption))).withStyle(ChatFormatting.AQUA)));
        list.add((Component)Component.translatable((String)(traslatableText + ".tooltip"), (Object[])tooltipArgs.toArray(new Object[0])).withStyle(ChatFormatting.DARK_GRAY));
        this.generateTooltipforPhase(list, itemstack, cap, playerpatch, (Map)this.properties.get(0), "Each Strike:");
        return list;
    }
}

