/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import com.mojang.datafixers.util.Pair;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.behavior.AnimatedCombatBehavior;
import yesman.epicfight.world.entity.ai.behavior.MoveToTargetSinkStopInaction;
import yesman.epicfight.world.entity.ai.brain.BrainRecomposer;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class CustomMobPatch<T extends PathfinderMob>
extends MobPatch<T> {
    private final MobPatchReloadListener.CustomMobPatchProvider provider;

    public CustomMobPatch(T original, Faction faction, MobPatchReloadListener.CustomMobPatchProvider provider) {
        super(original, faction);
        this.provider = provider;
    }

    @Override
    protected void initAI() {
        super.initAI();
        boolean useBrain = !((PathfinderMob)this.original).getBrain().availableBehaviorsByPriority.isEmpty();
        CombatBehaviors<CustomMobPatch> combatBehaviors = this.provider.getCombatBehaviorsBuilder().build(this);
        if (useBrain) {
            BrainRecomposer.recomposeBrainByType(((PathfinderMob)this.original).getType(), ((PathfinderMob)this.original).getBrain(), new AnimatedCombatBehavior<CustomMobPatch>(this, combatBehaviors), new MoveToTargetSinkStopInaction());
        } else {
            ((PathfinderMob)this.original).goalSelector.addGoal(0, new AnimatedAttackGoal<CustomMobPatch>(this, combatBehaviors));
            ((PathfinderMob)this.original).goalSelector.addGoal(1, (Goal)new TargetChasingGoal(this, (PathfinderMob)this.getOriginal(), this.provider.getChasingSpeed(), true));
        }
    }

    public void initAttributes() {
        ((PathfinderMob)this.original).getAttribute(EpicFightAttributes.MAX_STRIKES).setBaseValue(this.provider.getAttributeValues().getDouble(EpicFightAttributes.MAX_STRIKES));
        ((PathfinderMob)this.original).getAttribute(EpicFightAttributes.ARMOR_NEGATION).setBaseValue(this.provider.getAttributeValues().getDouble(EpicFightAttributes.ARMOR_NEGATION));
        ((PathfinderMob)this.original).getAttribute(EpicFightAttributes.IMPACT).setBaseValue(this.provider.getAttributeValues().getDouble(EpicFightAttributes.IMPACT));
        ((PathfinderMob)this.original).getAttribute(EpicFightAttributes.STUN_ARMOR).setBaseValue(this.provider.getAttributeValues().getDouble(EpicFightAttributes.STUN_ARMOR));
        if (this.provider.getAttributeValues().containsKey((Object)Attributes.ATTACK_DAMAGE)) {
            ((PathfinderMob)this.original).getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(this.provider.getAttributeValues().getDouble((Object)Attributes.ATTACK_DAMAGE));
        }
    }

    @Override
    public void readData(CompoundTag compound) {
        super.readData(compound);
        this.initAttributes();
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        for (Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> pair : this.provider.getDefaultAnimations()) {
            animator.addLivingAnimation((LivingMotion)pair.getFirst(), (AssetAccessor)pair.getSecond());
        }
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveMobUpdateMotion(considerInaction);
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return this.provider.getStunAnimations().get((Object)stunType);
    }

    @Override
    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        CapabilityItem itemCap = this.getAdvancedHoldingItemCapability(hand);
        if (itemCap.isEmpty()) {
            return this.provider.getHitSound();
        }
        return itemCap.getHitSound();
    }

    @Override
    public SoundEvent getSwingSound(InteractionHand hand) {
        CapabilityItem itemCap = this.getAdvancedHoldingItemCapability(hand);
        if (itemCap.isEmpty()) {
            return this.provider.getSwingSound();
        }
        return itemCap.getSmashingSound();
    }

    @Override
    public HitParticleType getWeaponHitParticle(InteractionHand hand) {
        CapabilityItem itemCap = this.getAdvancedHoldingItemCapability(hand);
        if (itemCap.isEmpty()) {
            return this.provider.getHitParticle();
        }
        return itemCap.getHitParticle();
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float scale = this.provider.getScale();
        return super.getModelMatrix(partialTicks).scale(scale, scale, scale);
    }
}

