/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.StunType;

public abstract class HurtableEntityPatch<T extends LivingEntity>
extends EntityPatch<T> {
    private boolean stunReductionDecreases;
    protected float stunTimeReductionDefault;
    protected float stunTimeReduction;
    protected boolean cancelKnockback;

    public HurtableEntityPatch(T original) {
        super(original);
    }

    protected void updateStunTime() {
        this.cancelKnockback = false;
        if (this.stunReductionDecreases) {
            float stunArmor = this.getStunArmor();
            this.stunTimeReduction -= 0.1f * (1.1f - this.stunTimeReduction * this.stunTimeReduction) * (1.0f - stunArmor / (7.5f + stunArmor));
            if (this.stunTimeReduction < 0.0f) {
                this.stunReductionDecreases = false;
                this.stunTimeReduction = 0.0f;
            }
        } else if (this.stunTimeReduction < this.stunTimeReductionDefault) {
            this.stunTimeReduction += 0.02f * (1.1f - this.stunTimeReduction * this.stunTimeReduction);
            if (this.stunTimeReduction > this.stunTimeReductionDefault) {
                this.stunTimeReduction = this.stunTimeReductionDefault;
            }
        }
    }

    @Override
    public void preTick(EntityTickEvent.Pre event) {
        if (!((LivingEntity)this.original).level().isClientSide()) {
            this.updateStunTime();
        }
    }

    public abstract boolean applyStun(StunType var1, float var2);

    public float getWeight() {
        return (float)((LivingEntity)this.original).getAttributeValue(Attributes.MAX_HEALTH) * 2.0f;
    }

    public float getStunShield() {
        return 0.0f;
    }

    public void setStunShield(float value) {
    }

    public void damageStunShield(float damage, float impact) {
        this.setStunShield(this.getStunShield() - impact);
    }

    public void setStunReductionOnHit(StunType stunType) {
        this.stunReductionDecreases = true;
        if (stunType != StunType.NONE) {
            this.stunTimeReduction += Math.max((1.0f - this.stunTimeReduction) * 0.8f, 0.5f);
            this.stunTimeReduction = Math.min(1.0f, this.stunTimeReduction);
            this.stunReductionDecreases = true;
        }
    }

    public float getStunReduction() {
        return this.stunTimeReduction;
    }

    public void setDefaultStunReduction(EquipmentSlot equipmentslot, ItemStack from, ItemStack to) {
        List<AttributeModifier> modifiersToAdd = CapabilityItem.getAttributeModifiersAsWeapon(EpicFightAttributes.STUN_ARMOR, equipmentslot, to, null);
        List<AttributeModifier> modifiersToRemove = CapabilityItem.getAttributeModifiersAsWeapon(EpicFightAttributes.STUN_ARMOR, equipmentslot, from, null);
        AttributeInstance tempAttr = new AttributeInstance(EpicFightAttributes.STUN_ARMOR, i -> {});
        tempAttr.replaceFrom(((LivingEntity)this.original).getAttribute(EpicFightAttributes.STUN_ARMOR));
        for (AttributeModifier modifier : modifiersToAdd) {
            if (tempAttr.hasModifier(modifier.id())) continue;
            tempAttr.addTransientModifier(modifier);
        }
        for (AttributeModifier modifier : modifiersToRemove) {
            if (!tempAttr.hasModifier(modifier.id())) continue;
            tempAttr.removeModifier(modifier);
        }
        float stunArmor = (float)tempAttr.getValue();
        this.stunReductionDecreases = stunArmor < this.getStunArmor();
        this.stunTimeReductionDefault = stunArmor / (stunArmor + 7.5f);
    }

    public float getStunArmor() {
        AttributeInstance stunArmor = ((LivingEntity)this.original).getAttribute(EpicFightAttributes.STUN_ARMOR);
        return (float)(stunArmor == null ? 0.0 : stunArmor.getValue());
    }

    public EntityState getEntityState() {
        return EntityState.DEFAULT_STATE;
    }

    public boolean shouldCancelKnockback() {
        return this.cancelKnockback;
    }

    public abstract boolean isStunned();

    public void knockBackEntity(Vec3 sourceLocation, float power) {
        double d1 = sourceLocation.x() - ((LivingEntity)this.original).getX();
        double d0 = sourceLocation.z() - ((LivingEntity)this.original).getZ();
        while (d1 * d1 + d0 * d0 < 1.0E-4) {
            d1 = (Math.random() - Math.random()) * 0.01;
            d0 = (Math.random() - Math.random()) * 0.01;
        }
        if ((double)(power = (float)((double)power * (1.0 - ((LivingEntity)this.original).getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)))) > 0.0) {
            ((LivingEntity)this.original).hurtMarked = true;
            ((LivingEntity)this.original).hasImpulse = true;
            Vec3 vec3 = ((LivingEntity)this.original).getDeltaMovement();
            Vec3 vec31 = new Vec3(d1, 0.0, d0).normalize().scale((double)power);
            ((LivingEntity)this.original).setDeltaMovement(vec3.x / 2.0 - vec31.x, ((LivingEntity)this.original).onGround() ? Math.min(0.4, vec3.y / 2.0) : vec3.y, vec3.z / 2.0 - vec31.z);
        }
    }

    public void playSound(Holder<SoundEvent> sound, float pitchModifierMin, float pitchModifierMax) {
        this.playSound((SoundEvent)sound.value(), 1.0f, pitchModifierMin, pitchModifierMax);
    }

    public void playSound(SoundEvent sound, float pitchModifierMin, float pitchModifierMax) {
        this.playSound(sound, 1.0f, pitchModifierMin, pitchModifierMax);
    }

    public void playSound(Holder<SoundEvent> sound, float volume, float pitchModifierMin, float pitchModifierMax) {
        this.playSound((SoundEvent)sound.value(), volume, pitchModifierMin, pitchModifierMax);
    }

    public void playSound(SoundEvent sound, float volume, float pitchModifierMin, float pitchModifierMax) {
        if (sound == null) {
            return;
        }
        float pitch = (((LivingEntity)this.original).getRandom().nextFloat() * 2.0f - 1.0f) * (pitchModifierMax - pitchModifierMin);
        if (!this.isLogicalClient()) {
            ((LivingEntity)this.original).level().playSound(null, ((LivingEntity)this.original).getX(), ((LivingEntity)this.original).getY(), ((LivingEntity)this.original).getZ(), sound, ((LivingEntity)this.original).getSoundSource(), volume, 1.0f + pitch);
        } else {
            ((LivingEntity)this.original).level().playLocalSound(((LivingEntity)this.original).getX(), ((LivingEntity)this.original).getY(), ((LivingEntity)this.original).getZ(), sound, ((LivingEntity)this.original).getSoundSource(), volume, 1.0f + pitch, false);
        }
    }

    @Override
    public boolean overrideRender() {
        return false;
    }
}

