/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector4f;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.ServerAnimator;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.neoevent.EntityRemoveEvent;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.EntitySnapshot;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.model.armature.types.ToolHolderArmature;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.common.AbstractAnimatorControl;
import yesman.epicfight.network.server.SPAnimatorControl;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.registry.entries.EpicFightExpandedEntityDataAccessors;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityDecorations;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.HurtableEntityPatch;
import yesman.epicfight.world.capabilities.item.ArmorCapability;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.data.ExpandedEntityDataAccessor;
import yesman.epicfight.world.entity.data.ExpandedSyncedData;

public abstract class LivingEntityPatch<T extends LivingEntity>
extends HurtableEntityPatch<T> {
    public static final double WEIGHT_CORRECTION = 37.037;
    protected Armature armature;
    protected Animator animator;
    protected EntityState state = EntityState.DEFAULT_STATE;
    protected Vec3 lastAttackPosition;
    protected EpicFightDamageSource epicFightDamageSource;
    protected boolean isLastAttackSuccess;
    protected float lastDealDamage;
    protected AttackResult.ResultType lastAttackResultType;
    protected Entity lastTryHurtEntity;
    protected LivingEntity grapplingTarget;
    protected ExpandedSyncedData expandedSynchedData;
    public LivingMotion currentLivingMotion = LivingMotions.IDLE;
    public LivingMotion currentCompositeMotion = LivingMotions.IDLE;
    protected final Map<InteractionHand, Joint> parentJointOfHands = new HashMap<InteractionHand, Joint>();
    protected final EntityDecorations entityDecorations = new EntityDecorations();

    public LivingEntityPatch(T entity) {
        super(entity);
        if (!this.isFakeEntity()) {
            this.expandedSynchedData = new ExpandedSyncedData(() -> ((LivingEntity)((LivingEntity)this.original)).getId(), !this.isLogicalClient());
            this.registerExpandedEntityDataAccessors(this.expandedSynchedData);
        }
    }

    @Override
    public void onConstructed(EntityEvent.EntityConstructing event) {
        Animator animator;
        this.armature = Armatures.getArmatureFor(this);
        this.animator = animator = EpicFightSharedConstants.getAnimator(this);
        this.initAnimator(animator);
        animator.postInit();
    }

    protected void registerExpandedEntityDataAccessors(ExpandedSyncedData expandedSynchedData) {
        expandedSynchedData.register((Holder<ExpandedEntityDataAccessor<?>>)EpicFightExpandedEntityDataAccessors.AIRBORNE);
        expandedSynchedData.register((Holder<ExpandedEntityDataAccessor<?>>)EpicFightExpandedEntityDataAccessors.ASSASSINATION_RESISTANCE);
        expandedSynchedData.register((Holder<ExpandedEntityDataAccessor<?>>)EpicFightExpandedEntityDataAccessors.STUN_SHIELD);
        expandedSynchedData.register((Holder<ExpandedEntityDataAccessor<?>>)EpicFightExpandedEntityDataAccessors.MAX_STUN_SHIELD);
    }

    protected void initAnimator(Animator animator) {
        animator.getVariables().putSharedVariableWithDefault(AttackAnimation.ATTACK_TRIED_ENTITIES);
        animator.getVariables().putSharedVariableWithDefault(AttackAnimation.ACTUALLY_HIT_ENTITIES);
        animator.getVariables().putSharedVariableWithDefault(ActionAnimation.ACTION_ANIMATION_COORD);
        Armature armature = this.armature;
        if (armature instanceof ToolHolderArmature) {
            ToolHolderArmature toolArmature = (ToolHolderArmature)((Object)armature);
            this.setParentJointOfHand(InteractionHand.MAIN_HAND, toolArmature.rightToolJoint());
            this.setParentJointOfHand(InteractionHand.OFF_HAND, toolArmature.leftToolJoint());
        }
    }

    @Override
    public void onJoinWorld(T entity, EntityJoinLevelEvent event) {
        super.onJoinWorld(entity, event);
        if (entity.getAttributeBaseValue(EpicFightAttributes.WEIGHT) == 0.0) {
            EntityDimensions entityDimensions = entity.getDimensions(net.minecraft.world.entity.Pose.STANDING);
            double weight = (double)(entityDimensions.width() * entityDimensions.height()) * 37.037;
            entity.getAttribute(EpicFightAttributes.WEIGHT).setBaseValue(weight);
        }
    }

    public abstract void updateMotion(boolean var1);

    public Armature getArmature() {
        return this.armature;
    }

    @Override
    public void preTick(EntityTickEvent.Pre event) {
        super.preTick(event);
        if (((LivingEntity)this.original).getHealth() <= 0.0f) {
            ((LivingEntity)this.original).setXRot(0.0f);
            AnimationPlayer animPlayer = ((Animator)this.getAnimator()).getPlayerFor(null);
            if (((LivingEntity)this.original).deathTime >= 19 && !animPlayer.isEmpty() && !animPlayer.isEnd()) {
                --((LivingEntity)this.original).deathTime;
            }
        }
        this.animator.tick();
        if (!this.getEntityState().inaction() && ((LivingEntity)this.original).onGround() && this.isAirborneState()) {
            this.setAirborneState(false);
        }
    }

    @Override
    public void preTickClient(EntityTickEvent.Pre event) {
        this.entityDecorations.tick();
    }

    public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTick) {
        if (pose.hasTransform("Head") && this.armature.hasJoint("Head") && animation.doesHeadRotFollowEntityHead()) {
            float headRotO = ((LivingEntity)this.original).yBodyRotO - ((LivingEntity)this.original).yHeadRotO;
            float headRot = ((LivingEntity)this.original).yBodyRot - ((LivingEntity)this.original).yHeadRot;
            float partialHeadRot = MathUtils.lerpBetween(headRotO, headRot, partialTick);
            OpenMatrix4f toOriginalRotation = new OpenMatrix4f(this.armature.getBoundTransformFor(pose, this.armature.searchJointByName("Head"))).removeScale().removeTranslation().invert();
            Vec3f xAxis = OpenMatrix4f.transform3v(toOriginalRotation, Vec3f.X_AXIS, null);
            Vec3f yAxis = OpenMatrix4f.transform3v(toOriginalRotation, Vec3f.Y_AXIS, null);
            OpenMatrix4f headRotation = OpenMatrix4f.createRotatorDeg(partialHeadRot, yAxis).rotateDeg(-((LivingEntity)this.original).getXRot(), xAxis);
            pose.orElseEmpty("Head").frontResult(JointTransform.fromMatrix(headRotation), OpenMatrix4f::mul);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void entityPairing(SPEntityPairingPacket packet) {
        super.entityPairing(packet);
        if (packet.pairingPacketType().is(EntityPairingPacketTypes.class)) {
            switch (packet.pairingPacketType().toEnum(EntityPairingPacketTypes.class)) {
                case BONEBREAKER_BEGIN: {
                    this.entityDecorations.addDecorationOverlay(EntityDecorations.BONEBREAKER_OVERLAY, new EntityDecorations.DecorationOverlay(this){
                        static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/entity/overlay/crack_level1.png");

                        @Override
                        public RenderType getRenderType() {
                            return EpicFightRenderTypes.overlayModel(TEXTURE);
                        }
                    });
                    break;
                }
                case BONEBREAKER_MAX_STACK: {
                    this.entityDecorations.addDecorationOverlay(EntityDecorations.BONEBREAKER_OVERLAY, new EntityDecorations.DecorationOverlay(this){
                        static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/entity/overlay/crack_level2.png");

                        @Override
                        public RenderType getRenderType() {
                            return EpicFightRenderTypes.overlayModel(TEXTURE);
                        }
                    });
                    break;
                }
                case BONEBREAKER_CLEAR: {
                    this.entityDecorations.removeDecorationOverlay(EntityDecorations.BONEBREAKER_OVERLAY);
                    break;
                }
                case STAMINA_PILLAGER_BODY_ASHES: {
                    this.entityDecorations.addColorModifier(EntityDecorations.STAMINA_PILLAGER_ASHES_COLOR, new EntityDecorations.RenderAttributeModifier<Vector4f>(){

                        @Override
                        public void modifyValue(Vector4f value, float partialTick) {
                            float color;
                            float rotProgression = Mth.clamp((float)(1.0f - ((float)((LivingEntity)LivingEntityPatch.this.original).deathTime + partialTick) / 16.0f), (float)0.0f, (float)1.0f);
                            value.x = color = Mth.clampedLerp((float)0.28f, (float)1.0f, (float)(rotProgression * rotProgression));
                            value.y = color;
                            value.z = color;
                        }
                    });
                    this.entityDecorations.addOverlayCoordModifier(EntityDecorations.STAMINA_PILLAGER_ASHES_OVERLAY, new EntityDecorations.RenderAttributeModifier<Vec2i>(this){

                        @Override
                        public void modifyValue(Vec2i value, float partialTick) {
                            value.x = 0;
                            value.y = 10;
                        }
                    });
                    this.entityDecorations.addParticleGenerator(EntityDecorations.STAMINA_PILLAGER_ASHES_PARTICLE, new EntityDecorations.ParticleGenerator(){

                        @Override
                        public void generateParticles() {
                            OpenMatrix4f boundRootTransform = LivingEntityPatch.this.armature.getBoundTransformFor(LivingEntityPatch.this.animator.getPose(1.0f), LivingEntityPatch.this.armature.rootJoint);
                            Vec3f boundRootPos = boundRootTransform.toTranslationVector().add((float)((LivingEntity)LivingEntityPatch.this.getOriginal()).getX(), (float)((LivingEntity)LivingEntityPatch.this.getOriginal()).getY(), (float)((LivingEntity)LivingEntityPatch.this.getOriginal()).getZ());
                            RandomSource random = ((LivingEntity)LivingEntityPatch.this.original).getRandom();
                            Vec3 lookVec = ((LivingEntity)LivingEntityPatch.this.original).getLookAngle().scale(0.1);
                            for (int i = 0; i < 3; ++i) {
                                ((LivingEntity)LivingEntityPatch.this.original).level().addParticle((ParticleOptions)EpicFightParticles.ASH_DIRECTIONAL.get(), (double)boundRootPos.x + random.nextGaussian() * (double)0.4f, (double)boundRootPos.y + random.nextGaussian() * (double)0.6f, (double)boundRootPos.z + random.nextGaussian() * (double)0.4f, lookVec.x, (double)0.1f, lookVec.z);
                            }
                        }
                    });
                    break;
                }
                case FLASH_WHITE: {
                    final int durationTick = packet.buffer().readInt();
                    final int maxOverlay = packet.buffer().readInt();
                    final int maxBrightness = packet.buffer().readInt();
                    final boolean disableRed = packet.buffer().readBoolean();
                    this.entityDecorations.addOverlayCoordModifier(EntityDecorations.FLASH_WHITE_OVERLAY, new EntityDecorations.RenderAttributeModifier<Vec2i>(this){
                        private int tickCount;

                        @Override
                        public void modifyValue(Vec2i value, float partialTick) {
                            float f = Mth.sin((float)(((float)this.tickCount + partialTick) / ((float)durationTick + 1.0f) * (float)Math.PI)) * (float)maxOverlay;
                            value.x = (int)f;
                            if (disableRed) {
                                value.y = 10;
                            }
                        }

                        @Override
                        public void tick() {
                            ++this.tickCount;
                        }

                        @Override
                        public boolean shouldRemove() {
                            return this.tickCount > durationTick;
                        }
                    });
                    this.entityDecorations.addLightModifier(EntityDecorations.FLASH_WHITE_LIGHT, new EntityDecorations.RenderAttributeModifier<Vec2i>(this){
                        private int tickCount;

                        @Override
                        public void modifyValue(Vec2i value, float partialTick) {
                            float f = Mth.sin((float)(((float)this.tickCount + partialTick) / ((float)durationTick + 1.0f) * (float)Math.PI)) * (float)maxBrightness;
                            value.x += (int)f;
                        }

                        @Override
                        public void tick() {
                            ++this.tickCount;
                        }

                        @Override
                        public boolean shouldRemove() {
                            return this.tickCount > durationTick;
                        }
                    });
                    break;
                }
                case VENGEANCE_OVERLAY: {
                    this.entityDecorations.addColorModifier(EntityDecorations.VENGEANCE_OVERLAY, new EntityDecorations.RenderAttributeModifier<Vector4f>(this){

                        @Override
                        public void modifyValue(Vector4f value, float partialTick) {
                            value.x = 1.0f;
                            value.y = 0.5f;
                            value.z = 0.5f;
                        }
                    });
                    break;
                }
                case VENGEANCE_TARGET_CANCEL: {
                    this.entityDecorations.removeColorModifier(EntityDecorations.VENGEANCE_OVERLAY);
                    break;
                }
            }
        }
    }

    public void onFall(LivingFallEvent event) {
        AssetAccessor<? extends StaticAnimation> fallAnimation;
        if (!((LivingEntity)this.getOriginal()).level().isClientSide() && this.isAirborneState() && (fallAnimation = ((Animator)this.getAnimator()).getLivingAnimation(LivingMotions.LANDING_RECOVERY, this.getHitAnimation(StunType.FALL))) != null) {
            this.playAnimationSynchronized(fallAnimation, 0.0f);
        }
        this.setAirborneState(false);
    }

    public void onDeath(LivingDeathEvent event) {
        ((Animator)this.getAnimator()).playDeathAnimation();
        this.currentLivingMotion = LivingMotions.DEATH;
    }

    public void onRemoved(EntityRemoveEvent event) {
    }

    public void updateEntityState() {
        this.state = this.animator.getEntityState();
    }

    public void updateEntityState(EntityState entityState) {
        this.state = entityState;
    }

    public void cancelItemUse() {
        if (((LivingEntity)this.original).isUsingItem()) {
            ((LivingEntity)this.original).stopUsingItem();
            EventHooks.onUseItemStop((LivingEntity)((LivingEntity)this.original), (ItemStack)((LivingEntity)this.original).getUseItem(), (int)((LivingEntity)this.original).getUseItemRemainingTicks());
        }
    }

    public CapabilityItem getHoldingItemCapability(InteractionHand hand) {
        return EpicFightCapabilities.getItemStackCapability(((LivingEntity)this.original).getItemInHand(hand));
    }

    public CapabilityItem getAdvancedHoldingItemCapability(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return this.getHoldingItemCapability(hand);
        }
        return this.isOffhandItemValid() ? this.getHoldingItemCapability(hand) : CapabilityItem.EMPTY;
    }

    public ItemStack getAdvancedHoldingItemStack(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return ((LivingEntity)this.original).getItemInHand(hand);
        }
        return this.isOffhandItemValid() ? ((LivingEntity)this.original).getItemInHand(hand) : ItemStack.EMPTY;
    }

    public EpicFightDamageSource getDamageSource(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, InteractionHand hand) {
        return EpicFightDamageSources.mobAttack((LivingEntity)this.original).setAnimation(animation).setBaseArmorNegation(this.getArmorNegation(hand)).setBaseImpact(this.getImpact(hand)).setUsedItem(((LivingEntity)this.original).getItemInHand(hand));
    }

    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        return AttackResult.of(this.getEntityState().attackResult(damageSource), amount);
    }

    public AttackResult tryHarm(Entity target, EpicFightDamageSource damagesource, float amount) {
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(target, LivingEntityPatch.class);
        AttackResult result = entitypatch != null ? entitypatch.tryHurt(damagesource, amount) : AttackResult.success(amount);
        return result;
    }

    @Nullable
    @ApiStatus.Internal
    public EpicFightDamageSource getEpicFightDamageSource() {
        return this.epicFightDamageSource;
    }

    protected void setOffhandDamage(InteractionHand hand, ItemStack mainhandItemStack, ItemStack offhandItemStack, boolean offhandValid, Collection<AttributeModifier> mainhandAttributes, Collection<AttributeModifier> offhandAttributes) {
        if (hand == InteractionHand.MAIN_HAND) {
            return;
        }
        ((LivingEntity)this.getOriginal()).setItemInHand(InteractionHand.MAIN_HAND, offhandValid ? offhandItemStack : ItemStack.EMPTY);
        ((LivingEntity)this.getOriginal()).setItemInHand(InteractionHand.OFF_HAND, mainhandItemStack);
        AttributeInstance damageAttributeInstance = ((LivingEntity)this.original).getAttribute(Attributes.ATTACK_DAMAGE);
        mainhandAttributes.forEach(arg_0 -> ((AttributeInstance)damageAttributeInstance).removeModifier(arg_0));
        offhandAttributes.forEach(arg_0 -> ((AttributeInstance)damageAttributeInstance).addTransientModifier(arg_0));
    }

    protected void recoverMainhandDamage(InteractionHand hand, ItemStack mainhandItemStack, ItemStack offhandItemStack, Collection<AttributeModifier> mainhandAttributes, Collection<AttributeModifier> offhandAttributes) {
        if (hand == InteractionHand.MAIN_HAND) {
            return;
        }
        ((LivingEntity)this.getOriginal()).setItemInHand(InteractionHand.MAIN_HAND, mainhandItemStack);
        ((LivingEntity)this.getOriginal()).setItemInHand(InteractionHand.OFF_HAND, offhandItemStack);
        AttributeInstance damageAttributeInstance = ((LivingEntity)this.original).getAttribute(Attributes.ATTACK_DAMAGE);
        offhandAttributes.forEach(arg_0 -> ((AttributeInstance)damageAttributeInstance).removeModifier(arg_0));
        mainhandAttributes.forEach(arg_0 -> ((AttributeInstance)damageAttributeInstance).addTransientModifier(arg_0));
    }

    public void setLastAttackResult(AttackResult attackResult) {
        this.lastAttackResultType = attackResult.resultType;
        this.lastDealDamage = attackResult.damage;
    }

    public void setLastAttackEntity(Entity tryHurtEntity) {
        this.lastTryHurtEntity = tryHurtEntity;
    }

    protected boolean checkLastAttackSuccess(Entity target) {
        boolean success = target.is(this.lastTryHurtEntity);
        this.lastTryHurtEntity = null;
        if (success && !this.isLastAttackSuccess) {
            this.setLastAttackSuccess(true);
        }
        return success;
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        return this.checkLastAttackSuccess(target) ? new AttackResult(this.lastAttackResultType, this.lastDealDamage) : AttackResult.missed(0.0f);
    }

    public float getModifiedBaseDamage(float baseDamage) {
        return baseDamage;
    }

    public boolean onDrop(LivingDropsEvent event) {
        return false;
    }

    @Override
    public float getStunShield() {
        return this.expandedSynchedData.get(EpicFightExpandedEntityDataAccessors.STUN_SHIELD).floatValue();
    }

    @Override
    public void setStunShield(float value) {
        float clamped = Mth.clamp((float)value, (float)0.0f, (float)this.getMaxStunShield());
        this.expandedSynchedData.set(EpicFightExpandedEntityDataAccessors.STUN_SHIELD, Float.valueOf(clamped));
    }

    public float getMaxStunShield() {
        return this.expandedSynchedData.get(EpicFightExpandedEntityDataAccessors.MAX_STUN_SHIELD).floatValue();
    }

    public void setMaxStunShield(float value) {
        float maximized = Math.max(value, 0.0f);
        this.expandedSynchedData.set(EpicFightExpandedEntityDataAccessors.MAX_STUN_SHIELD, Float.valueOf(maximized));
    }

    public int getAssassinationResistance() {
        return this.expandedSynchedData.get(EpicFightExpandedEntityDataAccessors.ASSASSINATION_RESISTANCE);
    }

    public void setExecutionResistance(int value) {
        int maxExecutionResistance = (int)((LivingEntity)this.original).getAttributeValue(EpicFightAttributes.ASSASSINATION_RESISTANCE);
        int minimized = Math.min(maxExecutionResistance, value);
        this.expandedSynchedData.set(EpicFightExpandedEntityDataAccessors.ASSASSINATION_RESISTANCE, minimized);
    }

    @Override
    public float getWeight() {
        return (float)((LivingEntity)this.original).getAttributeValue(EpicFightAttributes.WEIGHT);
    }

    public void rotateTo(float degree, float limit, boolean syncPrevRot) {
        LivingEntity entity = (LivingEntity)this.getOriginal();
        float yRot = Mth.wrapDegrees((float)entity.getYRot());
        float amount = Mth.clamp((float)Mth.wrapDegrees((float)(degree - yRot)), (float)(-limit), (float)limit);
        float f1 = yRot + amount;
        if (syncPrevRot) {
            entity.yRotO = f1;
            entity.yHeadRotO = f1;
            entity.yBodyRotO = f1;
        }
        entity.setYRot(f1);
        entity.yHeadRot = f1;
        entity.yBodyRot = f1;
    }

    public void rotateTo(Entity target, float limit, boolean syncPrevRot) {
        Vec3 playerPosition = ((LivingEntity)this.original).position();
        Vec3 targetPosition = target.position();
        float yaw = (float)MathUtils.getYRotOfVector(targetPosition.subtract(playerPosition));
        this.rotateTo(yaw, limit, syncPrevRot);
    }

    public float getYRotDeltaTo(Entity target) {
        Vec3 playerPosition = ((LivingEntity)this.getOriginal()).position();
        Vec3 targetPosition = target.position();
        float yRotToTarget = (float)MathUtils.getYRotOfVector(targetPosition.subtract(playerPosition));
        float yRotCurrent = Mth.wrapDegrees((float)((LivingEntity)this.getOriginal()).getYRot());
        return Mth.clamp((float)Mth.wrapDegrees((float)(yRotToTarget - yRotCurrent)), (float)(-this.getYRotLimit()), (float)this.getYRotLimit());
    }

    public LivingEntity getTarget() {
        return ((LivingEntity)this.original).getLastHurtMob();
    }

    public float getAttackDirectionPitch(float partialTick) {
        float partialTicks = EpicFightSharedConstants.isPhysicalClient() ? partialTick : 1.0f;
        float pitch = -((LivingEntity)this.getOriginal()).getViewXRot(partialTicks);
        float correct = pitch > 0.0f ? 0.03333f * (float)Math.pow(pitch, 2.0) : -0.03333f * (float)Math.pow(pitch, 2.0);
        return Mth.clamp((float)correct, (float)-30.0f, (float)30.0f);
    }

    public float getCameraXRot() {
        return Mth.wrapDegrees((float)((LivingEntity)this.original).getXRot());
    }

    public float getCameraYRot() {
        return Mth.wrapDegrees((float)((LivingEntity)this.original).getYRot());
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float yRot;
        float yRotO;
        float scale = ((LivingEntity)this.original).isBaby() ? 0.5f : 1.0f;
        Entity entity = ((LivingEntity)this.original).getVehicle();
        if (entity instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)entity;
            yRotO = ridingEntity.yBodyRotO;
            yRot = ridingEntity.yBodyRot;
        } else {
            yRotO = this.isLogicalClient() ? ((LivingEntity)this.original).yBodyRotO : ((LivingEntity)this.original).getYRot();
            yRot = this.isLogicalClient() ? ((LivingEntity)this.original).yBodyRot : ((LivingEntity)this.original).getYRot();
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, yRotO, yRot, partialTicks, scale, scale, scale);
    }

    public void playAnimation(AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier) {
        this.animator.playAnimation(animation, transitionTimeModifier);
    }

    public void playAnimationInstantly(AssetAccessor<? extends StaticAnimation> animation) {
        this.animator.playAnimationInstantly(animation);
        if (!this.isLogicalClient()) {
            this.handleAnimationPayload(new SPAnimatorControl(AbstractAnimatorControl.Action.PLAY_INSTANTLY, animation, this, 0.0f));
        }
    }

    public void reserveAnimation(AssetAccessor<? extends StaticAnimation> animation) {
        this.animator.reserveAnimation(animation);
        if (!this.isLogicalClient()) {
            this.handleAnimationPayload(new SPAnimatorControl(AbstractAnimatorControl.Action.RESERVE, animation, this, 0.0f));
        }
    }

    public void stopPlaying(AssetAccessor<? extends StaticAnimation> animation) {
        this.animator.stopPlaying(animation);
        if (!this.isLogicalClient()) {
            this.handleAnimationPayload(new SPAnimatorControl(AbstractAnimatorControl.Action.STOP, animation, this, -1.0f));
        }
    }

    public void playAnimationSynchronized(AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier) {
        this.animator.playAnimation(animation, transitionTimeModifier);
        if (!this.isLogicalClient()) {
            this.handleAnimationPayload(new SPAnimatorControl(AbstractAnimatorControl.Action.PLAY, animation, this, transitionTimeModifier));
        }
    }

    public void playAnimationInClientSide(AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier) {
        if (this.isLogicalClient()) {
            this.animator.playAnimation(animation, transitionTimeModifier);
        } else {
            this.sendToAllPlayersTrackingMe(new SPAnimatorControl(AbstractAnimatorControl.Action.PLAY, animation, ((LivingEntity)this.original).getId(), transitionTimeModifier, false), new CustomPacketPayload[0]);
        }
    }

    public void playShootingAnimation() {
        this.animator.playShootingAnimation();
        if (!this.isLogicalClient()) {
            this.sendToAllPlayersTrackingMe(new SPAnimatorControl(AbstractAnimatorControl.Action.SHOT, (AssetAccessor<? extends StaticAnimation>)Animations.EMPTY_ANIMATION, ((LivingEntity)this.original).getId(), 0.0f, false), new CustomPacketPayload[0]);
        }
    }

    private void handleAnimationPayload(SPAnimatorControl payload) {
        if (this.isLogicalClient()) {
            throw new IllegalStateException("Cannot send animation sync payload in client side.");
        }
        switch (payload.action()) {
            case SOFT_PAUSE: 
            case HARD_PAUSE: {
                throw new UnsupportedOperationException("Only PLAY, PLAY_INSTANTLY, STOP and RESERVE are allowed");
            }
        }
        if (payload.action().syncVariables()) {
            payload.animationVariables().addAll(((Animator)this.getAnimator()).getVariables().createPendingVariablesPayloads(payload.animation()));
        }
        this.sendToAllPlayersTrackingMe(payload, new CustomPacketPayload[0]);
    }

    public void pauseAnimator(AbstractAnimatorControl.Action action, boolean pause) {
        switch (action) {
            case SOFT_PAUSE: {
                this.animator.setSoftPause(pause);
                break;
            }
            case HARD_PAUSE: {
                this.animator.setHardPause(pause);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only SOFT_PAUSE and HARD_PAUSE are allowed");
            }
        }
        if (!this.isLogicalClient()) {
            this.sendToAllPlayersTrackingMe(new SPAnimatorControl(action, (AssetAccessor<? extends StaticAnimation>)Animations.EMPTY_ANIMATION, ((LivingEntity)this.original).getId(), 0.0f, pause), new CustomPacketPayload[0]);
        }
    }

    public void sendToAllPlayersTrackingMe(CustomPacketPayload packet, CustomPacketPayload ... others) {
        if (!this.isLogicalClient()) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(packet, this.original, others);
        }
    }

    public void resetSize(EntityDimensions size) {
        EntityDimensions entitysize1;
        EntityDimensions entitysize = ((LivingEntity)this.original).dimensions;
        ((LivingEntity)this.original).dimensions = entitysize1 = size;
        if (entitysize1.width() < entitysize.width()) {
            double d0 = (double)entitysize1.width() / 2.0;
            ((LivingEntity)this.original).setBoundingBox(new AABB(((LivingEntity)this.original).getX() - d0, ((LivingEntity)this.original).getY(), ((LivingEntity)this.original).getZ() - d0, ((LivingEntity)this.original).getX() + d0, ((LivingEntity)this.original).getY() + (double)entitysize1.height(), ((LivingEntity)this.original).getZ() + d0));
        } else {
            AABB axisalignedbb = ((LivingEntity)this.original).getBoundingBox();
            ((LivingEntity)this.original).setBoundingBox(new AABB(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ, axisalignedbb.minX + (double)entitysize1.width(), axisalignedbb.minY + (double)entitysize1.height(), axisalignedbb.minZ + (double)entitysize1.width()));
            if (entitysize1.width() > entitysize.width() && !((LivingEntity)this.original).level().isClientSide()) {
                float f = entitysize.width() - entitysize1.width();
                ((LivingEntity)this.original).move(MoverType.SELF, new Vec3((double)f, 0.0, (double)f));
            }
        }
    }

    @Override
    public boolean applyStun(StunType stunType, float stunTime) {
        ((LivingEntity)this.original).xxa = 0.0f;
        ((LivingEntity)this.original).yya = 0.0f;
        ((LivingEntity)this.original).zza = 0.0f;
        ((LivingEntity)this.original).setDeltaMovement(0.0, 0.0, 0.0);
        this.cancelKnockback = true;
        AssetAccessor<StaticAnimation> hitAnimation = this.getHitAnimation(stunType);
        if (hitAnimation != null) {
            this.playAnimationSynchronized(hitAnimation, stunType.hasFixedStunTime() ? 0.0f : stunTime);
            return true;
        }
        return false;
    }

    public void beginAction(ActionAnimation animation) {
    }

    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, InteractionHand hand) {
    }

    public void updateArmor(ArmorCapability fromCap, ArmorCapability toCap, EquipmentSlot slotType) {
    }

    public void onAttackBlocked(DamageSource damageSource, LivingEntityPatch<?> blocker) {
    }

    public void onStrike(AttackAnimation animation, InteractionHand hand) {
        this.getAdvancedHoldingItemCapability(hand).onStrike(this, animation);
    }

    public void onMount(boolean isMountOrDismount, Entity ridingEntity) {
    }

    public void notifyGrapplingWarning() {
    }

    public void onDodgeSuccess(DamageSource damageSource, Vec3 location) {
    }

    public void countHurtTime(float damageTaken) {
        ((LivingEntity)this.original).lastHurt = damageTaken;
        ((LivingEntity)this.original).invulnerableTime = 20;
        ((LivingEntity)this.original).hurtTime = ((LivingEntity)this.original).hurtDuration = 10;
    }

    @Override
    public boolean isStunned() {
        return this.getEntityState().hurt();
    }

    public <A extends Animator> A getAnimator() {
        return (A)this.animator;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ClientAnimator getClientAnimator() {
        return (ClientAnimator)this.getAnimator();
    }

    public ServerAnimator getServerAnimator() {
        return (ServerAnimator)this.getAnimator();
    }

    public abstract AssetAccessor<? extends StaticAnimation> getHitAnimation(StunType var1);

    public void aboutToDeath() {
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getHitSound();
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        CapabilityItem itemCap = this.getAdvancedHoldingItemCapability(hand);
        return this.entityDecorations.getModifiedSwingSound(itemCap.getSmashingSound(), itemCap);
    }

    public HitParticleType getWeaponHitParticle(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getHitParticle();
    }

    public Collider getColliderMatching(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getWeaponCollider();
    }

    public int getMaxStrikes(InteractionHand hand) {
        return (int)(hand == InteractionHand.MAIN_HAND ? ((LivingEntity)this.original).getAttributeValue(EpicFightAttributes.MAX_STRIKES) : (this.isOffhandItemValid() ? ((LivingEntity)this.original).getAttributeValue(EpicFightAttributes.OFFHAND_MAX_STRIKES) : ((LivingEntity)this.original).getAttribute(EpicFightAttributes.MAX_STRIKES).getBaseValue()));
    }

    public float getArmorNegation(InteractionHand hand) {
        return (float)(hand == InteractionHand.MAIN_HAND ? ((LivingEntity)this.original).getAttributeValue(EpicFightAttributes.ARMOR_NEGATION) : (this.isOffhandItemValid() ? ((LivingEntity)this.original).getAttributeValue(EpicFightAttributes.OFFHAND_ARMOR_NEGATION) : ((LivingEntity)this.original).getAttribute(EpicFightAttributes.ARMOR_NEGATION).getBaseValue()));
    }

    public float getImpact(InteractionHand hand) {
        float impact;
        int i = 0;
        if (hand == InteractionHand.MAIN_HAND) {
            impact = (float)((LivingEntity)this.original).getAttributeValue(EpicFightAttributes.IMPACT);
            i = ((LivingEntity)this.getOriginal()).getMainHandItem().getEnchantmentLevel(this.getLevel().registryAccess().holderOrThrow(Enchantments.KNOCKBACK));
        } else if (this.isOffhandItemValid()) {
            impact = (float)((LivingEntity)this.original).getAttributeValue(EpicFightAttributes.OFFHAND_IMPACT);
            i = ((LivingEntity)this.getOriginal()).getOffhandItem().getEnchantmentLevel(this.getLevel().registryAccess().holderOrThrow(Enchantments.KNOCKBACK));
        } else {
            impact = (float)((LivingEntity)this.original).getAttribute(EpicFightAttributes.IMPACT).getBaseValue();
        }
        return impact * (1.0f + (float)i * 0.12f);
    }

    public float getReach(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getReach();
    }

    public ItemStack getValidItemInHand(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return ((LivingEntity)this.original).getItemInHand(hand);
        }
        return this.isOffhandItemValid() ? ((LivingEntity)this.original).getItemInHand(hand) : ItemStack.EMPTY;
    }

    public boolean isOffhandItemValid() {
        return this.getHoldingItemCapability(InteractionHand.MAIN_HAND).checkOffhandValid(this);
    }

    public Joint getParentJointOfHand(InteractionHand hand) {
        return this.parentJointOfHands.getOrDefault(hand, this.armature.rootJoint);
    }

    public void setParentJointOfHand(InteractionHand hand, Joint joint) {
        this.parentJointOfHands.put(hand, joint);
    }

    public boolean isTargetInvulnerable(Entity target) {
        if (!target.isPickable() || target.isSpectator()) {
            return true;
        }
        if (((LivingEntity)this.original).getRootVehicle() == target.getRootVehicle() && !target.canRiderInteract()) {
            return true;
        }
        return ((LivingEntity)this.original).isAlliedTo(target) && ((LivingEntity)this.original).getTeam() != null && !((LivingEntity)this.original).getTeam().isAllowFriendlyFire();
    }

    public boolean canPush(Entity entity) {
        EntityState state;
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
        if (entitypatch != null && (state = entitypatch.getEntityState()).inaction()) {
            return false;
        }
        EntityState thisState = this.getEntityState();
        return !thisState.inaction() && !entity.is((Entity)this.grapplingTarget);
    }

    public LivingEntity getGrapplingTarget() {
        return this.grapplingTarget;
    }

    public void setGrapplingTarget(LivingEntity grapplingTarget) {
        this.grapplingTarget = grapplingTarget;
    }

    public Vec3 getLastAttackPosition() {
        return this.lastAttackPosition;
    }

    public void setLastAttackPosition() {
        this.lastAttackPosition = ((LivingEntity)this.original).position();
    }

    public void setAirborneState(boolean flag) {
        this.expandedSynchedData.set(EpicFightExpandedEntityDataAccessors.AIRBORNE, flag);
    }

    public boolean isAirborneState() {
        return this.expandedSynchedData.get(EpicFightExpandedEntityDataAccessors.AIRBORNE);
    }

    public void setLastAttackSuccess(boolean setter) {
        this.isLastAttackSuccess = setter;
    }

    public boolean isLastAttackSuccess() {
        return this.isLastAttackSuccess;
    }

    public boolean shouldMoveOnCurrentSide(ActionAnimation actionAnimation) {
        return !this.isLogicalClient();
    }

    public boolean isFirstPerson() {
        return false;
    }

    @Override
    public boolean overrideRender() {
        return true;
    }

    public boolean shouldBlockMoving() {
        return false;
    }

    public float getYRotLimit() {
        return 20.0f;
    }

    public double getXOld() {
        return ((LivingEntity)this.original).xOld;
    }

    public double getYOld() {
        return ((LivingEntity)this.original).yOld;
    }

    public double getZOld() {
        return ((LivingEntity)this.original).zOld;
    }

    public float getYRot() {
        return ((LivingEntity)this.original).getYRot();
    }

    public float getYRotO() {
        return ((LivingEntity)this.original).yRotO;
    }

    public void setYRot(float yRot) {
        ((LivingEntity)this.original).setYRot(yRot);
        if (this.isLogicalClient()) {
            ((LivingEntity)this.original).yBodyRot = yRot;
            ((LivingEntity)this.original).yHeadRot = yRot;
        }
    }

    public void setYRotO(float yRot) {
        ((LivingEntity)this.original).yRotO = yRot;
        if (this.isLogicalClient()) {
            ((LivingEntity)this.original).yBodyRotO = yRot;
            ((LivingEntity)this.original).yHeadRotO = yRot;
        }
    }

    @Override
    public EntityState getEntityState() {
        return this.state;
    }

    public InteractionHand getAttackingHand() {
        Pair<AnimationPlayer, AttackAnimation> layerInfo = ((Animator)this.getAnimator()).findFor(AttackAnimation.class);
        if (layerInfo != null) {
            return ((AttackAnimation)layerInfo.getSecond()).getPhaseByTime((float)((AnimationPlayer)layerInfo.getFirst()).getElapsedTime()).hand;
        }
        return null;
    }

    public LivingMotion getCurrentLivingMotion() {
        return this.currentLivingMotion;
    }

    public List<Entity> getCurrentlyAttackTriedEntities() {
        return ((Animator)this.getAnimator()).getVariables().getOrDefaultSharedVariable(AttackAnimation.ATTACK_TRIED_ENTITIES);
    }

    public List<LivingEntity> getCurrentlyActuallyHitEntities() {
        return ((Animator)this.getAnimator()).getVariables().getOrDefaultSharedVariable(AttackAnimation.ACTUALLY_HIT_ENTITIES);
    }

    public void removeHurtEntities() {
        ((Animator)this.getAnimator()).getVariables().getOrDefaultSharedVariable(AttackAnimation.ATTACK_TRIED_ENTITIES).clear();
        ((Animator)this.getAnimator()).getVariables().getOrDefaultSharedVariable(AttackAnimation.ACTUALLY_HIT_ENTITIES).clear();
    }

    public abstract Faction getFaction();

    public final ExpandedSyncedData getExpandedSynchedData() {
        return this.expandedSynchedData;
    }

    public EntityDecorations getEntityDecorations() {
        return this.entityDecorations;
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntitySnapshot<?> captureEntitySnapshot() {
        return EntitySnapshot.captureLivingEntity(this);
    }
}

