/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedDragonPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedPhases;

public class DragonFlyingPhase
extends PatchedDragonPhase {
    private Path currentPath;
    private Vec3 targetLocation;
    private boolean clockwise;
    private boolean executeAirstrike;

    public DragonFlyingPhase(EnderDragon p_31230_) {
        super(p_31230_);
    }

    public EnderDragonPhase<DragonFlyingPhase> getPhase() {
        return PatchedPhases.FLYING;
    }

    public void doServerTick() {
        double d0;
        double d = d0 = this.targetLocation == null ? 0.0 : this.targetLocation.distanceToSqr(this.dragon.getX(), this.dragon.getY(), this.dragon.getZ());
        if (d0 < 100.0 || d0 > 22500.0 || this.dragon.horizontalCollision || this.dragon.verticalCollision && this.dragon.getDragonFight() != null) {
            this.findNewTarget();
        }
    }

    public void begin() {
        this.currentPath = null;
        this.targetLocation = null;
    }

    @Nullable
    public Vec3 getFlyTargetLocation() {
        return this.dragonpatch.getEntityState().inaction() ? null : this.targetLocation;
    }

    public void enableAirstrike() {
        this.executeAirstrike = false;
    }

    private void findNewTarget() {
        if (this.currentPath != null && this.currentPath.isDone()) {
            List<Player> players = this.getPlayersNearbyWithin(100.0);
            for (Player player : players) {
                if (!DragonFlyingPhase.isValidTarget((LivingEntity)player)) continue;
                if (!this.executeAirstrike && this.dragon.getRandom().nextFloat() > (float)this.dragonpatch.getNearbyCrystals() * 0.1f) {
                    if (DragonFlyingPhase.isInEndSpikes((LivingEntity)player)) {
                        this.executeAirstrike = true;
                    }
                    this.dragonpatch.setAttakTargetSync((LivingEntity)player);
                    this.dragon.getPhaseManager().setPhase(PatchedPhases.AIRSTRIKE);
                } else if (DragonFlyingPhase.isInEndSpikes((LivingEntity)player)) {
                    this.dragon.getPhaseManager().setPhase(PatchedPhases.LANDING);
                }
                return;
            }
        }
        if (this.currentPath == null || this.currentPath.isDone()) {
            int j;
            int k = j = this.dragon.findClosestNode();
            if (this.dragon.getRandom().nextInt(8) == 0) {
                this.clockwise = !this.clockwise;
                k = j + 6;
            }
            k = this.clockwise ? ++k : --k;
            if (this.dragon.getDragonFight() != null && this.dragonpatch.getNearbyCrystals() >= 0) {
                if ((k %= 12) < 0) {
                    k += 12;
                }
            } else {
                k -= 12;
                k &= 7;
                k += 12;
            }
            this.currentPath = this.dragon.findPath(j, k, null);
            if (this.currentPath != null) {
                this.currentPath.advance();
            }
        }
        this.navigateToNextPathNode();
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.isDone()) {
            double d2;
            BlockPos vec3i = this.currentPath.getNextNodePos();
            this.currentPath.advance();
            double d0 = vec3i.getX();
            double d1 = vec3i.getZ();
            while ((d2 = (double)((float)vec3i.getY() + this.dragon.getRandom().nextFloat() * 20.0f)) < (double)vec3i.getY()) {
            }
            this.targetLocation = new Vec3(d0, d2, d1);
        }
    }
}

