/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonPhaseInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;

public abstract class PatchedDragonPhase
extends AbstractDragonPhaseInstance {
    protected final EnderDragonPatch dragonpatch;

    public PatchedDragonPhase(EnderDragon dragon) {
        super(dragon);
        this.dragonpatch = EpicFightCapabilities.getEntityPatch((Entity)dragon, EnderDragonPatch.class);
    }

    public void doClientTick() {
        this.dragon.oFlapTime = 0.5f;
        this.dragon.flapTime = 0.5f;
    }

    protected static boolean isValidTarget(LivingEntity entity) {
        return entity.canBeSeenAsEnemy();
    }

    protected static boolean isInEndSpikes(LivingEntity entity) {
        BlockPos blockpos = entity.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.getLocation((BlockPos)new BlockPos(0, 0, 0)));
        return blockpos.distSqr((Vec3i)new BlockPos.MutableBlockPos(entity.getX(), (double)blockpos.getY(), entity.getZ())) < 2000.0;
    }

    protected List<Player> getPlayersNearbyWithin(double within) {
        return this.dragon.level().getNearbyPlayers(EnderDragonPatch.DRAGON_TARGETING, (LivingEntity)this.dragon, this.dragon.getBoundingBox().inflate(within, within, within));
    }
}

