/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public class ArmorCapability
extends CapabilityItem {
    protected final double weight;
    protected final double stunArmor;
    protected final ArmorItem.Type armorType;

    protected ArmorCapability(Builder builder) {
        super(builder);
        this.armorType = builder.armorType;
        this.weight = builder.weight;
        this.stunArmor = builder.stunArmor;
    }

    @Override
    public void modifyItemTooltip(ItemStack stack, List<Component> itemTooltip, LivingEntityPatch<?> entitypatch) {
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiersForArmor() {
        HashMultimap map = HashMultimap.create();
        ResourceLocation modifierId = ResourceLocation.withDefaultNamespace((String)("armor." + this.armorType.getName()));
        map.put(EpicFightAttributes.WEIGHT, (Object)new AttributeModifier(modifierId, this.weight, AttributeModifier.Operation.ADD_VALUE));
        map.put(EpicFightAttributes.STUN_ARMOR, (Object)new AttributeModifier(modifierId, this.stunArmor, AttributeModifier.Operation.ADD_VALUE));
        return map;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends CapabilityItem.Builder<Builder> {
        private ArmorItem.Type armorType;
        private double weight;
        private double stunArmor;

        protected Builder() {
            this.constructor = ArmorCapability::new;
            this.weight = -1.0;
            this.stunArmor = -1.0;
        }

        public Builder byItem(Item item) {
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                Holder armorMaterial = armorItem.getMaterial();
                this.armorType = armorItem.getType();
                if (this.weight < 0.0) {
                    this.weight = (float)((ArmorMaterial)armorMaterial.value()).defense().getOrDefault(this.armorType, 1).intValue() * 2.5f;
                }
                if (this.stunArmor < 0.0) {
                    this.stunArmor = (float)((ArmorMaterial)armorMaterial.value()).defense().getOrDefault(this.armorType, 1).intValue() * 0.375f;
                }
            }
            return this;
        }

        public Builder weight(double weight) {
            this.weight = weight;
            return this;
        }

        public Builder stunArmor(double stunArmor) {
            this.stunArmor = stunArmor;
            return this;
        }
    }
}

