/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.skill;

import com.google.common.collect.HashMultimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.registry.EpicFightRegistries;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class PlayerSkills {
    public static final PlayerSkills EMPTY = new PlayerSkills(null);
    public final SkillContainer[] skillContainers;
    private final Map<Skill, SkillContainer> containersBySkill = new HashMap<Skill, SkillContainer>();
    private final HashMultimap<SkillCategory, SkillContainer> containersByCategory = HashMultimap.create();
    private final HashMultimap<SkillCategory, Skill> learnedSkills = HashMultimap.create();

    public PlayerSkills(PlayerPatch<?> playerpatch) {
        Collection<SkillSlot> slots = SkillSlot.ENUM_MANAGER.universalValues();
        this.skillContainers = new SkillContainer[slots.size()];
        for (SkillSlot slot : slots) {
            SkillContainer skillContainer;
            this.skillContainers[slot.universalOrdinal()] = skillContainer = new SkillContainer(playerpatch, slot);
            this.containersByCategory.put((Object)slot.category(), (Object)skillContainer);
        }
    }

    public void addLearnedSkill(Skill skill) {
        SkillCategory category = skill.getCategory();
        if (!this.learnedSkills.containsKey((Object)category) || !this.learnedSkills.get((Object)category).contains(skill)) {
            this.learnedSkills.put((Object)category, (Object)skill);
        }
    }

    public boolean removeLearnedSkill(Skill skill) {
        SkillCategory category = skill.getCategory();
        if (this.learnedSkills.containsKey((Object)category) && this.learnedSkills.remove((Object)category, (Object)skill)) {
            if (this.learnedSkills.get((Object)category).isEmpty()) {
                this.learnedSkills.removeAll((Object)category);
            }
            return true;
        }
        return false;
    }

    public boolean hasCategory(SkillCategory skillCategory) {
        return this.learnedSkills.containsKey((Object)skillCategory);
    }

    public boolean hasEmptyContainer(SkillCategory skillCategory) {
        for (SkillContainer container : this.containersByCategory.get((Object)skillCategory)) {
            if (!container.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public SkillContainer getFirstEmptyContainer(SkillCategory skillCategory) {
        for (SkillContainer container : this.containersByCategory.get((Object)skillCategory)) {
            if (!container.isEmpty()) continue;
            return container;
        }
        return null;
    }

    public boolean isEquipping(Skill skill) {
        return this.containersBySkill.containsKey(skill);
    }

    public boolean hasLearned(Skill skill) {
        return this.learnedSkills.get((Object)skill.getCategory()).contains(skill);
    }

    public Set<SkillContainer> getSkillContainersFor(SkillCategory skillCategory) {
        return this.containersByCategory.get((Object)skillCategory);
    }

    public SkillContainer getSkillContainerFor(SkillSlot skillSlot) {
        return this.getSkillContainerFor(skillSlot.universalOrdinal());
    }

    public SkillContainer getSkillContainerFor(int slotIndex) {
        return this.skillContainers[slotIndex];
    }

    @ApiStatus.Internal
    public void setSkillToContainer(Skill skill, SkillContainer container) {
        this.containersBySkill.put(skill, container);
    }

    @ApiStatus.Internal
    public void removeSkillFromContainer(Skill skill) {
        this.containersBySkill.remove(skill);
    }

    public SkillContainer getSkillContainer(Skill skill) {
        return this.containersBySkill.get(skill);
    }

    public Stream<SkillContainer> listSkillContainers() {
        return Stream.of(this.skillContainers);
    }

    public Stream<Skill> listAcquiredSkills() {
        return this.learnedSkills.values().stream();
    }

    public void clearContainersAndLearnedSkills(boolean isLocalOrServerPlayer) {
        for (SkillContainer container : this.skillContainers) {
            if (!container.getSlot().category().learnable()) continue;
            if (isLocalOrServerPlayer) {
                container.setSkill(null);
                container.setReplaceCooldown(0);
                continue;
            }
            container.setSkillRemote(null);
            container.setReplaceCooldown(0);
        }
        this.learnedSkills.clear();
    }

    public void copyFrom(PlayerSkills capabilitySkill) {
        int i = 0;
        for (SkillContainer container : this.skillContainers) {
            Skill oldone = capabilitySkill.skillContainers[i].getSkill();
            if (oldone != null && oldone.getCategory().shouldSynchronize()) {
                container.setSkill(capabilitySkill.skillContainers[i].getSkill());
                container.setReplaceCooldown(capabilitySkill.skillContainers[i].getReplaceCooldown());
            }
            ++i;
        }
        this.learnedSkills.putAll(capabilitySkill.learnedSkills);
    }

    public <T extends Event> T fireSkillEvents(String caller, T event) {
        ArrayList<Pair> subscribers = new ArrayList<Pair>();
        for (SkillContainer skillContainer : this.skillContainers) {
            Skill.SkillEventSubscriber skillEventSubscriber;
            Skill skill = skillContainer.getSkill();
            if (skill == null || (skillEventSubscriber = skill.getSkillEvent(caller, event.getClass(), skillContainer.getExecutor().isLogicalClient())) == null) continue;
            subscribers.add(Pair.of((Object)skillContainer, (Object)skillEventSubscriber));
        }
        subscribers.stream().sorted((p1, p2) -> ((Skill.SkillEventSubscriber)p2.getSecond()).compareTo((Skill.SkillEventSubscriber)p1.getSecond())).forEach(subscriber -> ((Skill.SkillEventSubscriber)subscriber.getSecond()).eventSubscriber().accept(event, (SkillContainer)subscriber.getFirst()));
        return event;
    }

    public CompoundTag write(CompoundTag compound) {
        CompoundTag skillCompound = new CompoundTag();
        for (SkillContainer container : this.skillContainers) {
            if (container.getSkill() == null || !container.getSkill().getCategory().shouldSave()) continue;
            skillCompound.putString(ParseUtil.toLowerCase(container.getSlot().toString()), container.getSkill().toString());
        }
        for (Map.Entry entry : this.learnedSkills.asMap().entrySet()) {
            CompoundTag learnedNBT = new CompoundTag();
            int i = 0;
            for (Skill skill : (Collection)entry.getValue()) {
                learnedNBT.putString(String.valueOf(i++), skill.toString());
            }
            skillCompound.put("learned:" + ParseUtil.toLowerCase(((SkillCategory)entry.getKey()).toString()), (Tag)learnedNBT);
        }
        skillCompound.putString("playerMode", this.skillContainers[0].getExecutor().getPlayerMode().toString());
        compound.put("playerSkills", (Tag)skillCompound);
        return compound;
    }

    public void read(CompoundTag compound) {
        CompoundTag skillCompound = compound.getCompound("playerSkills");
        for (SkillContainer container : this.skillContainers) {
            String key = ParseUtil.toLowerCase(container.getSlot().toString());
            if (!skillCompound.contains(key)) continue;
            EpicFightRegistries.SKILL.getHolder(ResourceLocation.parse((String)skillCompound.getString(key))).ifPresent(skill -> {
                container.setSkill((Skill)skill.value());
                this.addLearnedSkill((Skill)skill.value());
            });
        }
        for (SkillCategory category : SkillCategory.ENUM_MANAGER.universalValues()) {
            if (!skillCompound.contains("learned:" + ParseUtil.toLowerCase(category.toString()))) continue;
            CompoundTag learnedNBT = skillCompound.getCompound("learned:" + ParseUtil.toLowerCase(category.toString()));
            for (String key : learnedNBT.getAllKeys()) {
                EpicFightRegistries.SKILL.getHolder(ResourceLocation.parse((String)learnedNBT.getString(key))).ifPresent(skill -> this.addLearnedSkill((Skill)skill.value()));
            }
        }
        if (skillCompound.contains("playerMode")) {
            this.skillContainers[0].getExecutor().toMode(PlayerPatch.PlayerMode.valueOf(ParseUtil.toUpperCase(skillCompound.getString("playerMode"))), true);
        } else {
            this.skillContainers[0].getExecutor().toEpicFightMode(true);
        }
    }
}

