/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.function.BiConsumer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.neoevent.playerpatch.PlayerPatchEvent;
import yesman.epicfight.api.neoevent.playerpatch.StartActionEvent;
import yesman.epicfight.api.utils.datastructure.ParameterizedHashMap;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class MainFrameAnimation
extends StaticAnimation {
    public MainFrameAnimation(float convertTime, AnimationManager.AnimationAccessor<? extends MainFrameAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(convertTime, false, accessor, armature);
    }

    public MainFrameAnimation(float convertTime, String path, AssetAccessor<? extends Armature> armature) {
        super(convertTime, false, path, armature);
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        if (((Animator)entitypatch.getAnimator()).getPlayerFor(null).getAnimation().get() == this) {
            ParameterizedHashMap<EntityState.StateFactor<?>> stateMap = this.stateSpectrum.getStateMap(entitypatch, 0.0f);
            ParameterizedHashMap modifiedStateMap = new ParameterizedHashMap();
            stateMap.forEach((BiConsumer<EntityState.StateFactor<?>, Object>)((BiConsumer<EntityState.StateFactor, Object>)(k, v) -> modifiedStateMap.put((EntityState.StateFactor<?>)k, this.getModifiedLinkState((EntityState.StateFactor<?>)k, v, entitypatch, 0.0f))));
            entitypatch.updateEntityState(new EntityState(modifiedStateMap));
        }
        if (entitypatch.isLogicalClient()) {
            entitypatch.updateMotion(false);
            this.getProperty(AnimationProperty.StaticAnimationProperty.RESET_LIVING_MOTION).ifPresentOrElse(livingMotion -> entitypatch.getClientAnimator().forceResetBeforeAction((LivingMotion)livingMotion, (LivingMotion)livingMotion), () -> {
                entitypatch.getClientAnimator().resetMotion(true);
                entitypatch.getClientAnimator().resetCompositeMotion();
            });
            entitypatch.getClientAnimator().getPlayerFor(this.getAccessor()).setReversed(false);
        }
        super.begin(entitypatch);
        if (entitypatch instanceof PlayerPatch) {
            PlayerPatch playerpatch = (PlayerPatch)entitypatch;
            if (playerpatch.isLogicalClient()) {
                if (((Player)playerpatch.getOriginal()).isLocalPlayer()) {
                    PlayerPatchEvent.postAndFireSkillListeners(new StartActionEvent(playerpatch, this.getAccessor()));
                }
            } else {
                StartActionEvent startActionEvent = PlayerPatchEvent.postAndFireSkillListeners(new StartActionEvent(playerpatch, this.getAccessor()));
                if (startActionEvent.shouldResetActionTick()) {
                    playerpatch.resetActionTick();
                }
            }
        }
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        ((LivingEntity)entitypatch.getOriginal()).walkAnimation.setSpeed(0.0f);
    }

    @Override
    public boolean isMainFrameAnimation() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Layer.Priority getPriority() {
        return this.getProperty(ClientAnimationProperties.PRIORITY).orElse(Layer.Priority.HIGHEST);
    }
}

