/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.online;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SoftBodyTranslatable;
import yesman.epicfight.api.client.online.EpicFightServerConnectionHelper;
import yesman.epicfight.api.client.online.RemoteAssets;
import yesman.epicfight.api.client.physics.cloth.ClothColliderPresets;
import yesman.epicfight.api.client.physics.cloth.ClothSimulator;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.widgets.ColorSlider;
import yesman.epicfight.client.world.capabilites.entitypatch.player.AbstractClientPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.model.armature.HumanoidArmature;

@OnlyIn(value=Dist.CLIENT)
public record EpicSkins(Supplier<ResourceLocation> capeTexture, float r, float g, float b) {
    public static void initEpicSkins(AbstractClientPlayerPatch<?> playerpatch) {
        if (EpicFightServerConnectionHelper.supported() && ClientConfig.enableCosmetics) {
            EpicFightServerConnectionHelper.getPlayerSkinInfo(EpicFightSharedConstants.webServerDomain(), ((AbstractClientPlayer)playerpatch.getOriginal()).getUUID().toString().replace("-", ""), (response, exception) -> {
                if (exception != null) {
                    EpicFightMod.LOGGER.error("Failed at connecting Epic Fight web server: " + exception.getMessage());
                }
                if (response.statusCode() != 200) {
                    EpicFightMod.LOGGER.error("Failed at connecting Epic Fight web server: " + (String)response.body());
                }
                HashMap cosmetics = Maps.newHashMap();
                try {
                    JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(((String)response.body()).getBytes()), StandardCharsets.UTF_8));
                    JsonArray cosmeticsArray = Streams.parse((JsonReader)jsonReader).getAsJsonArray();
                    for (JsonElement cosmeticJson : cosmeticsArray) {
                        JsonObject cosmeticObj = cosmeticJson.getAsJsonObject();
                        try {
                            Cosmetic cosmetic = new Cosmetic(cosmeticObj);
                            cosmetics.put(cosmetic.slot(), cosmetic);
                        }
                        catch (JsonSyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception jsonReader) {
                    // empty catch block
                }
                if (cosmetics.containsKey((Object)Slot.CAPE)) {
                    Cosmetic cosmetic = (Cosmetic)cosmetics.get((Object)Slot.CAPE);
                    Supplier<ResourceLocation> cloakTextureProvider = null;
                    cloakTextureProvider = cosmetic.useBoolParam1() && cosmetic.boolParam1() ? () -> ((AbstractClientPlayer)playerpatch.getOriginal()).getSkin().capeTexture() : () -> cosmetic.textureLocation();
                    Supplier<ResourceLocation> fCloakTextureProvider = cloakTextureProvider;
                    RemoteAssets.getInstance().getRemoteMesh(cosmetic.seq(), cosmetic.fileLocation(), mesh -> {
                        SoftBodyTranslatable.TRACKING_SIMULATION_SUBJECTS.add(playerpatch);
                        playerpatch.getClothSimulator().runWhen(ClothSimulator.PLAYER_CLOAK, (SoftBodyTranslatable)((Object)mesh), ClothSimulator.ClothObjectBuilder.create().parentJoint(((HumanoidArmature)Armatures.BIPED.get()).torso).putAll(ClothColliderPresets.BIPED), () -> ((AbstractClientPlayer)playerpatch.getOriginal()).getSkin().capeTexture() != null && !((AbstractClientPlayer)playerpatch.getOriginal()).isInvisible() && ((AbstractClientPlayer)playerpatch.getOriginal()).isModelPartShown(PlayerModelPart.CAPE) && ((AbstractClientPlayer)playerpatch.getOriginal()).getItemBySlot(EquipmentSlot.CHEST).getItem() != Items.ELYTRA);
                        if (!(!cosmetic.useIntParam1() || cosmetic.useBoolParam1() && cosmetic.boolParam1())) {
                            double brightness = (float)(cosmetic.intParam1() & 0xFF) / 255.0f;
                            double saturation = (float)((cosmetic.intParam1() & 0xFF00) >> 8) / 255.0f;
                            double hue = (float)((cosmetic.intParam1() & 0xFF0000) >> 16) / 255.0f;
                            int hueColor = ColorSlider.rgbColor(hue);
                            int saturationApplied = ColorSlider.sliderPositionToColor(saturation, new int[]{hueColor, -1});
                            int brightnessApplied = ColorSlider.sliderPositionToColor(brightness, new int[]{saturationApplied, -16777216});
                            float r = (float)((brightnessApplied & 0xFF0000) >> 16) / 255.0f;
                            float g = (float)((brightnessApplied & 0xFF00) >> 8) / 255.0f;
                            float b = (float)(brightnessApplied & 0xFF) / 255.0f;
                            playerpatch.setEpicSkinsInformation(new EpicSkins(fCloakTextureProvider, r, g, b));
                        } else {
                            playerpatch.setEpicSkinsInformation(new EpicSkins(fCloakTextureProvider, 1.0f, 1.0f, 1.0f));
                        }
                    });
                } else {
                    EpicSkins.initDefaultCape(playerpatch);
                }
            });
        } else {
            EpicSkins.initDefaultCape(playerpatch);
        }
    }

    public static void initDefaultCape(AbstractClientPlayerPatch<?> playerpatch) {
        SoftBodyTranslatable.TRACKING_SIMULATION_SUBJECTS.add(playerpatch);
        playerpatch.getClothSimulator().runWhen(ClothSimulator.PLAYER_CLOAK, Meshes.CAPE_DEFAULT, ClothSimulator.ClothObjectBuilder.create().parentJoint(((HumanoidArmature)Armatures.BIPED.get()).torso).putAll(PlayerSkin.Model.WIDE.equals((Object)((AbstractClientPlayer)playerpatch.getOriginal()).getSkin().model()) ? ClothColliderPresets.BIPED : ClothColliderPresets.BIPED_SLIM), () -> ((AbstractClientPlayer)playerpatch.getOriginal()).getSkin().capeTexture() != null && !((AbstractClientPlayer)playerpatch.getOriginal()).isInvisible() && ((AbstractClientPlayer)playerpatch.getOriginal()).isModelPartShown(PlayerModelPart.CAPE) && ((AbstractClientPlayer)playerpatch.getOriginal()).getItemBySlot(EquipmentSlot.CHEST).getItem() != Items.ELYTRA);
        playerpatch.setEpicSkinsInformation(new EpicSkins(() -> ((AbstractClientPlayer)playerpatch.getOriginal()).getSkin().capeTexture(), 1.0f, 1.0f, 1.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Cosmetic(int seq, Slot slot, int intParam1, boolean boolParam1, boolean useIntParam1, boolean useBoolParam1, String fileLocation, ResourceLocation textureLocation) {
        public Cosmetic(JsonObject json) throws JsonSyntaxException {
            this(GsonHelper.getAsInt((JsonObject)json, (String)"cosmeticSeq"), Slot.valueOf(ParseUtil.toUpperCase(GsonHelper.getAsString((JsonObject)json, (String)"slot"))), GsonHelper.getAsInt((JsonObject)json, (String)"intParam1"), GsonHelper.getAsBoolean((JsonObject)json, (String)"boolParam1"), GsonHelper.getAsBoolean((JsonObject)json, (String)"useIntParam1"), GsonHelper.getAsBoolean((JsonObject)json, (String)"useBoolParam1"), GsonHelper.getAsString((JsonObject)json, (String)"fileLocation"), RemoteAssets.getInstance().getRemoteTexture(GsonHelper.getAsString((JsonObject)json, (String)"textureLocation")));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Slot {
        CAPE;

    }
}

