/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ModConfigSpec;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.AuthenticationHelper;
import yesman.epicfight.network.server.SPPlayUISound;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

@OnlyIn(value=Dist.CLIENT)
public class ClientEngine {
    private static ClientEngine instance = new ClientEngine();
    public Minecraft minecraft;
    private boolean vanillaModelDebuggingMode = false;
    private AuthenticationHelper authenticationHelper = new AuthenticationHelper(this){

        @Override
        public void initialize(ModConfigSpec.ConfigValue<String> accessToken, ModConfigSpec.ConfigValue<String> refreshToken, ModConfigSpec.EnumValue<AuthenticationHelper.AuthenticationProvider> provider) {
        }

        @Override
        public boolean valid() {
            return false;
        }

        @Override
        public AuthenticationHelper.Status status() {
            return AuthenticationHelper.Status.OFFLINE_MODE;
        }

        @Override
        public void loadPlayerSkin() {
        }
    };

    public static ClientEngine getInstance() {
        return instance;
    }

    public ClientEngine() {
        instance = this;
        this.minecraft = Minecraft.getInstance();
    }

    public boolean switchVanillaModelDebuggingMode() {
        this.vanillaModelDebuggingMode = !this.vanillaModelDebuggingMode;
        return this.vanillaModelDebuggingMode;
    }

    public boolean isVanillaModelDebuggingMode() {
        return this.vanillaModelDebuggingMode;
    }

    @Deprecated(forRemoval=true, since="1.21.1")
    @Nullable
    public LocalPlayerPatch getPlayerPatch() {
        return EpicFightCapabilities.getEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class);
    }

    public void initAuthHelper(AuthenticationHelper authHelper) {
        this.authenticationHelper = authHelper;
    }

    public AuthenticationHelper getAuthHelper() {
        return this.authenticationHelper;
    }

    public void playUISound(SPPlayUISound msg) {
        SimpleSoundInstance soundinstance = SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)msg.sound().value()), (float)msg.pitch(), (float)msg.volume());
        Minecraft.getInstance().getSoundManager().play((SoundInstance)soundinstance);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)soundinstance);
    }

    public boolean isEpicFightMode() {
        LocalPlayerPatch localPlayerPatch = EpicFightCapabilities.getEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class);
        if (localPlayerPatch == null) {
            return false;
        }
        return localPlayerPatch.isEpicFightMode();
    }

    public static Comparator<ParticleRenderType> makeCustomLowestParticleRenderTypeComparator(List<ParticleRenderType> renderOrder) {
        Comparator<ParticleRenderType> vanillaComparator = Comparator.comparingInt(renderOrder::indexOf);
        return (t1, t2) -> {
            boolean vanillaType1 = renderOrder.contains(t1);
            boolean vanillaType2 = renderOrder.contains(t2);
            if (vanillaType1 && vanillaType2) {
                return vanillaComparator.compare((ParticleRenderType)t1, (ParticleRenderType)t2);
            }
            if (t1 == ParticleRenderType.CUSTOM || t1 == EpicFightParticleRenderTypes.ENTITY_PARTICLE) {
                return 1;
            }
            if (t2 == ParticleRenderType.CUSTOM || t2 == EpicFightParticleRenderTypes.ENTITY_PARTICLE) {
                return -1;
            }
            if (!vanillaType1 && !vanillaType2) {
                return Integer.compare(System.identityHashCode(t1), System.identityHashCode(t2));
            }
            return vanillaType1 ? -1 : 1;
        };
    }
}

