/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events.engine;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.AnimationSubFileReader;
import yesman.epicfight.api.client.input.action.EpicFightInputActions;
import yesman.epicfight.api.client.input.handlers.InputManager;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.neoevent.PatchedRenderersEvent;
import yesman.epicfight.api.client.neoevent.RenderEnderDragonEvent;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.IEventBasedEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.gui.EntityUI;
import yesman.epicfight.client.gui.VersionNotifier;
import yesman.epicfight.client.gui.screen.overlay.OverlayManager;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.mesh.HumanoidMesh;
import yesman.epicfight.client.mesh.PiglinMesh;
import yesman.epicfight.client.renderer.AimHelperRenderer;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.FakeBlockRenderer;
import yesman.epicfight.client.renderer.FirstPersonRenderer;
import yesman.epicfight.client.renderer.VanillaFakeBlockRenderer;
import yesman.epicfight.client.renderer.patched.entity.PCreeperRenderer;
import yesman.epicfight.client.renderer.patched.entity.PCustomEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PCustomHumanoidEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PDrownedRenderer;
import yesman.epicfight.client.renderer.patched.entity.PEnderDragonRenderer;
import yesman.epicfight.client.renderer.patched.entity.PEndermanRenderer;
import yesman.epicfight.client.renderer.patched.entity.PHoglinRenderer;
import yesman.epicfight.client.renderer.patched.entity.PHumanoidRenderer;
import yesman.epicfight.client.renderer.patched.entity.PIllagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PIronGolemRenderer;
import yesman.epicfight.client.renderer.patched.entity.PPlayerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PRavagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PSpiderRenderer;
import yesman.epicfight.client.renderer.patched.entity.PStrayRenderer;
import yesman.epicfight.client.renderer.patched.entity.PVexRenderer;
import yesman.epicfight.client.renderer.patched.entity.PVindicatorRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitchRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitherRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitherSkeletonMinionRenderer;
import yesman.epicfight.client.renderer.patched.entity.PZombieVillagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PresetRenderer;
import yesman.epicfight.client.renderer.patched.entity.WitherGhostCloneRenderer;
import yesman.epicfight.client.renderer.patched.item.RenderFilledMap;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.client.renderer.patched.item.RenderKatana;
import yesman.epicfight.client.renderer.patched.item.RenderShield;
import yesman.epicfight.client.renderer.patched.item.RenderTrident;
import yesman.epicfight.client.renderer.patched.item.RenderTwoHandedRangedWeapon;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.registry.entries.EpicFightEntityTypes;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.BossPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.BowCapability;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.CrossbowCapability;
import yesman.epicfight.world.capabilities.item.MapCapability;
import yesman.epicfight.world.capabilities.item.ShieldCapability;
import yesman.epicfight.world.capabilities.item.TridentCapability;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

@OnlyIn(value=Dist.CLIENT)
public class RenderEngine
implements IEventBasedEngine {
    private static final RenderEngine INSTANCE = new RenderEngine();
    public final BattleModeGui battleModeHUD;
    public final VersionNotifier versionNotifier;
    public final Minecraft minecraft;
    private final BiMap<EntityType<?>, Function<EntityType<?>, PatchedEntityRenderer>> entityRendererProvider;
    private final Map<EntityType<?>, PatchedEntityRenderer> entityRendererCache;
    private final Map<Item, RenderItemBase> itemRendererMapByInstance;
    private final Map<Class<?>, RenderItemBase> itemRendererMapByClass;
    private final Map<UUID, BossPatch> bossEventOwners = new ConcurrentHashMap<UUID, BossPatch>();
    private final OverlayManager overlayManager;
    private FakeBlockRenderer fakeBlockRenderer;
    private Map<ResourceLocation, Function<JsonElement, RenderItemBase>> itemRenderers;
    private AimHelperRenderer aimHelper;
    private FirstPersonRenderer firstPersonRenderer;
    private PHumanoidRenderer<?, ?, ?, ?, ?> basicHumanoidRenderer;
    private int modelInitTimer;
    private boolean zoomingIn;
    private int zoomTick = 0;
    private int zoomTickO = 0;
    private final int maxZoomTicks = 6;
    private int zoomOutStandbyTicks = 0;
    private static final Vec3f AIMING_CORRECTION = new Vec3f(-1.5f, 0.0f, 1.25f);
    private static final OpenMatrix4f PLAYER_ROTATION = new OpenMatrix4f();
    private static final Vector3f CAMERA_ROTATION_EULER = new Vector3f();
    private static final ResourceLocation YELLOWBAR_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"boss_bar/yellow_background");
    private static final ResourceLocation YELLOWBAR_PROGRESS = ResourceLocation.withDefaultNamespace((String)"boss_bar/yellow_progress");

    public static RenderEngine getInstance() {
        return INSTANCE;
    }

    private RenderEngine() {
        this.minecraft = Minecraft.getInstance();
        this.battleModeHUD = new BattleModeGui(this.minecraft);
        this.versionNotifier = new VersionNotifier(this.minecraft);
        this.entityRendererProvider = HashBiMap.create();
        this.entityRendererCache = new HashMap();
        this.itemRendererMapByInstance = new HashMap<Item, RenderItemBase>();
        this.itemRendererMapByClass = new HashMap();
        this.overlayManager = new OverlayManager();
        this.fakeBlockRenderer = new VanillaFakeBlockRenderer();
    }

    public void initialize() {
        HashMap<ResourceLocation, Function<JsonElement, RenderItemBase>> builder = new HashMap<ResourceLocation, Function<JsonElement, RenderItemBase>>();
        builder.put(ResourceLocation.withDefaultNamespace((String)"base"), RenderItemBase::new);
        builder.put(ResourceLocation.withDefaultNamespace((String)"ranged"), RenderTwoHandedRangedWeapon::new);
        builder.put(ResourceLocation.withDefaultNamespace((String)"map"), RenderFilledMap::new);
        builder.put(ResourceLocation.withDefaultNamespace((String)"shield"), RenderShield::new);
        builder.put(ResourceLocation.withDefaultNamespace((String)"trident"), RenderTrident::new);
        builder.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"uchigatana"), RenderKatana::new);
        ModLoader.postEvent((Event)new PatchedRenderersEvent.RegisterItemRenderer(builder));
        this.itemRenderers = ImmutableMap.copyOf(builder);
    }

    public void reloadFakeBlockRenderer(FakeBlockRenderer fakeBlockRenderer) {
        this.fakeBlockRenderer = fakeBlockRenderer;
    }

    public void reloadItemRenderers(Map<ResourceLocation, JsonElement> objects) {
        this.itemRendererMapByInstance.clear();
        this.itemRendererMapByClass.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objects.entrySet()) {
            Function<JsonElement, RenderItemBase> rendererProvider;
            ResourceLocation rl = entry.getKey();
            String pathString = rl.getPath();
            ResourceLocation registryName = ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)pathString);
            if (!BuiltInRegistries.ITEM.containsKey(registryName)) {
                EpicFightMod.LOGGER.warn("Failed to load item skin: no item named " + String.valueOf(registryName));
                continue;
            }
            Item item = (Item)BuiltInRegistries.ITEM.get(registryName);
            if (entry.getValue().getAsJsonObject().has("renderer")) {
                ResourceLocation rendererName = ResourceLocation.parse((String)entry.getValue().getAsJsonObject().get("renderer").getAsString());
                if (this.itemRenderers.containsKey(rendererName)) {
                    rendererProvider = this.itemRenderers.get(rendererName);
                } else {
                    EpicFightMod.LOGGER.warn("No renderer named " + String.valueOf(rendererName));
                    rendererProvider = RenderItemBase::new;
                }
            } else {
                rendererProvider = RenderItemBase::new;
            }
            RenderItemBase itemRenderer = rendererProvider.apply(entry.getValue());
            this.itemRendererMapByInstance.put(item, itemRenderer);
        }
        RenderItemBase baseRenderer = new RenderItemBase((JsonElement)new JsonObject());
        RenderTwoHandedRangedWeapon bowRenderer = new RenderTwoHandedRangedWeapon((JsonElement)objects.get(BuiltInRegistries.ITEM.getKey((Object)Items.BOW)).getAsJsonObject());
        RenderTwoHandedRangedWeapon crossbowRenderer = new RenderTwoHandedRangedWeapon((JsonElement)objects.get(BuiltInRegistries.ITEM.getKey((Object)Items.CROSSBOW)).getAsJsonObject());
        RenderTrident tridentRenderer = new RenderTrident((JsonElement)objects.get(BuiltInRegistries.ITEM.getKey((Object)Items.TRIDENT)).getAsJsonObject());
        RenderFilledMap mapRenderer = new RenderFilledMap((JsonElement)objects.get(BuiltInRegistries.ITEM.getKey((Object)Items.FILLED_MAP)).getAsJsonObject());
        RenderShield shieldRenderer = new RenderShield((JsonElement)objects.get(BuiltInRegistries.ITEM.getKey((Object)Items.SHIELD)).getAsJsonObject());
        this.itemRendererMapByClass.put(BowItem.class, bowRenderer);
        this.itemRendererMapByClass.put(CrossbowItem.class, crossbowRenderer);
        this.itemRendererMapByClass.put(ShieldItem.class, baseRenderer);
        this.itemRendererMapByClass.put(TridentItem.class, tridentRenderer);
        this.itemRendererMapByClass.put(ShieldItem.class, shieldRenderer);
        this.itemRendererMapByClass.put(BowCapability.class, bowRenderer);
        this.itemRendererMapByClass.put(CrossbowCapability.class, crossbowRenderer);
        this.itemRendererMapByClass.put(TridentCapability.class, tridentRenderer);
        this.itemRendererMapByClass.put(MapCapability.class, mapRenderer);
        this.itemRendererMapByClass.put(ShieldCapability.class, shieldRenderer);
    }

    public void resetRenderers() {
        this.entityRendererCache.clear();
        for (Map.Entry entry : this.entityRendererProvider.entrySet()) {
            this.entityRendererCache.put((EntityType)entry.getKey(), (PatchedEntityRenderer)((Function)entry.getValue()).apply((EntityType)entry.getKey()));
        }
        ModLoader.postEvent((Event)new PatchedRenderersEvent.Modify(this.entityRendererCache));
    }

    public void registerCustomEntityRenderer(EntityType<?> entityType, String rendererName, CompoundTag compound) {
        if (StringUtil.isNullOrEmpty((String)rendererName)) {
            return;
        }
        EntityRenderDispatcher erd = this.minecraft.getEntityRenderDispatcher();
        EntityRendererProvider.Context context = new EntityRendererProvider.Context(erd, this.minecraft.getItemRenderer(), this.minecraft.getBlockRenderer(), erd.getItemInHandRenderer(), this.minecraft.getResourceManager(), this.minecraft.getEntityModels(), this.minecraft.font);
        if ("player".equals(rendererName)) {
            this.entityRendererCache.put(entityType, this.basicHumanoidRenderer);
        } else if ("epicfight:custom".equals(rendererName)) {
            if (compound.getBoolean("humanoid")) {
                this.entityRendererCache.put(entityType, new PCustomHumanoidEntityRenderer<HumanoidMesh>(Meshes.getOrCreate(ResourceLocation.parse((String)compound.getString("model")), jsonAssetLoader -> jsonAssetLoader.loadSkinnedMesh(HumanoidMesh::new)), context, entityType));
            } else {
                this.entityRendererCache.put(entityType, new PCustomEntityRenderer(Meshes.getOrCreate(ResourceLocation.parse((String)compound.getString("model")), jsonAssetLoader -> jsonAssetLoader.loadSkinnedMesh(HumanoidMesh::new)), context));
            }
        } else {
            EntityType presetEntityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)rendererName));
            if (this.entityRendererProvider.containsKey((Object)presetEntityType)) {
                PatchedEntityRenderer renderer = (PatchedEntityRenderer)((Function)this.entityRendererProvider.get((Object)presetEntityType)).apply(entityType);
                if (!(this.minecraft.getEntityRenderDispatcher().renderers.get(entityType) instanceof LivingEntityRenderer) && renderer instanceof PatchedLivingEntityRenderer) {
                    PatchedLivingEntityRenderer patchedLivingEntityRenderer = (PatchedLivingEntityRenderer)renderer;
                    this.entityRendererCache.put(entityType, new PresetRenderer(context, entityType, (LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>>)((LivingEntityRenderer)context.getEntityRenderDispatcher().renderers.get(presetEntityType)), patchedLivingEntityRenderer.getDefaultMesh()));
                } else {
                    this.entityRendererCache.put(entityType, (PatchedEntityRenderer)((Function)this.entityRendererProvider.get((Object)presetEntityType)).apply(entityType));
                }
            } else {
                throw new IllegalArgumentException("Datapack Mob Patch Crash: Invalid Renderer type " + rendererName);
            }
        }
    }

    public RenderItemBase getItemRenderer(ItemStack itemstack) {
        RenderItemBase renderItem = this.itemRendererMapByInstance.get(itemstack.getItem());
        if (renderItem == null) {
            renderItem = this.findMatchingRendererByClass(itemstack.getItem().getClass());
            if (renderItem == null) {
                CapabilityItem itemCap = EpicFightCapabilities.getItemStackCapability(itemstack);
                renderItem = this.findMatchingRendererByClass(itemCap.getClass());
            }
            if (renderItem == null) {
                renderItem = this.itemRendererMapByInstance.get(Items.AIR);
            }
            this.itemRendererMapByInstance.put(itemstack.getItem(), renderItem);
        }
        return renderItem;
    }

    private RenderItemBase findMatchingRendererByClass(Class<?> clazz) {
        RenderItemBase renderer = null;
        while (clazz != null && renderer == null) {
            renderer = this.itemRendererMapByClass.get(clazz);
            clazz = clazz.getSuperclass();
        }
        return renderer;
    }

    public void renderEntityArmatureModel(LivingEntity livingEntity, LivingEntityPatch<?> entitypatch, EntityRenderer<? extends Entity> renderer, MultiBufferSource buffer, PoseStack matStack, int packedLight, float partialTicks) {
        this.getEntityRenderer((Entity)livingEntity).render(livingEntity, entitypatch, renderer, buffer, matStack, packedLight, partialTicks);
    }

    public PatchedEntityRenderer getEntityRenderer(Entity entity) {
        return this.getEntityRenderer(entity.getType());
    }

    public PatchedEntityRenderer getEntityRenderer(EntityType entityType) {
        return this.entityRendererCache.get(entityType);
    }

    public boolean hasRendererFor(Entity entity) {
        return this.entityRendererCache.computeIfAbsent(entity.getType(), key -> this.entityRendererProvider.containsKey(key) ? (PatchedEntityRenderer)((Function)this.entityRendererProvider.get((Object)entity.getType())).apply(entity.getType()) : null) != null;
    }

    public Set<ResourceLocation> getRendererEntries() {
        Set<ResourceLocation> availableRendererEntities = this.entityRendererProvider.keySet().stream().map(entityType -> EntityType.getKey((EntityType)entityType)).collect(Collectors.toSet());
        availableRendererEntities.add(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"custom"));
        return availableRendererEntities;
    }

    public void zoomIn() {
        if (!this.zoomingIn) {
            this.zoomingIn = true;
            this.zoomTick = this.zoomTick == 0 ? 1 : this.zoomTick;
        }
    }

    public void zoomOut(int zoomOutTicks) {
        if (this.zoomingIn) {
            this.zoomingIn = false;
            this.zoomOutStandbyTicks = zoomOutTicks;
        }
    }

    public void setModelInitializerTimer(int tick) {
        this.modelInitTimer = tick;
    }

    public void setRangedWeaponThirdPerson(Camera camera, CameraType pov, double partialTicks) {
        if (this.zoomTickO < 1) {
            return;
        }
        if (ClientEngine.getInstance().getPlayerPatch() == null) {
            return;
        }
        Entity entity = this.minecraft.getCameraEntity();
        Vec3 vector = camera.getPosition();
        double totalX = vector.x();
        double totalY = vector.y();
        double totalZ = vector.z();
        if (pov == CameraType.THIRD_PERSON_BACK) {
            double d3;
            float f;
            double posX = vector.x();
            double posY = vector.y();
            double posZ = vector.z();
            double entityPosX = entity.xOld + (entity.getX() - entity.xOld) * partialTicks;
            double entityPosY = entity.yOld + (entity.getY() - entity.yOld) * partialTicks + (double)entity.getEyeHeight();
            double entityPosZ = entity.zOld + (entity.getZ() - entity.zOld) * partialTicks;
            if (pov == CameraType.THIRD_PERSON_BACK) {
                float f2 = (float)Mth.lerp((double)partialTicks, (double)this.zoomTickO, (double)this.zoomTick);
                Objects.requireNonNull(this);
                f = f2 / 6.0f;
            } else {
                f = 0.0f;
            }
            float zoomAmount = f;
            Vec3f interpolatedCorrection = new Vec3f(RenderEngine.AIMING_CORRECTION.x * zoomAmount, RenderEngine.AIMING_CORRECTION.y * zoomAmount, RenderEngine.AIMING_CORRECTION.z * zoomAmount);
            OpenMatrix4f rotationMatrix = ClientEngine.getInstance().getPlayerPatch().getMatrix((float)partialTicks);
            Vec3f rotateVec = OpenMatrix4f.transform3v(rotationMatrix, interpolatedCorrection, null);
            double smallest = d3 = Math.sqrt(rotateVec.x * rotateVec.x + rotateVec.y * rotateVec.y + rotateVec.z * rotateVec.z);
            double d00 = posX + (double)rotateVec.x;
            double d11 = posY - (double)rotateVec.y;
            double d22 = posZ + (double)rotateVec.z;
            for (int i = 0; i < 8; ++i) {
                double d7;
                BlockHitResult raytraceresult;
                float f3 = (i & 1) * 2 - 1;
                float f1 = (i >> 1 & 1) * 2 - 1;
                float f2 = (i >> 2 & 1) * 2 - 1;
                if ((raytraceresult = this.minecraft.level.clip(new ClipContext(new Vec3(entityPosX + (double)(f3 *= 0.1f), entityPosY + (double)(f1 *= 0.1f), entityPosZ + (double)(f2 *= 0.1f)), new Vec3(d00 + (double)f3 + (double)f2, d11 + (double)f1, d22 + (double)f2), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity))) == null || !((d7 = raytraceresult.getLocation().distanceTo(new Vec3(entityPosX, entityPosY, entityPosZ))) < smallest)) continue;
                smallest = d7;
            }
            float dist = d3 == 0.0 ? 0.0f : (float)(smallest / d3);
            totalX += (double)(rotateVec.x * dist);
            totalY -= (double)(rotateVec.y * dist);
            totalZ += (double)(rotateVec.z * dist);
        }
        camera.setPosition(totalX, totalY, totalZ);
    }

    public void correctCamera(ViewportEvent.ComputeCameraAngles event, float partialTicks) {
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        Camera camera = event.getCamera();
        CameraType cameraType = this.minecraft.options.getCameraType();
        if (localPlayerPatch != null) {
            float yRot;
            float xRot;
            if (localPlayerPatch.getTarget() != null && localPlayerPatch.isTargetLockedOn()) {
                xRot = localPlayerPatch.getLerpedLockOnX(partialTicks);
                yRot = localPlayerPatch.getLerpedLockOnY(partialTicks);
                if (cameraType.isMirrored()) {
                    yRot += 180.0f;
                    xRot *= -1.0f;
                }
                camera.setRotation(yRot, xRot);
                event.setPitch(xRot);
                event.setYaw(yRot);
                if (!cameraType.isFirstPerson()) {
                    Entity cameraEntity = this.minecraft.cameraEntity;
                    camera.setPosition(Mth.lerp((double)partialTicks, (double)cameraEntity.xo, (double)cameraEntity.getX()), Mth.lerp((double)partialTicks, (double)cameraEntity.yo, (double)cameraEntity.getY()) + (double)Mth.lerp((float)partialTicks, (float)camera.eyeHeightOld, (float)camera.eyeHeight), Mth.lerp((double)partialTicks, (double)cameraEntity.zo, (double)cameraEntity.getZ()));
                    camera.move(-camera.getMaxZoom(4.0f), 0.0f, 0.0f);
                }
            }
            if (ClientConfig.enablePovAction && cameraType.isFirstPerson() && localPlayerPatch.isEpicFightMode() && !localPlayerPatch.getFirstPersonLayer().isOff()) {
                if (localPlayerPatch.isLerpingFpv()) {
                    xRot = localPlayerPatch.getLerpedFpvXRot(partialTicks);
                    yRot = localPlayerPatch.getLerpedFpvYRot(partialTicks);
                    this.minecraft.cameraEntity.setXRot(xRot);
                    this.minecraft.cameraEntity.setYRot(yRot);
                } else {
                    AnimationSubFileReader.PovSettings.ViewLimit viewLimit = localPlayerPatch.getPovSettings().viewLimit();
                    if (viewLimit != null) {
                        float clampedXRot = Mth.clamp((float)event.getPitch(), (float)viewLimit.xRotMin(), (float)viewLimit.xRotMax());
                        float bodyY = MathUtils.findNearestRotation(event.getYaw(), localPlayerPatch.getYRot());
                        float clampedYRot = Mth.clamp((float)event.getYaw(), (float)(bodyY + viewLimit.yRotMin()), (float)(bodyY + viewLimit.yRotMax()));
                        if (Float.compare(clampedXRot, event.getPitch()) != 0 || Float.compare(clampedYRot, event.getYaw()) != 0) {
                            localPlayerPatch.fixFpvRotation(clampedXRot, localPlayerPatch.getYRot());
                        }
                    }
                }
                if (localPlayerPatch.hasCameraAnimation()) {
                    float time = Mth.lerp((float)partialTicks, (float)localPlayerPatch.getFirstPersonLayer().animationPlayer.getPrevElapsedTime(), (float)localPlayerPatch.getFirstPersonLayer().animationPlayer.getElapsedTime());
                    JointTransform cameraTransform = localPlayerPatch.getFirstPersonLayer().animationPlayer.getAnimation().get().isLinkAnimation() || localPlayerPatch.getPovSettings() == null ? localPlayerPatch.getFirstPersonLayer().getLinkCameraTransform().getInterpolatedTransform(time) : localPlayerPatch.getPovSettings().cameraTransform().getInterpolatedTransform(time);
                    float xRot2 = ((LocalPlayer)localPlayerPatch.getOriginal()).getXRot();
                    float yRot2 = ((LocalPlayer)localPlayerPatch.getOriginal()).getYRot();
                    Vec3f translation = OpenMatrix4f.transform3v(OpenMatrix4f.ofRotationDegree(yRot2, Vec3f.Y_AXIS, PLAYER_ROTATION).rotate(xRot2, Vec3f.X_AXIS), cameraTransform.translation(), null);
                    Quaternionf rot = cameraTransform.rotation();
                    rot.getEulerAnglesXYZ(CAMERA_ROTATION_EULER);
                    RenderEngine.CAMERA_ROTATION_EULER.x = (float)Math.toDegrees(RenderEngine.CAMERA_ROTATION_EULER.x);
                    RenderEngine.CAMERA_ROTATION_EULER.y = (float)Math.toDegrees(RenderEngine.CAMERA_ROTATION_EULER.y);
                    RenderEngine.CAMERA_ROTATION_EULER.z = (float)Math.toDegrees(RenderEngine.CAMERA_ROTATION_EULER.z);
                    camera.move(translation.x, translation.y, translation.z);
                    event.setPitch(event.getPitch() + RenderEngine.CAMERA_ROTATION_EULER.x);
                    event.setYaw(event.getYaw() + RenderEngine.CAMERA_ROTATION_EULER.y);
                    event.setRoll(event.getRoll() + RenderEngine.CAMERA_ROTATION_EULER.z);
                }
            }
        }
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public FirstPersonRenderer getFirstPersonRenderer() {
        return this.firstPersonRenderer;
    }

    public boolean shouldRenderVanillaModel() {
        return ClientEngine.getInstance().isVanillaModelDebuggingMode() || this.modelInitTimer > 0;
    }

    public void addBossEventOwner(UUID uuid, BossPatch bosspatch) {
        this.bossEventOwners.put(uuid, bosspatch);
    }

    public void removeBossEventOwner(UUID uuid, BossPatch bosspatch) {
        this.bossEventOwners.remove(uuid);
    }

    public void initHUD(LocalPlayerPatch playerpatch) {
        this.battleModeHUD.init(playerpatch);
        this.versionNotifier.init();
    }

    private void freeUnusedSources() {
        this.bossEventOwners.entrySet().removeIf(entry -> {
            Object entity = ((EntityPatch)((BossPatch)entry.getValue()).cast()).getOriginal();
            return !entity.isAlive() || entity.isRemoved();
        });
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> EpicFightRenderTypes.freeUnusedWorldRenderTypes());
        } else {
            EpicFightRenderTypes.freeUnusedWorldRenderTypes();
        }
    }

    public void clear() {
        this.zoomOut(0);
        this.bossEventOwners.clear();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                this.resetRenderers();
                EpicFightRenderTypes.clearWorldRenderTypes();
            });
        } else {
            this.resetRenderers();
            EpicFightRenderTypes.clearWorldRenderTypes();
        }
    }

    public static boolean hitResultEquals(@Nullable HitResult hitResult, HitResult.Type hitType) {
        return hitResult == null ? false : hitType.equals((Object)hitResult.getType());
    }

    public static boolean hitResultNotEquals(@Nullable HitResult hitResult, HitResult.Type hitType) {
        return hitResult == null ? true : !hitType.equals((Object)hitResult.getType());
    }

    private void epicfight$renderLivingPre(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
        LocalPlayerPatch playerpatch;
        LivingEntity livingentity = event.getEntity();
        if (livingentity.level() == null) {
            return;
        }
        if (this.hasRendererFor((Entity)livingentity)) {
            LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)livingentity, LivingEntityPatch.class);
            float originalYRot = 0.0f;
            if ((event.getPartialTick() == 0.0f || event.getPartialTick() == 1.0f) && entitypatch instanceof LocalPlayerPatch) {
                LocalPlayerPatch localPlayerPatch = (LocalPlayerPatch)entitypatch;
                if (entitypatch.overrideRender()) {
                    originalYRot = localPlayerPatch.getModelYRot();
                    localPlayerPatch.setModelYRotInGui(livingentity.getYRot());
                    event.getPoseStack().translate(0.0, 0.1, 0.0);
                    boolean compusteShaderSetting = ClientConfig.activateComputeShader;
                    ClientConfig.activateComputeShader = false;
                    this.renderEntityArmatureModel(livingentity, entitypatch, (EntityRenderer<? extends Entity>)event.getRenderer(), event.getMultiBufferSource(), event.getPoseStack(), event.getPackedLight(), event.getPartialTick());
                    ClientConfig.activateComputeShader = compusteShaderSetting;
                    event.setCanceled(true);
                    localPlayerPatch.disableModelYRotInGui(originalYRot);
                }
                return;
            }
            if (entitypatch != null && entitypatch.overrideRender()) {
                this.renderEntityArmatureModel(livingentity, entitypatch, (EntityRenderer<? extends Entity>)event.getRenderer(), event.getMultiBufferSource(), event.getPoseStack(), event.getPackedLight(), event.getPartialTick());
                if (this.shouldRenderVanillaModel()) {
                    event.getPoseStack().translate(this.modelInitTimer > 0 ? 10000.0f : 1.5f, 0.0f, 0.0f);
                    --this.modelInitTimer;
                } else {
                    event.setCanceled(true);
                }
            }
        }
        if ((playerpatch = ClientEngine.getInstance().getPlayerPatch()) != null && !this.minecraft.options.hideGui && !EpicFightGameRules.DISABLE_ENTITY_UI.getRuleValue(livingentity.level()).booleanValue()) {
            LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)livingentity, LivingEntityPatch.class);
            for (EntityUI entityIndicator : EntityUI.ENTITY_UI_LIST) {
                if (!entityIndicator.shouldDraw(livingentity, entitypatch, playerpatch, event.getPartialTick())) continue;
                entityIndicator.draw(livingentity, entitypatch, playerpatch, event.getPoseStack(), event.getMultiBufferSource(), event.getPartialTick());
            }
        }
    }

    private void epicfight$itemTooltip(ItemTooltipEvent event) {
        if (ClientConfig.showEpicFightAttributesInTooltip && event.getEntity() != null && event.getEntity().level().isClientSide) {
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), LocalPlayerPatch.class).ifPresent(playerpatch -> EpicFightCapabilities.getItemCapability(event.getItemStack()).ifPresent(itemCapability -> {
                if (InputManager.isActionPhysicallyActive(EpicFightInputActions.WEAPON_INNATE_SKILL_TOOLTIP)) {
                    Skill weaponInnateSkill = itemCapability.getInnateSkill((PlayerPatch<?>)playerpatch, event.getItemStack());
                    if (weaponInnateSkill != null) {
                        event.getToolTip().clear();
                        List<Component> skilltooltip = weaponInnateSkill.getTooltipOnItem(event.getItemStack(), (CapabilityItem)itemCapability, (PlayerPatch<?>)playerpatch);
                        for (Component s : skilltooltip) {
                            event.getToolTip().add(s);
                        }
                    }
                } else {
                    List tooltip = event.getToolTip();
                    itemCapability.modifyItemTooltip(event.getItemStack(), event.getToolTip(), (LivingEntityPatch<?>)playerpatch);
                    for (int i = 0; i < tooltip.size(); ++i) {
                        MutableComponent mutableComponent$2;
                        ComponentContents patt2$temp;
                        Object patt1$temp;
                        TranslatableContents translatableContent;
                        MutableComponent mutableComponent;
                        ComponentContents patt0$temp;
                        Component sibling;
                        Component textComp = (Component)tooltip.get(i);
                        if (textComp.getSiblings().isEmpty() || !((sibling = (Component)textComp.getSiblings().get(0)) instanceof MutableComponent) || !((patt0$temp = (mutableComponent = (MutableComponent)sibling).getContents()) instanceof TranslatableContents) || (translatableContent = (TranslatableContents)patt0$temp).getArgs().length <= 1 || !((patt1$temp = translatableContent.getArgs()[1]) instanceof MutableComponent) || !((patt2$temp = (mutableComponent$2 = (MutableComponent)patt1$temp).getContents()) instanceof TranslatableContents)) continue;
                        TranslatableContents translatableContent$2 = (TranslatableContents)patt2$temp;
                        if (translatableContent$2.getKey().equals(((Attribute)Attributes.ATTACK_SPEED.value()).getDescriptionId())) {
                            float weaponSpeed = (float)playerpatch.getWeaponAttribute((Holder<Attribute>)Attributes.ATTACK_SPEED, event.getItemStack());
                            tooltip.remove(i);
                            tooltip.add(i, Component.literal((String)String.format(" %.2f ", Float.valueOf(playerpatch.getModifiedAttackSpeed((CapabilityItem)itemCapability, weaponSpeed)))).append((Component)Component.translatable((String)((Attribute)Attributes.ATTACK_SPEED.value()).getDescriptionId())));
                            continue;
                        }
                        if (!translatableContent$2.getKey().equals(((Attribute)Attributes.ATTACK_DAMAGE.value()).getDescriptionId())) continue;
                        float weaponDamage = (float)playerpatch.getWeaponAttribute((Holder<Attribute>)Attributes.ATTACK_DAMAGE, event.getItemStack());
                        String damageFormat = ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(playerpatch.getModifiedBaseDamage(weaponDamage));
                        tooltip.remove(i);
                        tooltip.add(i, Component.literal((String)String.format(" %s ", damageFormat)).append((Component)Component.translatable((String)((Attribute)Attributes.ATTACK_DAMAGE.value()).getDescriptionId())).withStyle(ChatFormatting.DARK_GREEN));
                    }
                    Skill weaponInnateSkill = itemCapability.getInnateSkill((PlayerPatch<?>)playerpatch, event.getItemStack());
                    if (weaponInnateSkill != null) {
                        event.getToolTip().add(Component.translatable((String)"inventory.epicfight.guide_innate_tooltip", (Object[])new Object[]{EpicFightKeyMappings.WEAPON_INNATE_SKILL_TOOLTIP.getKey().getDisplayName()}).withStyle(ChatFormatting.DARK_GRAY));
                    }
                }
            }));
        }
    }

    private void epicfight$computeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        this.correctCamera(event, (float)event.getPartialTick());
    }

    private void epicfight$renderGuiPre(RenderGuiEvent.Pre event) {
        Window window = Minecraft.getInstance().getWindow();
        LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerpatch != null) {
            playerpatch.getPlayerSkills().listSkillContainers().filter(skillContainer -> skillContainer.getSkill() != null).forEach(skillContainer -> skillContainer.getSkill().onScreen(playerpatch, window.getGuiScaledWidth(), window.getGuiScaledHeight()));
            this.overlayManager.renderTick(window.getGuiScaledWidth(), window.getGuiScaledHeight());
            this.versionNotifier.render(event.getGuiGraphics(), true);
        }
    }

    private void epicfight$bossEventProgress(CustomizeGuiOverlayEvent.BossEventProgress event) {
        Object entitypatch;
        float stunShield;
        if (event.getBossEvent().getName().getString().equals("Ender Dragon") && this.bossEventOwners.containsKey(event.getBossEvent().getId()) && (stunShield = ((LivingEntityPatch)(entitypatch = this.bossEventOwners.get(event.getBossEvent().getId()).cast())).getStunShield()) > 0.0f) {
            float progression = stunShield / ((LivingEntityPatch)entitypatch).getMaxStunShield();
            int x = event.getX();
            int y = event.getY();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            event.getGuiGraphics().blitSprite(YELLOWBAR_BACKGROUND, 182, 5, 0, 0, x, y + 6, 182, 5);
            event.getGuiGraphics().blitSprite(YELLOWBAR_PROGRESS, 182, 5, 0, 0, x, y + 6, (int)(182.0f * progression), 5);
        }
    }

    private void epicfight$renderHand(RenderHandEvent event) {
        LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerpatch != null && playerpatch.isEpicFightMode() && ClientConfig.enableAnimatedFirstPersonModel) {
            boolean useEpicFightModel;
            RenderItemBase mainhandItemSkin = this.getItemRenderer(((LocalPlayer)playerpatch.getOriginal()).getMainHandItem());
            RenderItemBase offhandItemSkin = this.getItemRenderer(((LocalPlayer)playerpatch.getOriginal()).getOffhandItem());
            boolean bl = useEpicFightModel = !(mainhandItemSkin != null && mainhandItemSkin.forceVanillaFirstPerson() || offhandItemSkin != null && offhandItemSkin.forceVanillaFirstPerson());
            if (useEpicFightModel) {
                if (event.getHand() == InteractionHand.MAIN_HAND) {
                    this.firstPersonRenderer.render((LocalPlayer)playerpatch.getOriginal(), playerpatch, (LivingEntityRenderer<LocalPlayer, PlayerModel<LocalPlayer>>)((LivingEntityRenderer)this.minecraft.getEntityRenderDispatcher().getRenderer((Entity)((LocalPlayer)playerpatch.getOriginal()))), event.getMultiBufferSource(), event.getPoseStack(), event.getPackedLight(), event.getPartialTick());
                }
                event.setCanceled(true);
            }
        }
    }

    private void epicfight$renderAfterLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            if (ClientConfig.mineBlockGuideOption.showBlockHighlight() && this.minecraft.hitResult.getType() == HitResult.Type.BLOCK) {
                EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class).ifPresent(playerpatch -> {
                    if (!playerpatch.canPlayAttackAnimation()) {
                        this.fakeBlockRenderer.render(event.getCamera(), event.getPoseStack(), (MultiBufferSource)this.minecraft.renderBuffers().bufferSource(), (Level)this.minecraft.level, ((BlockHitResult)this.minecraft.hitResult).getBlockPos(), 1.0f, 1.0f, 1.0f, 0.4f);
                    }
                });
            }
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && ClientConfig.aimingPovCorrection && this.zoomTick > 0 && this.minecraft.options.getCameraType() == CameraType.THIRD_PERSON_BACK) {
            float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(false);
            this.aimHelper.doRender(event.getPoseStack(), partialTick);
        }
    }

    private void epicfight$renderEnderDragon(RenderEnderDragonEvent event) {
        EnderDragon livingentity = event.getEntity();
        if (this.hasRendererFor((Entity)livingentity)) {
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)livingentity, EnderDragonPatch.class).ifPresent(enderdragonpatch -> {
                event.setCanceled(true);
                this.getEntityRenderer((Entity)livingentity).render(livingentity, enderdragonpatch, event.getRenderer(), event.getBuffers(), event.getPoseStack(), event.getLight(), event.getPartialRenderTick());
            });
        }
    }

    private void epicfight$renderTickPre(RenderFrameEvent.Pre event) {
        EntityUI.HEALTH_BAR.reset();
    }

    private void epicfight$renderTickPost(RenderFrameEvent.Post event) {
        EntityUI.HEALTH_BAR.remove();
    }

    private void epicfight$clientTickPre(ClientTickEvent.Pre event) {
        LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerpatch != null) {
            this.battleModeHUD.tick(playerpatch);
        }
        this.freeUnusedSources();
    }

    private void epicfight$levelTickPost(LevelTickEvent.Post event) {
        if (!event.getLevel().isClientSide()) {
            return;
        }
        this.zoomTickO = this.zoomTick;
        EntityUI.HEALTH_BAR.tick();
        if (this.zoomTick > 0 && ClientConfig.aimingPovCorrection) {
            if (this.zoomOutStandbyTicks > 0) {
                --this.zoomOutStandbyTicks;
            } else {
                this.zoomTick = this.zoomingIn ? this.zoomTick + 1 : this.zoomTick - 1;
            }
            this.zoomTick = Math.clamp((long)this.zoomTick, 0, this.maxZoomTicks);
        }
    }

    private void epicfight$renderBlockHighlight(RenderHighlightEvent.Block event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class).ifPresent(playerpatch -> {
            if (playerpatch.canPlayAttackAnimation()) {
                event.setCanceled(true);
            }
        });
    }

    private void epicfight$renderGuiLayer$Pre(RenderGuiLayerEvent.Pre event) {
        if (event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR)) {
            CameraType cameraType = this.minecraft.options.getCameraType();
            if (event.isCanceled() && cameraType.isFirstPerson() || !cameraType.isFirstPerson()) {
                return;
            }
            MutableBoolean itemAction = new MutableBoolean(true);
            if (ClientConfig.mineBlockGuideOption.switchCrosshair()) {
                EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class).ifPresent(playerpatch -> itemAction.setValue(playerpatch.canPlayAttackAnimation()));
            }
            if (!itemAction.booleanValue()) {
                event.setCanceled(true);
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                event.getGuiGraphics().blit(EntityUI.BATTLE_ICON, (event.getGuiGraphics().guiWidth() - 15) / 2, (event.getGuiGraphics().guiHeight() - 15) / 2, 0, 240, 15, 15);
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableBlend();
            }
        }
    }

    private void epicfight$addLayers(EntityRenderersEvent.AddLayers event) {
        EntityRendererProvider.Context context = event.getContext();
        this.entityRendererProvider.clear();
        this.entityRendererProvider.put((Object)EntityType.CREEPER, entityType -> new PCreeperRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.ENDERMAN, entityType -> new PEndermanRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.ZOMBIE, entityType -> new PHumanoidRenderer((AssetAccessor<HumanoidMesh>)Meshes.BIPED_OLD_TEX, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.ZOMBIE_VILLAGER, entityType -> new PZombieVillagerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.ZOMBIFIED_PIGLIN, entityType -> new PHumanoidRenderer((AssetAccessor<PiglinMesh>)Meshes.PIGLIN, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.HUSK, entityType -> new PHumanoidRenderer((AssetAccessor<HumanoidMesh>)Meshes.BIPED_OLD_TEX, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.SKELETON, entityType -> new PHumanoidRenderer((AssetAccessor<HumanoidMesh>)Meshes.SKELETON, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.WITHER_SKELETON, entityType -> new PHumanoidRenderer((AssetAccessor<HumanoidMesh>)Meshes.SKELETON, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.STRAY, entityType -> new PStrayRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.PLAYER, entityType -> new PPlayerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.SPIDER, entityType -> new PSpiderRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.CAVE_SPIDER, entityType -> new PSpiderRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.IRON_GOLEM, entityType -> new PIronGolemRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.VINDICATOR, entityType -> new PVindicatorRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.EVOKER, entityType -> new PIllagerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.WITCH, entityType -> new PWitchRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.DROWNED, entityType -> new PDrownedRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.PILLAGER, entityType -> new PIllagerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.RAVAGER, entityType -> new PRavagerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.VEX, entityType -> new PVexRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.PIGLIN, entityType -> new PHumanoidRenderer((AssetAccessor<PiglinMesh>)Meshes.PIGLIN, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.PIGLIN_BRUTE, entityType -> new PHumanoidRenderer((AssetAccessor<PiglinMesh>)Meshes.PIGLIN, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.HOGLIN, entityType -> new PHoglinRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.ZOGLIN, entityType -> new PHoglinRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.ENDER_DRAGON, entityType -> new PEnderDragonRenderer());
        this.entityRendererProvider.put((Object)EntityType.WITHER, entityType -> new PWitherRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)((EntityType)EpicFightEntityTypes.WITHER_SKELETON_MINION.get()), entityType -> new PWitherSkeletonMinionRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)((EntityType)EpicFightEntityTypes.WITHER_GHOST_CLONE.get()), entityType -> new WitherGhostCloneRenderer());
        this.firstPersonRenderer = new FirstPersonRenderer(context, EntityType.PLAYER);
        this.basicHumanoidRenderer = new PHumanoidRenderer(Meshes.BIPED, context, EntityType.PLAYER);
        this.aimHelper = new AimHelperRenderer();
        ModLoader.postEvent((Event)new PatchedRenderersEvent.Add((Map<EntityType<?>, Function<EntityType<?>, PatchedEntityRenderer>>)this.entityRendererProvider, context));
        this.resetRenderers();
    }

    @Override
    public void gameEventBus(IEventBus gameEventBus) {
        gameEventBus.addListener(this::epicfight$bossEventProgress);
        gameEventBus.addListener(this::epicfight$renderLivingPre);
        gameEventBus.addListener(this::epicfight$itemTooltip);
        gameEventBus.addListener(this::epicfight$computeCameraAngles);
        gameEventBus.addListener(this::epicfight$renderGuiPre);
        gameEventBus.addListener(this::epicfight$renderHand);
        gameEventBus.addListener(this::epicfight$renderAfterLevel);
        gameEventBus.addListener(this::epicfight$renderEnderDragon);
        gameEventBus.addListener(this::epicfight$renderTickPre);
        gameEventBus.addListener(this::epicfight$renderTickPost);
        gameEventBus.addListener(this::epicfight$clientTickPre);
        gameEventBus.addListener(this::epicfight$levelTickPost);
        gameEventBus.addListener(this::epicfight$renderBlockHighlight);
        gameEventBus.addListener(this::epicfight$renderGuiLayer$Pre);
    }

    @Override
    public void modEventBus(IEventBus modEventBus) {
        modEventBus.addListener(this::epicfight$addLayers);
    }
}

