/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.datapack.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.util.internal.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.screen.DatapackEditScreen;
import yesman.epicfight.client.gui.datapack.screen.MessageScreen;
import yesman.epicfight.client.gui.datapack.screen.PackEntry;
import yesman.epicfight.client.gui.datapack.widgets.Grid;
import yesman.epicfight.client.gui.datapack.widgets.ResizableComponent;
import yesman.epicfight.client.gui.datapack.widgets.ResizableEditBox;
import yesman.epicfight.client.gui.datapack.widgets.Static;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;

@OnlyIn(value=Dist.CLIENT)
public class WeaponAttributeScreen
extends Screen {
    private final Map<String, Condition.ParameterEditor> weaponAttributeEditors = Maps.newLinkedHashMap();
    private final Map<String, Condition.ParameterEditor> armorAttributeEditors = Maps.newLinkedHashMap();
    private final Screen parentScreen;
    private final DatapackEditScreen.ItemCapabilityTab.ItemType itemType;
    private Grid stylesGrid;
    private Grid attributesGrid;
    private final List<PackEntry<String, CompoundTag>> styles = Lists.newArrayList();
    private final CompoundTag rootTag;

    public WeaponAttributeScreen(Screen parentScreen, CompoundTag rootTag, DatapackEditScreen.ItemCapabilityTab.ItemType itemType) {
        super((Component)Component.translatable((String)"datapack_edit.item_capability.attributes"));
        this.itemType = itemType;
        this.parentScreen = parentScreen;
        this.rootTag = rootTag;
        this.minecraft = parentScreen.getMinecraft();
        this.font = parentScreen.getMinecraft().font;
        ResizableEditBox impactEditBox = new ResizableEditBox(this.font, 0, 0, 0, 0, (Component)Component.literal((String)"impact"), null, null);
        ResizableEditBox armorNegationEditBox = new ResizableEditBox(this.font, 0, 0, 0, 0, (Component)Component.literal((String)"armor_negation"), null, null);
        ResizableEditBox maxStrikesEditBox = new ResizableEditBox(this.font, 0, 0, 0, 0, (Component)Component.literal((String)"max_strikes"), null, null);
        ResizableEditBox damageBonusEditBox = new ResizableEditBox(this.font, 0, 0, 0, 0, (Component)Component.literal((String)"damage_bonus"), null, null);
        ResizableEditBox speedBonusEditBox = new ResizableEditBox(this.font, 0, 0, 0, 0, (Component)Component.literal((String)"speed_bonus"), null, null);
        ResizableEditBox stunArmorEditBox = new ResizableEditBox(this.font, 0, 0, 0, 0, (Component)Component.literal((String)"stun_armor"), null, null);
        ResizableEditBox weightEditBox = new ResizableEditBox(this.font, 0, 0, 0, 0, (Component)Component.literal((String)"weight"), null, null);
        impactEditBox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
        armorNegationEditBox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
        maxStrikesEditBox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Integer::parseInt));
        damageBonusEditBox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
        speedBonusEditBox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
        stunArmorEditBox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
        weightEditBox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
        this.weaponAttributeEditors.put("armor_negation", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)ParseUtil.parseOrGet(value.toString(), Double::parseDouble, 0.0)), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), (AbstractWidget)armorNegationEditBox));
        this.weaponAttributeEditors.put("impact", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)ParseUtil.parseOrGet(value.toString(), Double::parseDouble, 0.0)), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), (AbstractWidget)impactEditBox));
        this.weaponAttributeEditors.put("max_strikes", Condition.ParameterEditor.of(value -> IntTag.valueOf((int)ParseUtil.parseOrGet(value.toString(), Integer::parseInt, 0)), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), (AbstractWidget)maxStrikesEditBox));
        this.weaponAttributeEditors.put("damage_bonus", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)ParseUtil.parseOrGet(value.toString(), Double::parseDouble, 0.0)), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), (AbstractWidget)damageBonusEditBox));
        this.weaponAttributeEditors.put("speed_bonus", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)ParseUtil.parseOrGet(value.toString(), Double::parseDouble, 0.0)), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), (AbstractWidget)speedBonusEditBox));
        this.armorAttributeEditors.put("stun_armor", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)ParseUtil.parseOrGet(value.toString(), Double::parseDouble, 0.0)), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), (AbstractWidget)stunArmorEditBox));
        this.armorAttributeEditors.put("weight", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)ParseUtil.parseOrGet(value.toString(), Double::parseDouble, 0.0)), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), (AbstractWidget)weightEditBox));
        if (itemType == DatapackEditScreen.ItemCapabilityTab.ItemType.WEAPON) {
            this.stylesGrid = Grid.builder(this, parentScreen.getMinecraft()).xy1(20, 60).xy2(90, 50).horizontalSizing(ResizableComponent.HorizontalSizing.LEFT_WIDTH).verticalSizing(ResizableComponent.VerticalSizing.TOP_BOTTOM).rowHeight(21).rowEditable(Grid.GridBuilder.RowEditButton.ADD_REMOVE).rowpositionChanged((rowposition, values) -> {
                Grid.PackImporter packImporter = new Grid.PackImporter();
                for (Map.Entry entry : this.styles.get((int)rowposition.intValue()).getValue().tags.entrySet()) {
                    Condition.ParameterEditor paramEditor = this.weaponAttributeEditors.get(entry.getKey());
                    packImporter.newRow().newValue("attribute", this.weaponAttributeEditors.get(entry.getKey())).newValue("amount", paramEditor == null ? "" : paramEditor.fromTag.apply((Tag)entry.getValue()));
                }
                this.attributesGrid._setActive(true);
                this.attributesGrid._setValue(packImporter);
            }).addColumn(Grid.combo("style", Style.ENUM_MANAGER.universalValues()).valueChanged(event -> this.styles.get(event.rowposition).setPackKey(ParseUtil.nullParam(event.postValue).toLowerCase(Locale.ROOT))).defaultVal(CapabilityItem.Styles.ONE_HAND)).pressAdd((grid, button) -> {
                this.styles.add(PackEntry.of("", CompoundTag::new));
                int rowposition = grid.addRow();
                grid.setGridFocus(rowposition, "style");
            }).pressRemove((grid, button) -> {
                grid.removeRow(removedRow -> this.styles.remove(removedRow));
                if (grid.children().size() == 0) {
                    this.attributesGrid._setActive(false);
                }
            }).build();
            this.attributesGrid = Grid.builder(this, parentScreen.getMinecraft()).xy1(120, 60).xy2(20, 50).horizontalSizing(ResizableComponent.HorizontalSizing.LEFT_RIGHT).verticalSizing(ResizableComponent.VerticalSizing.TOP_BOTTOM).rowHeight(21).rowEditable(Grid.GridBuilder.RowEditButton.ADD_REMOVE).addColumn(Grid.combo("attribute", List.copyOf(this.weaponAttributeEditors.values())).toDisplayText(editor -> ParseUtil.nullOrToString(editor, editor$1 -> ParseUtil.snakeToSpacedCamel(editor.editWidget.getMessage().getString()))).valueChanged(event -> {
                CompoundTag attributesCompound = this.styles.get(this.stylesGrid.getRowposition()).getValue();
                if (event.prevValue != null) {
                    attributesCompound.remove(((Condition.ParameterEditor)event.prevValue).editWidget.getMessage().getString());
                } else {
                    attributesCompound.remove("");
                }
                attributesCompound.putString(ParseUtil.nullParam(((Condition.ParameterEditor)event.postValue).editWidget.getMessage().getString()), "");
            }).width(100)).addColumn(Grid.wildcard("amount").editWidgetProvider(row -> {
                Condition.ParameterEditor editor = (Condition.ParameterEditor)row.getValue("attribute");
                return editor == null ? null : editor.editWidget;
            }).valueChanged(event -> {
                CompoundTag attributesTag = this.styles.get(this.stylesGrid.getRowposition()).getValue();
                Condition.ParameterEditor editor = (Condition.ParameterEditor)event.grid.getValue(event.rowposition, "attribute");
                if (!StringUtil.isNullOrEmpty((String)ParseUtil.nullParam(event.postValue))) {
                    attributesTag.put(editor.editWidget.getMessage().getString(), editor.toTag.apply(event.postValue));
                } else {
                    attributesTag.remove(editor.editWidget.getMessage().getString());
                }
            }).width(150)).pressAdd((grid, button) -> {
                this.styles.get(this.stylesGrid.getRowposition()).getValue().put("", (Tag)StringTag.valueOf((String)""));
                int rowposition = grid.addRow();
                grid.setGridFocus(rowposition, "attribute");
            }).pressRemove((grid, button) -> {
                this.styles.get(this.stylesGrid.getRowposition()).getValue().remove(((Condition.ParameterEditor)grid.getValue((int)grid.getRowposition(), (String)"attribute")).editWidget.getMessage().getString());
                grid.removeRow(removedRow -> {});
            }).build();
            Grid.PackImporter packImporter = new Grid.PackImporter();
            for (Map.Entry entry : rootTag.tags.entrySet()) {
                this.styles.add(PackEntry.of((String)entry.getKey(), () -> (CompoundTag)entry.getValue()));
                packImporter.newRow();
                packImporter.newValue("style", Style.ENUM_MANAGER.get((String)entry.getKey()));
            }
            this.stylesGrid._setValue(packImporter);
            this.attributesGrid._setActive(false);
        } else if (itemType == DatapackEditScreen.ItemCapabilityTab.ItemType.ARMOR) {
            this.styles.add(PackEntry.of("armor", CompoundTag::new));
            this.attributesGrid = Grid.builder(this, parentScreen.getMinecraft()).xy1(20, 60).xy2(20, 50).horizontalSizing(ResizableComponent.HorizontalSizing.LEFT_RIGHT).verticalSizing(ResizableComponent.VerticalSizing.TOP_BOTTOM).rowHeight(21).rowEditable(Grid.GridBuilder.RowEditButton.ADD_REMOVE).addColumn(Grid.combo("attribute", List.copyOf(this.armorAttributeEditors.values())).toDisplayText(editor -> ParseUtil.nullOrToString(editor, editor$1 -> ParseUtil.snakeToSpacedCamel(editor.editWidget.getMessage().getString()))).valueChanged(event -> {
                CompoundTag attributesCompound = this.styles.get(0).getValue();
                if (event.prevValue != null) {
                    attributesCompound.remove(((Condition.ParameterEditor)event.prevValue).editWidget.getMessage().getString());
                } else {
                    attributesCompound.remove("");
                }
                attributesCompound.putString(ParseUtil.nullParam(((Condition.ParameterEditor)event.postValue).editWidget.getMessage().getString()), "");
            }).width(100)).addColumn(Grid.wildcard("amount").editWidgetProvider(row -> {
                Condition.ParameterEditor editor = (Condition.ParameterEditor)row.getValue("attribute");
                return editor == null ? null : editor.editWidget;
            }).valueChanged(event -> {
                CompoundTag attributesTag = this.styles.get(0).getValue();
                Condition.ParameterEditor editor = (Condition.ParameterEditor)event.grid.getValue(event.rowposition, "attribute");
                if (!StringUtil.isNullOrEmpty((String)ParseUtil.nullParam(event.postValue))) {
                    attributesTag.put(editor.editWidget.getMessage().getString(), editor.toTag.apply(event.postValue));
                } else {
                    attributesTag.remove(editor.editWidget.getMessage().getString());
                }
            }).width(150)).pressAdd((grid, button) -> {
                this.styles.get(0).getValue().put("", (Tag)StringTag.valueOf((String)""));
                int rowposition = grid.addRow();
                grid.setGridFocus(rowposition, "attribute");
            }).pressRemove((grid, button) -> {
                this.styles.get(0).getValue().remove((String)grid.getValue(grid.getRowposition(), "attribute"));
                grid.removeRow(removedRow -> {});
            }).build();
            this.styles.add(PackEntry.of("attributes", CompoundTag::new));
            Grid.PackImporter packImporter = new Grid.PackImporter();
            for (Map.Entry entry : rootTag.tags.entrySet()) {
                Condition.ParameterEditor paramEditor = this.armorAttributeEditors.get(entry.getKey());
                packImporter.newRow();
                packImporter.newValue("attribute", this.armorAttributeEditors.get(entry.getKey()));
                packImporter.newValue("amount", paramEditor.fromTag.apply((Tag)entry.getValue()));
            }
            this.attributesGrid._setValue(packImporter);
        }
    }

    protected void init() {
        if (this.itemType == DatapackEditScreen.ItemCapabilityTab.ItemType.WEAPON) {
            this.stylesGrid.resize(this.getRectangle());
            this.addRenderableWidget(new Static((Screen)this, 20, 60, 40, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.translatable((String)"datapack_edit.styles")));
            this.addRenderableWidget(this.stylesGrid);
        }
        this.attributesGrid.resize(this.getRectangle());
        this.addRenderableWidget(new Static((Screen)this, this.itemType == DatapackEditScreen.ItemCapabilityTab.ItemType.WEAPON ? 120 : 20, 60, 40, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.translatable((String)"datapack_edit.item_capability.attributes")));
        this.addRenderableWidget(this.attributesGrid);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            if (this.itemType == DatapackEditScreen.ItemCapabilityTab.ItemType.WEAPON) {
                HashSet styles = Sets.newHashSet();
                for (PackEntry<String, CompoundTag> entry : this.styles) {
                    if (styles.contains(entry.getKey())) {
                        this.minecraft.setScreen(new MessageScreen("Save Failed", "Unable to save because of duplicated style: " + entry.getKey(), (Screen)this, button2 -> this.minecraft.setScreen((Screen)this), 180, 90));
                        return;
                    }
                    styles.add(entry.getKey());
                }
                this.rootTag.tags.clear();
                for (PackEntry<String, CompoundTag> entry : this.styles) {
                    this.rootTag.put(entry.getKey(), (Tag)entry.getValue());
                }
            } else if (this.itemType == DatapackEditScreen.ItemCapabilityTab.ItemType.ARMOR) {
                CompoundTag attributesTag = this.styles.get(0).getValue();
                for (Map.Entry tag : attributesTag.tags.entrySet()) {
                    this.rootTag.put((String)tag.getKey(), (Tag)tag.getValue());
                }
            }
            this.onClose();
        }).pos(this.width / 2 - 162, this.height - 32).size(160, 21).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.minecraft.setScreen(new MessageScreen("", "Do you want to quit without saving changes?", (Screen)this, button2 -> this.onClose(), button2 -> this.minecraft.setScreen((Screen)this), 180, 70))).pos(this.width / 2 + 2, this.height - 32).size(160, 21).build());
    }

    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int yBegin = 32;
        int yEnd = this.height - 45;
        guiGraphics.drawString(this.font, this.title, 20, 16, 0xFFFFFF);
        guiGraphics.setColor(0.125f, 0.125f, 0.125f, 1.0f);
        guiGraphics.blit(Screen.MENU_BACKGROUND, 0, yBegin, (float)this.width, (float)yEnd - (float)yBegin, this.width, yEnd, 32, 32);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.setColor(0.25f, 0.25f, 0.25f, 1.0f);
        guiGraphics.blit(Screen.MENU_BACKGROUND, 0, 0, 0.0f, 0.0f, this.width, yBegin, 32, 32);
        guiGraphics.blit(Screen.MENU_BACKGROUND, 0, yEnd, 0.0f, (float)yEnd - (float)yBegin, this.width, yEnd, 32, 32);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.fillGradient(RenderType.guiOverlay(), 0, yBegin, this.width, yBegin + 4, -16777216, 0, 0);
        guiGraphics.fillGradient(RenderType.guiOverlay(), 0, yEnd, this.width, yEnd + 1, 0, -16777216, 0);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }
}

