/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.ClientHooks;
import org.joml.Matrix4f;
import yesman.epicfight.api.client.neoevent.AttributeIconRegisterEvent;
import yesman.epicfight.api.client.neoevent.WeaponCategoryIconRegisterEvent;
import yesman.epicfight.client.gui.datapack.widgets.Static;
import yesman.epicfight.client.gui.screen.SlotSelectScreen;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.registry.entries.EpicFightItems;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.item.SkillBookItem;

@OnlyIn(value=Dist.CLIENT)
public class SkillBookScreen
extends Screen {
    private static final Map<WeaponCategory, ItemStack> WEAPON_CATEGORY_ICONS = new HashMap<WeaponCategory, ItemStack>();
    private static final Map<Holder<Attribute>, TextureInfo> ATTRIBUTE_ICONS = new HashMap<Holder<Attribute>, TextureInfo>();
    private static final ResourceLocation SKILLBOOK_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/gui/screen/skillbook.png");
    public static final TextureInfo HEALTH_TEXTURE_INFO = new TextureInfo(SKILLBOOK_BACKGROUND, 22, 205, 10, 10);
    public static final TextureInfo STAMINA_TEXTURE_INFO = new TextureInfo(SKILLBOOK_BACKGROUND, 32, 205, 10, 10);
    public static final TextureInfo COOLDOWN_TEXTURE_INFO = new TextureInfo(SKILLBOOK_BACKGROUND, 42, 205, 10, 10);
    protected final Player opener;
    protected final LocalPlayerPatch playerpatch;
    protected final Skill skill;
    protected final Screen parentScreen;
    protected final SkillTooltipList skillTooltipList;
    protected final AvailableItemsList availableWeaponCategoryList;
    protected final AttributeIconList consumptionList;
    protected final AttributeIconList providingAttributesList;
    protected final InteractionHand hand;
    private double customScale;
    private Button learnButton;

    public static void registerIconItems() {
        WEAPON_CATEGORY_ICONS.put(CapabilityItem.WeaponCategories.NOT_WEAPON, new ItemStack((ItemLike)Items.AIR));
        WEAPON_CATEGORY_ICONS.put(CapabilityItem.WeaponCategories.AXE, new ItemStack((ItemLike)Items.IRON_AXE));
        WEAPON_CATEGORY_ICONS.put(CapabilityItem.WeaponCategories.FIST, new ItemStack((ItemLike)EpicFightItems.GLOVE.get()));
        WEAPON_CATEGORY_ICONS.put(CapabilityItem.WeaponCategories.GREATSWORD, new ItemStack((ItemLike)EpicFightItems.IRON_GREATSWORD.get()));
        WEAPON_CATEGORY_ICONS.put(CapabilityItem.WeaponCategories.HOE, new ItemStack((ItemLike)Items.IRON_HOE));
        WEAPON_CATEGORY_ICONS.put(CapabilityItem.WeaponCategories.PICKAXE, new ItemStack((ItemLike)Items.IRON_PICKAXE));
        WEAPON_CATEGORY_ICONS.put(CapabilityItem.WeaponCategories.SHOVEL, new ItemStack((ItemLike)Items.IRON_SHOVEL));
        WEAPON_CATEGORY_ICONS.put(CapabilityItem.WeaponCategories.SWORD, new ItemStack((ItemLike)Items.IRON_SWORD));
        WEAPON_CATEGORY_ICONS.put(CapabilityItem.WeaponCategories.UCHIGATANA, new ItemStack((ItemLike)EpicFightItems.UCHIGATANA.get()));
        WEAPON_CATEGORY_ICONS.put(CapabilityItem.WeaponCategories.SPEAR, new ItemStack((ItemLike)EpicFightItems.IRON_SPEAR.get()));
        WEAPON_CATEGORY_ICONS.put(CapabilityItem.WeaponCategories.TACHI, new ItemStack((ItemLike)EpicFightItems.IRON_TACHI.get()));
        WEAPON_CATEGORY_ICONS.put(CapabilityItem.WeaponCategories.TRIDENT, new ItemStack((ItemLike)Items.TRIDENT));
        WEAPON_CATEGORY_ICONS.put(CapabilityItem.WeaponCategories.LONGSWORD, new ItemStack((ItemLike)EpicFightItems.IRON_LONGSWORD.get()));
        WEAPON_CATEGORY_ICONS.put(CapabilityItem.WeaponCategories.DAGGER, new ItemStack((ItemLike)EpicFightItems.IRON_DAGGER.get()));
        WEAPON_CATEGORY_ICONS.put(CapabilityItem.WeaponCategories.SHIELD, new ItemStack((ItemLike)Items.SHIELD));
        WEAPON_CATEGORY_ICONS.put(CapabilityItem.WeaponCategories.RANGED, new ItemStack((ItemLike)Items.BOW));
        ATTRIBUTE_ICONS.put((Holder<Attribute>)Attributes.MAX_HEALTH, new TextureInfo(SKILLBOOK_BACKGROUND, 22, 195, 10, 10));
        ATTRIBUTE_ICONS.put((Holder<Attribute>)EpicFightAttributes.MAX_STAMINA, new TextureInfo(SKILLBOOK_BACKGROUND, 42, 195, 10, 10));
        ATTRIBUTE_ICONS.put((Holder<Attribute>)Attributes.ATTACK_DAMAGE, new TextureInfo(SKILLBOOK_BACKGROUND, 52, 195, 10, 10));
        ATTRIBUTE_ICONS.put((Holder<Attribute>)EpicFightAttributes.STAMINA_REGEN, new TextureInfo(SKILLBOOK_BACKGROUND, 62, 195, 10, 10));
        ATTRIBUTE_ICONS.put((Holder<Attribute>)Attributes.ATTACK_SPEED, new TextureInfo(SKILLBOOK_BACKGROUND, 72, 195, 10, 10));
        WeaponCategoryIconRegisterEvent weaponCategoryIconRegisterEvent = new WeaponCategoryIconRegisterEvent(WEAPON_CATEGORY_ICONS);
        ModLoader.postEvent((Event)weaponCategoryIconRegisterEvent);
        AttributeIconRegisterEvent attributeIconRegisterEvent = new AttributeIconRegisterEvent(ATTRIBUTE_ICONS);
        ModLoader.postEvent((Event)attributeIconRegisterEvent);
    }

    public Button getLearnButton() {
        return this.learnButton;
    }

    public SkillBookScreen(Player opener, ItemStack stack, @Nullable InteractionHand hand) {
        this(opener, (Skill)SkillBookItem.getContainSkill(stack).get().value(), hand, null);
    }

    public SkillBookScreen(Player opener, Skill skill, @Nullable InteractionHand hand, @Nullable Screen parentScreen) {
        super((Component)Component.empty());
        this.minecraft = Minecraft.getInstance();
        this.font = Minecraft.getInstance().font;
        this.opener = opener;
        this.playerpatch = EpicFightCapabilities.getEntityPatch((Entity)this.opener, LocalPlayerPatch.class);
        this.skill = skill;
        this.hand = hand;
        this.parentScreen = parentScreen;
        Minecraft minecraft = Minecraft.getInstance();
        Objects.requireNonNull(Minecraft.getInstance().font);
        this.skillTooltipList = new SkillTooltipList(minecraft, 0, 0, 0, 9);
        this.availableWeaponCategoryList = new AvailableItemsList(0, 0);
        this.consumptionList = new AttributeIconList(Minecraft.getInstance(), 0, 0, 100, 16);
        this.providingAttributesList = new AttributeIconList(Minecraft.getInstance(), 0, 0, 100, 16);
        List list = Minecraft.getInstance().font.split((FormattedText)Component.translatable((String)(this.skill.getTranslationKey() + ".tooltip"), (Object[])this.skill.getTooltipArgsOfScreen(Lists.newArrayList()).toArray(new Object[0])), 148);
        list.forEach(this.skillTooltipList::add);
        if (this.skill.getAvailableWeaponCategories() != null) {
            this.skill.getAvailableWeaponCategories().forEach(this.availableWeaponCategoryList::addWeaponCategory);
        }
        if (!this.skill.getCustomConsumptionTooltips(this.consumptionList)) {
            this.consumptionList.children().clear();
            switch (this.skill.getResourceType()) {
                case WEAPON_CHARGE: {
                    break;
                }
                case COOLDOWN: {
                    this.consumptionList.add((Component)Component.translatable((String)EpicFightMod.format("attribute.name.%s.cooldown.consume.tooltip")), (Component)Component.translatable((String)EpicFightMod.format("attribute.name.%s.cooldown.consume"), (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.skill.getConsumption()))}), COOLDOWN_TEXTURE_INFO);
                    break;
                }
                case STAMINA: {
                    this.consumptionList.add((Component)Component.translatable((String)EpicFightMod.format("attribute.name.%s.stamina.consume.tooltip")), (Component)Component.translatable((String)EpicFightMod.format("attribute.name.%s.stamina.consume"), (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.skill.getConsumption()))}), STAMINA_TEXTURE_INFO);
                    break;
                }
                case HEALTH: {
                    this.consumptionList.add((Component)Component.translatable((String)EpicFightMod.format("attribute.name.%s.health.consume.tooltip")), (Component)Component.translatable((String)EpicFightMod.format("attribute.name.%s.health.consume")), HEALTH_TEXTURE_INFO);
                    break;
                }
            }
        }
        this.skill.getModfierEntry().forEach(entry -> this.providingAttributesList.add((Holder<Attribute>)((Holder)entry.getKey()), (AttributeModifier)entry.getValue(), ATTRIBUTE_ICONS.get(entry.getKey())));
    }

    protected void init() {
        Window window;
        Optional<SkillContainer> skillContainer = this.playerpatch.getSkillContainerFor(this.skill);
        Optional<SkillContainer> priorSkillContainer = this.skill == null ? null : this.playerpatch.getSkillContainerFor(this.skill.getPriorSkill());
        boolean isUsing = skillContainer.isPresent();
        boolean meetsCondition = this.skill == null ? false : this.skill.getPriorSkill() == null || priorSkillContainer.isPresent();
        Component tooltip = CommonComponents.EMPTY;
        if (!isUsing) {
            if (meetsCondition) {
                if (skillContainer.isPresent()) {
                    tooltip = Component.translatable((String)EpicFightMod.format("gui.%s.replace"), (Object[])new Object[]{Component.translatable((String)this.skill.getTranslationKey()).getString()});
                }
            } else {
                tooltip = Component.translatable((String)EpicFightMod.format("gui.%s.require_to_learn"), (Object[])new Object[]{Component.translatable((String)this.skill.getPriorSkill().getTranslationKey()).getString()});
            }
        }
        if ((window = Minecraft.getInstance().getWindow()).getGuiScaledHeight() < 270 && window.getGuiScale() > 1.0) {
            this.customScale = window.getGuiScale() - 1.0;
            this.width = (int)((double)window.getWidth() / this.customScale);
            this.height = (int)((double)window.getHeight() / this.customScale);
        } else {
            this.customScale = window.getGuiScale();
        }
        this.learnButton = Button.builder((Component)Component.translatable((String)(EpicFightMod.format("gui.%s") + (isUsing ? ".applied" : (meetsCondition ? ".learn" : ".unusable")))), button -> {
            Set<SkillContainer> skillContainers = this.playerpatch.getPlayerSkills().getSkillContainersFor(this.skill.getCategory());
            if (skillContainers.size() == 1) {
                this.acquireSkillTo(skillContainers.iterator().next());
            } else {
                SlotSelectScreen slotSelectScreen = new SlotSelectScreen(skillContainers, this);
                this.minecraft.setScreen((Screen)slotSelectScreen);
            }
        }).bounds(this.width / 2 + 54, this.height / 2 + 90, 67, 21).tooltip(Tooltip.create((Component)tooltip, null)).build(x$0 -> new LearnButton(this, (Button.Builder)x$0));
        if (isUsing || !meetsCondition) {
            this.learnButton.active = false;
        }
        if (this.hand == null) {
            this.learnButton.visible = false;
        }
        this.availableWeaponCategoryList.setX(this.width / 2 + 21);
        this.availableWeaponCategoryList.setY(this.height / 2 + 50);
        this.skillTooltipList.updateSizeAndPosition(210, (this.height + (this.availableWeaponCategoryList.availableCategories.size() == 0 ? 150 : 80)) / 2 - (this.height / 2 - 100), this.height / 2 - 100);
        this.skillTooltipList.setX(this.width / 2 - 40);
        int consumptionEndPos = this.height / 2 + 20 + 20 * Math.min(2, this.consumptionList.children().size());
        this.consumptionList.updateSizeAndPosition(140, consumptionEndPos - this.height / 2 + 20, this.height / 2 + 20);
        this.consumptionList.setX(this.width / 2 - 160);
        this.providingAttributesList.updateSizeAndPosition(140, 60, consumptionEndPos);
        this.providingAttributesList.setX(this.width / 2 - 160);
        this.addRenderableWidget((GuiEventListener)this.learnButton);
        this.addRenderableWidget((GuiEventListener)this.skillTooltipList);
        this.addRenderableWidget((GuiEventListener)this.availableWeaponCategoryList);
        if (this.consumptionList.children().size() > 0) {
            this.addRenderableWidget((GuiEventListener)this.consumptionList);
        }
        if (this.providingAttributesList.children().size() > 0) {
            this.addRenderableWidget((GuiEventListener)this.providingAttributesList);
        }
    }

    protected void acquireSkillTo(SkillContainer skillContainer) {
        skillContainer.setSkill(this.skill);
        this.minecraft.setScreen(null);
        this.playerpatch.getPlayerSkills().addLearnedSkill(this.skill);
        int i = this.hand == InteractionHand.MAIN_HAND ? this.opener.getInventory().selected : 40;
        EpicFightNetworkManager.sendToServer(new CPChangeSkill(skillContainer.getSlot(), this.skill.holder(), i), new CustomPacketPayload[0]);
    }

    protected boolean consumesItem() {
        return true;
    }

    public void onClose() {
        if (this.parentScreen != null) {
            this.minecraft.setScreen(this.parentScreen);
        } else {
            super.onClose();
        }
    }

    public boolean mouseClicked(double x, double y, int button) {
        Window window = Minecraft.getInstance().getWindow();
        return super.mouseClicked((double)((int)(x * window.getGuiScale() / this.customScale)), (double)((int)(y * window.getGuiScale() / this.customScale)), button);
    }

    public boolean mouseReleased(double x, double y, int button) {
        Window window = Minecraft.getInstance().getWindow();
        return super.mouseReleased((double)((int)(x * window.getGuiScale() / this.customScale)), (double)((int)(y * window.getGuiScale() / this.customScale)), button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        Window window = Minecraft.getInstance().getWindow();
        return super.mouseDragged((double)((int)(mouseX * window.getGuiScale() / this.customScale)), (double)((int)(mouseY * window.getGuiScale() / this.customScale)), button, dx, dy);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double xScroll, double yScroll) {
        Window window = Minecraft.getInstance().getWindow();
        return super.mouseScrolled((double)((int)(pMouseX * window.getGuiScale() / this.customScale)), (double)((int)(pMouseY * window.getGuiScale() / this.customScale)), xScroll, yScroll);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.render(guiGraphics, mouseX, mouseY, partialTicks, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, boolean asBackground) {
        guiGraphics.pose().pushPose();
        Window window = Minecraft.getInstance().getWindow();
        double originalScale = window.getGuiScale();
        if (originalScale != this.customScale) {
            window.setGuiScale(this.customScale);
            Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)((double)window.getWidth() / window.getGuiScale()), (float)((double)window.getHeight() / window.getGuiScale()), 0.0f, 1000.0f, ClientHooks.getGuiFarPlane());
            RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
            mouseX = (int)((double)mouseX * (originalScale / this.customScale));
            mouseY = (int)((double)mouseY * (originalScale / this.customScale));
        }
        if (!asBackground) {
            this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        }
        int posX = (this.width - 284) / 2;
        int posY = (this.height - 165) / 2;
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        guiGraphics.blit(SKILLBOOK_BACKGROUND, this.width / 2 - 192, this.height / 2 - 140, 384, 279, 0.0f, 0.0f, 256, 186, 256, 256);
        int iconStartX = 106;
        int iconStartY = 211;
        if (this.skill.getCategory() == SkillCategories.DODGE) {
            iconStartX += 9;
        } else if (this.skill.getCategory() == SkillCategories.GUARD) {
            iconStartX += 18;
        } else if (this.skill.getCategory() == SkillCategories.IDENTITY) {
            iconStartX += 27;
        } else if (this.skill.getCategory() == SkillCategories.MOVER) {
            iconStartX += 36;
        } else if (this.skill.getCategory() == SkillCategories.PASSIVE) {
            iconStartX += 45;
        }
        guiGraphics.blit(SKILLBOOK_BACKGROUND, this.width / 2 - 160, this.height / 2 - 73, 12, 12, (float)iconStartX, (float)iconStartY, 9, 9, 256, 256);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)(this.width / 2 - 16), (double)(this.height / 2 - 73), 0.0);
        guiGraphics.pose().scale(-1.0f, 1.0f, 1.0f);
        RenderSystem.disableCull();
        guiGraphics.blit(SKILLBOOK_BACKGROUND, 0, 0, 12, 12, (float)iconStartX, (float)iconStartY, 9, 9, 256, 256);
        RenderSystem.enableCull();
        guiGraphics.pose().popPose();
        RenderSystem.enableBlend();
        guiGraphics.blit(this.skill.getSkillTexture(), this.width / 2 - 122, this.height / 2 - 99, 68, 68, 0.0f, 0.0f, 128, 128, 128, 128);
        RenderSystem.disableBlend();
        String translationName = this.skill.getTranslationKey();
        String skillName = Component.translatable((String)translationName).getString();
        int width = this.font.width(skillName);
        guiGraphics.drawString(this.font, skillName, posX + 56 - width / 2, posY + 75, 0, false);
        String skillCategory = String.format("(%s)", Component.translatable((String)(EpicFightMod.format("skill.%s") + "." + this.skill.getCategory().toString().toLowerCase() + ".category")).getString());
        width = this.font.width(skillCategory);
        guiGraphics.drawString(this.font, skillCategory, posX + 56 - width / 2, posY + 90, 0, false);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        guiGraphics.pose().popPose();
        if (originalScale != this.customScale) {
            window.setGuiScale(originalScale);
            Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)((double)window.getWidth() / window.getGuiScale()), (float)((double)window.getHeight() / window.getGuiScale()), 0.0f, 1000.0f, ClientHooks.getGuiFarPlane());
            RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TextureInfo {
        final ResourceLocation resourceLocation;
        final int u;
        final int v;
        final int width;
        final int height;

        public TextureInfo(ResourceLocation resourceLocation, int u, int v, int width, int height) {
            this.resourceLocation = resourceLocation;
            this.u = u;
            this.v = v;
            this.width = width;
            this.height = height;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private class SkillTooltipList
    extends ObjectSelectionList<TooltipLine> {
        public SkillTooltipList(Minecraft minecraft, int width, int height, int y, int itemHeight) {
            super(minecraft, width, height, y, itemHeight);
            this.setRenderHeader(false, 0);
        }

        protected void renderListBackground(GuiGraphics guiGraphics) {
        }

        protected void renderListSeparators(GuiGraphics guiGraphics) {
        }

        public void add(FormattedCharSequence tooltip) {
            this.addEntry((AbstractSelectionList.Entry)new TooltipLine(tooltip));
        }

        protected int getScrollbarPosition() {
            return this.getRight() - 6;
        }

        @OnlyIn(value=Dist.CLIENT)
        private class TooltipLine
        extends ObjectSelectionList.Entry<TooltipLine> {
            private final FormattedCharSequence tooltip;

            private TooltipLine(FormattedCharSequence string) {
                this.tooltip = string;
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                guiGraphics.drawString(SkillBookScreen.this.font, this.tooltip, left + 59, top, 0, false);
            }

            public Component getNarration() {
                return Component.empty();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private class AvailableItemsList
    extends AbstractWidget {
        private static final float ICON_LENGTH = 21.25f;
        private final List<WeaponCategory> availableCategories;
        private int startIdx;
        private int size;

        private AvailableItemsList(int x, int y) {
            super(x, y, 0, 0, (Component)Component.translatable((String)EpicFightMod.format("gui.%s.available_weapon_types")));
            this.availableCategories = Lists.newArrayList();
            this.width = 0;
            this.height = 28;
        }

        public void addWeaponCategory(WeaponCategory weaopnCategory) {
            this.availableCategories.add(weaopnCategory);
            this.width = (int)((float)this.width + 21.25f);
            ++this.size;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.availableCategories.size() == 0) {
                return;
            }
            float x = this.getX() + 3;
            int y = this.getY() + 13;
            boolean updatedTooltip = false;
            guiGraphics.blit(SKILLBOOK_BACKGROUND, SkillBookScreen.this.width / 2 + 20, SkillBookScreen.this.height / 2 + 60, 130, 22, 0.0f, 223.0f, 104, 17, 256, 256);
            int displayedCount = 0;
            for (int i = this.startIdx; i < this.size && displayedCount <= 5; ++displayedCount, ++i) {
                WeaponCategory category = this.availableCategories.get(i);
                if (WEAPON_CATEGORY_ICONS.containsKey(category)) {
                    guiGraphics.renderItem(WEAPON_CATEGORY_ICONS.get(category), (int)x, y);
                }
                if ((float)mouseX >= x && (float)mouseX <= x + 21.25f && mouseY >= y && (float)mouseY <= (float)y + 21.25f) {
                    this.setTooltip(Tooltip.create((Component)Component.translatable((String)(EpicFightMod.format("%s.weapon_category.") + category.toString().toLowerCase(Locale.ROOT)))));
                    updatedTooltip = true;
                }
                x += 21.25f;
            }
            if (!updatedTooltip) {
                this.setTooltip(null);
            }
            if (this.availableCategories.size() > 5) {
                int x1 = SkillBookScreen.this.width / 2 + 20;
                int y1 = SkillBookScreen.this.height / 2 + 83;
                int scrollSize = (int)(130.0 * (6.0 / (double)this.size));
                int scrollStart = this.startIdx * (130 - scrollSize) + 1;
                guiGraphics.fill(x1, y1, x1 + 130, y1 + 4, -1845578);
                guiGraphics.fill(x1 + scrollStart, y1 + 1, x1 + scrollStart + scrollSize - 2, y1 + 3, -4016228);
            }
            guiGraphics.drawString(SkillBookScreen.this.font, this.getMessage(), this.getX(), this.getY(), 0, false);
        }

        public boolean mouseScrolled(double x, double y, double xScroll, double yScroll) {
            if (this.isMouseOver(x, y) && this.size > 6) {
                this.startIdx = Mth.clamp((int)((int)((double)this.startIdx - yScroll)), (int)0, (int)(this.size - 6));
                return true;
            }
            return false;
        }

        protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class AttributeIconList
    extends ContainerObjectSelectionList<ProvidingAttributeEntry> {
        public AttributeIconList(Minecraft minecraft, int width, int height, int y, int itemHeight) {
            super(minecraft, width, height, y, itemHeight);
            this.setRenderHeader(false, 0);
        }

        protected void renderListBackground(GuiGraphics guiGraphics) {
        }

        protected void renderListSeparators(GuiGraphics guiGraphics) {
        }

        public void add(Holder<Attribute> attribute, AttributeModifier ability, TextureInfo textureInfo) {
            this.addEntry((AbstractSelectionList.Entry)new ProvidingAttributeEntry(this, attribute, ability, textureInfo));
        }

        public void add(Component tooltip, Component descriptor, TextureInfo textureInfo) {
            this.addEntry((AbstractSelectionList.Entry)new ProvidingAttributeEntry(this, tooltip, descriptor, textureInfo));
        }

        protected int getScrollbarPosition() {
            return this.getRight() - 6;
        }

        public int getRowLeft() {
            return this.getX() + 2;
        }

        @OnlyIn(value=Dist.CLIENT)
        private class ProvidingAttributeEntry
        extends ContainerObjectSelectionList.Entry<ProvidingAttributeEntry> {
            private List<AbstractWidget> icons = Lists.newArrayList();

            private ProvidingAttributeEntry(AttributeIconList attributeIconList, Holder<Attribute> attribute, AttributeModifier ability, TextureInfo textureInfo) {
                Object amountString = "";
                String operator = "+";
                double amount = ability.amount();
                if (amount < 0.0) {
                    operator = "-";
                    amount = Math.abs(amount);
                }
                switch (ability.operation()) {
                    case ADD_VALUE: {
                        amountString = ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(amount);
                        break;
                    }
                    case ADD_MULTIPLIED_BASE: 
                    case ADD_MULTIPLIED_TOTAL: {
                        amountString = ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(amount * 100.0) + "%";
                    }
                }
                this.icons.add(new AttributeIcon(0, 0, 12, 12, attribute, textureInfo));
                Static abilityString = new Static((Screen)attributeIconList.SkillBookScreen.this, 0, 140, 0, 15, null, null, (Component)Component.literal((String)(operator + (String)amountString + " " + Component.translatable((String)((Attribute)attribute.value()).getDescriptionId()).getString())));
                abilityString.setColor(0, 0, 0);
                this.icons.add(abilityString);
            }

            private ProvidingAttributeEntry(AttributeIconList attributeIconList, Component customTooltip, Component customDescription, TextureInfo textureInfo) {
                this.icons.add(new AttributeIcon(0, 0, 12, 12, customTooltip, textureInfo));
                Static abilityString = new Static((Screen)attributeIconList.SkillBookScreen.this, 0, 140, 0, 15, null, null, customDescription);
                abilityString.setColor(0, 0, 0);
                this.icons.add(abilityString);
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                int widgetLeft = left;
                for (AbstractWidget widget : this.icons) {
                    widget.setPosition(widgetLeft, top);
                    widget.render(guiGraphics, mouseX, mouseY, partialTicks);
                    widgetLeft += widget.getWidth() + 4;
                }
            }

            public List<? extends GuiEventListener> children() {
                return this.icons;
            }

            public List<? extends NarratableEntry> narratables() {
                return this.icons;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private class LearnButton
    extends Button {
        protected static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"widget/skillbook_button"), ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"widget/skillbook_button_disabled"), ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"widget/skillbook_button_highlighted"));

        protected LearnButton(SkillBookScreen skillBookScreen, Button.Builder builder) {
            super(builder);
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            Minecraft minecraft = Minecraft.getInstance();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            guiGraphics.pose().pushPose();
            guiGraphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            guiGraphics.pose().popPose();
            int i = this.getFGColor();
            this.renderString(guiGraphics, minecraft.font, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class AttributeIcon
    extends AbstractWidget {
        private final TextureInfo textureInfo;

        public AttributeIcon(int x, int y, int width, int height, Holder<Attribute> attribute, TextureInfo textureInfo) {
            super(x, y, width, height, (Component)Component.translatable((String)(((Attribute)attribute.value()).getDescriptionId() + ".skillbook_tooltip")));
            this.textureInfo = textureInfo;
        }

        public AttributeIcon(int x, int y, int width, int height, Component customTooltip, TextureInfo textureInfo) {
            super(x, y, width, height, customTooltip);
            this.textureInfo = textureInfo;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.textureInfo != null) {
                guiGraphics.blit(this.textureInfo.resourceLocation, this.getX(), this.getY(), this.getWidth(), this.getHeight(), (float)this.textureInfo.u, (float)this.textureInfo.v, this.textureInfo.width, this.textureInfo.height, 256, 256);
            }
            if (this.isHovered()) {
                this.setTooltip(this.getMessage() == null ? null : Tooltip.create((Component)this.getMessage()));
            } else {
                this.setTooltip(null);
            }
        }

        protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
        }
    }
}

