/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import net.caffeinemc.mods.sodium.client.model.quad.BakedQuadView;
import net.irisshaders.batchedentityrendering.impl.FullyBufferedMultiBufferSource;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix3f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.FakeBlockRenderer;

@OnlyIn(value=Dist.CLIENT)
public class SodiumFakeBlockRenderer
implements FakeBlockRenderer {
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final int POSITION_MAX_VALUE = 65536;
    private static final float MODEL_ORIGIN = 8.0f;
    private static final float MODEL_RANGE = 32.0f;
    private static final float MODEL_SCALE = 4.8828125E-4f;
    private static final float MODEL_SCALE_INV = 2048.0f;

    @Override
    public void render(Camera camera, PoseStack poseStack, MultiBufferSource buffers, Level level, BlockPos bp, float r, float g, float b, float a) {
        BlockState bs = level.getBlockState(bp);
        if (bs.getRenderShape() != RenderShape.MODEL) {
            return;
        }
        RandomSource randomsource = RandomSource.create();
        long seed = bs.getSeed(bp);
        randomsource.setSeed(seed);
        Vec3 offset = bs.hasOffsetFunction() ? bs.getOffset((BlockGetter)level, bp) : Vec3.ZERO;
        VertexConsumer buffer = buffers.getBuffer(EpicFightRenderTypes.blockHighlight());
        BlockRenderDispatcher blockrenderdispatcher = Minecraft.getInstance().getBlockRenderer();
        BakedModel model = blockrenderdispatcher.getBlockModel(bs);
        BlockPos.MutableBlockPos mutablepos = bp.mutable();
        int originX = bp.getX() & 0xF;
        int originY = bp.getY() & 0xF;
        int originZ = bp.getZ() & 0xF;
        for (Direction d : DIRECTIONS) {
            List culledFaces = model.getQuads(bs, d, randomsource, ModelData.EMPTY, null);
            mutablepos.setWithOffset((Vec3i)bp, d);
            if (!Block.shouldRenderFace((BlockState)bs, (BlockGetter)level, (BlockPos)bp, (Direction)d, (BlockPos)mutablepos)) continue;
            this.renderPreviewBlocks(buffer, (BlockAndTintGetter)level, culledFaces, originX, originY, originZ, offset, r, g, b, a);
        }
        this.renderPreviewBlocks(buffer, (BlockAndTintGetter)level, model.getQuads(bs, null, randomsource, ModelData.EMPTY, null), originX, originY, originZ, offset, r, g, b, a);
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().mul((Matrix4fc)poseStack.last().pose());
        RenderSystem.applyModelViewMatrix();
        Uniform uniform = GameRenderer.getRendertypeTranslucentShader().CHUNK_OFFSET;
        Vec3 camPos = camera.getPosition();
        int cameraBpX = (int)camPos.x;
        int cameraBpY = (int)camPos.y;
        int cameraBpZ = (int)camPos.z;
        uniform.set((float)((bp.getX() >> 4 << 4) - cameraBpX) - SodiumFakeBlockRenderer.fractional(camPos.x), (float)((bp.getY() >> 4 << 4) - cameraBpY) - SodiumFakeBlockRenderer.fractional(camPos.y), (float)((bp.getZ() >> 4 << 4) - cameraBpZ) - SodiumFakeBlockRenderer.fractional(camPos.z));
        if (buffers instanceof FullyBufferedMultiBufferSource) {
            FullyBufferedMultiBufferSource irisBuffer = (FullyBufferedMultiBufferSource)buffers;
            irisBuffer.endBatch();
        } else if (buffers instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource vanillaBuffer = (MultiBufferSource.BufferSource)buffers;
            vanillaBuffer.endLastBatch();
        }
        uniform.set(0.0f, 0.0f, 0.0f);
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    private void renderPreviewBlocks(VertexConsumer consumer, BlockAndTintGetter level, List<BakedQuad> quads, int originX, int originY, int originZ, Vec3 offset, float r, float g, float b, float a) {
        for (BakedQuad bakedquad : quads) {
            float f = level.getShade(bakedquad.getDirection(), bakedquad.isShade());
            SodiumFakeBlockRenderer.putBulkDataWithoutPose(consumer, bakedquad, originX, originY, originZ, offset, new float[]{f, f, f, f}, r, g, b, a, new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF}, OverlayTexture.NO_OVERLAY, false);
        }
    }

    private static void putBulkDataWithoutPose(VertexConsumer vertexConsumer, BakedQuad pQuad, int originX, int originY, int originZ, Vec3 offset, float[] pColorMuls, float pRed, float pGreen, float pBlue, float alpha, int[] pCombinedLights, int pCombinedOverlay, boolean pMulColor) {
        float[] afloat = new float[]{pColorMuls[0], pColorMuls[1], pColorMuls[2], pColorMuls[3]};
        int[] aint1 = pQuad.getVertices();
        Vec3i vec3i = pQuad.getDirection().getNormal();
        Vector3f vector3f = new Vector3f((float)vec3i.getX(), (float)vec3i.getY(), (float)vec3i.getZ());
        int j = pQuad.getVertices().length / 8;
        BakedQuadView bakedQuadView = (BakedQuadView)pQuad;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.BLOCK.getVertexSize());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int k = 0; k < j; ++k) {
                float f5;
                float f4;
                float f3;
                intbuffer.clear();
                intbuffer.put(aint1, k * 8, 8);
                float outX = SodiumFakeBlockRenderer.decodePosition(SodiumFakeBlockRenderer.encodePosition((float)originX + bakedQuadView.getX(k) + (float)offset.x()));
                float outY = SodiumFakeBlockRenderer.decodePosition(SodiumFakeBlockRenderer.encodePosition((float)originY + bakedQuadView.getY(k) + (float)offset.y()));
                float outZ = SodiumFakeBlockRenderer.decodePosition(SodiumFakeBlockRenderer.encodePosition((float)originZ + bakedQuadView.getZ(k) + (float)offset.z()));
                if (pMulColor) {
                    float f6 = (float)(bytebuffer.get(12) & 0xFF) / 255.0f;
                    float f7 = (float)(bytebuffer.get(13) & 0xFF) / 255.0f;
                    float f8 = (float)(bytebuffer.get(14) & 0xFF) / 255.0f;
                    f3 = f6 * afloat[k] * pRed;
                    f4 = f7 * afloat[k] * pGreen;
                    f5 = f8 * afloat[k] * pBlue;
                } else {
                    f3 = afloat[k] * pRed;
                    f4 = afloat[k] * pGreen;
                    f5 = afloat[k] * pBlue;
                }
                int l = vertexConsumer.applyBakedLighting(pCombinedLights[k], bytebuffer);
                float f9 = bytebuffer.getFloat(16);
                float f10 = bytebuffer.getFloat(20);
                vertexConsumer.applyBakedNormals(vector3f, bytebuffer, new Matrix3f());
                float vertexAlpha = pMulColor ? alpha * (float)(bytebuffer.get(15) & 0xFF) / 255.0f : alpha;
                vertexConsumer.addVertex(outX, outY, outZ).setColor(f3, f4, f5, vertexAlpha).setUv(f9, f10).setOverlay(pCombinedOverlay).setLight(l).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
            }
        }
    }

    private static float fractional(double value) {
        float fullPrecision = (float)(value - (double)((int)value));
        float modifier = Math.copySign(128.0f, fullPrecision);
        return fullPrecision + modifier - modifier;
    }

    static short encodePosition(float v) {
        return (short)((8.0f + v) * 2048.0f);
    }

    static float decodePosition(short raw) {
        return (float)(raw & 0xFFFF) * 4.8828125E-4f - 8.0f;
    }
}

