/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ZombieVillagerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.VillagerProfessionLayer;
import net.minecraft.client.resources.metadata.animation.VillagerMetaDataSection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.mesh.VillagerMesh;
import yesman.epicfight.client.renderer.patched.layer.ModelRenderLayer;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

@OnlyIn(value=Dist.CLIENT)
public class PatchedVillagerProfessionLayer
extends ModelRenderLayer<ZombieVillager, MobPatch<ZombieVillager>, ZombieVillagerModel<ZombieVillager>, VillagerProfessionLayer<ZombieVillager, ZombieVillagerModel<ZombieVillager>>, VillagerMesh> {
    public PatchedVillagerProfessionLayer() {
        super(Meshes.VILLAGER_ZOMBIE);
    }

    @Override
    protected void renderLayer(MobPatch<ZombieVillager> entitypatch, ZombieVillager entityliving, VillagerProfessionLayer<ZombieVillager, ZombieVillagerModel<ZombieVillager>> vanillaLayer, PoseStack postStack, MultiBufferSource buffer, int packedLight, OpenMatrix4f[] poses, float bob, float yRot, float xRot, float partialTicks) {
        if (!entityliving.isInvisible()) {
            VillagerData villagerdata = ((VillagerDataHolder)entitypatch.getOriginal()).getVillagerData();
            VillagerMetaDataSection.Hat typeHat = vanillaLayer.getHatData(vanillaLayer.typeHatCache, "type", BuiltInRegistries.VILLAGER_TYPE, (Object)villagerdata.getType());
            VillagerMetaDataSection.Hat professionHat = vanillaLayer.getHatData(vanillaLayer.professionHatCache, "profession", BuiltInRegistries.VILLAGER_PROFESSION, (Object)villagerdata.getProfession());
            if (typeHat != VillagerMetaDataSection.Hat.NONE && (typeHat != VillagerMetaDataSection.Hat.PARTIAL || professionHat == VillagerMetaDataSection.Hat.FULL) || !entityliving.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                ((VillagerMesh)this.mesh.get()).head.setHidden(true);
                ((VillagerMesh)this.mesh.get()).hat.setHidden(true);
            }
            if (!((ZombieVillager)entitypatch.getOriginal()).getItemBySlot(EquipmentSlot.LEGS).isEmpty()) {
                ((VillagerMesh)this.mesh.get()).jacket.setHidden(true);
            }
            ((VillagerMesh)this.mesh.get()).draw(postStack, buffer, RenderType.entityCutoutNoCull((ResourceLocation)vanillaLayer.getResourceLocation("type", BuiltInRegistries.VILLAGER_TYPE.getKey((Object)villagerdata.getType()))), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, LivingEntityRenderer.getOverlayCoords((LivingEntity)entityliving, (float)0.0f), entitypatch.getArmature(), poses);
            if (villagerdata.getProfession() != VillagerProfession.NONE) {
                ((VillagerMesh)this.mesh.get()).draw(postStack, buffer, RenderType.entityCutoutNoCull((ResourceLocation)vanillaLayer.getResourceLocation("profession", BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)villagerdata.getProfession()))), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, LivingEntityRenderer.getOverlayCoords((LivingEntity)entityliving, (float)0.0f), entitypatch.getArmature(), poses);
            }
        }
    }
}

