/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.compat.shouldersurfing;

import com.github.exopandora.shouldersurfing.api.callback.ICameraCouplingCallback;
import com.github.exopandora.shouldersurfing.api.plugin.IShoulderSurfingPlugin;
import com.github.exopandora.shouldersurfing.api.plugin.IShoulderSurfingRegistrar;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.input.action.EpicFightInputActions;
import yesman.epicfight.api.client.input.handlers.InputManager;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;

@OnlyIn(value=Dist.CLIENT)
public class ShoulderSurfingCompat
implements IShoulderSurfingPlugin {
    public void register(IShoulderSurfingRegistrar registrar) {
        registrar.registerCameraCouplingCallback((ICameraCouplingCallback)new ForceCameraCouplingWhenAttackingCallback());
        registrar.registerCameraCouplingCallback((ICameraCouplingCallback)new ForceCameraCouplingWhenHoldingSkillCallback());
    }

    private static class ForceCameraCouplingWhenAttackingCallback
    implements ICameraCouplingCallback {
        private ForceCameraCouplingWhenAttackingCallback() {
        }

        public boolean isForcingCameraCoupling(Minecraft minecraft) {
            return InputManager.isActionActive(EpicFightInputActions.ATTACK) || InputManager.isActionActive(EpicFightInputActions.VANILLA_ATTACK_DESTROY);
        }
    }

    private static class ForceCameraCouplingWhenHoldingSkillCallback
    implements ICameraCouplingCallback {
        private ForceCameraCouplingWhenHoldingSkillCallback() {
        }

        public boolean isForcingCameraCoupling(Minecraft minecraft) {
            LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
            if (localPlayerPatch == null) {
                return false;
            }
            return localPlayerPatch.isHoldingAny();
        }
    }
}

