/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.epicskins.client.screen;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.exception.ExceptionUtils;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SoftBodyTranslatable;
import yesman.epicfight.api.client.physics.cloth.ClothColliderPresets;
import yesman.epicfight.api.client.physics.cloth.ClothSimulator;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.api.utils.math.Vec4f;
import yesman.epicfight.client.gui.datapack.screen.MessageScreen;
import yesman.epicfight.client.gui.datapack.widgets.CheckBox;
import yesman.epicfight.client.gui.datapack.widgets.InputComponentList;
import yesman.epicfight.client.gui.datapack.widgets.ModelPreviewer;
import yesman.epicfight.client.gui.datapack.widgets.ResizableComponent;
import yesman.epicfight.client.gui.datapack.widgets.ResizableEditBox;
import yesman.epicfight.client.gui.datapack.widgets.Static;
import yesman.epicfight.client.gui.widgets.ColorSlider;
import yesman.epicfight.epicskins.animation.EpicSkinsAnimations;
import yesman.epicfight.epicskins.client.screen.AwaitIconMessageScreen;
import yesman.epicfight.epicskins.client.widget.CapePopupBox;
import yesman.epicfight.epicskins.exception.HttpResponseException;
import yesman.epicfight.epicskins.user.AuthenticationHelperImpl;
import yesman.epicfight.epicskins.user.Cosmetic;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.main.AuthenticationHelper;
import yesman.epicfight.model.armature.HumanoidArmature;

@OnlyIn(value=Dist.CLIENT)
public class AvatarEditScreen
extends Screen {
    private static final List<AssetAccessor<? extends StaticAnimation>> IDLE_ANIMATIONS = List.of(EpicSkinsAnimations.BIPED_IDLE1, EpicSkinsAnimations.BIPED_IDLE2);
    private final Screen parentScreen;
    private final Queue<Runnable> deferredWorks = new ConcurrentLinkedQueue<Runnable>();
    private LayoutElements<?> capeOptionsLayout;
    private LayoutElements<?> capeSelectionLayout;
    private LayoutElements<?> activatedLayout;
    private CapePopupBox capePopupBox;
    private CapeList capeList;
    private InputComponentList<JsonElement> capeOptions;
    private ModelPreviewer mainModelPreviewer;
    private ColorSlider hueSlider;
    private ColorSlider saturationSlider;
    private ColorSlider brightnessSlider;
    private CheckBox useVanillTextureCheckBox;
    private int nextPlaying;
    private Button saveButton;
    private Button quitButton;
    private Button signOutButton;
    private Button backButton;

    public AvatarEditScreen(Screen screen) {
        super((Component)Component.translatable((String)"gui.epicskins.skin_config"));
        this.parentScreen = screen;
        this.minecraft = screen.getMinecraft();
        this.font = this.minecraft.font;
        this.saveButton = Button.builder((Component)Component.translatable((String)"gui.epicskins.button.save"), button -> {
            this.popupResponseAwaiting();
            AuthenticationHelperImpl.CapeProperties epicskinsInfo = AuthenticationHelperImpl.getInstance().capeProperties();
            epicskinsInfo.setCape(this.capePopupBox._getValue() != null ? ((Cosmetic)this.capePopupBox._getValue()).seq() : -1);
            epicskinsInfo.setHue(this.hueSlider.getPosition());
            epicskinsInfo.setSaturation(this.saturationSlider.getPosition());
            epicskinsInfo.setBrightness(this.brightnessSlider.getPosition());
            epicskinsInfo.setVanillaTextureUse(this.useVanillTextureCheckBox._getValue());
            AuthenticationHelperImpl.getInstance().sendSaveRequest(ex -> {
                if (ex instanceof HttpResponseException) {
                    HttpResponseException httpFailResponseException = (HttpResponseException)ex;
                    httpFailResponseException.printStackTrace();
                    this.popupHttpResponseException(httpFailResponseException.getHttpStatusCode(), httpFailResponseException.getResponseBody());
                } else if (ex != null) {
                    this.popupConnectionFail((Throwable)ex);
                } else {
                    this.popupSavedSuccess();
                }
            });
        }).size(80, 20).build();
        this.saveButton.active = AuthenticationHelperImpl.getInstance().status() == AuthenticationHelper.Status.AUTHENTICATED;
        this.quitButton = Button.builder((Component)Component.translatable((String)"gui.epicskins.button.quit"), button -> Minecraft.getInstance().setScreen(this.parentScreen)).size(80, 20).build();
        this.signOutButton = Button.builder((Component)Component.translatable((String)"gui.epicskins.button.delete_account"), button -> this.popupSignOutAsk()).size(90, 20).build();
        this.backButton = Button.builder((Component)Component.translatable((String)"gui.epicskins.button.back"), button -> this.deferredWorks.add(() -> {
            this.capeOptionsLayout.accept(x$0 -> this.addRenderableWidget((GuiEventListener)x$0));
            this.capeSelectionLayout.accept(x$0 -> this.removeWidget((GuiEventListener)x$0));
            this.activatedLayout = this.capeOptionsLayout;
            Cosmetic cosmetic = (Cosmetic)this.capePopupBox._getValue();
            if (cosmetic != null) {
                cosmetic.getAsMesh(mesh -> {
                    this.mainModelPreviewer.setCloakColor(cosmetic.useIntParam1() ? this.brightnessSlider.getColor() : -1);
                    this.mainModelPreviewer.initCloakInfo((SoftBodyTranslatable)((Object)mesh), cosmetic.textureLocation(), ClothSimulator.ClothObjectBuilder.create().parentJoint(((HumanoidArmature)Armatures.BIPED.get()).torso).putAll(ClothColliderPresets.BIPED));
                    this.capePopupBox._setValue(cosmetic);
                    this.refreshOptionComponents(cosmetic);
                });
            } else {
                this.mainModelPreviewer.removeCloak();
            }
        })).size(200, 20).build();
        this.mainModelPreviewer = new ModelPreviewer(165, 10, 15, 34, ResizableComponent.HorizontalSizing.WIDTH_RIGHT, ResizableComponent.VerticalSizing.TOP_BOTTOM, Armatures.BIPED, Meshes.BIPED);
        this.mainModelPreviewer.setBackgroundClearColor(new Vec4f(0.0f, 0.0f, 0.0f, 0.0f));
        this.mainModelPreviewer.enableZoomingCamera(false);
        this.mainModelPreviewer.enableCameraMove(false);
        this.mainModelPreviewer.setCameraTransform(-3.0, 28.0f, 160.0f, 0.0f, 0.0f);
        this.mainModelPreviewer.setFigureTexture(AuthenticationHelperImpl.getInstance().playerInfo().getSkin().texture());
        if (PlayerSkin.Model.SLIM.equals((Object)AuthenticationHelperImpl.getInstance().playerInfo().getSkin().model())) {
            this.mainModelPreviewer.setMesh(Meshes.ALEX);
        } else {
            this.mainModelPreviewer.setMesh(Meshes.BIPED);
        }
        this.mainModelPreviewer.addAnimationToPlay(EpicSkinsAnimations.BIPED_STANDING);
        RandomSource randomSource = RandomSource.create((long)System.currentTimeMillis());
        this.nextPlaying = 160 + randomSource.nextInt(120);
        this.capeOptions = new InputComponentList<JsonElement>(this, (Screen)this, 0, 0, 0, 30){

            @Override
            public void importTag(JsonElement tag) {
            }
        };
        this.capePopupBox = new CapePopupBox(this, this.font, 0, 10, 60, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"gui.epicskins.avatar.cape_type"), cosmetic -> ParseUtil.nullOrToString(cosmetic, Cosmetic::title), () -> this.deferredWorks.add(() -> {
            block0: for (CapeList.CosmeticsEntry e : this.capeList.children()) {
                for (GuiEventListener guiEventListener : e.children()) {
                    CapeList.CapeBlock capeBlock = (CapeList.CapeBlock)guiEventListener;
                    if (capeBlock.cosmetic != this.capePopupBox._getValue()) continue;
                    this.capeList.setFocused((GuiEventListener)e);
                    if (this.capeList.focused != null) {
                        this.capeList.focused.setFocused(false);
                    }
                    this.capeList.focused = capeBlock;
                    capeBlock.setFocused(true);
                    break block0;
                }
            }
            this.capeList.moveScrollToFocus();
            this.capeOptionsLayout.accept(x$0 -> this.removeWidget((GuiEventListener)x$0));
            this.capeSelectionLayout.accept(x$0 -> this.addRenderableWidget((GuiEventListener)x$0));
            this.activatedLayout = this.capeSelectionLayout;
        }), null);
        this.capeOptions.newRow();
        this.capeOptions.addComponentCurrentRow(new Static((Screen)this, this.capeOptions.nextStart(8), 80, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "gui.epicskins.avatar.cape_type"));
        this.capeOptions.addComponentCurrentRow(this.capePopupBox.relocateX(this.getRectangle(), this.capeOptions.nextStart(8)));
        this.hueSlider = new ColorSlider(this.font, this.capeOptions.nextStart(8), 10, 60, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"gui.epicskins.cape_color"), ColorSlider.Style.SIMPLE, 0.0, (position, color) -> {
            this.saturationSlider.changeColor((int)color, 0);
            this.brightnessSlider.changeColor(this.saturationSlider.getColor(), 0);
            if (!(((Cosmetic)this.capePopupBox._getValue()).useBoolParam1() && this.useVanillTextureCheckBox._getValue().booleanValue() || !((Cosmetic)this.capePopupBox._getValue()).useIntParam1())) {
                this.mainModelPreviewer.setCloakColor(this.brightnessSlider.getColor());
            }
        });
        this.saturationSlider = new ColorSlider(this.font, 0, 10, 60, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"gui.epicskins.cape_color"), ColorSlider.Style.SIMPLE, 0.0, (position, color) -> {
            this.brightnessSlider.changeColor((int)color, 0);
            if (!(((Cosmetic)this.capePopupBox._getValue()).useBoolParam1() && this.useVanillTextureCheckBox._getValue().booleanValue() || !((Cosmetic)this.capePopupBox._getValue()).useIntParam1())) {
                this.mainModelPreviewer.setCloakColor(this.brightnessSlider.getColor());
            }
        }, -65536, -1);
        this.brightnessSlider = new ColorSlider(this.font, 0, 10, 60, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"gui.epicskins.cape_color"), ColorSlider.Style.SIMPLE, 0.0, (position, color) -> {
            if (!(((Cosmetic)this.capePopupBox._getValue()).useBoolParam1() && this.useVanillTextureCheckBox._getValue().booleanValue() || !((Cosmetic)this.capePopupBox._getValue()).useIntParam1())) {
                this.mainModelPreviewer.setCloakColor((int)color);
            }
        }, -65536, -16777216);
        this.useVanillTextureCheckBox = new CheckBox(this.font, this.capeOptions.nextStart(8), 60, 0, 10, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, false, (Component)Component.literal((String)""), null);
        Consumer<Boolean> responder = val -> {
            if (this.capeList != null) {
                this.mainModelPreviewer.setCloakTexture(val != false ? AuthenticationHelperImpl.getInstance().playerInfo().getSkin().capeTexture() : ((Cosmetic)this.capePopupBox._getValue()).textureLocation());
                this.mainModelPreviewer.setCloakColor(val != false || !((Cosmetic)this.capePopupBox._getValue()).useIntParam1() ? -1 : this.brightnessSlider.getColor());
            }
        };
        AuthenticationHelperImpl.CapeProperties epicskinsInfo = AuthenticationHelperImpl.getInstance().capeProperties();
        Cosmetic cosmetic2 = AuthenticationHelperImpl.getInstance().getCosmetic(epicskinsInfo.capeSeq());
        if (cosmetic2 != null) {
            cosmetic2.getAsMesh(mesh -> {
                this.mainModelPreviewer.setCloakColor(cosmetic2.useIntParam1() && !epicskinsInfo.useVanillaTexture() ? this.brightnessSlider.getColor() : -1);
                this.mainModelPreviewer.initCloakInfo((SoftBodyTranslatable)((Object)mesh), cosmetic2.useBoolParam1() && epicskinsInfo.useVanillaTexture() ? AuthenticationHelperImpl.getInstance().playerInfo().getSkin().capeTexture() : cosmetic2.textureLocation(), ClothSimulator.ClothObjectBuilder.create().parentJoint(((HumanoidArmature)Armatures.BIPED.get()).torso).putAll(ClothColliderPresets.BIPED));
                this.refreshOptionComponents(cosmetic2);
            });
            this.capePopupBox._setValue(cosmetic2);
            this.useVanillTextureCheckBox._setResponder(responder);
            this.useVanillTextureCheckBox._setValue(epicskinsInfo.useVanillaTexture());
            this.hueSlider.setValue(epicskinsInfo.hue());
            this.saturationSlider.setValue(epicskinsInfo.saturation());
            this.brightnessSlider.setValue(epicskinsInfo.brightness());
        } else {
            this.useVanillTextureCheckBox._setValue(false);
            this.useVanillTextureCheckBox._setResponder(responder);
        }
        this.capeList = new CapeList(this.minecraft, (int)((float)this.width * 0.6f) - 20, this.height - 64, 30);
        this.capeOptionsLayout = new LayoutElements((GuiEventListener[])new AbstractWidget[]{this.capeOptions, this.saveButton, this.quitButton, this.signOutButton});
        this.capeSelectionLayout = new LayoutElements((GuiEventListener[])new AbstractWidget[]{this.capeList, this.backButton});
    }

    public void refreshOptionComponents(Cosmetic selectedCosmetic) {
        this.capeOptions.clearComponents();
        switch (selectedCosmetic.slot()) {
            case CAPE: {
                this.capeOptions.newRow();
                this.capeOptions.addComponentCurrentRow(new Static((Screen)this, this.capeOptions.nextStart(8), 80, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "gui.epicskins.avatar.cape_type"));
                this.capeOptions.addComponentCurrentRow(this.capePopupBox.relocateX(this.getRectangle(), this.capeOptions.nextStart(8)));
                if (selectedCosmetic.useIntParam1()) {
                    this.capeOptions.newRow();
                    this.capeOptions.addComponentCurrentRow(new Static((Screen)this, this.capeOptions.nextStart(8), 80, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "gui.epicskins.avatar.cape_color"));
                    this.capeOptions.addComponentCurrentRow(this.hueSlider.relocateX(this.getRectangle(), this.capeOptions.nextStart(8)));
                    this.capeOptions.newRow();
                    this.capeOptions.addComponentCurrentRow(this.saturationSlider.relocateX(this.getRectangle(), this.capeOptions.nextStart(96)));
                    this.capeOptions.newRow();
                    this.capeOptions.addComponentCurrentRow(this.brightnessSlider.relocateX(this.getRectangle(), this.capeOptions.nextStart(96)));
                }
                if (!selectedCosmetic.useBoolParam1() || AuthenticationHelperImpl.getInstance().playerInfo().getSkin().capeTexture() == null) break;
                this.capeOptions.newRow();
                this.capeOptions.addComponentCurrentRow(new Static((Screen)this, this.capeOptions.nextStart(8), 80, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "gui.epicskins.avatar.vanilla_texture"));
                this.capeOptions.addComponentCurrentRow(this.useVanillTextureCheckBox.relocateX(this.getRectangle(), this.capeOptions.nextStart(8)));
            }
        }
        this.capeOptions.updateSizeAndPosition((int)((float)this.width * 0.6f) - 20, this.height - 64, 30);
        this.capeOptions.setX(10);
    }

    protected void init() {
        this.saveButton.setPosition(this.width / 2 - 125, this.height - 28);
        this.quitButton.setPosition(this.width / 2 - 40, this.height - 28);
        this.signOutButton.setPosition(this.width / 2 + 45, this.height - 28);
        this.signOutButton.active = AuthenticationHelperImpl.getInstance().status() == AuthenticationHelper.Status.AUTHENTICATED;
        this.backButton.setPosition(this.width / 2 - 100, this.height - 28);
        this.mainModelPreviewer.setX1((int)((float)this.width * 0.4f));
        this.mainModelPreviewer.resize(this.getRectangle());
        this.capeOptions.updateSizeAndPosition((int)((float)this.width * 0.6f) - 20, this.height - 64, 30);
        this.capeOptions.setX(10);
        this.capeList.updateSizeAndPosition((int)((float)this.width * 0.6f) - 20, this.height - 64, 30);
        this.capeList.setX(10);
        this.capeList.rearrangeCosmetics();
        this.addRenderableWidget(this.mainModelPreviewer);
        if (!this.initialized) {
            if (this.capePopupBox._getValue() != null && ((Cosmetic)this.capePopupBox._getValue()).useBoolParam1() && this.useVanillTextureCheckBox._getValue().booleanValue()) {
                this.mainModelPreviewer.setCloakTexture(AuthenticationHelperImpl.getInstance().playerInfo().getSkin().capeTexture());
            }
            this.initialized = true;
            this.capeOptionsLayout.accept(x$0 -> this.addRenderableWidget((GuiEventListener)x$0));
            this.activatedLayout = this.capeOptionsLayout;
            switch (AuthenticationHelperImpl.getInstance().status()) {
                case UNAUTHENTICATED: {
                    this.popupStartSigningIn();
                    break;
                }
                case OFFLINE_MODE: {
                    this.popupOfflineModeWarning();
                    break;
                }
            }
        } else {
            this.activatedLayout.accept(x$0 -> this.addRenderableWidget((GuiEventListener)x$0));
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        return this.getChildAt(mouseX, mouseY).filter(listener -> listener.mouseDragged(mouseX, mouseY, button, dx, dy)).isPresent();
    }

    public void tick() {
        Runnable work = null;
        while ((work = this.deferredWorks.poll()) != null) {
            work.run();
        }
        if (--this.nextPlaying < 0) {
            RandomSource randomSource = RandomSource.create((long)System.currentTimeMillis());
            this.mainModelPreviewer.getAnimator().playAnimation(IDLE_ANIMATIONS.get(randomSource.nextInt(IDLE_ANIMATIONS.size())), 0.0f);
            this.nextPlaying = 160 + randomSource.nextInt(120);
        }
        this.mainModelPreviewer._tick();
    }

    public void onSigninSuccess() {
        this.deferredWorks.add(() -> {
            this.saveButton.active = true;
            this.minecraft.setScreen((Screen)this);
            this.capeList.rearrangeCosmetics();
            AuthenticationHelperImpl.CapeProperties userskinInfo = AuthenticationHelperImpl.getInstance().capeProperties();
            Cosmetic cosmetic = AuthenticationHelperImpl.getInstance().getCosmetic(userskinInfo.capeSeq());
            if (cosmetic != null) {
                this.capePopupBox._setValue(cosmetic);
                this.hueSlider.setValue(userskinInfo.hue());
                this.saturationSlider.setValue(userskinInfo.saturation());
                this.brightnessSlider.setValue(userskinInfo.brightness());
                this.useVanillTextureCheckBox._setValue(userskinInfo.useVanillaTexture());
                this.refreshOptionComponents(cosmetic);
            }
        });
    }

    public void popupStartSigningIn() {
        this.deferredWorks.add(() -> this.minecraft.setScreen(new MessageScreen("Sign up/in first before setting up cosmetics", "", (Screen)this, button -> {
            this.popupAuthCodeEnter();
            AuthenticationHelperImpl.getInstance().openAuthenticateBrowser();
        }, 240, 70).autoCalculateHeight()));
    }

    public void popupAuthCodeEnter() {
        this.deferredWorks.add(() -> {
            ResizableEditBox verifyingBox = new ResizableEditBox(this.minecraft.font, 0, 0, 0, 16, (Component)Component.literal((String)""), null, null);
            verifyingBox.setMaxLength(6);
            this.minecraft.setScreen(new MessageScreen<String>("Enter the 6-characters verifying code", "", this, code -> {
                this.popupResponseAwaiting();
                AuthenticationHelperImpl.getInstance().loginWithAuthCode((String)code, () -> this.onSigninSuccess(), ex -> {
                    ex.printStackTrace();
                    if (ex instanceof HttpResponseException) {
                        HttpResponseException httpFailResponseException = (HttpResponseException)ex;
                        switch (httpFailResponseException.getResponseBody()) {
                            case "expired": {
                                this.popupVerifyCodeExpired();
                                break;
                            }
                            case "invalid_code": {
                                this.popupInvalidVerifyingCode();
                                break;
                            }
                            case "not_an_owner": {
                                this.popupInvalidVerifyingCode();
                                break;
                            }
                            default: {
                                this.popupHttpResponseException(httpFailResponseException.getHttpStatusCode(), httpFailResponseException.getResponseBody());
                                break;
                            }
                        }
                    } else {
                        this.popupException((Throwable)ex);
                    }
                });
            }, button -> this.minecraft.setScreen((Screen)this), verifyingBox, 300, 90));
        });
    }

    public void popupInvalidVerifyingCode() {
        this.deferredWorks.add(() -> {
            ResizableEditBox verifyingBox = new ResizableEditBox(this.minecraft.font, 0, 0, 0, 16, (Component)Component.literal((String)""), null, null);
            verifyingBox.setMaxLength(6);
            this.minecraft.setScreen(new MessageScreen<String>("Invalid verifying code!", "Please try again", this, code -> AuthenticationHelperImpl.getInstance().loginWithAuthCode((String)code, () -> this.onSigninSuccess(), ex -> {
                if (ex instanceof HttpResponseException) {
                    HttpResponseException httpFailResponseException = (HttpResponseException)ex;
                    switch (httpFailResponseException.getResponseBody()) {
                        case "expired": {
                            this.popupVerifyCodeExpired();
                            break;
                        }
                        case "invalid_code": {
                            this.popupInvalidVerifyingCode();
                            break;
                        }
                        case "not_an_owner": {
                            this.popupInvalidVerifyingCode();
                        }
                    }
                } else {
                    this.popupException((Throwable)ex);
                }
            }), button -> this.minecraft.setScreen((Screen)this), verifyingBox, 200, 100));
        });
    }

    public void popupVerifyCodeExpired() {
        this.deferredWorks.add(() -> this.minecraft.setScreen(new MessageScreen("Verifying code expired!", "", (Screen)this, button2 -> this.minecraft.setScreen(this.parentScreen), 200, 70).autoCalculateHeight()));
    }

    public void popupOfflineModeWarning() {
        this.deferredWorks.add(() -> this.minecraft.setScreen(new MessageScreen("Failed to verify your Minecraft account", "You may use cracked or unofficial launcher, please use official launcher to connect your Minecraft account.", (Screen)this, button2 -> this.minecraft.setScreen(this.parentScreen), 300, 70).autoCalculateHeight()));
    }

    public void popupConnectionFail(Throwable exception) {
        this.deferredWorks.add(() -> this.minecraft.setScreen(new MessageScreen("Connection failed", ExceptionUtils.getRootCause((Throwable)exception).getMessage() + "\n\nPlease try later\nIf the problem persists, please contact us by the links below:\nOfficial Discord Server: https://discord.com/invite/NbAJwj8RHg\nGithub Issue Trakcer: https://github.com/Yesssssman/epicfightmod/issues", (Screen)this, button2 -> this.minecraft.setScreen(this.parentScreen), 300, 70).autoCalculateHeight()));
    }

    public void popupException(Throwable exception) {
        this.deferredWorks.add(() -> this.minecraft.setScreen(new MessageScreen("Connection failed", String.valueOf(ExceptionUtils.getRootCause((Throwable)exception)) + ": " + ExceptionUtils.getRootCause((Throwable)exception).getMessage() + "\n\nPlease report the issue to the link below\nGithub Issue Trakcer: https://github.com/Yesssssman/epicfightmod/issues", (Screen)this, button2 -> this.minecraft.setScreen(this.parentScreen), 300, 70).autoCalculateHeight()));
    }

    public void popupHttpResponseException(int responseCode, String responseBody) {
        this.deferredWorks.add(() -> this.minecraft.setScreen(new MessageScreen(String.valueOf(responseCode) + " Response", responseBody + "\n\nPlease report the issue to the link below\nGithub Issue Trakcer: https://github.com/Yesssssman/epicfightmod/issues", (Screen)this, button2 -> this.minecraft.setScreen(this.parentScreen), 300, 70).autoCalculateHeight()));
    }

    public void popupAccessDenied() {
        this.deferredWorks.add(() -> this.minecraft.setScreen(new MessageScreen("Failed in Discord authentication", "Access denied.", (Screen)this, button2 -> this.minecraft.setScreen((Screen)this), 250, 70).autoCalculateHeight()));
    }

    public void popupNoUserInfo() {
        this.deferredWorks.add(() -> this.minecraft.setScreen(new MessageScreen("Failed in Discord authentication", "Can't find your account in Epic Fight discord server. Please join our Discord server to identify your account.\nOfficial Discord Server: https://discord.com/invite/NbAJwj8RHg", (Screen)this, button2 -> this.minecraft.setScreen((Screen)this), 250, 70).autoCalculateHeight()));
    }

    public void popupDuplicatedDiscordID(String errMsg) {
        this.deferredWorks.add(() -> this.minecraft.setScreen(new MessageScreen("Failed in Discord authentication", errMsg + "\nPlease contact our developer team to get any supports.\nOfficial Discord Server: https://discord.com/invite/NbAJwj8RHg", (Screen)this, button2 -> this.minecraft.setScreen((Screen)this), 330, 70).autoCalculateHeight()));
    }

    public void popupSignOutAsk() {
        this.deferredWorks.add(() -> this.minecraft.setScreen(new MessageScreen("Do you want to sign out?", "", (Screen)this, ok -> {
            this.popupResponseAwaiting();
            AuthenticationHelperImpl.getInstance().signOut(() -> this.popupSignOutSuccess(), ex -> {
                if (ex instanceof HttpResponseException) {
                    HttpResponseException httpFailResponseException = (HttpResponseException)ex;
                    if (httpFailResponseException.getHttpStatusCode() == 404) {
                        AuthenticationHelperImpl.getInstance().onSignOut();
                    }
                    this.popupHttpResponseException(httpFailResponseException.getHttpStatusCode(), httpFailResponseException.getResponseBody());
                } else {
                    this.popupException((Throwable)ex);
                }
            });
        }, cancel -> this.minecraft.setScreen((Screen)this), 200, 90).autoCalculateHeight()));
    }

    public void popupSavedSuccess() {
        this.deferredWorks.add(() -> this.minecraft.setScreen(new MessageScreen("Successfully saved!", "", (Screen)this, button2 -> this.minecraft.setScreen((Screen)this), 200, 70).autoCalculateHeight()));
    }

    public void popupSignOutSuccess() {
        this.deferredWorks.add(() -> this.minecraft.setScreen(new MessageScreen("Successfully signed out!", "", (Screen)this, button2 -> this.minecraft.setScreen((Screen)new TitleScreen()), 200, 70).autoCalculateHeight()));
    }

    public void popupTimeout() {
        this.deferredWorks.add(() -> this.minecraft.setScreen(new MessageScreen("Failed in Discord authentication", "Session timed out! Please try it later.", (Screen)this, button2 -> this.minecraft.setScreen((Screen)this), 300, 70).autoCalculateHeight()));
    }

    public void popupResponseAwaiting() {
        this.deferredWorks.add(() -> this.minecraft.setScreen(new AwaitIconMessageScreen("Awaiting for response...", "", this, 200, 90).withOkTitle(CommonComponents.GUI_CANCEL)));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title, 56, 15, 0xFFFFFF);
    }

    public void onClose() {
        this.capeList.destroy();
        this.minecraft.setScreen(this.parentScreen);
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CapeList
    extends ContainerObjectSelectionList<CosmeticsEntry> {
        private CosmeticBlock focused;

        public CapeList(Minecraft pMinecraft, int pWidth, int pHeight, int pY0) {
            super(pMinecraft, pWidth, pHeight, pY0, 0);
        }

        protected void renderListBackground(GuiGraphics guiGraphics) {
        }

        protected void renderListSeparators(GuiGraphics guiGraphics) {
        }

        public Cosmetic getSelectedCloak() {
            return this.focused != null ? this.focused.getCosmetic() : null;
        }

        public void moveScrollToFocus() {
            int idx = this.children().indexOf(this.getFocused());
            if (idx > -1) {
                this.setScrollAmount(this.itemHeight * idx);
            }
        }

        public void rearrangeCosmetics() {
            int rowWidth;
            int blockLength = 0;
            int columns = 1;
            while (true) {
                if ((rowWidth = this.width / columns) < 200) break;
                ++columns;
            }
            blockLength = rowWidth;
            this.itemHeight = blockLength;
            this.clearEntries();
            int count = 0;
            int row = 0;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Cosmetic cosmetic : AuthenticationHelperImpl.getInstance().getAllCosmetics()) {
                CapeBlock capeButton = new CapeBlock(this.getX() + count * blockLength + 3, this.getY() + row * blockLength + 3, blockLength - 6, blockLength - 6, cosmetic);
                capeButton.setTooltip(Tooltip.create((Component)Component.literal((String)cosmetic.description())));
                builder.add((Object)capeButton);
                if (++count != columns) continue;
                this.addEntry((AbstractSelectionList.Entry)new CosmeticsEntry(this, (List<CosmeticBlock>)builder.build()));
                builder = ImmutableList.builder();
                count = 0;
                ++row;
            }
            ImmutableList list = builder.build();
            if (!list.isEmpty()) {
                this.addEntry((AbstractSelectionList.Entry)new CosmeticsEntry(this, (List<CosmeticBlock>)list));
            }
        }

        protected int getScrollbarPosition() {
            return this.getRight() - 6;
        }

        public int getRowWidth() {
            return this.width;
        }

        protected void clearEntries() {
            this.destroy();
            super.clearEntries();
        }

        public void destroy() {
            this.children().forEach(entry -> entry.cosmeticsBlock.forEach(CosmeticBlock::destroy));
        }

        public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
            this.updateScrollingState(pMouseX, pMouseY, pButton);
            if (!this.isMouseOver(pMouseX, pMouseY)) {
                return false;
            }
            for (int i1 = 0; i1 < this.getItemCount(); ++i1) {
                int j1 = this.getRowTop(i1);
                int k1 = this.getRowBottom(i1);
                if (k1 < this.getY() || j1 > this.getBottom()) continue;
                CosmeticsEntry entry = (CosmeticsEntry)((Object)this.children().get(i1));
                for (CosmeticBlock b : entry.cosmeticsBlock) {
                    if (!b.mouseClicked(pMouseX, pMouseY, pButton)) continue;
                    CosmeticsEntry oEntry = (CosmeticsEntry)this.getFocused();
                    if (entry != oEntry && oEntry instanceof ContainerEventHandler) {
                        CosmeticsEntry containereventhandler = oEntry;
                        containereventhandler.setFocused(null);
                    }
                    this.setFocused((GuiEventListener)entry);
                    this.setDragging(true);
                    b.onPress(b == this.focused);
                    if (this.focused != null) {
                        this.focused.setFocused(false);
                    }
                    this.focused = b;
                    this.focused.setFocused(true);
                    return true;
                }
            }
            return this.scrolling;
        }

        @OnlyIn(value=Dist.CLIENT)
        public abstract class CosmeticBlock
        extends AbstractWidget {
            public CosmeticBlock(CapeList this$1, int pX, int pY, int pWidth, int pHeight, Component pMessage) {
                super(pX, pY, pWidth, pHeight, pMessage);
            }

            public abstract void onPress(boolean var1);

            public abstract Cosmetic getCosmetic();

            public abstract void destroy();
        }

        @OnlyIn(value=Dist.CLIENT)
        public class CapeBlock
        extends CosmeticBlock {
            private static final ResourceLocation LOCK_ICON = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/gui/lock.png");
            private final ModelPreviewer modelPreviewer;
            private Cosmetic cosmetic;

            public CapeBlock(int pX, int pY, int pWidth, int pHeight, Cosmetic cosmetic) {
                super(CapeList.this, pX, pY, pWidth, pHeight, (Component)Component.empty());
                this.cosmetic = cosmetic;
                switch (cosmetic.slot()) {
                    case CAPE: {
                        this.modelPreviewer = new ModelPreviewer(pX, pWidth, pY, pHeight, null, null, null, Meshes.BIPED);
                        this.modelPreviewer.setBackgroundClearColor(new Vec4f(0.3552f, 0.3552f, 0.3552f, 0.3f));
                        this.modelPreviewer.setCameraTransform(-2.5, 18.75f, 16.25f, -1.1641532E-8f, -0.0f);
                        cosmetic.getAsMesh(mesh -> this.modelPreviewer.initCloakInfo((SoftBodyTranslatable)((Object)mesh), cosmetic.textureLocation(), null));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported slot type: " + String.valueOf((Object)cosmetic.slot()));
                    }
                }
            }

            protected void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                if (this.isFocused()) {
                    this.modelPreviewer.setBackgroundClearColor(new Vec4f(0.5552f, 0.5552f, 0.5552f, 0.8f));
                } else {
                    this.modelPreviewer.setBackgroundClearColor(new Vec4f(0.3552f, 0.3552f, 0.3552f, 0.3f));
                }
                RenderSystem.enableBlend();
                this.modelPreviewer.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
                if (!this.cosmetic.unlocked()) {
                    guiGraphics.fill(this.modelPreviewer.getX(), this.modelPreviewer.getY(), this.modelPreviewer.getX() + this.modelPreviewer.getWidth(), this.modelPreviewer.getY() + this.modelPreviewer.getHeight(), -1156509423);
                    guiGraphics.blit(LOCK_ICON, this.modelPreviewer.getX() + this.modelPreviewer.getWidth() / 2 - 8, this.modelPreviewer.getY() + this.modelPreviewer.getHeight() / 2 - 8, 16, 16, 0.0f, 0.0f, 16, 16, 16, 16);
                }
                RenderSystem.disableBlend();
                guiGraphics.drawCenteredString(((CapeList)CapeList.this).minecraft.font, this.cosmetic.title(), this.getX() + this.width / 2, this.getY() + this.height - 12, -1);
            }

            @Override
            public void onPress(boolean pressedTwice) {
                if (!pressedTwice) {
                    if (this.modelPreviewer.getCloakMesh() != null) {
                        boolean canConfigureColor;
                        boolean bl = canConfigureColor = AvatarEditScreen.this.useVanillTextureCheckBox._getValue() == false && this.cosmetic.useIntParam1();
                        if (canConfigureColor) {
                            AvatarEditScreen.this.mainModelPreviewer.setCloakColor(AvatarEditScreen.this.brightnessSlider.getColor());
                        } else {
                            AvatarEditScreen.this.mainModelPreviewer.setCloakColor(-1);
                        }
                        boolean useVanillaTexture = AvatarEditScreen.this.useVanillTextureCheckBox._getValue() != false && this.cosmetic.useBoolParam1();
                        AvatarEditScreen.this.mainModelPreviewer.initCloakInfo(this.modelPreviewer.getCloakMesh(), useVanillaTexture ? AuthenticationHelperImpl.getInstance().playerInfo().getSkin().capeTexture() : this.modelPreviewer.getCloakTexture(), ClothSimulator.ClothObjectBuilder.create().parentJoint(((HumanoidArmature)Armatures.BIPED.get()).torso).putAll(ClothColliderPresets.BIPED));
                    } else {
                        AvatarEditScreen.this.mainModelPreviewer.removeCloak();
                    }
                }
                if (pressedTwice && this.cosmetic.unlocked()) {
                    AvatarEditScreen.this.capePopupBox._setValue(this.cosmetic);
                    AvatarEditScreen.this.refreshOptionComponents(this.cosmetic);
                    AvatarEditScreen.this.capeSelectionLayout.accept(x$0 -> AvatarEditScreen.this.removeWidget((GuiEventListener)x$0));
                    AvatarEditScreen.this.capeOptionsLayout.accept(x$0 -> AvatarEditScreen.this.addRenderableWidget((GuiEventListener)x$0));
                    AvatarEditScreen.this.activatedLayout = AvatarEditScreen.this.capeOptionsLayout;
                }
            }

            @Override
            public void destroy() {
                this.modelPreviewer.onDestroy();
            }

            @Override
            public Cosmetic getCosmetic() {
                return this.cosmetic;
            }

            protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
            }

            public void setX(int x) {
                super.setX(x);
                this.modelPreviewer.setX(x);
            }

            public void setY(int y) {
                super.setY(y);
                this.modelPreviewer.setY(y);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public class CosmeticsEntry
        extends ContainerObjectSelectionList.Entry<CosmeticsEntry> {
            private final List<CosmeticBlock> cosmeticsBlock;

            public CosmeticsEntry(CapeList this$1, List<CosmeticBlock> cosmeticBlocks) {
                this.cosmeticsBlock = cosmeticBlocks;
            }

            public List<? extends GuiEventListener> children() {
                return this.cosmeticsBlock;
            }

            public List<? extends NarratableEntry> narratables() {
                return this.cosmeticsBlock;
            }

            public void render(GuiGraphics pGuiGraphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pHovering, float pPartialTick) {
                for (CosmeticBlock cosmeticBlock : this.cosmeticsBlock) {
                    cosmeticBlock.setY(pTop);
                    cosmeticBlock.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LayoutElements<T extends GuiEventListener & Renderable> {
        private List<T> components;

        @SafeVarargs
        private LayoutElements(T ... components) {
            this.components = Arrays.asList(components);
        }

        public void accept(Consumer<T> consumer) {
            this.components.forEach(consumer);
        }
    }
}

