/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.epicskins.user;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ModConfigSpec;
import yesman.epicfight.api.client.online.EpicFightServerConnectionHelper;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.epicskins.client.screen.AvatarEditScreen;
import yesman.epicfight.epicskins.exception.HttpResponseException;
import yesman.epicfight.epicskins.exception.OfflineUserException;
import yesman.epicfight.epicskins.user.Cosmetic;
import yesman.epicfight.epicskins.util.JsonConverter;
import yesman.epicfight.main.AuthenticationHelper;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.main.EpicFightSharedConstants;

@OnlyIn(value=Dist.CLIENT)
public class AuthenticationHelperImpl
implements AuthenticationHelper {
    private final Multimap<Cosmetic.Slot, Cosmetic> cosmeticsBySlot = HashMultimap.create();
    private final Map<Integer, Cosmetic> cosmetics = Maps.newHashMap();
    private PlayerInfo playerInfo;
    private String accessToken;
    private String refreshToken;
    private AuthenticationHelper.Status status = AuthenticationHelper.Status.UNAUTHENTICATED;
    private AuthenticationHelper.AuthenticationProvider authProvider;
    private CapeProperties capeProperties;

    public static boolean checkOnlineUser(User user) {
        return !"0".equals(user.getAccessToken());
    }

    private static String profileIdToString(User user) {
        return user.getProfileId().toString().replace("-", "");
    }

    public static synchronized AuthenticationHelperImpl getInstance() {
        return (AuthenticationHelperImpl)ClientEngine.getInstance().getAuthHelper();
    }

    private AuthenticationHelperImpl() {
        ClientEngine.getInstance().initAuthHelper(this);
        this.capeProperties = new CapeProperties();
    }

    @Override
    public void initialize(ModConfigSpec.ConfigValue<String> accessToken, ModConfigSpec.ConfigValue<String> refreshToken, ModConfigSpec.EnumValue<AuthenticationHelper.AuthenticationProvider> provider) {
        if (this.status != AuthenticationHelper.Status.UNAUTHENTICATED) {
            return;
        }
        this.accessToken = (String)accessToken.get();
        this.refreshToken = (String)refreshToken.get();
        this.authProvider = (AuthenticationHelper.AuthenticationProvider)((Object)provider.get());
        User user = Minecraft.getInstance().getUser();
        if (AuthenticationHelperImpl.checkOnlineUser(user)) {
            EpicFightServerConnectionHelper.autoLogin(EpicFightSharedConstants.webServerDomain(), AuthenticationHelperImpl.profileIdToString(user), this.accessToken, this.refreshToken, this.authProvider.toString(), (response, exception) -> {
                if (exception != null) {
                    EpicFightMod.LOGGER.warn("Auto login failed: " + String.valueOf(exception));
                    exception.printStackTrace();
                } else if (response.statusCode() == 200) {
                    JsonObject responseJson = JsonConverter.parseJson((String)response.body()).getAsJsonObject();
                    this.onAuthenticationSuccess(responseJson, () -> {}, ex -> {});
                } else {
                    EpicFightMod.LOGGER.warn("Auto login failed with status code " + response.statusCode() + ": " + (String)response.body());
                }
            });
        } else {
            this.status = AuthenticationHelper.Status.OFFLINE_MODE;
        }
    }

    @Override
    public Screen getAvatarEditorScreen(Screen parentScreen) {
        return new AvatarEditScreen(parentScreen);
    }

    @Override
    public boolean valid() {
        return true;
    }

    public void openAuthenticateBrowser() {
        User user = Minecraft.getInstance().getUser();
        Util.getPlatform().openUri(URI.create(EpicFightSharedConstants.webServerDomain() + "/login?mc_uuid=" + AuthenticationHelperImpl.profileIdToString(user) + "&mc_username=" + user.getName()));
    }

    public void loginWithAuthCode(String code, Runnable onSuccess, Consumer<Throwable> onFail) {
        User user = Minecraft.getInstance().getUser();
        EpicFightServerConnectionHelper.signIn(EpicFightSharedConstants.webServerDomain(), AuthenticationHelperImpl.profileIdToString(user), code, (response, exception) -> {
            if (exception != null) {
                onFail.accept((Throwable)exception);
                return;
            }
            if (response.statusCode() == 200) {
                JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(((String)response.body()).getBytes()), StandardCharsets.UTF_8));
                JsonObject jsonObject = Streams.parse((JsonReader)jsonReader).getAsJsonObject();
                this.onAuthenticationSuccess(jsonObject, onSuccess, onFail);
            } else {
                onFail.accept(new HttpResponseException("Invalid code", response.statusCode(), (String)response.body()));
            }
        });
    }

    private void onAuthenticationSuccess(JsonObject authResponse, Runnable onSuccess, Consumer<Throwable> onFailed) {
        this.status = AuthenticationHelper.Status.AUTHENTICATED;
        this.authProvider = AuthenticationHelper.AuthenticationProvider.valueOf(GsonHelper.getAsString((JsonObject)authResponse, (String)"provider").toUpperCase(Locale.ROOT));
        this.accessToken = GsonHelper.getAsString((JsonObject)authResponse, (String)"access_token");
        this.refreshToken = GsonHelper.getAsString((JsonObject)authResponse, (String)"refresh_token");
        ClientConfig.ACCESS_TOKEN.set((Object)this.accessToken);
        ClientConfig.REFRESH_TOKNE.set((Object)this.refreshToken);
        ClientConfig.PROVIDER.set((Object)this.authProvider);
        JsonArray cosmeticsArray = GsonHelper.getAsJsonArray((JsonObject)authResponse, (String)"cosmetics");
        for (JsonElement cosmeticElement : cosmeticsArray) {
            JsonObject cosemticObject = cosmeticElement.getAsJsonObject();
            if (!"cape".equals(GsonHelper.getAsString((JsonObject)cosemticObject, (String)"slot"))) continue;
            this.capeProperties.setCape(GsonHelper.getAsInt((JsonObject)cosemticObject, (String)"cosmetic_seq"));
            this.capeProperties.unpackColorSliderPositions(GsonHelper.getAsInt((JsonObject)cosemticObject, (String)"int_param1"));
            this.capeProperties.setVanillaTextureUse(GsonHelper.getAsBoolean((JsonObject)cosemticObject, (String)"bool_param1"));
        }
        this.cosmeticsBySlot.clear();
        this.cosmetics.clear();
        User user = Minecraft.getInstance().getUser();
        EpicFightServerConnectionHelper.getAvailableCosmetics(EpicFightSharedConstants.webServerDomain(), AuthenticationHelperImpl.profileIdToString(user), this.accessToken, this.refreshToken, this.authProvider.toString(), (response, exception) -> {
            if (exception != null) {
                onFailed.accept((Throwable)exception);
            }
            if (response.statusCode() == 200) {
                try {
                    JsonObject responseJson = JsonConverter.parseJson((String)response.body()).getAsJsonObject();
                    for (JsonElement json : responseJson.getAsJsonArray("object")) {
                        Cosmetic cosmetic = new Cosmetic(json.getAsJsonObject());
                        this.cosmeticsBySlot.put((Object)cosmetic.slot(), (Object)cosmetic);
                        this.cosmetics.put(cosmetic.seq(), cosmetic);
                    }
                    onSuccess.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                onFailed.accept(new HttpResponseException("Failed at getting available cosmetics", response.statusCode(), (String)response.body()));
            }
        });
    }

    public void signOut(Runnable onSuccess, Consumer<Throwable> onFailed) {
        User user = Minecraft.getInstance().getUser();
        EpicFightServerConnectionHelper.signOut(EpicFightSharedConstants.webServerDomain(), AuthenticationHelperImpl.profileIdToString(user), this.accessToken, this.refreshToken, this.authProvider.toString(), (response, exception) -> {
            if (exception != null) {
                onFailed.accept((Throwable)exception);
            } else if (response.statusCode() == 200) {
                AuthenticationHelperImpl.getInstance().onSignOut();
                onSuccess.run();
            } else {
                onFailed.accept(new HttpResponseException("Sign out failed", response.statusCode(), (String)response.body()));
            }
        });
    }

    public void onSignOut() {
        try {
            this.status = AuthenticationHelper.Status.UNAUTHENTICATED;
            this.authProvider = AuthenticationHelper.AuthenticationProvider.NULL;
            this.accessToken = "";
            this.refreshToken = "";
            ClientConfig.ACCESS_TOKEN.set((Object)this.accessToken);
            ClientConfig.REFRESH_TOKNE.set((Object)this.refreshToken);
            ClientConfig.PROVIDER.set((Object)this.authProvider);
            this.cosmeticsBySlot.clear();
            this.cosmetics.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendSaveRequest(Consumer<Throwable> callback) {
        User user = Minecraft.getInstance().getUser();
        if (!AuthenticationHelperImpl.checkOnlineUser(user)) {
            this.status = AuthenticationHelper.Status.OFFLINE_MODE;
            throw new OfflineUserException("Offline mode user");
        }
        JsonObject postBody = new JsonObject();
        postBody.addProperty("provider", this.authProvider.toString());
        postBody.addProperty("access_token", this.accessToken);
        postBody.addProperty("refresh_token", this.refreshToken);
        postBody.addProperty("minecraft_uuid", AuthenticationHelperImpl.profileIdToString(user));
        postBody.addProperty("cosmetic_seq", (Number)this.capeProperties.capeSeq());
        postBody.addProperty("slot", "cape");
        postBody.addProperty("int_param1", (Number)this.capeProperties.packColorSliderPositions());
        postBody.addProperty("bool_param1", Boolean.valueOf(this.capeProperties.useVanillaTexture()));
        EpicFightServerConnectionHelper.saveConfiguration(EpicFightSharedConstants.webServerDomain(), postBody.toString(), (response, exception) -> {
            if (exception != null) {
                callback.accept((Throwable)exception);
            }
            if (response.statusCode() == 200) {
                JsonObject responseJson = JsonConverter.parseJson((String)response.body()).getAsJsonObject();
                this.accessToken = GsonHelper.getAsString((JsonObject)responseJson, (String)"accessToken");
                this.refreshToken = GsonHelper.getAsString((JsonObject)responseJson, (String)"refreshToken");
                ClientConfig.ACCESS_TOKEN.set((Object)this.accessToken);
                ClientConfig.REFRESH_TOKNE.set((Object)this.refreshToken);
                callback.accept(null);
            } else {
                callback.accept(new HttpResponseException("Failed at updating cosmetic information", response.statusCode(), (String)response.body()));
            }
        });
    }

    @Override
    public void loadPlayerSkin() {
        this.playerInfo = new PlayerInfo(Minecraft.getInstance().getGameProfile(), false);
        ResourceLocation rl = this.playerInfo.getSkin().texture();
    }

    public void setStatus(AuthenticationHelper.Status status) {
        this.status = status;
    }

    public AuthenticationHelper.AuthenticationProvider authProvider() {
        return this.authProvider;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public AuthenticationHelper.Status status() {
        return this.status;
    }

    public PlayerInfo playerInfo() {
        return this.playerInfo;
    }

    public Collection<Cosmetic> getAllCosmetics() {
        return this.cosmetics.values();
    }

    public Collection<Cosmetic> getCosmeticsBySlot(Cosmetic.Slot cosmeticSlot) {
        return this.cosmeticsBySlot.get((Object)cosmeticSlot);
    }

    public Cosmetic getCosmetic(int seq) {
        return this.cosmetics.get(seq);
    }

    public CapeProperties capeProperties() {
        return this.capeProperties;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CapeProperties {
        private int capeSeq;
        private boolean useVanillaTexture;
        private double hue;
        private double saturation;
        private double brightness;

        public void setCape(int capeSeq) {
            this.capeSeq = capeSeq;
        }

        public void setVanillaTextureUse(boolean useVanillaTexture) {
            this.useVanillaTexture = useVanillaTexture;
        }

        public void setHue(double hue) {
            this.hue = hue;
        }

        public void setSaturation(double saturation) {
            this.saturation = saturation;
        }

        public void setBrightness(double brightness) {
            this.brightness = brightness;
        }

        public int capeSeq() {
            return this.capeSeq;
        }

        public boolean useVanillaTexture() {
            return this.useVanillaTexture;
        }

        public double hue() {
            return this.hue;
        }

        public double saturation() {
            return this.saturation;
        }

        public double brightness() {
            return this.brightness;
        }

        public void unpackColorSliderPositions(int packedColorSlider) {
            this.brightness = (float)(packedColorSlider & 0xFF) / 255.0f;
            this.saturation = (float)((packedColorSlider & 0xFF00) >> 8) / 255.0f;
            this.hue = (float)((packedColorSlider & 0xFF0000) >> 16) / 255.0f;
        }

        public int packColorSliderPositions() {
            double huePos = Mth.clamp((double)this.hue, (double)0.0, (double)1.0);
            double saturationPos = Mth.clamp((double)this.saturation, (double)0.0, (double)1.0);
            double brightnessPos = Mth.clamp((double)this.brightness, (double)0.0, (double)1.0);
            return (int)(huePos * 255.0) << 16 | (int)(saturationPos * 255.0) << 8 | (int)(brightnessPos * 255.0);
        }
    }
}

