/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.registry.callbacks;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.registries.callback.AddCallback;
import net.neoforged.neoforge.registries.callback.BakeCallback;
import net.neoforged.neoforge.registries.callback.ClearCallback;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.registry.EpicFightRegistries;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillDataKey;

public class SkillDataKeyCallbacks
implements BakeCallback<SkillDataKey<?>>,
AddCallback<SkillDataKey<?>>,
ClearCallback<SkillDataKey<?>> {
    private static final SkillDataKeyCallbacks INSTANCE = new SkillDataKeyCallbacks();
    private static final Map<Class<? extends Skill>, Set<Holder<SkillDataKey<?>>>> CLASS_TO_DATA_KEYS = Maps.newHashMap();
    private final HashMultimap<Class<? extends Skill>, Holder<SkillDataKey<?>>> dataKeysBySkillClasses = HashMultimap.create();

    public static SkillDataKeyCallbacks getRegistryCallback() {
        return INSTANCE;
    }

    public static Map<Class<? extends Skill>, Set<Holder<SkillDataKey<?>>>> getSkillDataKeyMap() {
        return CLASS_TO_DATA_KEYS;
    }

    public void onBake(Registry<SkillDataKey<?>> registry) {
        EpicFightRegistries.SKILL.holders().forEach(holder -> {
            Class<?> skillClass = ((Skill)holder.value()).getClass();
            Set dataKeySet = CLASS_TO_DATA_KEYS.computeIfAbsent(skillClass, k -> new HashSet());
            do {
                if (!this.dataKeysBySkillClasses.containsKey(skillClass)) continue;
                dataKeySet.addAll(this.dataKeysBySkillClasses.get(skillClass));
            } while (Skill.class.isAssignableFrom(skillClass = skillClass.getSuperclass()));
            if (!dataKeySet.isEmpty()) {
                EpicFightMod.LOGGER.info("Data keys " + String.valueOf(dataKeySet.stream().map(Holder::getRegisteredName).toList()) + " for " + holder.getRegisteredName());
            }
        });
    }

    public void onAdd(Registry<SkillDataKey<?>> registry, int id, ResourceKey<SkillDataKey<?>> key, SkillDataKey<?> value) {
        value.referencingSkillClasses().forEach(cls -> this.dataKeysBySkillClasses.put(cls, (Object)((Holder)registry.getHolder(key).orElseThrow())));
    }

    public void onClear(Registry<SkillDataKey<?>> registry, boolean full) {
        CLASS_TO_DATA_KEYS.clear();
    }
}

