/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.neoevent.playerpatch.TakeDamageEvent;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class EnduranceSkill
extends PassiveSkill {
    private float staminaRatio;

    public EnduranceSkill(SkillBuilder<?> builder) {
        super((SkillBuilder<? extends SkillBuilder>)builder);
    }

    @Override
    public void loadDatapackParameters(CompoundTag parameters) {
        super.loadDatapackParameters(parameters);
        this.staminaRatio = parameters.getFloat("stamina_ratio");
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void takeDamagePre(TakeDamageEvent.Income event, SkillContainer skillContainer) {
        if (skillContainer.getExecutor().getEntityState().getLevel() == 1 && event.getDamageSource().getEntity() != null && ((ServerPlayerPatch)event.getPlayerPatch()).consumeForSkill(this, this.resource)) {
            float staminaConsumption = Math.max(skillContainer.getExecutor().getStamina() * this.staminaRatio, 1.5f);
            if (skillContainer.getExecutor().consumeForSkill((Skill)this, Skill.Resource.STAMINA, staminaConsumption)) {
                CompoundTag argument = new CompoundTag();
                argument.putFloat("staminaConsumption", staminaConsumption);
                this.executeOnServer(skillContainer, argument);
            }
        }
    }

    @Override
    public void executeOnServer(SkillContainer container, CompoundTag arguments) {
        super.executeOnServer(container, arguments);
        float staminaConsume = arguments.getFloat("staminaConsumption");
        container.getExecutor().setMaxStunShield(staminaConsume);
        container.getExecutor().setStunShield(staminaConsume);
        Player player = (Player)container.getExecutor().getOriginal();
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)EpicFightSounds.ENDURACNE.get(), player.getSoundSource(), 1.0f, 1.0f);
        SPEntityPairingPacket pairingPacket = new SPEntityPairingPacket(((Player)container.getExecutor().getOriginal()).getId(), EntityPairingPacketTypes.FLASH_WHITE);
        pairingPacket.buffer().writeInt(9);
        pairingPacket.buffer().writeInt(15);
        pairingPacket.buffer().writeInt(1);
        pairingPacket.buffer().writeBoolean(true);
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(pairingPacket, (ServerPlayer)container.getServerExecutor().getOriginal(), new CustomPacketPayload[0]);
    }

    @Override
    public void cancelOnServer(SkillContainer container, CompoundTag arguments) {
        container.getExecutor().setStunShield(0.0f);
        container.getExecutor().setMaxStunShield(0.0f);
        super.cancelOnServer(container, arguments);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return container.getStack() == 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%d", this.maxDuration / 20));
        return list;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean getCustomConsumptionTooltips(SkillBookScreen.AttributeIconList consumptionList) {
        consumptionList.add((Component)Component.translatable((String)"attribute.name.epicfight.cooldown.consume.tooltip"), (Component)Component.translatable((String)"attribute.name.epicfight.cooldown.consume", (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(this.getConsumption())}), SkillBookScreen.COOLDOWN_TEXTURE_INFO);
        consumptionList.add((Component)Component.translatable((String)"attribute.name.epicfight.stamina.consume.tooltip"), (Component)Component.translatable((String)"attribute.name.epicfight.stamina_current_ratio.consume", (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(this.staminaRatio * 100.0f)}), SkillBookScreen.STAMINA_TEXTURE_INFO);
        return true;
    }
}

