/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import com.mojang.datafixers.util.Pair;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.behavior.AnimatedCombatBehavior;
import yesman.epicfight.world.entity.ai.behavior.MoveToTargetSinkStopInaction;
import yesman.epicfight.world.entity.ai.brain.BrainRecomposer;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class CustomHumanoidMobPatch<T extends PathfinderMob>
extends HumanoidMobPatch<T> {
    private final MobPatchReloadListener.CustomHumanoidMobPatchProvider provider;

    public CustomHumanoidMobPatch(T original, Faction faction, MobPatchReloadListener.CustomHumanoidMobPatchProvider provider) {
        super(original, faction);
        this.provider = provider;
        this.weaponLivingMotions = this.provider.getHumanoidWeaponMotions();
        this.weaponAttackMotions = this.provider.getHumanoidCombatBehaviors();
    }

    @Override
    public void setAIAsInfantry(boolean holdingRanedWeapon) {
        CombatBehaviors.Builder<HumanoidMobPatch<?>> builder;
        boolean useBrain;
        boolean bl = useBrain = !((PathfinderMob)this.original).getBrain().availableBehaviorsByPriority.isEmpty();
        if (useBrain) {
            if (!holdingRanedWeapon) {
                CombatBehaviors.Builder<HumanoidMobPatch<?>> builder2 = this.getHoldingItemWeaponMotionBuilder();
                BrainRecomposer.recomposeBrainByType(((PathfinderMob)this.original).getType(), ((PathfinderMob)this.original).getBrain(), builder2 != null ? new AnimatedCombatBehavior<CustomHumanoidMobPatch>(this, builder2.build(this)) : null, new MoveToTargetSinkStopInaction());
            }
        } else if (!holdingRanedWeapon && (builder = this.getHoldingItemWeaponMotionBuilder()) != null) {
            ((PathfinderMob)this.original).goalSelector.addGoal(0, new AnimatedAttackGoal<CustomHumanoidMobPatch>(this, builder.build(this)));
            ((PathfinderMob)this.original).goalSelector.addGoal(1, (Goal)new TargetChasingGoal(this, (PathfinderMob)this.getOriginal(), this.provider.getChasingSpeed(), true));
        }
    }

    @Override
    public void readData(CompoundTag compound) {
        super.readData(compound);
        this.initAttributes();
    }

    public void initAttributes() {
        ((PathfinderMob)this.original).getAttribute(EpicFightAttributes.MAX_STRIKES).setBaseValue(this.provider.getAttributeValues().getDouble(EpicFightAttributes.MAX_STRIKES));
        ((PathfinderMob)this.original).getAttribute(EpicFightAttributes.ARMOR_NEGATION).setBaseValue(this.provider.getAttributeValues().getDouble(EpicFightAttributes.ARMOR_NEGATION));
        ((PathfinderMob)this.original).getAttribute(EpicFightAttributes.IMPACT).setBaseValue(this.provider.getAttributeValues().getDouble(EpicFightAttributes.IMPACT));
        ((PathfinderMob)this.original).getAttribute(EpicFightAttributes.STUN_ARMOR).setBaseValue(this.provider.getAttributeValues().getDouble(EpicFightAttributes.STUN_ARMOR));
        if (this.provider.getAttributeValues().containsKey((Object)Attributes.ATTACK_DAMAGE)) {
            ((PathfinderMob)this.original).getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(this.provider.getAttributeValues().getDouble((Object)Attributes.ATTACK_DAMAGE));
        }
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        for (Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> pair : this.provider.getDefaultAnimations()) {
            animator.addLivingAnimation((LivingMotion)pair.getFirst(), (AssetAccessor)pair.getSecond());
        }
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveMobUpdateMotion(considerInaction);
        if (((PathfinderMob)this.original).isUsingItem()) {
            CapabilityItem activeItem = this.getHoldingItemCapability(((PathfinderMob)this.original).getUsedItemHand());
            UseAnim useAnim = ((PathfinderMob)this.original).getItemInHand(((PathfinderMob)this.original).getUsedItemHand()).getUseAnimation();
            UseAnim secondUseAnim = activeItem.getUseAnimation(this);
            this.currentCompositeMotion = useAnim == UseAnim.BLOCK || secondUseAnim == UseAnim.BLOCK ? (activeItem.getWeaponCategory() == CapabilityItem.WeaponCategories.SHIELD ? LivingMotions.BLOCK_SHIELD : LivingMotions.BLOCK) : (useAnim == UseAnim.BOW || useAnim == UseAnim.SPEAR ? LivingMotions.AIM : (useAnim == UseAnim.CROSSBOW ? LivingMotions.RELOAD : this.currentLivingMotion));
        } else {
            this.currentCompositeMotion = CrossbowItem.isCharged((ItemStack)((PathfinderMob)this.original).getMainHandItem()) ? LivingMotions.AIM : (this.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getAnimation().get().isReboundAnimation() ? LivingMotions.NONE : (((PathfinderMob)this.original).swinging && ((PathfinderMob)this.original).getSleepingPos().isEmpty() ? LivingMotions.DIGGING : this.currentLivingMotion));
        }
    }

    @Override
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return this.provider.getStunAnimations().get((Object)stunType);
    }

    @Override
    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        CapabilityItem itemCap = this.getAdvancedHoldingItemCapability(hand);
        if (itemCap.isEmpty()) {
            return this.provider.getHitSound();
        }
        return itemCap.getHitSound();
    }

    @Override
    public SoundEvent getSwingSound(InteractionHand hand) {
        CapabilityItem itemCap = this.getAdvancedHoldingItemCapability(hand);
        if (itemCap.isEmpty()) {
            return this.provider.getSwingSound();
        }
        return itemCap.getSmashingSound();
    }

    @Override
    public HitParticleType getWeaponHitParticle(InteractionHand hand) {
        CapabilityItem itemCap = this.getAdvancedHoldingItemCapability(hand);
        if (itemCap.isEmpty()) {
            return this.provider.getHitParticle();
        }
        return itemCap.getHitParticle();
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float scale = this.provider.getScale();
        return super.getModelMatrix(partialTicks).scale(scale, scale, scale);
    }
}

