/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Vex;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.StunType;

public class VexPatch
extends MobPatch<Vex> {
    public VexPatch(Vex original) {
        super(original, Factions.ILLAGER);
    }

    @Override
    protected void initAI() {
        super.initAI();
        ((Vex)this.original).goalSelector.addGoal(0, (Goal)new ChargeAttackGoal());
    }

    @Override
    protected void selectGoalToRemove(Set<Goal> toRemove) {
        super.selectGoalToRemove(toRemove);
        Iterator iterator = ((Vex)this.original).goalSelector.getAvailableGoals().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            WrappedGoal goal = (WrappedGoal)iterator.next();
            Goal inner = goal.getGoal();
            if (index == 1) {
                toRemove.add(inner);
                break;
            }
            ++index;
        }
    }

    @Override
    public void preTickServer(EntityTickEvent.Pre event) {
        super.preTickServer(event);
        if (this.getEntityState().movementLocked()) {
            ((Vex)this.original).goalSelector.disableControlFlag(Goal.Flag.MOVE);
            ((Vex)this.original).goalSelector.disableControlFlag(Goal.Flag.JUMP);
        } else {
            ((Vex)this.original).goalSelector.enableControlFlag(Goal.Flag.MOVE);
            ((Vex)this.original).goalSelector.enableControlFlag(Goal.Flag.JUMP);
        }
        if (this.getEntityState().turningLocked()) {
            ((Vex)this.original).goalSelector.disableControlFlag(Goal.Flag.LOOK);
        } else {
            ((Vex)this.original).goalSelector.enableControlFlag(Goal.Flag.LOOK);
        }
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation(LivingMotions.IDLE, Animations.VEX_IDLE);
        animator.addLivingAnimation(LivingMotions.DEATH, Animations.VEX_DEATH);
        animator.addLivingAnimation(LivingMotions.IDLE, Animations.VEX_FLIPPING);
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((Vex)this.original).getHealth() <= 0.0f) {
            this.currentLivingMotion = LivingMotions.DEATH;
        } else if (this.state.inaction() && considerInaction) {
            this.currentLivingMotion = LivingMotions.INACTION;
        } else {
            this.currentLivingMotion = LivingMotions.IDLE;
            this.currentCompositeMotion = LivingMotions.IDLE;
        }
    }

    @Override
    public void onAttackBlocked(DamageSource damageSource, LivingEntityPatch<?> opponent) {
        ((Vex)this.original).setPos(((LivingEntity)opponent.getOriginal()).getEyePosition().add(((LivingEntity)opponent.getOriginal()).getLookAngle()));
        this.playAnimationSynchronized(Animations.VEX_NEUTRALIZED, 0.0f);
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return Animations.VEX_HIT;
    }

    class ChargeAttackGoal
    extends Goal {
        private int chargingCounter;

        public ChargeAttackGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (((Vex)VexPatch.this.original).getTarget() != null && !VexPatch.this.getEntityState().inaction() && ((Vex)VexPatch.this.original).getRandom().nextInt(10) == 0) {
                double distance = ((Vex)VexPatch.this.original).distanceToSqr((Entity)((Vex)VexPatch.this.original).getTarget());
                return distance < 49.0;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.chargingCounter > 0;
        }

        public void start() {
            ((Vex)VexPatch.this.original).getMoveControl().setWantedPosition(((Vex)VexPatch.this.original).getX(), ((Vex)VexPatch.this.original).getY(), ((Vex)VexPatch.this.original).getZ(), 0.25);
            VexPatch.this.playAnimationSynchronized(Animations.VEX_CHARGE, 0.0f);
            ((Vex)VexPatch.this.original).playSound(SoundEvents.VEX_CHARGE, 1.0f, 1.0f);
            ((Vex)VexPatch.this.original).setIsCharging(true);
            this.chargingCounter = 20;
        }

        public void stop() {
            ((Vex)VexPatch.this.original).setIsCharging(false);
        }

        public void tick() {
            --this.chargingCounter;
        }
    }
}

