/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.player;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.ApiStatus;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.neoevent.BattleModeSustainableEvent;
import yesman.epicfight.api.neoevent.ChangePlayerModeEvent;
import yesman.epicfight.api.neoevent.playerpatch.ModifyAttackSpeedEvent;
import yesman.epicfight.api.neoevent.playerpatch.ModifyBaseDamageEvent;
import yesman.epicfight.api.neoevent.playerpatch.PlayerPatchEvent;
import yesman.epicfight.api.neoevent.playerpatch.SkillConsumeEvent;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.registry.entries.EpicFightExpandedEntityDataAccessors;
import yesman.epicfight.registry.entries.EpicFightSkills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.common.ComboAttacks;
import yesman.epicfight.skill.modules.ChargeableSkill;
import yesman.epicfight.skill.modules.HoldableSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.skill.PlayerSkills;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.data.ExpandedEntityDataAccessor;
import yesman.epicfight.world.entity.data.ExpandedSyncedData;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public abstract class PlayerPatch<T extends Player>
extends LivingEntityPatch<T> {
    protected static final float PLAYER_SCALE = 0.9375f;
    protected final PlayerSkills playerSkills = new PlayerSkills(this);
    protected PlayerMode playerMode = PlayerMode.EPICFIGHT;
    protected boolean battleModeRestricted;
    protected float modelYRotO;
    protected float modelYRot;
    protected boolean useModelYRot;
    protected int tickSinceLastAction;
    protected int staminaRegenAwaitTicks;
    protected int lastChargingTick;
    protected int chargingTicks;
    protected HoldableSkill holdingSkill;
    protected double xo;
    protected double yo;
    protected double zo;
    public double dx;
    public double dz;

    public PlayerPatch(T entity) {
        super(entity);
    }

    @Override
    public void onJoinWorld(T entity, EntityJoinLevelEvent event) {
        super.onJoinWorld(entity, event);
        PlayerSkills skillCapability = this.getPlayerSkills();
        skillCapability.skillContainers[SkillSlots.COMBO_ATTACKS.universalOrdinal()].setSkill((Skill)EpicFightSkills.COMBO_ATTACKS.get());
        skillCapability.skillContainers[SkillSlots.AIR_SLASH.universalOrdinal()].setSkill((Skill)EpicFightSkills.AIR_SLASH.get());
        skillCapability.skillContainers[SkillSlots.KNOCKDOWN_WAKEUP.universalOrdinal()].setSkill((Skill)EpicFightSkills.KNOCKDOWN_WAKEUP.get());
        this.tickSinceLastAction = 0;
        this.staminaRegenAwaitTicks = 30;
    }

    @Override
    protected void registerExpandedEntityDataAccessors(ExpandedSyncedData expandedSynchedData) {
        super.registerExpandedEntityDataAccessors(expandedSynchedData);
        expandedSynchedData.register((Holder<ExpandedEntityDataAccessor<?>>)EpicFightExpandedEntityDataAccessors.STAMINA);
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation(LivingMotions.IDLE, Animations.BIPED_IDLE);
        animator.addLivingAnimation(LivingMotions.WALK, Animations.BIPED_WALK);
        animator.addLivingAnimation(LivingMotions.RUN, Animations.BIPED_RUN);
        animator.addLivingAnimation(LivingMotions.SNEAK, Animations.BIPED_SNEAK);
        animator.addLivingAnimation(LivingMotions.SWIM, Animations.BIPED_SWIM);
        animator.addLivingAnimation(LivingMotions.FLOAT, Animations.BIPED_FLOAT);
        animator.addLivingAnimation(LivingMotions.KNEEL, Animations.BIPED_KNEEL);
        animator.addLivingAnimation(LivingMotions.FALL, Animations.BIPED_FALL);
        animator.addLivingAnimation(LivingMotions.MOUNT, Animations.BIPED_MOUNT);
        animator.addLivingAnimation(LivingMotions.SIT, Animations.BIPED_SIT);
        animator.addLivingAnimation(LivingMotions.FLY, Animations.BIPED_FLYING);
        animator.addLivingAnimation(LivingMotions.DEATH, Animations.BIPED_DEATH);
        animator.addLivingAnimation(LivingMotions.JUMP, Animations.BIPED_JUMP);
        animator.addLivingAnimation(LivingMotions.CLIMB, Animations.BIPED_CLIMBING);
        animator.addLivingAnimation(LivingMotions.SLEEP, Animations.BIPED_SLEEPING);
        animator.addLivingAnimation(LivingMotions.CREATIVE_FLY, Animations.BIPED_CREATIVE_FLYING);
        animator.addLivingAnimation(LivingMotions.CREATIVE_IDLE, Animations.BIPED_CREATIVE_IDLE);
        animator.addLivingAnimation(LivingMotions.DIGGING, Animations.BIPED_DIG);
        animator.addLivingAnimation(LivingMotions.AIM, Animations.BIPED_BOW_AIM);
        animator.addLivingAnimation(LivingMotions.SHOT, Animations.BIPED_BOW_SHOT);
        animator.addLivingAnimation(LivingMotions.DRINK, Animations.BIPED_DRINK);
        animator.addLivingAnimation(LivingMotions.EAT, Animations.BIPED_EAT);
        animator.addLivingAnimation(LivingMotions.SPECTATE, Animations.BIPED_SPYGLASS_USE);
    }

    public void copyOldData(PlayerPatch<?> old, boolean isDeath) {
        this.getPlayerSkills().copyFrom(old.getPlayerSkills());
        if (!isDeath) {
            old.getPlayerSkills().listSkillContainers().forEach(skillContainer -> skillContainer.transferDataTo(this.getPlayerSkills().getSkillContainerFor(skillContainer.getSlot())));
            CompoundTag oldData = new CompoundTag();
            old.expandedSynchedData.saveData(oldData);
            this.expandedSynchedData.load(oldData);
        }
    }

    public void setModelYRot(float rotDeg, boolean sendPacket) {
        this.useModelYRot = true;
        this.modelYRot = rotDeg;
    }

    public void disableModelYRot(boolean sendPacket) {
        this.useModelYRot = false;
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTick) {
        float yRot;
        float oYRot;
        float scale = (((Player)this.original).isBaby() ? 0.5f : 1.0f) * 0.9375f;
        Entity entity = ((Player)this.original).getVehicle();
        if (entity instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)entity;
            oYRot = ridingEntity.yBodyRotO;
            yRot = ridingEntity.yBodyRot;
        } else {
            oYRot = this.modelYRotO;
            yRot = this.modelYRot;
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, oYRot, yRot, partialTick, scale, scale, scale);
    }

    @Override
    public void preTickServer(EntityTickEvent.Pre event) {
        super.preTickServer(event);
        if (this.state.canBasicAttack()) {
            ++this.tickSinceLastAction;
        }
        if (!this.state.inaction() && this.staminaRegenAwaitTicks > 0) {
            --this.staminaRegenAwaitTicks;
        }
        float stamina = this.getStamina();
        float maxStamina = this.getMaxStamina();
        float staminaRegen = (float)((Player)this.original).getAttributeValue(EpicFightAttributes.STAMINA_REGEN);
        if (staminaRegen > 0.0f) {
            int regenWhenLessThan = 30 - 900 / (int)(30.0f * staminaRegen);
            if (stamina < maxStamina && this.staminaRegenAwaitTicks <= regenWhenLessThan) {
                float staminaFactor = 1.0f + (float)Math.pow(stamina / (maxStamina - stamina * 0.5f), 2.0);
                this.setStamina(stamina + maxStamina * 0.01f * staminaFactor * staminaRegen);
            }
        }
        if (maxStamina < stamina) {
            this.setStamina(maxStamina);
        }
    }

    @Override
    public void preTick(EntityTickEvent.Pre event) {
        if (this.playerMode == PlayerMode.EPICFIGHT || this.battleModeRestricted) {
            BattleModeSustainableEvent battleModeSustainableEvent = new BattleModeSustainableEvent(this);
            NeoForge.EVENT_BUS.post((Event)battleModeSustainableEvent);
            if (battleModeSustainableEvent.isCanceled()) {
                if (this.playerMode == PlayerMode.EPICFIGHT) {
                    this.toVanillaMode(false);
                    this.battleModeRestricted = true;
                }
            } else if (this.battleModeRestricted) {
                this.battleModeRestricted = false;
                this.toEpicFightMode(false);
            }
        }
        if (!this.isLogicalClient() || ((Player)this.original).isLocalPlayer()) {
            this.getPlayerSkills().listSkillContainers().forEach(SkillContainer::update);
        }
        this.modelYRotO = this.modelYRot;
        super.preTick(event);
        if (!this.state.canUseItem()) {
            this.cancelItemUse();
        }
        if (this.getEntityState().turningLocked()) {
            if (!this.useModelYRot) {
                this.setModelYRot(((Player)this.original).getYRot(), false);
            }
        } else if (this.useModelYRot) {
            this.disableModelYRot(false);
        }
        if (this.getEntityState().inaction() && ((Player)this.original).getControlledVehicle() == null) {
            ((Player)this.original).yBodyRot = ((Player)this.original).getYRot();
            ((Player)this.original).yHeadRot = ((Player)this.original).getYRot();
        }
        if (!this.useModelYRot) {
            float originalYRot = this.isLogicalClient() ? ((Player)this.original).yBodyRot : ((Player)this.original).getYRot();
            this.modelYRot += Mth.clamp((float)Mth.wrapDegrees((float)(originalYRot - this.modelYRot)), (float)-45.0f, (float)45.0f);
        }
        this.xo = ((Player)this.original).getX();
        this.yo = ((Player)this.original).getY();
        this.zo = ((Player)this.original).getZ();
    }

    public SkillContainer getSkill(Skill skill) {
        if (skill == null) {
            return null;
        }
        return this.getPlayerSkills().getSkillContainer(skill);
    }

    public Optional<SkillContainer> getSkillContainerFor(Skill skill) {
        if (skill == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getPlayerSkills().getSkillContainer(skill));
    }

    public SkillContainer getSkill(SkillSlot slot) {
        return this.getSkill(slot.universalOrdinal());
    }

    public SkillContainer getSkill(int slotIndex) {
        return this.getPlayerSkills().getSkillContainerFor(slotIndex);
    }

    public PlayerSkills getPlayerSkills() {
        return this.playerSkills;
    }

    @Override
    public void writeData(CompoundTag compound) {
        super.writeData(compound);
        this.playerSkills.write(compound);
    }

    @Override
    public void readData(CompoundTag compound) {
        super.readData(compound);
        this.playerSkills.read(compound);
    }

    @Override
    public float getModifiedBaseDamage(float baseDamage) {
        ModifyBaseDamageEvent event = new ModifyBaseDamageEvent(this, baseDamage, ValueModifier.calculator());
        PlayerPatchEvent.postAndFireSkillListeners(event);
        return event.calculateModifiedDamage();
    }

    public float getAttackSpeed(InteractionHand hand) {
        float baseSpeed = hand == InteractionHand.MAIN_HAND ? (float)((Player)this.original).getAttributeValue(Attributes.ATTACK_SPEED) : (float)(this.isOffhandItemValid() ? ((Player)this.original).getAttributeValue(EpicFightAttributes.OFFHAND_ATTACK_SPEED) : ((Player)this.original).getAttributeBaseValue(Attributes.ATTACK_SPEED));
        return this.getModifiedAttackSpeed(this.getAdvancedHoldingItemCapability(hand), baseSpeed);
    }

    public float getModifiedAttackSpeed(CapabilityItem itemCapability, float baseSpeed) {
        ModifyAttackSpeedEvent event = new ModifyAttackSpeedEvent(this, itemCapability, baseSpeed);
        PlayerPatchEvent.postAndFireSkillListeners(event);
        float weight = this.getWeight();
        if (weight > 40.0f) {
            float attenuation = (float)Mth.clamp((int)EpicFightGameRules.WEIGHT_PENALTY.getRuleValue(((Player)this.getOriginal()).level()), (int)0, (int)100) / 100.0f;
            return event.getAttackSpeed() + -0.1f * (weight / 40.0f) * Math.max(event.getAttackSpeed() - 0.8f, 0.0f) * attenuation;
        }
        return event.getAttackSpeed();
    }

    public double getWeaponAttribute(Holder<Attribute> attribute, ItemStack itemstack) {
        AttributeInstance attrInstance = new AttributeInstance(attribute, attrInstance$2 -> {});
        Set<AttributeModifier> itemModifiers = Set.copyOf(CapabilityItem.getAttributeModifiersAsWeapon(attribute, EquipmentSlot.MAINHAND, itemstack, this));
        Set<AttributeModifier> mainhandModifiers = Set.copyOf(CapabilityItem.getAttributeModifiersAsWeapon(attribute, EquipmentSlot.MAINHAND, ((Player)this.original).getMainHandItem(), this));
        double baseValue = ((Player)this.original).getAttribute(attribute) == null ? ((Attribute)attribute.value()).getDefaultValue() : Objects.requireNonNull(((Player)this.original).getAttribute(attribute)).getBaseValue();
        attrInstance.setBaseValue(baseValue);
        for (AttributeModifier modifier : Objects.requireNonNull(((Player)this.original).getAttribute(attribute)).getModifiers()) {
            if (itemModifiers.contains(modifier) || mainhandModifiers.contains(modifier)) continue;
            attrInstance.addTransientModifier(modifier);
        }
        for (AttributeModifier modifier : itemModifiers) {
            if (attrInstance.hasModifier(modifier.id())) continue;
            attrInstance.addTransientModifier(modifier);
        }
        EpicFightCapabilities.getItemCapability(itemstack).ifPresent(itemCapability -> {
            for (AttributeModifier modifier : itemCapability.getAttributeModifiers(this).get((Object)attribute)) {
                if (attrInstance.hasModifier(modifier.id())) continue;
                attrInstance.addTransientModifier(modifier);
            }
        });
        return attrInstance.getValue();
    }

    @Override
    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        float fallDist = ((Player)this.original).fallDistance;
        boolean onGround = ((Player)this.original).onGround();
        boolean offhandValid = this.isOffhandItemValid();
        ItemStack mainHandItem = ((Player)this.getOriginal()).getMainHandItem();
        ItemStack offHandItem = ((Player)this.getOriginal()).getOffhandItem();
        List<AttributeModifier> mainHandAttributes = CapabilityItem.getAttributeModifiersAsWeapon((Holder<Attribute>)Attributes.ATTACK_DAMAGE, EquipmentSlot.MAINHAND, ((Player)this.original).getMainHandItem(), this);
        Set<AttributeModifier> offHandAttributes = this.isOffhandItemValid() ? CapabilityItem.getAttributeModifiersAsWeapon((Holder<Attribute>)Attributes.ATTACK_DAMAGE, EquipmentSlot.MAINHAND, ((Player)this.original).getOffhandItem(), this) : Set.of();
        this.epicFightDamageSource = damageSource;
        ((Player)this.original).attackStrengthTicker = Integer.MAX_VALUE;
        ((Player)this.original).fallDistance = 0.0f;
        ((Player)this.original).setOnGround(false);
        this.setOffhandDamage(hand, mainHandItem, offHandItem, offhandValid, mainHandAttributes, offHandAttributes);
        ((Player)this.original).attack(target);
        this.recoverMainhandDamage(hand, mainHandItem, offHandItem, mainHandAttributes, offHandAttributes);
        this.epicFightDamageSource = null;
        ((Player)this.original).fallDistance = fallDist;
        ((Player)this.original).setOnGround(onGround);
        return super.attack(damageSource, target, hand);
    }

    @Override
    public EpicFightDamageSource getDamageSource(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, InteractionHand hand) {
        EpicFightDamageSource damagesource = EpicFightDamageSources.playerAttack((Player)this.original).setAnimation(animation).setBaseArmorNegation(this.getArmorNegation(hand)).setBaseImpact(this.getImpact(hand)).setUsedItem(((Player)this.getOriginal()).getItemInHand(hand));
        boolean chargeWeapon = ((StaticAnimation)animation.get()).isComboAttackAnimation() || ((Animator)this.getAnimator()).getVariables().get(ComboAttacks.COMBO, animation).orElse(false) != false;
        damagesource.setChargeWeapon(chargeWeapon);
        return damagesource;
    }

    @Override
    public void cancelItemUse() {
        super.cancelItemUse();
        this.resetHolding();
    }

    public float getMaxStamina() {
        AttributeInstance maxStamina = ((Player)this.original).getAttribute(EpicFightAttributes.MAX_STAMINA);
        return (float)(maxStamina == null ? 0.0 : maxStamina.getValue());
    }

    public float getStamina() {
        return this.getMaxStamina() <= 0.0f ? 0.0f : this.getExpandedSynchedData().get(EpicFightExpandedEntityDataAccessors.STAMINA).floatValue();
    }

    public float getModifiedStaminaConsume(float amount) {
        float attenuation = (float)Mth.clamp((int)EpicFightGameRules.WEIGHT_PENALTY.getRuleValue(((Player)this.getOriginal()).level()), (int)0, (int)100) / 100.0f;
        float weight = this.getWeight();
        return ((weight / 40.0f - 1.0f) * attenuation + 1.0f) * amount;
    }

    public boolean hasStamina(float amount) {
        return this.getStamina() > amount;
    }

    public void setStamina(float value) {
        float f1 = Mth.clamp((float)value, (float)0.0f, (float)this.getMaxStamina());
        this.getExpandedSynchedData().set(EpicFightExpandedEntityDataAccessors.STAMINA, Float.valueOf(f1));
    }

    public void clampMaxAttributes() {
        float maxStamina;
        float currentStamina;
        float maxHealth;
        float currentHealth = ((Player)this.original).getHealth();
        if (currentHealth > (maxHealth = ((Player)this.original).getMaxHealth())) {
            ((Player)this.original).setHealth(maxHealth);
        }
        if ((currentStamina = this.getStamina()) > (maxStamina = this.getMaxStamina())) {
            this.setStamina(maxStamina);
        }
    }

    public boolean consumeForSkill(Skill skill, Skill.Resource consumeResource) {
        return this.consumeForSkill(skill, consumeResource, skill.getDefaultConsumptionAmount(this));
    }

    public boolean consumeForSkill(Skill skill, Skill.Resource consumeResource, float amount) {
        return this.consumeForSkill(skill, consumeResource, amount, false, null);
    }

    @ApiStatus.Internal
    public boolean consumeForSkill(Skill skill, Skill.Resource consumeResource, @Nullable CompoundTag args) {
        return this.consumeForSkill(skill, consumeResource, skill.getDefaultConsumptionAmount(this), false, args);
    }

    public boolean consumeForSkill(Skill skill, Skill.Resource consumeResource, float amount, boolean activateConsumeForce, @Nullable CompoundTag args) {
        Optional<SkillContainer> oContainer = this.getSkillContainerFor(skill);
        if (oContainer.isEmpty()) {
            return false;
        }
        SkillContainer skillContainer = oContainer.get();
        SkillConsumeEvent skillConsumeEvent = new SkillConsumeEvent(this, skill, consumeResource, amount, args);
        PlayerPatchEvent.postAndFireSkillListeners(skillConsumeEvent);
        if (skillConsumeEvent.isCanceled()) {
            return false;
        }
        float modifiedAmount = skillConsumeEvent.getAmount();
        if (skillConsumeEvent.getResourceType().predicate.canExecute(skillContainer, this, modifiedAmount)) {
            if (!this.isLogicalClient()) {
                skillConsumeEvent.getResourceType().consumer.consume(skillContainer, (ServerPlayerPatch)this, modifiedAmount);
            }
            return true;
        }
        if (activateConsumeForce && !this.isLogicalClient()) {
            skillConsumeEvent.getResourceType().consumer.consume(skillContainer, (ServerPlayerPatch)this, modifiedAmount);
        }
        return false;
    }

    public void resetActionTick() {
        this.tickSinceLastAction = 0;
        this.staminaRegenAwaitTicks = 30;
    }

    public int getTickSinceLastAction() {
        return this.tickSinceLastAction;
    }

    public void setStaminaRegenAwaitTicks(int tick) {
        this.staminaRegenAwaitTicks = tick;
    }

    public int getStaminaRegenAwaitTicks() {
        return this.staminaRegenAwaitTicks;
    }

    public boolean startSkillHolding(HoldableSkill holdableSkill) {
        Optional<SkillContainer> containerOptional = this.getSkillContainerFor(holdableSkill.asSkill());
        if (containerOptional.isEmpty()) {
            return false;
        }
        holdableSkill.startHolding(containerOptional.get());
        this.lastChargingTick = ((Player)this.original).tickCount;
        this.holdingSkill = holdableSkill;
        return true;
    }

    public void resetHolding() {
        if (this.holdingSkill != null) {
            if (this.holdingSkill instanceof ChargeableSkill) {
                this.chargingTicks = 0;
            }
            this.holdingSkill.resetHolding(this.getSkill(this.holdingSkill.asSkill()));
            this.holdingSkill = null;
        }
    }

    public boolean isHoldingAny() {
        return this.holdingSkill != null;
    }

    public boolean isHoldingSkill(Skill holdingSkill) {
        return this.holdingSkill == holdingSkill;
    }

    public int getLastChargingTick() {
        return this.lastChargingTick;
    }

    public void setChargingTicks(int amount) {
        HoldableSkill holdableSkill;
        if (this.isHoldingAny() && (holdableSkill = this.getHoldingSkill()) instanceof ChargeableSkill) {
            ChargeableSkill chargeableSkill = (ChargeableSkill)holdableSkill;
            this.chargingTicks = Math.clamp((long)amount, 0, chargeableSkill.getMaxChargingTicks());
        } else {
            this.chargingTicks = 0;
        }
    }

    public int getChargingTicks() {
        return this.chargingTicks;
    }

    public float getSkillChargingTicks(float partialTicks) {
        return this.isHoldingAny() ? (float)(((Player)this.original).tickCount - this.getLastChargingTick()) - 1.0f + partialTicks : 0.0f;
    }

    public int getSkillChargingTicks() {
        int n;
        HoldableSkill holdableSkill;
        if (this.isHoldingAny() && (holdableSkill = this.holdingSkill) instanceof ChargeableSkill) {
            ChargeableSkill chargingSkill = (ChargeableSkill)holdableSkill;
            n = Math.min(((Player)this.original).tickCount - this.getLastChargingTick(), chargingSkill.getMaxChargingTicks());
        } else {
            n = 0;
        }
        return n;
    }

    public int getAccumulatedChargeTicks() {
        return this.getHoldingSkill() instanceof ChargeableSkill ? this.chargingTicks : 0;
    }

    public HoldableSkill getHoldingSkill() {
        return this.holdingSkill;
    }

    public boolean isInAir() {
        return ((Player)this.original).isFallFlying() || this.currentLivingMotion == LivingMotions.FALL;
    }

    @Override
    public boolean shouldMoveOnCurrentSide(ActionAnimation actionAnimation) {
        return this.isLogicalClient();
    }

    public void openSkillBook(ItemStack itemstack, InteractionHand hand) {
    }

    @Override
    public void onFall(LivingFallEvent event) {
        this.getPlayerSkills().fireSkillEvents("epicfight", event);
        super.onFall(event);
        this.setAirborneState(false);
    }

    public void toggleMode() {
        switch (this.playerMode.ordinal()) {
            case 0: {
                this.toEpicFightMode(true);
                break;
            }
            case 1: {
                this.toVanillaMode(true);
            }
        }
    }

    public void toMode(PlayerMode playerMode, boolean synchronize) {
        switch (playerMode.ordinal()) {
            case 0: {
                this.toVanillaMode(synchronize);
                break;
            }
            case 1: {
                this.toEpicFightMode(synchronize);
            }
        }
    }

    public PlayerMode getPlayerMode() {
        return this.playerMode;
    }

    public void toVanillaMode(boolean synchronize) {
        ChangePlayerModeEvent prepareModelEvent;
        if (this.playerMode == PlayerMode.VANILLA) {
            return;
        }
        if (this.battleModeRestricted) {
            this.battleModeRestricted = false;
        }
        if (!((ChangePlayerModeEvent)NeoForge.EVENT_BUS.post((Event)(prepareModelEvent = new ChangePlayerModeEvent(this, PlayerMode.VANILLA)))).isCanceled()) {
            this.playerMode = prepareModelEvent.getPlayerMode();
        }
    }

    public void toEpicFightMode(boolean synchronize) {
        if (this.playerMode == PlayerMode.EPICFIGHT) {
            return;
        }
        ChangePlayerModeEvent prepareModelEvent = new ChangePlayerModeEvent(this, PlayerMode.EPICFIGHT);
        if (!((ChangePlayerModeEvent)NeoForge.EVENT_BUS.post((Event)prepareModelEvent)).isCanceled()) {
            this.playerMode = prepareModelEvent.getPlayerMode();
        }
    }

    public boolean isEpicFightMode() {
        return this.playerMode == PlayerMode.EPICFIGHT;
    }

    public boolean isVanillaMode() {
        return this.playerMode == PlayerMode.VANILLA;
    }

    @Override
    public double getXOld() {
        return this.xo;
    }

    @Override
    public double getYOld() {
        return this.yo;
    }

    @Override
    public double getZOld() {
        return this.zo;
    }

    @Override
    public float getYRot() {
        return this.modelYRot;
    }

    @Override
    public float getYRotO() {
        return this.modelYRotO;
    }

    @Override
    public void setYRotO(float yRot) {
        this.modelYRotO = yRot;
    }

    @Override
    public void setYRot(float yRot) {
        this.setModelYRot(yRot, true);
    }

    @Override
    public float getYRotLimit() {
        return 180.0f;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        if (((Player)this.original).getVehicle() != null) {
            return Animations.BIPED_HIT_ON_MOUNT;
        }
        return switch (stunType) {
            case StunType.LONG -> Animations.BIPED_HIT_LONG;
            case StunType.SHORT, StunType.HOLD -> Animations.BIPED_HIT_SHORT;
            case StunType.KNOCKDOWN -> Animations.BIPED_KNOCKDOWN;
            case StunType.NEUTRALIZE -> Animations.BIPED_COMMON_NEUTRALIZED;
            case StunType.FALL -> Animations.BIPED_LANDING;
            case StunType.NONE -> null;
            default -> null;
        };
    }

    public double checkXTurn(double xRot) {
        return xRot;
    }

    public double checkYTurn(double yRot) {
        return yRot;
    }

    @Override
    public Faction getFaction() {
        return Factions.NEUTRAL;
    }

    public static enum PlayerMode {
        VANILLA,
        EPICFIGHT;

    }
}

