/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.registry.entries.EpicFightEntityTypes;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.registry.entries.EpicFightSounds;

public class DroppedNetherStar
extends ItemEntity {
    public DroppedNetherStar(EntityType<? extends DroppedNetherStar> entityType, Level level) {
        super(entityType, level);
    }

    public DroppedNetherStar(Level level, double x, double y, double z, ItemStack itemstack, double dx, double dy, double dz) {
        this((EntityType<? extends DroppedNetherStar>)((EntityType)EpicFightEntityTypes.DROPPED_NETHER_STAR.get()), level);
        this.setPos(x, y, z);
        this.setDeltaMovement(dx, dy, dz);
        this.setItem(itemstack);
        this.lifespan = itemstack.getItem() == null ? 6000 : itemstack.getEntityLifespan(level);
        this.noPhysics = true;
        this.setPickUpDelay(30);
        this.setNoGravity(true);
    }

    public DroppedNetherStar(Level level, Vec3 position, Vec3 deltaMovement) {
        this(level, position.x, position.y, position.z, new ItemStack((ItemLike)Items.NETHER_STAR), deltaMovement.x, deltaMovement.y, deltaMovement.z);
    }

    public void tick() {
        super.tick();
        if (this.tickCount % 70 == 0) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)EpicFightSounds.NETHER_STAR_GLITTER.get(), this.getSoundSource(), 1.0f, 1.0f, false);
        }
        Vec3 deltaMove = this.getDeltaMovement();
        if (this.level().isClientSide()) {
            Vec3 particleDeltaMove = new Vec3(-deltaMove.x, -1.0, -deltaMove.z).normalize().add((double)((this.random.nextFloat() - 0.5f) * 0.1f), 0.0, (double)((this.random.nextFloat() - 0.5f) * 0.1f));
            this.level().addParticle((ParticleOptions)EpicFightParticles.NORMAL_DUST.get(), this.getX() + (double)((this.random.nextFloat() - 0.5f) * this.getBbWidth()), this.getY() + (double)this.getBbHeight() * 2.5, this.getZ() + (double)((this.random.nextFloat() - 0.5f) * this.getBbWidth()), particleDeltaMove.x, 0.0, particleDeltaMove.z);
        }
        this.setDeltaMovement(deltaMove.multiply(0.68, 0.68, 0.68));
    }

    public boolean isOnFire() {
        return true;
    }

    public boolean displayFireAnimation() {
        return false;
    }
}

