/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.entity.DodgeLocationIndicator;

public class DodgeAnimation
extends ActionAnimation {
    public static final Function<DamageSource, AttackResult.ResultType> DODGEABLE_SOURCE_VALIDATOR = damagesource -> {
        if (!(damagesource.getEntity() == null || damagesource.is(DamageTypeTags.IS_EXPLOSION) || damagesource.is(DamageTypes.MAGIC) || damagesource.is(DamageTypeTags.BYPASSES_ARMOR) || damagesource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || damagesource.is(EpicFightDamageTypeTags.BYPASS_DODGE))) {
            return AttackResult.ResultType.MISSED;
        }
        return AttackResult.ResultType.SUCCESS;
    };
    public static final Consumer<ProjectileImpactEvent> IGNORE_ALL_PROJECTILES = event -> event.setCanceled(true);

    public DodgeAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends DodgeAnimation> accessor, float width, float height, AssetAccessor<? extends Armature> armature) {
        this(transitionTime, 10.0f, accessor, width, height, armature);
    }

    public DodgeAnimation(float transitionTime, float delayTime, AnimationManager.AnimationAccessor<? extends DodgeAnimation> accessor, float width, float height, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, delayTime, accessor, armature);
        this.stateSpectrumBlueprint.clear().newTimePair(0.0f, delayTime).addState(EntityState.TURNING_LOCKED, true).addState(EntityState.MOVEMENT_LOCKED, true).addState(EntityState.UPDATE_LIVING_MOTION, false).addState(EntityState.COMBO_ATTACKS_DOABLE, false).addState(EntityState.SKILL_EXECUTABLE, false).addState(EntityState.INACTION, true).newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.ATTACK_RESULT, DODGEABLE_SOURCE_VALIDATOR).addState(EntityState.PROJECTILE_IMPACT_RESULT, IGNORE_ALL_PROJECTILES);
        this.addProperty(AnimationProperty.ActionAnimationProperty.AFFECT_SPEED, true);
        this.addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, AnimationEvent.SimpleEvent.create(Animations.ReusableSources.RESTORE_BOUNDING_BOX, AnimationEvent.Side.BOTH));
        this.addEvents(AnimationProperty.StaticAnimationProperty.TICK_EVENTS, new AnimationEvent[]{AnimationEvent.SimpleEvent.create(Animations.ReusableSources.RESIZE_BOUNDING_BOX, AnimationEvent.Side.BOTH).params(EntityDimensions.scalable((float)width, (float)height))});
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        if (!entitypatch.isLogicalClient() && entitypatch != null) {
            ((LivingEntity)entitypatch.getOriginal()).level().addFreshEntity((Entity)new DodgeLocationIndicator(entitypatch));
        }
    }
}

