/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationVariables;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class SelectiveAnimation
extends StaticAnimation {
    public static final AnimationVariables.IndependentVariableKey<Integer> PREVIOUS_STATE = AnimationVariables.unsyncIndependent(animator -> 0, true);
    private final Function<LivingEntityPatch<?>, Integer> selector;
    private final List<AssetAccessor<? extends StaticAnimation>> animationsInEachState;

    @SafeVarargs
    public SelectiveAnimation(Function<LivingEntityPatch<?>, Integer> selector, AnimationManager.AnimationAccessor<? extends SelectiveAnimation> accessor, AssetAccessor<? extends StaticAnimation> ... selectOptions) {
        super(0.15f, false, accessor, null);
        this.selector = selector;
        this.animationsInEachState = List.of(selectOptions);
        for (AssetAccessor<? extends StaticAnimation> subAnimations : this.animationsInEachState) {
            subAnimations.get().addEvents(AnimationEvent.SimpleEvent.create((entitypatch, animation, params) -> {
                int currentStateId = this.selector.apply(entitypatch);
                Optional<Integer> prevState = ((Animator)entitypatch.getAnimator()).getVariables().get(PREVIOUS_STATE, this.getAccessor());
                prevState.ifPresentOrElse(prevStateId -> {
                    if (prevStateId != currentStateId) {
                        ((Animator)entitypatch.getAnimator()).playAnimation(this.animationsInEachState.get(currentStateId), 0.0f);
                        ((Animator)entitypatch.getAnimator()).getVariables().put(PREVIOUS_STATE, this.getAccessor(), currentStateId);
                    }
                }, () -> {
                    ((Animator)entitypatch.getAnimator()).playAnimation(this.animationsInEachState.get(0), 0.0f);
                    ((Animator)entitypatch.getAnimator()).getVariables().put(PREVIOUS_STATE, this.getAccessor(), 0);
                });
            }, AnimationEvent.Side.BOTH));
        }
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        int result = this.selector.apply(entitypatch);
        ((Animator)entitypatch.getAnimator()).getVariables().put(PREVIOUS_STATE, this.getAccessor(), result);
        ((Animator)entitypatch.getAnimator()).playAnimation(this.animationsInEachState.get(result), 0.0f);
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
    }

    @Override
    public boolean isMetaAnimation() {
        return true;
    }

    @Override
    public List<AssetAccessor<? extends StaticAnimation>> getSubAnimations() {
        return this.animationsInEachState;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Layer.Priority getPriority() {
        return this.animationsInEachState.get(0).get().getPriority();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Layer.LayerType getLayerType() {
        return this.animationsInEachState.get(0).get().getLayerType();
    }
}

