/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model.transformer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mod.azure.azurelibarmor.common.api.client.renderer.GeoArmorRenderer;
import mod.azure.azurelibarmor.common.internal.client.RenderProvider;
import mod.azure.azurelibarmor.common.internal.client.util.RenderUtils;
import mod.azure.azurelibarmor.common.internal.common.cache.object.GeoBone;
import mod.azure.azurelibarmor.common.internal.common.cache.object.GeoCube;
import mod.azure.azurelibarmor.common.internal.common.cache.object.GeoQuad;
import mod.azure.azurelibarmor.common.internal.common.cache.object.GeoVertex;
import mod.azure.azurelibarmor.core.animatable.GeoAnimatable;
import mod.azure.azurelibarmor.core.animatable.model.CoreGeoBone;
import mod.azure.azurelibarmor.core.state.BoneSnapshot;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.model.MeshPartDefinition;
import yesman.epicfight.api.client.model.SingleGroupVertexBuilder;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.client.model.transformer.GeoModelTransformer;
import yesman.epicfight.api.client.model.transformer.HumanoidModelTransformer;
import yesman.epicfight.api.client.neoevent.AnimatedArmorTextureEvent;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;

@OnlyIn(value=Dist.CLIENT)
public class AzureArmorTransformer
extends HumanoidModelTransformer {
    static final HumanoidModelTransformer.PartTransformer<GeoCube> HEAD = new SimpleTransformer(9);
    static final HumanoidModelTransformer.PartTransformer<GeoCube> LEFT_FEET = new SimpleTransformer(5);
    static final HumanoidModelTransformer.PartTransformer<GeoCube> RIGHT_FEET = new SimpleTransformer(2);
    static final HumanoidModelTransformer.PartTransformer<GeoCube> LEFT_ARM = new LimbPartTransformer(16, 17, 19, 1.125f, false, AABB.ofSize((Vec3)new Vec3(-0.375, 1.125, 0.0), (double)0.5, (double)0.85, (double)0.5));
    static final HumanoidModelTransformer.PartTransformer<GeoCube> RIGHT_ARM = new LimbPartTransformer(11, 12, 14, 1.125f, false, AABB.ofSize((Vec3)new Vec3(0.375, 1.125, 0.0), (double)0.5, (double)0.85, (double)0.5));
    static final HumanoidModelTransformer.PartTransformer<GeoCube> LEFT_LEG = new LimbPartTransformer(4, 5, 6, 0.375f, true, AABB.ofSize((Vec3)new Vec3(-0.15, 0.375, 0.0), (double)0.5, (double)0.85, (double)0.5));
    static final HumanoidModelTransformer.PartTransformer<GeoCube> RIGHT_LEG = new LimbPartTransformer(1, 2, 3, 0.375f, true, AABB.ofSize((Vec3)new Vec3(0.15, 0.375, 0.0), (double)0.5, (double)0.85, (double)0.5));
    static final HumanoidModelTransformer.PartTransformer<GeoCube> CHEST = new ChestPartTransformer(8, 7, 1.125f, AABB.ofSize((Vec3)new Vec3(0.0, 1.125, 0.0), (double)0.9, (double)0.85, (double)0.45));

    public static void getGeoArmorTexturePath(AnimatedArmorTextureEvent event) {
        HumanoidModel extensionRenderer;
        RenderProvider customRenderProperties = RenderProvider.of((ItemStack)event.getItemstack());
        if (customRenderProperties != null && (extensionRenderer = customRenderProperties.getHumanoidArmorModel(event.getLivingEntity(), event.getItemstack(), event.getEquipmentSlot(), event.getOriginalModel())) instanceof GeoArmorRenderer) {
            GeoArmorRenderer geoArmorRenderer = (GeoArmorRenderer)extensionRenderer;
            Item item = event.getItemstack().getItem();
            if (item instanceof GeoAnimatable) {
                GeoAnimatable geoAnimatable = (GeoAnimatable)item;
                event.setResultLocation(geoArmorRenderer.getTextureLocation(geoAnimatable));
            }
        }
    }

    @Override
    public SkinnedMesh transformArmorModel(HumanoidModel<?> humanoidModel) {
        if (!(humanoidModel instanceof GeoArmorRenderer)) {
            return null;
        }
        GeoArmorRenderer geoModel = (GeoArmorRenderer)humanoidModel;
        ArrayList boxes = Lists.newArrayList();
        GeoBone headBone = geoModel.getHeadBone();
        GeoBone bodyBone = geoModel.getBodyBone();
        GeoBone rightArmBone = geoModel.getRightArmBone();
        GeoBone leftArmBone = geoModel.getLeftArmBone();
        GeoBone rightLegBone = geoModel.getRightLegBone();
        GeoBone leftLegBone = geoModel.getLeftLegBone();
        GeoBone rightBootBone = geoModel.getRightBootBone();
        GeoBone leftBootBone = geoModel.getLeftBootBone();
        if (headBone != null) {
            headBone.setRotX(0.0f);
            headBone.setRotY(0.0f);
            headBone.setRotZ(0.0f);
        }
        if (bodyBone != null) {
            bodyBone.setRotX(0.0f);
            bodyBone.setRotY(0.0f);
            bodyBone.setRotZ(0.0f);
        }
        if (rightArmBone != null) {
            rightArmBone.setRotX(0.0f);
            rightArmBone.setRotY(0.0f);
            rightArmBone.setRotZ(0.0f);
        }
        if (leftArmBone != null) {
            leftArmBone.setRotX(0.0f);
            leftArmBone.setRotY(0.0f);
            leftArmBone.setRotZ(0.0f);
        }
        if (rightLegBone != null) {
            rightLegBone.setRotX(0.0f);
            rightLegBone.setRotY(0.0f);
            rightLegBone.setRotZ(0.0f);
        }
        if (leftLegBone != null) {
            leftLegBone.setRotX(0.0f);
            leftLegBone.setRotY(0.0f);
            leftLegBone.setRotZ(0.0f);
        }
        if (rightBootBone != null) {
            rightBootBone.setRotX(0.0f);
            rightBootBone.setRotY(0.0f);
            rightBootBone.setRotZ(0.0f);
        }
        if (leftBootBone != null) {
            leftBootBone.setRotX(0.0f);
            leftBootBone.setRotY(0.0f);
            leftBootBone.setRotZ(0.0f);
        }
        if (headBone != null) {
            boxes.add(new GeoModelPartition(HEAD, headBone));
        }
        if (bodyBone != null) {
            boxes.add(new GeoModelPartition(CHEST, bodyBone));
        }
        if (rightArmBone != null) {
            boxes.add(new GeoModelPartition(RIGHT_ARM, rightArmBone));
        }
        if (leftArmBone != null) {
            boxes.add(new GeoModelPartition(LEFT_ARM, leftArmBone));
        }
        if (leftLegBone != null) {
            boxes.add(new GeoModelPartition(LEFT_LEG, leftLegBone));
        }
        if (rightLegBone != null) {
            boxes.add(new GeoModelPartition(RIGHT_LEG, rightLegBone));
        }
        if (leftBootBone != null) {
            boxes.add(new GeoModelPartition(LEFT_FEET, leftBootBone));
        }
        if (rightBootBone != null) {
            boxes.add(new GeoModelPartition(RIGHT_FEET, rightBootBone));
        }
        return AzureArmorTransformer.bakeMeshFromCubes(boxes);
    }

    private static SkinnedMesh bakeMeshFromCubes(List<GeoModelPartition> partitions) {
        ArrayList vertices = Lists.newArrayList();
        HashMap indices = Maps.newHashMap();
        PoseStack poseStack = new PoseStack();
        HumanoidModelTransformer.PartTransformer.IndexCounter indexCounter = new HumanoidModelTransformer.PartTransformer.IndexCounter();
        for (GeoModelPartition modelpartition : partitions) {
            AzureArmorTransformer.bake(poseStack, modelpartition, modelpartition.geoBone.getName(), modelpartition.geoBone, vertices, indices, Lists.newArrayList(), indexCounter, false);
        }
        return SingleGroupVertexBuilder.loadVertexInformation(vertices, indices);
    }

    private static void bake(PoseStack poseStack, GeoModelPartition modelpartition, String partName, GeoBone geoBone, List<SingleGroupVertexBuilder> vertices, Map<MeshPartDefinition, IntList> indices, List<String> path, HumanoidModelTransformer.PartTransformer.IndexCounter indexCounter, boolean bindPartAnimation) {
        if (geoBone == null) {
            return;
        }
        poseStack.pushPose();
        RenderUtils.prepMatrixForBone((PoseStack)poseStack, (CoreGeoBone)geoBone);
        ArrayList<String> newList = new ArrayList<String>(path);
        if (bindPartAnimation) {
            newList.add(partName);
        }
        if (!geoBone.isHidden()) {
            for (GeoCube cube : geoBone.getCubes()) {
                poseStack.pushPose();
                RenderUtils.translateToPivotPoint((PoseStack)poseStack, (GeoCube)cube);
                RenderUtils.rotateMatrixAroundCube((PoseStack)poseStack, (GeoCube)cube);
                RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoCube)cube);
                MeshPartDefinition partDefinition = GeoModelTransformer.GeoMeshPartDefinition.of(partName);
                if (bindPartAnimation) {
                    OpenMatrix4f invertedParentTransform = OpenMatrix4f.importFromMojangMatrix(poseStack.last().pose());
                    invertedParentTransform.m30 *= 0.0625f;
                    invertedParentTransform.m31 *= 0.0625f;
                    invertedParentTransform.m32 *= 0.0625f;
                    invertedParentTransform.invert();
                    partDefinition = AzureArmorMeshPartDefinition.of(partName, newList, invertedParentTransform, modelpartition.geoBone);
                }
                modelpartition.partTransformer.bakeCube(poseStack, partDefinition, cube, vertices, indices, indexCounter);
                poseStack.popPose();
            }
        }
        if (!geoBone.isHidingChildren()) {
            for (GeoBone childBone : geoBone.getChildBones()) {
                AzureArmorTransformer.bake(poseStack, modelpartition, partName, childBone, vertices, indices, newList, indexCounter, true);
            }
        }
        poseStack.popPose();
    }

    static Direction getDirectionFromVector(Vector3f directionVec) {
        for (Direction direction : Direction.values()) {
            Vector3f direcVec = new Vector3f(Float.compare(directionVec.x(), -0.0f) == 0 ? 0.0f : directionVec.x(), directionVec.y(), directionVec.z());
            if (!direcVec.equals((Object)direction.step())) continue;
            return direction;
        }
        return null;
    }

    static Vec3 getCenterOfCube(PoseStack poseStack, GeoCube cube) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        double maxZ = Double.MIN_VALUE;
        Matrix4f matrix = poseStack.last().pose();
        for (GeoQuad quad : cube.quads()) {
            for (GeoVertex v : quad.vertices()) {
                Vector4f translatedPosition = new Vector4f((Vector3fc)v.position(), 1.0f);
                translatedPosition.mul((Matrix4fc)matrix);
                if (minX > (double)translatedPosition.x()) {
                    minX = translatedPosition.x();
                }
                if (minY > (double)translatedPosition.y()) {
                    minY = translatedPosition.y();
                }
                if (minZ > (double)translatedPosition.z()) {
                    minZ = translatedPosition.z();
                }
                if (maxX < (double)translatedPosition.x()) {
                    maxX = translatedPosition.x();
                }
                if (maxY < (double)translatedPosition.y()) {
                    maxY = translatedPosition.y();
                }
                if (!(maxZ < (double)translatedPosition.z())) continue;
                maxZ = translatedPosition.z();
            }
        }
        return new Vec3(minX + (maxX - minX) * 0.5, minY + (maxY - minY) * 0.5, minZ + (maxZ - minZ) * 0.5);
    }

    static Vector3f getClipPoint(Vector3f pos1, Vector3f pos2, float yClip) {
        Vector3f direct = new Vector3f((Vector3fc)pos2);
        direct.sub((Vector3fc)pos1);
        direct.mul((yClip - pos1.y()) / (pos2.y() - pos1.y()));
        Vector3f clipPoint = new Vector3f((Vector3fc)pos1);
        clipPoint.add((Vector3fc)direct);
        return clipPoint;
    }

    static ModelPart.Vertex getTranslatedVertex(GeoVertex original, Matrix4f matrix) {
        Vector4f translatedPosition = new Vector4f((Vector3fc)original.position(), 1.0f);
        translatedPosition.mul((Matrix4fc)matrix);
        return new ModelPart.Vertex(translatedPosition.x(), translatedPosition.y(), translatedPosition.z(), original.texU(), original.texV());
    }

    public static OpenMatrix4f of(PoseStack poseStack, GeoBone bone) {
        BoneSnapshot boneSnapshot = bone.getInitialSnapshot();
        poseStack.pushPose();
        poseStack.translate(boneSnapshot.getOffsetX(), boneSnapshot.getOffsetY(), boneSnapshot.getOffsetZ());
        if (boneSnapshot.getRotX() != 0.0f || boneSnapshot.getRotY() != 0.0f || boneSnapshot.getRotZ() != 0.0f) {
            poseStack.mulPose(new Quaternionf().rotationZYX(boneSnapshot.getRotZ(), boneSnapshot.getRotY(), boneSnapshot.getRotX()));
        }
        Matrix4f lastPose = new Matrix4f((Matrix4fc)poseStack.last().pose());
        poseStack.popPose();
        OpenMatrix4f matrix = OpenMatrix4f.importFromMojangMatrix(lastPose);
        matrix.m30 *= 0.0625f;
        matrix.m31 *= 0.0625f;
        matrix.m32 *= 0.0625f;
        OpenMatrix4f partAnimation = OpenMatrix4f.mulMatrices(matrix, new OpenMatrix4f().translate(new Vec3f(bone.getPosX() - boneSnapshot.getOffsetX(), bone.getPosY() - boneSnapshot.getOffsetY(), bone.getPosZ() - boneSnapshot.getOffsetZ()).scale(0.0625f)).mulBack(OpenMatrix4f.fromQuaternion(new Quaternionf().rotationZYX(boneSnapshot.getRotZ() - bone.getRotZ(), boneSnapshot.getRotY() - bone.getRotY(), boneSnapshot.getRotX() - bone.getRotX()))).scale(new Vec3f(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ())), OpenMatrix4f.invert(matrix, null));
        return partAnimation;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class GeoModelPartition {
        final HumanoidModelTransformer.PartTransformer<GeoCube> partTransformer;
        final GeoBone geoBone;

        private GeoModelPartition(HumanoidModelTransformer.PartTransformer<GeoCube> partTransformer, GeoBone geoBone) {
            this.partTransformer = partTransformer;
            this.geoBone = geoBone;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record AzureArmorMeshPartDefinition(String partName, List<String> path, OpenMatrix4f invertedParentTransform, GeoBone root) implements MeshPartDefinition
    {
        public static MeshPartDefinition of(String partName) {
            return new AzureArmorMeshPartDefinition(partName, null, null, null);
        }

        public static MeshPartDefinition of(String partName, List<String> path, OpenMatrix4f invertedParentTransform, GeoBone root) {
            return new AzureArmorMeshPartDefinition(partName, path, invertedParentTransform, root);
        }

        public static GeoBone getChildBone(GeoBone bone, String boneName) {
            for (GeoBone childBone : bone.getChildBones()) {
                if (!childBone.getName().equals(boneName)) continue;
                return childBone;
            }
            return null;
        }

        @Override
        public Supplier<OpenMatrix4f> getModelPartAnimationProvider() {
            return this.root == null ? () -> null : () -> {
                PoseStack poseStack = new PoseStack();
                this.progress(this.root, poseStack, false);
                GeoBone bone = this.root;
                int idx = 0;
                for (String childPartName : this.path) {
                    if ((bone = AzureArmorMeshPartDefinition.getChildBone(bone, childPartName)) == null) {
                        return null;
                    }
                    this.progress(bone, poseStack, ++idx == this.path.size());
                }
                OpenMatrix4f parentTransform = OpenMatrix4f.importFromMojangMatrix(poseStack.last().pose());
                GeoBone lastBone = bone;
                BoneSnapshot boneSnapshot = bone.getInitialSnapshot();
                OpenMatrix4f partAnimation = OpenMatrix4f.mulMatrices(parentTransform, new OpenMatrix4f().mulBack(OpenMatrix4f.fromQuaternion(new Quaternionf().rotationZYX(boneSnapshot.getRotZ(), boneSnapshot.getRotY(), boneSnapshot.getRotX())).transpose().invert()).translate(new Vec3f(lastBone.getPosX() - boneSnapshot.getOffsetX(), lastBone.getPosY() - boneSnapshot.getOffsetY(), lastBone.getPosZ() - boneSnapshot.getOffsetZ()).scale(0.0625f)).mulBack(OpenMatrix4f.fromQuaternion(new Quaternionf().rotationZYX(boneSnapshot.getRotZ(), boneSnapshot.getRotY(), boneSnapshot.getRotX())).transpose()).mulBack(OpenMatrix4f.fromQuaternion(new Quaternionf().rotationZYX(boneSnapshot.getRotZ() - lastBone.getRotZ(), boneSnapshot.getRotY() - lastBone.getRotY(), boneSnapshot.getRotX() - lastBone.getRotX()))).scale(new Vec3f(lastBone.getScaleX(), lastBone.getScaleY(), lastBone.getScaleZ())), this.invertedParentTransform);
                return partAnimation;
            };
        }

        @Override
        public Mesh.RenderProperties renderProperties() {
            return null;
        }

        private void progress(GeoBone bone, PoseStack poseStack, boolean last) {
            BoneSnapshot boneSnapshot = bone.getInitialSnapshot();
            if (last) {
                poseStack.translate(boneSnapshot.getOffsetX(), boneSnapshot.getOffsetY(), boneSnapshot.getOffsetZ());
                poseStack.mulPose(new Quaternionf().rotationZYX(boneSnapshot.getRotZ(), boneSnapshot.getRotY(), boneSnapshot.getRotX()));
            } else {
                poseStack.translate(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                poseStack.mulPose(new Quaternionf().rotationZYX(bone.getRotZ(), bone.getRotY(), bone.getRotX()));
                poseStack.scale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MeshPartDefinition) {
                MeshPartDefinition comparision = (MeshPartDefinition)o;
                return this.partName.equals(comparision.partName());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.partName.hashCode();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class SimpleTransformer
    extends HumanoidModelTransformer.PartTransformer<GeoCube> {
        final int jointId;

        public SimpleTransformer(int jointId) {
            this.jointId = jointId;
        }

        @Override
        public void bakeCube(PoseStack poseStack, MeshPartDefinition partName, GeoCube cube, List<SingleGroupVertexBuilder> vertices, Map<MeshPartDefinition, IntList> indices, HumanoidModelTransformer.PartTransformer.IndexCounter indexCounter) {
            for (GeoQuad quad : cube.quads()) {
                if (quad == null) continue;
                Vector3f norm = new Vector3f((Vector3fc)quad.normal());
                norm.mul((Matrix3fc)poseStack.last().normal());
                for (GeoVertex vertex : quad.vertices()) {
                    Vector4f pos = new Vector4f((Vector3fc)vertex.position(), 1.0f);
                    pos.mul((Matrix4fc)poseStack.last().pose());
                    vertices.add(new SingleGroupVertexBuilder().setPosition(new Vec3f(pos.x(), pos.y(), pos.z())).setNormal(new Vec3f(norm.x(), norm.y(), norm.z())).setTextureCoordinate(new Vec2f(vertex.texU(), vertex.texV())).setEffectiveJointIDs(new Vec3f(this.jointId, 0.0f, 0.0f)).setEffectiveJointWeights(new Vec3f(1.0f, 0.0f, 0.0f)).setEffectiveJointNumber(1));
                }
                SimpleTransformer.triangluatePolygon(indices, partName, indexCounter);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class LimbPartTransformer
    extends HumanoidModelTransformer.PartTransformer<GeoCube> {
        final int upperJoint;
        final int lowerJoint;
        final int middleJoint;
        final boolean bendInFront;
        final SimpleTransformer upperAttachmentTransformer;
        final SimpleTransformer lowerAttachmentTransformer;
        final AABB noneAttachmentArea;
        final float yClipCoord;

        public LimbPartTransformer(int upperJoint, int lowerJoint, int middleJoint, float yClipCoord, boolean bendInFront, AABB noneAttachmentArea) {
            this.upperJoint = upperJoint;
            this.lowerJoint = lowerJoint;
            this.middleJoint = middleJoint;
            this.bendInFront = bendInFront;
            this.upperAttachmentTransformer = new SimpleTransformer(upperJoint);
            this.lowerAttachmentTransformer = new SimpleTransformer(lowerJoint);
            this.noneAttachmentArea = noneAttachmentArea;
            this.yClipCoord = yClipCoord;
        }

        @Override
        public void bakeCube(PoseStack poseStack, MeshPartDefinition partName, GeoCube cube, List<SingleGroupVertexBuilder> vertices, Map<MeshPartDefinition, IntList> indices, HumanoidModelTransformer.PartTransformer.IndexCounter indexCounter) {
            Vec3 centerOfCube = AzureArmorTransformer.getCenterOfCube(poseStack, cube);
            if (!this.noneAttachmentArea.contains(centerOfCube)) {
                if (centerOfCube.y < (double)this.yClipCoord) {
                    this.lowerAttachmentTransformer.bakeCube(poseStack, partName, cube, vertices, indices, indexCounter);
                } else {
                    this.upperAttachmentTransformer.bakeCube(poseStack, partName, cube, vertices, indices, indexCounter);
                }
                return;
            }
            ArrayList polygons = Lists.newArrayList();
            for (GeoQuad quad : cube.quads()) {
                Matrix4f matrix = poseStack.last().pose();
                ModelPart.Vertex pos0 = AzureArmorTransformer.getTranslatedVertex(quad.vertices()[0], matrix);
                ModelPart.Vertex pos1 = AzureArmorTransformer.getTranslatedVertex(quad.vertices()[1], matrix);
                ModelPart.Vertex pos2 = AzureArmorTransformer.getTranslatedVertex(quad.vertices()[2], matrix);
                ModelPart.Vertex pos3 = AzureArmorTransformer.getTranslatedVertex(quad.vertices()[3], matrix);
                Direction direction = AzureArmorTransformer.getDirectionFromVector(quad.normal());
                if (pos1.pos.y() > this.yClipCoord != pos2.pos.y() > this.yClipCoord) {
                    boolean isFront;
                    boolean hasSameZ;
                    int lowerId;
                    int upperId;
                    float distance = pos2.pos.y() - pos1.pos.y();
                    float textureV = pos1.v + (pos2.v - pos1.v) * ((this.yClipCoord - pos1.pos.y()) / distance);
                    Vector3f clipPos1 = AzureArmorTransformer.getClipPoint(pos1.pos, pos2.pos, this.yClipCoord);
                    Vector3f clipPos2 = AzureArmorTransformer.getClipPoint(pos0.pos, pos3.pos, this.yClipCoord);
                    ModelPart.Vertex pos4 = new ModelPart.Vertex(clipPos2, pos0.u, textureV);
                    ModelPart.Vertex pos5 = new ModelPart.Vertex(clipPos1, pos1.u, textureV);
                    if (distance > 0.0f) {
                        upperId = this.lowerJoint;
                        lowerId = this.upperJoint;
                    } else {
                        upperId = this.upperJoint;
                        lowerId = this.lowerJoint;
                    }
                    polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, upperId), new AnimatedVertex(pos1, upperId), new AnimatedVertex(pos5, upperId), new AnimatedVertex(pos4, upperId)}, direction));
                    polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, lowerId), new AnimatedVertex(pos5, lowerId), new AnimatedVertex(pos2, lowerId), new AnimatedVertex(pos3, lowerId)}, direction));
                    boolean bl = hasSameZ = pos4.pos.z() < 0.0f == pos5.pos.z() < 0.0f;
                    boolean bl2 = hasSameZ && pos4.pos.z() < 0.0f == this.bendInFront ? true : (isFront = false);
                    if (isFront) {
                        polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, this.middleJoint), new AnimatedVertex(pos5, this.middleJoint), new AnimatedVertex(pos5, this.upperJoint), new AnimatedVertex(pos4, this.upperJoint)}, 0.001f, direction));
                        polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, this.lowerJoint), new AnimatedVertex(pos5, this.lowerJoint), new AnimatedVertex(pos5, this.middleJoint), new AnimatedVertex(pos4, this.middleJoint)}, 0.001f, direction));
                        continue;
                    }
                    if (hasSameZ) continue;
                    boolean startFront = pos4.pos.z() > 0.0f;
                    int firstJoint = this.lowerJoint;
                    int secondJoint = this.lowerJoint;
                    int thirdJoint = startFront ? this.upperJoint : this.middleJoint;
                    int fourthJoint = startFront ? this.middleJoint : this.upperJoint;
                    int fifthJoint = this.upperJoint;
                    int sixthJoint = this.upperJoint;
                    polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, firstJoint), new AnimatedVertex(pos5, secondJoint), new AnimatedVertex(pos5, thirdJoint), new AnimatedVertex(pos4, fourthJoint)}, 0.001f, direction));
                    polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, fourthJoint), new AnimatedVertex(pos5, thirdJoint), new AnimatedVertex(pos5, fifthJoint), new AnimatedVertex(pos4, sixthJoint)}, 0.001f, direction));
                    continue;
                }
                int jointId = pos0.pos.y() > this.yClipCoord ? this.upperJoint : this.lowerJoint;
                polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, jointId), new AnimatedVertex(pos1, jointId), new AnimatedVertex(pos2, jointId), new AnimatedVertex(pos3, jointId)}, direction));
            }
            for (AnimatedPolygon quad : polygons) {
                Vector3f norm = new Vector3f((Vector3fc)quad.normal);
                norm.mul((Matrix3fc)poseStack.last().normal());
                for (AnimatedVertex vertex : quad.animatedVertexPositions) {
                    Vector4f pos = new Vector4f((Vector3fc)vertex.pos, 1.0f);
                    vertices.add(new SingleGroupVertexBuilder().setPosition(new Vec3f(pos.x(), pos.y(), pos.z())).setNormal(new Vec3f(norm.x(), norm.y(), norm.z())).setTextureCoordinate(new Vec2f(vertex.u, vertex.v)).setEffectiveJointIDs(new Vec3f(vertex.jointId.getX(), 0.0f, 0.0f)).setEffectiveJointWeights(new Vec3f(1.0f, 0.0f, 0.0f)).setEffectiveJointNumber(1));
                }
                LimbPartTransformer.triangluatePolygon(indices, partName, indexCounter);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ChestPartTransformer
    extends HumanoidModelTransformer.PartTransformer<GeoCube> {
        static final float X_PLANE = 0.0f;
        static final VertexWeight[] WEIGHT_ALONG_Y = new VertexWeight[]{new VertexWeight(13.6666f, 0.23f, 0.77f), new VertexWeight(15.8333f, 0.254f, 0.746f), new VertexWeight(18.0f, 0.5f, 0.5f), new VertexWeight(20.1666f, 0.744f, 0.256f), new VertexWeight(22.3333f, 0.77f, 0.23f)};
        final SimpleTransformer upperAttachmentTransformer;
        final SimpleTransformer lowerAttachmentTransformer;
        final AABB noneAttachmentArea;
        final float yClipCoord;

        public ChestPartTransformer(int upperJoint, int lowerJoint, float yBasis, AABB noneAttachmentArea) {
            this.noneAttachmentArea = noneAttachmentArea;
            this.upperAttachmentTransformer = new SimpleTransformer(upperJoint);
            this.lowerAttachmentTransformer = new SimpleTransformer(lowerJoint);
            this.yClipCoord = yBasis;
        }

        @Override
        public void bakeCube(PoseStack poseStack, MeshPartDefinition partName, GeoCube cube, List<SingleGroupVertexBuilder> vertices, Map<MeshPartDefinition, IntList> indices, HumanoidModelTransformer.PartTransformer.IndexCounter indexCounter) {
            ModelPart.Vertex pos5;
            ModelPart.Vertex pos4;
            Vec3 centerOfCube = AzureArmorTransformer.getCenterOfCube(poseStack, cube);
            if (!this.noneAttachmentArea.contains(centerOfCube)) {
                if (centerOfCube.y < (double)this.yClipCoord) {
                    this.lowerAttachmentTransformer.bakeCube(poseStack, partName, cube, vertices, indices, indexCounter);
                } else {
                    this.upperAttachmentTransformer.bakeCube(poseStack, partName, cube, vertices, indices, indexCounter);
                }
                return;
            }
            ArrayList xClipPolygons = Lists.newArrayList();
            ArrayList xyClipPolygons = Lists.newArrayList();
            for (GeoQuad polygon : cube.quads()) {
                Matrix4f matrix = poseStack.last().pose();
                ModelPart.Vertex pos0 = AzureArmorTransformer.getTranslatedVertex(polygon.vertices()[0], matrix);
                ModelPart.Vertex pos1 = AzureArmorTransformer.getTranslatedVertex(polygon.vertices()[1], matrix);
                ModelPart.Vertex pos2 = AzureArmorTransformer.getTranslatedVertex(polygon.vertices()[2], matrix);
                ModelPart.Vertex pos3 = AzureArmorTransformer.getTranslatedVertex(polygon.vertices()[3], matrix);
                Direction direction = AzureArmorTransformer.getDirectionFromVector(polygon.normal());
                VertexWeight pos0Weight = ChestPartTransformer.getYClipWeight(pos0.pos.y());
                VertexWeight pos1Weight = ChestPartTransformer.getYClipWeight(pos1.pos.y());
                VertexWeight pos2Weight = ChestPartTransformer.getYClipWeight(pos2.pos.y());
                VertexWeight pos3Weight = ChestPartTransformer.getYClipWeight(pos3.pos.y());
                if (pos1.pos.x() > 0.0f != pos2.pos.x() > 0.0f) {
                    float distance = pos2.pos.x() - pos1.pos.x();
                    float textureU = pos1.u + (pos2.u - pos1.u) * ((0.0f - pos1.pos.x()) / distance);
                    pos4 = new ModelPart.Vertex(0.0f, pos0.pos.y(), pos0.pos.z(), textureU, pos0.v);
                    pos5 = new ModelPart.Vertex(0.0f, pos1.pos.y(), pos1.pos.z(), textureU, pos1.v);
                    xClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos4, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos5, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f), new AnimatedVertex(pos3, 8, 7, 0, pos3Weight.chestWeight, pos3Weight.torsoWeight, 0.0f)}, direction));
                    xClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos1, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f), new AnimatedVertex(pos2, 8, 7, 0, pos2Weight.chestWeight, pos2Weight.torsoWeight, 0.0f), new AnimatedVertex(pos5, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f)}, direction));
                    continue;
                }
                xClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos1, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f), new AnimatedVertex(pos2, 8, 7, 0, pos2Weight.chestWeight, pos2Weight.torsoWeight, 0.0f), new AnimatedVertex(pos3, 8, 7, 0, pos3Weight.chestWeight, pos3Weight.torsoWeight, 0.0f)}, direction));
            }
            for (AnimatedPolygon polygon : xClipPolygons) {
                boolean upsideDown = polygon.animatedVertexPositions[1].pos.y() > polygon.animatedVertexPositions[2].pos.y();
                AnimatedVertex pos0 = upsideDown ? polygon.animatedVertexPositions[2] : polygon.animatedVertexPositions[0];
                AnimatedVertex pos1 = upsideDown ? polygon.animatedVertexPositions[3] : polygon.animatedVertexPositions[1];
                AnimatedVertex pos2 = upsideDown ? polygon.animatedVertexPositions[0] : polygon.animatedVertexPositions[2];
                AnimatedVertex pos3 = upsideDown ? polygon.animatedVertexPositions[1] : polygon.animatedVertexPositions[3];
                Direction direction = AzureArmorTransformer.getDirectionFromVector(polygon.normal);
                List<VertexWeight> vertexWeights = ChestPartTransformer.getMiddleYClipWeights(pos1.pos.y(), pos2.pos.y());
                ArrayList animatedVertices = Lists.newArrayList();
                animatedVertices.add(pos0);
                animatedVertices.add(pos1);
                if (!vertexWeights.isEmpty()) {
                    for (VertexWeight vertexWeight : vertexWeights) {
                        float distance = pos2.pos.y() - pos1.pos.y();
                        float textureV = pos1.v + (pos2.v - pos1.v) * ((vertexWeight.yClipCoord - pos1.pos.y()) / distance);
                        Vector3f clipPos1 = AzureArmorTransformer.getClipPoint(pos1.pos, pos2.pos, vertexWeight.yClipCoord);
                        Vector3f clipPos2 = AzureArmorTransformer.getClipPoint(pos0.pos, pos3.pos, vertexWeight.yClipCoord);
                        pos4 = new ModelPart.Vertex(clipPos2, pos0.u, textureV);
                        pos5 = new ModelPart.Vertex(clipPos1, pos1.u, textureV);
                        animatedVertices.add(new AnimatedVertex(pos4, 8, 7, 0, vertexWeight.chestWeight, vertexWeight.torsoWeight, 0.0f));
                        animatedVertices.add(new AnimatedVertex(pos5, 8, 7, 0, vertexWeight.chestWeight, vertexWeight.torsoWeight, 0.0f));
                    }
                }
                animatedVertices.add(pos3);
                animatedVertices.add(pos2);
                for (int i = 0; i < (animatedVertices.size() - 2) / 2; ++i) {
                    int start = i * 2;
                    AnimatedVertex p0 = (AnimatedVertex)((Object)animatedVertices.get(start));
                    AnimatedVertex p1 = (AnimatedVertex)((Object)animatedVertices.get(start + 1));
                    AnimatedVertex p2 = (AnimatedVertex)((Object)animatedVertices.get(start + 3));
                    AnimatedVertex p3 = (AnimatedVertex)((Object)animatedVertices.get(start + 2));
                    xyClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(p0, 8, 7, 0, p0.weight.x, p0.weight.y, 0.0f), new AnimatedVertex(p1, 8, 7, 0, p1.weight.x, p1.weight.y, 0.0f), new AnimatedVertex(p2, 8, 7, 0, p2.weight.x, p2.weight.y, 0.0f), new AnimatedVertex(p3, 8, 7, 0, p3.weight.x, p3.weight.y, 0.0f)}, direction));
                }
            }
            for (AnimatedPolygon polygon : xyClipPolygons) {
                Vector3f norm = new Vector3f((Vector3fc)polygon.normal);
                norm.mul((Matrix3fc)poseStack.last().normal());
                for (AnimatedVertex vertex : polygon.animatedVertexPositions) {
                    int count;
                    Vector4f pos = new Vector4f((Vector3fc)vertex.pos, 1.0f);
                    float weight1 = vertex.weight.x;
                    float weight2 = vertex.weight.y;
                    int joint1 = vertex.jointId.getX();
                    int joint2 = vertex.jointId.getY();
                    int n = count = weight1 > 0.0f && weight2 > 0.0f ? 2 : 1;
                    if (weight1 <= 0.0f) {
                        joint1 = joint2;
                        weight1 = weight2;
                    }
                    vertices.add(new SingleGroupVertexBuilder().setPosition(new Vec3f(pos.x(), pos.y(), pos.z())).setNormal(new Vec3f(norm.x(), norm.y(), norm.z())).setTextureCoordinate(new Vec2f(vertex.u, vertex.v)).setEffectiveJointIDs(new Vec3f(joint1, joint2, 0.0f)).setEffectiveJointWeights(new Vec3f(weight1, weight2, 0.0f)).setEffectiveJointNumber(count));
                }
                ChestPartTransformer.triangluatePolygon(indices, partName, indexCounter);
            }
        }

        static VertexWeight getYClipWeight(float y) {
            if (y < ChestPartTransformer.WEIGHT_ALONG_Y[0].yClipCoord) {
                return new VertexWeight(y, 0.0f, 1.0f);
            }
            int index = -1;
            for (int i = 0; i < WEIGHT_ALONG_Y.length; ++i) {
            }
            if (index > 0) {
                VertexWeight pair = WEIGHT_ALONG_Y[index];
                return new VertexWeight(y, pair.chestWeight, pair.torsoWeight);
            }
            return new VertexWeight(y, 1.0f, 0.0f);
        }

        static List<VertexWeight> getMiddleYClipWeights(float minY, float maxY) {
            ArrayList cutYs = Lists.newArrayList();
            for (VertexWeight vertexWeight : WEIGHT_ALONG_Y) {
                if (!(vertexWeight.yClipCoord > minY) || !(maxY >= vertexWeight.yClipCoord)) continue;
                cutYs.add(vertexWeight);
            }
            return cutYs;
        }

        static class VertexWeight {
            final float yClipCoord;
            final float chestWeight;
            final float torsoWeight;

            public VertexWeight(float yClipCoord, float chestWeight, float torsoWeight) {
                this.yClipCoord = yClipCoord;
                this.chestWeight = chestWeight;
                this.torsoWeight = torsoWeight;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class AnimatedPolygon {
        public final AnimatedVertex[] animatedVertexPositions;
        public final Vector3f normal;

        public AnimatedPolygon(AnimatedVertex[] positionsIn, Direction directionIn) {
            this.animatedVertexPositions = positionsIn;
            this.normal = directionIn.step();
        }

        public AnimatedPolygon(AnimatedVertex[] positionsIn, float cor, Direction directionIn) {
            this.animatedVertexPositions = positionsIn;
            positionsIn[0] = new AnimatedVertex(positionsIn[0], positionsIn[0].u, positionsIn[0].v + cor, positionsIn[0].jointId, positionsIn[0].weight);
            positionsIn[1] = new AnimatedVertex(positionsIn[1], positionsIn[1].u, positionsIn[1].v + cor, positionsIn[1].jointId, positionsIn[1].weight);
            positionsIn[2] = new AnimatedVertex(positionsIn[2], positionsIn[2].u, positionsIn[2].v - cor, positionsIn[2].jointId, positionsIn[2].weight);
            positionsIn[3] = new AnimatedVertex(positionsIn[3], positionsIn[3].u, positionsIn[3].v - cor, positionsIn[3].jointId, positionsIn[3].weight);
            this.normal = directionIn.step();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class AnimatedVertex
    extends ModelPart.Vertex {
        final Vec3i jointId;
        final Vec3f weight;

        public AnimatedVertex(ModelPart.Vertex posTexVertx, int jointId) {
            this(posTexVertx, jointId, 0, 0, 1.0f, 0.0f, 0.0f);
        }

        public AnimatedVertex(ModelPart.Vertex posTexVertx, int jointId1, int jointId2, int jointId3, float weight1, float weight2, float weight3) {
            this(posTexVertx, new Vec3i(jointId1, jointId2, jointId3), new Vec3f(weight1, weight2, weight3));
        }

        public AnimatedVertex(ModelPart.Vertex posTexVertx, Vec3i ids, Vec3f weights) {
            this(posTexVertx, posTexVertx.u, posTexVertx.v, ids, weights);
        }

        public AnimatedVertex(ModelPart.Vertex posTexVertx, float u, float v, Vec3i ids, Vec3f weights) {
            super(posTexVertx.pos.x(), posTexVertx.pos.y(), posTexVertx.pos.z(), u, v);
            this.jointId = ids;
            this.weight = weights;
        }
    }
}

