/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils;

import com.mojang.datafixers.util.Function7;
import com.mojang.datafixers.util.Function8;
import com.mojang.datafixers.util.Function9;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.ExtensibleEnum;
import yesman.epicfight.api.utils.ExtensibleEnumManager;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public interface ByteBufCodecsExtends {
    public static final StreamCodec<ByteBuf, Void> EMPTY = new StreamCodec<ByteBuf, Void>(){

        public void encode(ByteBuf buffer, Void obj) {
        }

        public Void decode(ByteBuf buffer) {
            return null;
        }
    };
    public static final StreamCodec<ByteBuf, Vec3> VEC3 = new StreamCodec<ByteBuf, Vec3>(){

        public void encode(ByteBuf buffer, Vec3 obj) {
            buffer.writeDouble(obj.x);
            buffer.writeDouble(obj.y);
            buffer.writeDouble(obj.z);
        }

        public Vec3 decode(ByteBuf buffer) {
            return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    };
    public static final StreamCodec<ByteBuf, Vec3f> VEC3F = new StreamCodec<ByteBuf, Vec3f>(){

        public void encode(ByteBuf buffer, Vec3f obj) {
            buffer.writeFloat(obj.x);
            buffer.writeFloat(obj.y);
            buffer.writeFloat(obj.z);
        }

        public Vec3f decode(ByteBuf buffer) {
            return new Vec3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    public static final StreamCodec<ByteBuf, AssetAccessor<? extends StaticAnimation>> ANIMATION = new StreamCodec<ByteBuf, AssetAccessor<? extends StaticAnimation>>(){

        public void encode(ByteBuf buffer, AssetAccessor<? extends StaticAnimation> obj) {
            buffer.writeInt(obj.get().getId());
        }

        public AssetAccessor<? extends StaticAnimation> decode(ByteBuf buffer) {
            int animationId = buffer.readInt();
            return animationId < 0 ? Animations.EMPTY_ANIMATION : AnimationManager.byId(animationId);
        }
    };
    public static final StreamCodec<ByteBuf, EpicFightGameRules.KeyValuePair> GAMERULE = new StreamCodec<ByteBuf, EpicFightGameRules.KeyValuePair>(){

        public void encode(ByteBuf buffer, EpicFightGameRules.KeyValuePair obj) {
            Utf8String.write((ByteBuf)buffer, (CharSequence)obj.gamerule().getRuleName(), (int)Short.MAX_VALUE);
            obj.gamerule().getRuleType().codec().encode((Object)buffer, obj.value());
        }

        public EpicFightGameRules.KeyValuePair decode(ByteBuf buffer) {
            String ruleName = Utf8String.read((ByteBuf)buffer, (int)Short.MAX_VALUE);
            EpicFightGameRules.ConfigurableGameRule<?, ?, ?> gamerule = EpicFightGameRules.GAME_RULES.get(ruleName);
            Object value = gamerule.getRuleType().codec().decode((Object)buffer);
            return new EpicFightGameRules.KeyValuePair(gamerule, value);
        }
    };
    public static final Function<Class<? extends Enum<?>>, StreamCodec<? super RegistryFriendlyByteBuf, ? extends Enum<?>>> ENUM = Util.memoize(enumType -> {
        try {
            return new EnumCodec((Class<Enum<?>>)enumType);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(enumType.getName() + " is not a valid type for enum codec", e);
        }
    });
    public static final Function<ExtensibleEnumManager<? extends ExtensibleEnum>, StreamCodec<? super RegistryFriendlyByteBuf, ? extends ExtensibleEnum>> EXTENSIBLE_ENUM = Util.memoize(enumManager -> new StreamCodec<RegistryFriendlyByteBuf, ExtensibleEnum>(){

        public void encode(RegistryFriendlyByteBuf buffer, ExtensibleEnum obj) {
            buffer.writeInt(obj.universalOrdinal());
        }

        public ExtensibleEnum decode(RegistryFriendlyByteBuf buffer) {
            return enumManager.getOrThrow(buffer.readInt());
        }
    });

    public static <B extends ByteBuf, T> StreamCodec<B, List<T>> listOf(final StreamCodec<B, T> elementCodec) {
        return new StreamCodec<B, List<T>>(){

            public void encode(B buffer, List<T> obj) {
                buffer.writeInt(obj.size());
                obj.forEach(val -> elementCodec.encode(buffer, val));
            }

            public List<T> decode(B buffer) {
                int size = buffer.readInt();
                ArrayList<Object> list = new ArrayList<Object>(size);
                for (int i = 0; i < size; ++i) {
                    Object obj = elementCodec.decode(buffer);
                    list.add(obj);
                }
                return list;
            }
        };
    }

    public static <B extends ByteBuf, T> StreamCodec<B, List<Holder<T>>> listOfHolder(final StreamCodec<B, Holder<T>> elementCodec) {
        return new StreamCodec<B, List<Holder<T>>>(){

            public void encode(B buffer, List<Holder<T>> obj) {
                buffer.writeInt(obj.size());
                obj.forEach(val -> elementCodec.encode(buffer, val));
            }

            public List<Holder<T>> decode(B buffer) {
                int size = buffer.readInt();
                ArrayList list = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    Holder obj = (Holder)elementCodec.decode(buffer);
                    list.add(obj);
                }
                return list;
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, ResourceKey<T>> getResourceKey(final ResourceKey<? extends Registry<T>> registryKey) {
        return new StreamCodec<RegistryFriendlyByteBuf, ResourceKey<T>>(){

            public void encode(RegistryFriendlyByteBuf buffer, ResourceKey<T> obj) {
                buffer.writeResourceKey(obj);
            }

            public ResourceKey<T> decode(RegistryFriendlyByteBuf buffer) {
                return buffer.readResourceKey(registryKey);
            }
        };
    }

    public static <B extends ByteBuf, T extends Enum<T>> StreamCodec<B, T> enumCodec(Class<T> enumType) {
        return ENUM.apply(enumType);
    }

    public static <T> StreamCodec<ByteBuf, T> ofNullable(final StreamCodec<? super RegistryFriendlyByteBuf, T> codec) {
        return new StreamCodec<ByteBuf, T>(){

            public T decode(ByteBuf buffer) {
                boolean isNull = buffer.readBoolean();
                if (isNull) {
                    return null;
                }
                return codec.decode((Object)buffer);
            }

            public void encode(ByteBuf buffer, T object) {
                if (object == null) {
                    buffer.writeBoolean(true);
                } else {
                    buffer.writeBoolean(false);
                    codec.encode((Object)buffer, object);
                }
            }
        };
    }

    public static <T> StreamCodec<FriendlyByteBuf, TagKey<T>> tagKey(ResourceKey<Registry<T>> registry) {
        return new StreamCodec<FriendlyByteBuf, TagKey<T>>(){

            public TagKey<T> decode(FriendlyByteBuf buffer) {
                ResourceLocation registry = buffer.readResourceLocation();
                ResourceLocation tagName = buffer.readResourceLocation();
                return TagKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)registry), (ResourceLocation)tagName);
            }

            public void encode(FriendlyByteBuf buffer, TagKey<T> tagKey) {
                buffer.writeResourceLocation(tagKey.registry().location());
                buffer.writeResourceLocation(tagKey.location());
            }
        };
    }

    public static <B extends ByteBuf, T extends ExtensibleEnum> StreamCodec<B, T> extendableEnumCodec(ExtensibleEnumManager<T> enumManager) {
        return EXTENSIBLE_ENUM.apply(enumManager);
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7> StreamCodec<B, C> composite7(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final Function7<T1, T2, T3, T4, T5, T6, T7, C> factory) {
        return new StreamCodec<B, C>(){

            public C decode(B p_330310_) {
                Object t1 = codec1.decode(p_330310_);
                Object t2 = codec2.decode(p_330310_);
                Object t3 = codec3.decode(p_330310_);
                Object t4 = codec4.decode(p_330310_);
                Object t5 = codec5.decode(p_330310_);
                Object t6 = codec6.decode(p_330310_);
                Object t7 = codec7.decode(p_330310_);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7);
            }

            public void encode(B p_332052_, C p_331912_) {
                codec1.encode(p_332052_, getter1.apply(p_331912_));
                codec2.encode(p_332052_, getter2.apply(p_331912_));
                codec3.encode(p_332052_, getter3.apply(p_331912_));
                codec4.encode(p_332052_, getter4.apply(p_331912_));
                codec5.encode(p_332052_, getter5.apply(p_331912_));
                codec6.encode(p_332052_, getter6.apply(p_331912_));
                codec7.encode(p_332052_, getter7.apply(p_331912_));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8> StreamCodec<B, C> composite8(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final StreamCodec<? super B, T8> codec8, final Function<C, T8> getter8, final Function8<T1, T2, T3, T4, T5, T6, T7, T8, C> factory) {
        return new StreamCodec<B, C>(){

            public C decode(B p_330310_) {
                Object t1 = codec1.decode(p_330310_);
                Object t2 = codec2.decode(p_330310_);
                Object t3 = codec3.decode(p_330310_);
                Object t4 = codec4.decode(p_330310_);
                Object t5 = codec5.decode(p_330310_);
                Object t6 = codec6.decode(p_330310_);
                Object t7 = codec7.decode(p_330310_);
                Object t8 = codec8.decode(p_330310_);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7, t8);
            }

            public void encode(B p_332052_, C p_331912_) {
                codec1.encode(p_332052_, getter1.apply(p_331912_));
                codec2.encode(p_332052_, getter2.apply(p_331912_));
                codec3.encode(p_332052_, getter3.apply(p_331912_));
                codec4.encode(p_332052_, getter4.apply(p_331912_));
                codec5.encode(p_332052_, getter5.apply(p_331912_));
                codec6.encode(p_332052_, getter6.apply(p_331912_));
                codec7.encode(p_332052_, getter7.apply(p_331912_));
                codec8.encode(p_332052_, getter8.apply(p_331912_));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8, T9> StreamCodec<B, C> composite9(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final StreamCodec<? super B, T8> codec8, final Function<C, T8> getter8, final StreamCodec<? super B, T9> codec9, final Function<C, T9> getter9, final Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, C> factory) {
        return new StreamCodec<B, C>(){

            public C decode(B p_330310_) {
                Object t1 = codec1.decode(p_330310_);
                Object t2 = codec2.decode(p_330310_);
                Object t3 = codec3.decode(p_330310_);
                Object t4 = codec4.decode(p_330310_);
                Object t5 = codec5.decode(p_330310_);
                Object t6 = codec6.decode(p_330310_);
                Object t7 = codec7.decode(p_330310_);
                Object t8 = codec8.decode(p_330310_);
                Object t9 = codec9.decode(p_330310_);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9);
            }

            public void encode(B p_332052_, C p_331912_) {
                codec1.encode(p_332052_, getter1.apply(p_331912_));
                codec2.encode(p_332052_, getter2.apply(p_331912_));
                codec3.encode(p_332052_, getter3.apply(p_331912_));
                codec4.encode(p_332052_, getter4.apply(p_331912_));
                codec5.encode(p_332052_, getter5.apply(p_331912_));
                codec6.encode(p_332052_, getter6.apply(p_331912_));
                codec7.encode(p_332052_, getter7.apply(p_331912_));
                codec8.encode(p_332052_, getter8.apply(p_331912_));
                codec9.encode(p_332052_, getter9.apply(p_331912_));
            }
        };
    }

    public static class EnumCodec<B extends ByteBuf, T extends Enum<T>>
    implements StreamCodec<B, T> {
        private final T[] enumValues;

        private EnumCodec(Class<? extends Enum<?>> enumType) throws NoSuchMethodException, SecurityException, IllegalAccessException, InvocationTargetException {
            Method valuesInvoker = enumType.getMethod("values", new Class[0]);
            this.enumValues = (Enum[])valuesInvoker.invoke(null, new Object[0]);
        }

        public T decode(B buffer) {
            return this.enumValues[buffer.readInt()];
        }

        public void encode(B buffer, T value) {
            buffer.writeInt(((Enum)value).ordinal());
        }
    }
}

