/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.neoevent.playerpatch.PlayerPatchEvent;
import yesman.epicfight.api.neoevent.playerpatch.TargetIndicatorCheckEvent;
import yesman.epicfight.client.gui.EntityUI;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class TargetIndicator
extends EntityUI {
    @Override
    public boolean shouldDraw(LivingEntity entity, @Nullable LivingEntityPatch<?> entitypatch, LocalPlayerPatch playerpatch, float partialTicks) {
        if (!ClientConfig.showTargetIndicator) {
            return false;
        }
        if (playerpatch != null && entity != playerpatch.getTarget()) {
            return false;
        }
        if (entity.isInvisibleTo((Player)playerpatch.getOriginal()) || !entity.isAlive() || entity == playerpatch.getOriginal()) {
            return true;
        }
        if (entity.distanceToSqr(Minecraft.getInstance().getCameraEntity()) >= 400.0) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.isSpectator();
        }
        return true;
    }

    @Override
    public void draw(LivingEntity entity, @Nullable LivingEntityPatch<?> entitypatch, LocalPlayerPatch playerpatch, PoseStack poseStack, MultiBufferSource buffers, float partialTicks) {
        poseStack.pushPose();
        EntityUI.setupPoseStack(poseStack, entity, 0.0f, entity.getBbHeight() + 0.45f, 0.0f, true, partialTicks);
        if (entitypatch == null) {
            TargetIndicator.drawUIAsLevelModel(poseStack.last(), BATTLE_ICON, buffers, -0.1f, -0.1f, 0.1f, 0.1f, 97, 2, 128, 33, 256);
        } else {
            TargetIndicatorCheckEvent event = new TargetIndicatorCheckEvent(playerpatch, entitypatch);
            PlayerPatchEvent.postAndFireSkillListeners(event);
            switch (event.getIndicatorType()) {
                case NORMAL: {
                    TargetIndicator.drawUIAsLevelModel(poseStack.last(), BATTLE_ICON, buffers, -0.1f, -0.1f, 0.1f, 0.1f, 97, 2, 128, 33, 256);
                    break;
                }
                case FLASH: {
                    if (entity.tickCount % 2 == 0) {
                        TargetIndicator.drawUIAsLevelModel(poseStack.last(), BATTLE_ICON, buffers, -0.1f, -0.1f, 0.1f, 0.1f, 132, 0, 167, 36, 256);
                        break;
                    }
                    TargetIndicator.drawUIAsLevelModel(poseStack.last(), BATTLE_ICON, buffers, -0.1f, -0.1f, 0.1f, 0.1f, 97, 2, 128, 33, 256);
                }
            }
        }
        poseStack.popPose();
    }
}

