/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.utils.math.QuaternionUtils;

@OnlyIn(value=Dist.CLIENT)
public abstract class CustomModelParticle<M extends Mesh>
extends Particle {
    protected final AssetAccessor<M> particleMeshProvider;
    protected float pitch;
    protected float pitchO;
    protected float yaw;
    protected float yawO;
    protected float scale = 1.0f;
    protected float scaleO = 1.0f;

    public CustomModelParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, AssetAccessor<M> particleMesh) {
        super(level, x, y, z, xd, yd, zd);
        this.particleMeshProvider = particleMesh;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        PoseStack poseStack = new PoseStack();
        poseStack.pushPose();
        this.setupPoseStack(poseStack, camera, partialTicks);
        this.prepareDraw(poseStack, partialTicks);
        ((Mesh)this.particleMeshProvider.get()).draw(poseStack, vertexConsumer, Mesh.DrawingFunction.POSITION_TEX_COLOR_LIGHTMAP, this.getLightColor(partialTicks), this.rCol, this.gCol, this.bCol, this.alpha, OverlayTexture.NO_OVERLAY);
        this.revert(poseStack);
        poseStack.popPose();
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.pitchO = this.pitch;
            this.yawO = this.yaw;
            this.oRoll = this.roll;
            this.scaleO = this.scale;
        }
    }

    public void prepareDraw(PoseStack poseStack, float partialTicks) {
    }

    protected void setupPoseStack(PoseStack poseStack, Camera camera, float partialTicks) {
        poseStack.pushPose();
        Vec3 cameraPosition = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPosition.x());
        float y = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPosition.y());
        float z = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPosition.z());
        poseStack.translate(x, y, z);
        Quaternionf rotation = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        float roll = Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll);
        float pitch = Mth.lerp((float)partialTicks, (float)this.pitchO, (float)this.pitch);
        float yaw = Mth.lerp((float)partialTicks, (float)this.yawO, (float)this.yaw);
        rotation.mul((Quaternionfc)QuaternionUtils.YP.rotationDegrees(180.0f - yaw));
        rotation.mul((Quaternionfc)QuaternionUtils.XP.rotationDegrees(pitch));
        rotation.mul((Quaternionfc)QuaternionUtils.ZP.rotationDegrees(roll));
        poseStack.mulPose(rotation);
        float scale = Mth.lerp((float)partialTicks, (float)this.scaleO, (float)this.scale);
        poseStack.scale(scale, scale, scale);
    }

    protected void revert(PoseStack poseStack) {
        poseStack.popPose();
    }
}

