/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.client.mesh.WitherMesh;
import yesman.epicfight.client.renderer.entity.WitherGhostRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitherRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.boss.WitherGhostPatch;
import yesman.epicfight.world.entity.WitherGhostClone;

@OnlyIn(value=Dist.CLIENT)
public class WitherGhostCloneRenderer
extends PatchedEntityRenderer<WitherGhostClone, WitherGhostPatch, WitherGhostRenderer, WitherMesh> {
    @Override
    public void render(WitherGhostClone entity, WitherGhostPatch entitypatch, WitherGhostRenderer renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        RenderType renderType = RenderType.entityTranslucent((ResourceLocation)PWitherRenderer.WITHER_INVULNERABLE_LOCATION);
        WitherMesh mesh = (WitherMesh)this.getMeshProvider(entitypatch).get();
        Armature armature = entitypatch.getArmature();
        float tranparency = entity.isNoAi() ? 0.6f : Mth.sin((float)(((float)entity.tickCount + partialTicks) * 0.025f * (float)Math.PI)) * 0.6f;
        poseStack.pushPose();
        this.mulPoseStack(poseStack, armature, entity, entitypatch, partialTicks);
        this.setArmaturePose(entitypatch, armature, partialTicks);
        mesh.draw(poseStack, buffer, renderType, packedLight, 1.0f, 1.0f, 1.0f, tranparency, OverlayTexture.NO_OVERLAY, entitypatch.getArmature(), armature.getPoseMatrices());
        if (Minecraft.getInstance().getEntityRenderDispatcher().shouldRenderHitBoxes()) {
            for (Layer.Priority priority : Layer.Priority.values()) {
                AnimationPlayer animPlayer = entitypatch.getClientAnimator().getCompositeLayer((Layer.Priority)priority).animationPlayer;
                float playTime = animPlayer.getPrevElapsedTime() + (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()) * partialTicks;
                animPlayer.getAnimation().get().renderDebugging(poseStack, buffer, entitypatch, playTime, partialTicks);
            }
        }
        poseStack.popPose();
    }

    @Override
    public AssetAccessor<WitherMesh> getDefaultMesh() {
        return Meshes.WITHER;
    }
}

