/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.world.capabilites.entitypatch.player;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.joml.Vector4f;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.neoevent.RenderEpicFightPlayerEvent;
import yesman.epicfight.api.client.neoevent.UpdatePlayerMotionEvent;
import yesman.epicfight.api.client.online.EpicSkins;
import yesman.epicfight.api.client.physics.cloth.ClothSimulatable;
import yesman.epicfight.api.client.physics.cloth.ClothSimulator;
import yesman.epicfight.api.neoevent.playerpatch.PlayerPatchEvent;
import yesman.epicfight.api.physics.PhysicsSimulator;
import yesman.epicfight.api.physics.SimulationTypes;
import yesman.epicfight.api.utils.EntitySnapshot;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.world.capabilities.entitypatch.EntityDecorations;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

@OnlyIn(value=Dist.CLIENT)
public class AbstractClientPlayerPatch<T extends AbstractClientPlayer>
extends PlayerPatch<T>
implements ClothSimulatable {
    private Item prevHeldItem;
    private Item prevHeldItemOffHand;
    protected EpicSkins epicSkinsInformation;
    private final ClothSimulator clothSimulator = new ClothSimulator();
    public float modelYRotO2;
    public double xPosO2;
    public double yPosO2;
    public double zPosO2;
    public double xCloakO2;
    public double yCloakO2;
    public double zCloakO2;

    public AbstractClientPlayerPatch(T entity) {
        super(entity);
    }

    @Override
    public void onJoinWorld(T entity, EntityJoinLevelEvent event) {
        super.onJoinWorld(entity, event);
        this.prevHeldItem = Items.AIR;
        this.prevHeldItemOffHand = Items.AIR;
        EpicSkins.initEpicSkins(this);
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((AbstractClientPlayer)this.original).getHealth() <= 0.0f) {
            this.currentLivingMotion = LivingMotions.DEATH;
        } else if (!this.state.updateLivingMotion() && considerInaction) {
            this.currentLivingMotion = LivingMotions.INACTION;
        } else if (((AbstractClientPlayer)this.original).isFallFlying() || ((AbstractClientPlayer)this.original).isAutoSpinAttack()) {
            this.currentLivingMotion = LivingMotions.FLY;
        } else if (((AbstractClientPlayer)this.original).getVehicle() != null) {
            this.currentLivingMotion = ((AbstractClientPlayer)this.original).getVehicle() instanceof PlayerRideableJumping ? LivingMotions.MOUNT : LivingMotions.SIT;
        } else if (((AbstractClientPlayer)this.original).isVisuallySwimming()) {
            this.currentLivingMotion = LivingMotions.SWIM;
        } else if (((AbstractClientPlayer)this.original).isSleeping()) {
            this.currentLivingMotion = LivingMotions.SLEEP;
        } else if (!((AbstractClientPlayer)this.original).onGround() && ((AbstractClientPlayer)this.original).onClimbable()) {
            this.currentLivingMotion = LivingMotions.CLIMB;
        } else if (!((AbstractClientPlayer)this.original).getAbilities().flying) {
            ClientAnimator animator = this.getClientAnimator();
            if (((AbstractClientPlayer)this.original).isUnderWater() && ((AbstractClientPlayer)this.original).getY() - this.yo < -0.005) {
                this.currentLivingMotion = LivingMotions.FLOAT;
            } else if (((AbstractClientPlayer)this.original).getY() - this.yo < (double)-0.4f || this.isAirborneState()) {
                this.currentLivingMotion = LivingMotions.FALL;
            } else if (this.isMoving()) {
                this.currentLivingMotion = ((AbstractClientPlayer)this.original).isCrouching() ? LivingMotions.SNEAK : (((AbstractClientPlayer)this.original).isSprinting() ? LivingMotions.RUN : LivingMotions.WALK);
                animator.baseLayer.animationPlayer.setReversed(this.dz < 0.0);
            } else {
                animator.baseLayer.animationPlayer.setReversed(false);
                this.currentLivingMotion = ((AbstractClientPlayer)this.original).isCrouching() ? LivingMotions.KNEEL : LivingMotions.IDLE;
            }
        } else {
            this.currentLivingMotion = this.isMoving() ? LivingMotions.CREATIVE_FLY : LivingMotions.CREATIVE_IDLE;
        }
        UpdatePlayerMotionEvent.BaseLayer baseLayerEvent = new UpdatePlayerMotionEvent.BaseLayer(this, this.currentLivingMotion, !this.state.updateLivingMotion() && considerInaction);
        PlayerPatchEvent.postAndFireSkillListeners(baseLayerEvent);
        this.currentLivingMotion = baseLayerEvent.getMotion();
        if (!this.state.updateLivingMotion() && considerInaction) {
            this.currentCompositeMotion = LivingMotions.NONE;
        } else {
            UseAnim useAnim;
            CapabilityItem mainhandItemCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
            CapabilityItem offhandItemCap = this.getHoldingItemCapability(InteractionHand.OFF_HAND);
            LivingMotion customLivingMotion = mainhandItemCap.getLivingMotion(this, InteractionHand.MAIN_HAND);
            if (customLivingMotion == null) {
                customLivingMotion = offhandItemCap.getLivingMotion(this, InteractionHand.OFF_HAND);
            }
            this.currentCompositeMotion = customLivingMotion != null ? customLivingMotion : (((AbstractClientPlayer)this.original).isUsingItem() ? ((useAnim = ((AbstractClientPlayer)this.original).getUseItem().getUseAnimation()) == UseAnim.BLOCK ? LivingMotions.BLOCK_SHIELD : (useAnim == UseAnim.CROSSBOW ? LivingMotions.RELOAD : (useAnim == UseAnim.DRINK ? LivingMotions.DRINK : (useAnim == UseAnim.EAT ? LivingMotions.EAT : (useAnim == UseAnim.SPYGLASS ? LivingMotions.SPECTATE : this.currentLivingMotion))))) : (this.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getRealAnimation().get().isReboundAnimation() ? LivingMotions.SHOT : (((AbstractClientPlayer)this.original).swinging && ((AbstractClientPlayer)this.original).getSleepingPos().isEmpty() ? LivingMotions.DIGGING : this.currentLivingMotion)));
            UpdatePlayerMotionEvent.CompositeLayer compositeLayerEvent = new UpdatePlayerMotionEvent.CompositeLayer(this, this.currentCompositeMotion);
            PlayerPatchEvent.postAndFireSkillListeners(compositeLayerEvent);
            this.currentCompositeMotion = compositeLayerEvent.getMotion();
        }
    }

    @Override
    public void preTickClient(EntityTickEvent.Pre event) {
        boolean isOffHandChanged;
        this.xCloakO2 = ((AbstractClientPlayer)this.original).xCloakO;
        this.yCloakO2 = ((AbstractClientPlayer)this.original).yCloakO;
        this.zCloakO2 = ((AbstractClientPlayer)this.original).zCloakO;
        super.preTickClient(event);
        if (!this.getEntityState().updateLivingMotion()) {
            ((AbstractClientPlayer)this.original).yBodyRot = ((AbstractClientPlayer)this.original).getYRot();
        }
        boolean isMainHandChanged = this.prevHeldItem != ((AbstractClientPlayer)this.original).getInventory().getSelected().getItem();
        boolean bl = isOffHandChanged = this.prevHeldItemOffHand != ((ItemStack)((AbstractClientPlayer)this.original).getInventory().offhand.get(0)).getItem();
        if (isMainHandChanged || isOffHandChanged) {
            this.updateHeldItem(this.getHoldingItemCapability(InteractionHand.MAIN_HAND), this.getHoldingItemCapability(InteractionHand.OFF_HAND));
            if (isMainHandChanged) {
                this.prevHeldItem = ((AbstractClientPlayer)this.original).getInventory().getSelected().getItem();
            }
            if (isOffHandChanged) {
                this.prevHeldItemOffHand = ((ItemStack)((AbstractClientPlayer)this.original).getInventory().offhand.get(0)).getItem();
            }
        }
        if (((AbstractClientPlayer)this.original).deathTime == 1) {
            this.getClientAnimator().playDeathAnimation();
        }
        this.clothSimulator.tick(this);
    }

    @Override
    public void postTickClient(EntityTickEvent.Post event) {
        this.modelYRotO2 = this.modelYRotO;
        this.xPosO2 = (float)((AbstractClientPlayer)this.original).xOld;
        this.yPosO2 = (float)((AbstractClientPlayer)this.original).yOld;
        this.zPosO2 = (float)((AbstractClientPlayer)this.original).zOld;
    }

    protected boolean isMoving() {
        return Math.abs(this.dx) > (double)0.01f || Math.abs(this.dz) > (double)0.01f;
    }

    public void updateHeldItem(CapabilityItem mainHandCap, CapabilityItem offHandCap) {
        this.cancelItemUse();
        this.getClientAnimator().iterAllLayers(layer -> {
            if (layer.isOff()) {
                return;
            }
            layer.animationPlayer.getRealAnimation().get().getProperty(AnimationProperty.StaticAnimationProperty.ON_ITEM_CHANGE_EVENT).ifPresent(event -> {
                event.params(mainHandCap, offHandCap);
                event.execute(this, layer.animationPlayer.getRealAnimation(), layer.animationPlayer.getPrevElapsedTime(), layer.animationPlayer.getElapsedTime());
            });
        });
    }

    @Override
    public void entityPairing(SPEntityPairingPacket packet) {
        super.entityPairing(packet);
        if (packet.pairingPacketType().is(EntityPairingPacketTypes.class)) {
            switch (packet.pairingPacketType().toEnum(EntityPairingPacketTypes.class)) {
                case TECHNICIAN_ACTIVATED: {
                    ((AbstractClientPlayer)this.original).level().addParticle((ParticleOptions)EpicFightParticles.WHITE_AFTERIMAGE.get(), ((AbstractClientPlayer)this.original).getX(), ((AbstractClientPlayer)this.original).getY(), ((AbstractClientPlayer)this.original).getZ(), Double.longBitsToDouble(((AbstractClientPlayer)this.original).getId()), 0.0, 0.0);
                    break;
                }
                case ADRENALINE_ACTIVATED: {
                    if (((AbstractClientPlayer)this.original).isLocalPlayer()) {
                        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)EpicFightSounds.ADRENALINE.get()), (float)1.0f, (float)1.0f));
                    } else {
                        ((AbstractClientPlayer)this.original).playSound((SoundEvent)EpicFightSounds.ADRENALINE.get());
                    }
                    ((AbstractClientPlayer)this.original).level().addParticle((ParticleOptions)EpicFightParticles.ADRENALINE_PLAYER_BEATING.get(), ((AbstractClientPlayer)this.original).getX(), ((AbstractClientPlayer)this.original).getY(), ((AbstractClientPlayer)this.original).getZ(), Double.longBitsToDouble(((AbstractClientPlayer)this.original).getId()), 0.0, 0.0);
                    break;
                }
                case EMERGENCY_ESCAPE_ACTIVATED: {
                    float yRot = packet.buffer().readFloat();
                    ((AbstractClientPlayer)this.original).level().addParticle((ParticleOptions)EpicFightParticles.AIR_BURST.get(), ((AbstractClientPlayer)this.original).getX(), ((AbstractClientPlayer)this.original).getY() + (double)(((AbstractClientPlayer)this.original).getBbHeight() * 0.5f), ((AbstractClientPlayer)this.original).getZ(), 90.0, (double)yRot, 0.0);
                    this.entityDecorations.addColorModifier(EntityDecorations.EMERGENCY_ESCAPE_TRANSPARENCY_MODIFIER, new EntityDecorations.RenderAttributeModifier<Vector4f>(this){
                        private int tickCount;

                        @Override
                        public void modifyValue(Vector4f val, float partialTick) {
                            val.w = (float)Math.pow((double)((float)this.tickCount + partialTick) / 6.0, 2.0) - 0.4f;
                        }

                        @Override
                        public boolean shouldRemove() {
                            return this.tickCount > 6;
                        }

                        @Override
                        public void tick() {
                            ++this.tickCount;
                        }
                    });
                    break;
                }
            }
        }
    }

    @Override
    public boolean overrideRender() {
        RenderEpicFightPlayerEvent renderepicfightplayerevent = new RenderEpicFightPlayerEvent(this, this.isEpicFightMode());
        NeoForge.EVENT_BUS.post((Event)renderepicfightplayerevent);
        return renderepicfightplayerevent.shouldRender();
    }

    @Override
    public boolean shouldMoveOnCurrentSide(ActionAnimation actionAnimation) {
        return false;
    }

    @Override
    public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTick) {
        if (pose.hasTransform("Head") && this.armature.hasJoint("Head") && animation.doesHeadRotFollowEntityHead()) {
            float headRotO = this.modelYRotO - ((AbstractClientPlayer)this.original).yHeadRotO;
            float headRot = this.modelYRot - ((AbstractClientPlayer)this.original).yHeadRot;
            float partialHeadRot = Mth.wrapDegrees((float)MathUtils.lerpBetween(headRotO, headRot, partialTick));
            float xRot = -((AbstractClientPlayer)this.original).getXRot();
            partialHeadRot = Mth.clamp((float)partialHeadRot, (float)-90.0f, (float)90.0f);
            OpenMatrix4f toOriginalRotation = this.armature.getBoundTransformFor(pose, this.armature.searchJointByName("Head")).removeScale().removeTranslation().invert();
            Vec3f xAxis = OpenMatrix4f.transform3v(toOriginalRotation, Vec3f.X_AXIS, null);
            Vec3f yAxis = OpenMatrix4f.transform3v(toOriginalRotation, Vec3f.Y_AXIS, null);
            OpenMatrix4f headRotation = OpenMatrix4f.createRotatorDeg(partialHeadRot, yAxis).rotateDeg(xRot, xAxis);
            pose.orElseEmpty("Head").frontResult(JointTransform.fromMatrix(headRotation), OpenMatrix4f::mul);
        }
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTick) {
        float yRot;
        float yRotO;
        if (((AbstractClientPlayer)this.original).isAutoSpinAttack()) {
            OpenMatrix4f mat = MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, partialTick, 0.9375f, 0.9375f, 0.9375f);
            float yRot2 = MathUtils.lerpBetween(((AbstractClientPlayer)this.original).yRotO, ((AbstractClientPlayer)this.original).getYRot(), partialTick);
            float xRot = MathUtils.lerpBetween(((AbstractClientPlayer)this.original).xRotO, ((AbstractClientPlayer)this.original).getXRot(), partialTick);
            mat.rotateDeg(-yRot2, Vec3f.Y_AXIS).rotateDeg(-xRot, Vec3f.X_AXIS).rotateDeg(((float)((AbstractClientPlayer)this.original).tickCount + partialTick) * -55.0f, Vec3f.Z_AXIS).translate(0.0f, -0.39f, 0.0f);
            return mat;
        }
        if (((AbstractClientPlayer)this.original).isFallFlying()) {
            OpenMatrix4f mat = MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, partialTick, 0.9375f, 0.9375f, 0.9375f);
            float f1 = (float)((AbstractClientPlayer)this.original).getFallFlyingTicks() + partialTick;
            float f2 = Mth.clamp((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            mat.rotateDeg(-Mth.rotLerp((float)partialTick, (float)((AbstractClientPlayer)this.original).yBodyRotO, (float)((AbstractClientPlayer)this.original).yBodyRot), Vec3f.Y_AXIS).rotateDeg(f2 * -((AbstractClientPlayer)this.original).getXRot(), Vec3f.X_AXIS);
            Vec3 vec3d = ((AbstractClientPlayer)this.original).getViewVector(partialTick);
            Vec3 vec3d1 = ((AbstractClientPlayer)this.original).getDeltaMovementLerped(partialTick);
            double d0 = vec3d1.horizontalDistanceSqr();
            double d1 = vec3d.horizontalDistanceSqr();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec3d1.x * vec3d.x + vec3d1.z * vec3d.z) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = vec3d1.x * vec3d.z - vec3d1.z * vec3d.x;
                mat.rotate((float)(-(Math.signum(d3) * Math.acos(d2))), Vec3f.Z_AXIS);
            }
            return mat;
        }
        if (((AbstractClientPlayer)this.original).isSleeping()) {
            BlockState blockstate = ((AbstractClientPlayer)this.original).getInBlockState();
            float yRot3 = 0.0f;
            if (blockstate.isBed((BlockGetter)((AbstractClientPlayer)this.original).level(), (BlockPos)((AbstractClientPlayer)this.original).getSleepingPos().orElse(null), (LivingEntity)this.original) && blockstate.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                switch ((Direction)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case EAST: {
                        yRot3 = 90.0f;
                        break;
                    }
                    case WEST: {
                        yRot3 = -90.0f;
                        break;
                    }
                    case SOUTH: {
                        yRot3 = 180.0f;
                        break;
                    }
                }
            }
            return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, yRot3, yRot3, 0.0f, 0.9375f, 0.9375f, 0.9375f);
        }
        float xRotO = 0.0f;
        float xRot = 0.0f;
        Entity d0 = ((AbstractClientPlayer)this.original).getVehicle();
        if (d0 instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)d0;
            yRotO = ridingEntity.yBodyRotO;
            yRot = ridingEntity.yBodyRot;
        } else {
            yRotO = this.modelYRotO;
            yRot = this.modelYRot;
        }
        if (!this.getEntityState().inaction() && ((AbstractClientPlayer)this.original).getPose() == net.minecraft.world.entity.Pose.SWIMMING) {
            float f4;
            float f = ((AbstractClientPlayer)this.original).getSwimAmount(partialTick);
            float f3 = ((AbstractClientPlayer)this.original).isInWater() ? ((AbstractClientPlayer)this.original).getXRot() : 0.0f;
            xRotO = f4 = Mth.lerp((float)f, (float)0.0f, (float)f3);
            xRot = f4;
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, xRotO, xRot, yRotO, yRot, partialTick, 0.9375f, 0.9375f, 0.9375f);
    }

    public void setEpicSkinsInformation(EpicSkins epicSkinsInformation) {
        this.epicSkinsInformation = epicSkinsInformation;
    }

    public EpicSkins getEpicSkinsInformation() {
        return this.epicSkinsInformation;
    }

    public boolean isEpicSkinsLoaded() {
        return this.epicSkinsInformation != null;
    }

    @Override
    public EntitySnapshot<?> captureEntitySnapshot() {
        return EntitySnapshot.capturePlayer(this);
    }

    @Override
    public <SIM extends PhysicsSimulator<?, ?, ?, ?, ?>> Optional<SIM> getSimulator(SimulationTypes<?, ?, ?, ?, ?, SIM> simulationType) {
        if (simulationType == SimulationTypes.CLOTH) {
            return Optional.of(this.clothSimulator);
        }
        return Optional.empty();
    }

    @Override
    public ClothSimulator getClothSimulator() {
        return this.clothSimulator;
    }

    @Override
    public Vec3 getAccurateCloakLocation(float partialFrame) {
        if (partialFrame < 0.0f) {
            partialFrame = 1.0f - partialFrame;
            double x = Mth.lerp((double)partialFrame, (double)this.xCloakO2, (double)((AbstractClientPlayer)this.original).xCloakO) - Mth.lerp((double)partialFrame, (double)this.xPosO2, (double)((AbstractClientPlayer)this.original).xo);
            double y = Mth.lerp((double)partialFrame, (double)this.yCloakO2, (double)((AbstractClientPlayer)this.original).yCloakO) - Mth.lerp((double)partialFrame, (double)this.yPosO2, (double)((AbstractClientPlayer)this.original).yo);
            double z = Mth.lerp((double)partialFrame, (double)this.zCloakO2, (double)((AbstractClientPlayer)this.original).zCloakO) - Mth.lerp((double)partialFrame, (double)this.zPosO2, (double)((AbstractClientPlayer)this.original).zo);
            return new Vec3(x, y, z);
        }
        double x = Mth.lerp((double)partialFrame, (double)((AbstractClientPlayer)this.original).xCloakO, (double)((AbstractClientPlayer)this.original).xCloak) - Mth.lerp((double)partialFrame, (double)((AbstractClientPlayer)this.original).xo, (double)((AbstractClientPlayer)this.original).getX());
        double y = Mth.lerp((double)partialFrame, (double)((AbstractClientPlayer)this.original).yCloakO, (double)((AbstractClientPlayer)this.original).yCloak) - Mth.lerp((double)partialFrame, (double)((AbstractClientPlayer)this.original).yo, (double)((AbstractClientPlayer)this.original).getY());
        double z = Mth.lerp((double)partialFrame, (double)((AbstractClientPlayer)this.original).zCloakO, (double)((AbstractClientPlayer)this.original).zCloak) - Mth.lerp((double)partialFrame, (double)((AbstractClientPlayer)this.original).zo, (double)((AbstractClientPlayer)this.original).getZ());
        return new Vec3(x, y, z);
    }

    @Override
    public Vec3 getAccuratePartialLocation(float partialFrame) {
        if (partialFrame < 0.0f) {
            partialFrame = 1.0f + partialFrame;
            double x = Mth.lerp((double)partialFrame, (double)this.xPosO2, (double)((AbstractClientPlayer)this.original).xOld);
            double y = Mth.lerp((double)partialFrame, (double)this.yPosO2, (double)((AbstractClientPlayer)this.original).yOld);
            double z = Mth.lerp((double)partialFrame, (double)this.zPosO2, (double)((AbstractClientPlayer)this.original).zOld);
            return new Vec3(x, y, z);
        }
        double x = Mth.lerp((double)partialFrame, (double)((AbstractClientPlayer)this.original).xOld, (double)((AbstractClientPlayer)this.original).getX());
        double y = Mth.lerp((double)partialFrame, (double)((AbstractClientPlayer)this.original).yOld, (double)((AbstractClientPlayer)this.original).getY());
        double z = Mth.lerp((double)partialFrame, (double)((AbstractClientPlayer)this.original).zOld, (double)((AbstractClientPlayer)this.original).getZ());
        return new Vec3(x, y, z);
    }

    @Override
    public Vec3 getObjectVelocity() {
        return new Vec3(((AbstractClientPlayer)this.original).getX() - ((AbstractClientPlayer)this.original).xOld, ((AbstractClientPlayer)this.original).getY() - ((AbstractClientPlayer)this.original).yOld, ((AbstractClientPlayer)this.original).getZ() - ((AbstractClientPlayer)this.original).zOld);
    }

    @Override
    public float getAccurateYRot(float partialFrame) {
        if (partialFrame < 0.0f) {
            partialFrame = 1.0f + partialFrame;
            return Mth.rotLerp((float)partialFrame, (float)this.modelYRotO2, (float)this.getYRotO());
        }
        return Mth.rotLerp((float)partialFrame, (float)this.getYRotO(), (float)this.getYRot());
    }

    @Override
    public float getYRotDelta(float partialFrame) {
        if (partialFrame < 0.0f) {
            partialFrame = 1.0f + partialFrame;
            return Mth.rotLerp((float)partialFrame, (float)this.modelYRotO2, (float)this.getYRotO()) - this.modelYRotO2;
        }
        return Mth.rotLerp((float)partialFrame, (float)this.getYRotO(), (float)this.getYRot()) - this.getYRotO();
    }

    @Override
    public boolean invalid() {
        return ((AbstractClientPlayer)this.original).isRemoved();
    }

    @Override
    public float getScale() {
        return 0.9375f;
    }

    @Override
    public Animator getSimulatableAnimator() {
        return this.animator;
    }

    @Override
    public float getGravity() {
        return ((AbstractClientPlayer)this.getOriginal()).isUnderWater() ? 0.98f : 9.8f;
    }
}

