/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.data.loot.function;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.floats.FloatObjectPair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.fml.ModList;
import yesman.epicfight.registry.entries.EpicFightDataComponentTypes;
import yesman.epicfight.registry.entries.EpicFightLootItemFunctions;
import yesman.epicfight.skill.Skill;

public class SetSkillFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetSkillFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SetSkillFunction.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)Skill.CODEC.listOf().fieldOf("skills").forGetter(setskillfunction -> setskillfunction.skillSource.stream().map(Pair::right).toList()), (App)Codec.FLOAT.listOf().fieldOf("weights").forGetter(setskillfunction -> setskillfunction.skillSource.stream().map(FloatObjectPair::leftFloat).toList()))).apply((Applicative)instance, SetSkillFunction::new));
    private final List<FloatObjectPair<Holder<Skill>>> skillSource;

    public SetSkillFunction(List<LootItemCondition> predicates, List<Holder<Skill>> skills, List<Float> weights) {
        super(predicates);
        if (skills.size() != weights.size()) {
            throw new IllegalArgumentException("skills and weights number unmatches");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < skills.size(); ++i) {
            builder.add((Object)FloatObjectPair.of((float)weights.get(i).floatValue(), skills.get(i)));
        }
        this.skillSource = builder.build();
    }

    private Holder<Skill> selectRandomSkillFromSource(RandomSource randomSource) {
        for (FloatObjectPair<Holder<Skill>> pair : this.skillSource) {
            if (!(randomSource.nextFloat() < pair.firstFloat())) continue;
            return (Holder)pair.second();
        }
        return this.skillSource.isEmpty() ? null : (Holder)this.skillSource.get(0).second();
    }

    protected ItemStack run(ItemStack itemstack, LootContext context) {
        if (ModList.get().isLoaded("epicskills")) {
            return ItemStack.EMPTY;
        }
        Holder<Skill> skill = this.selectRandomSkillFromSource(context.getRandom());
        if (skill != null) {
            itemstack.set(EpicFightDataComponentTypes.SKILL, skill);
        }
        return itemstack;
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return (LootItemFunctionType)EpicFightLootItemFunctions.SKILLS.get();
    }

    @SafeVarargs
    public static LootItemFunction.Builder builder(final Holder<Skill> ... skills) {
        return new LootItemFunction.Builder(){

            public LootItemFunction build() {
                ArrayList<Holder<Skill>> list1 = new ArrayList<Holder<Skill>>();
                ArrayList<Float> list2 = new ArrayList<Float>();
                float weight = 1.0f / (float)skills.length;
                float weightSum = 0.0f;
                for (Holder skill : skills) {
                    list1.add((Holder<Skill>)skill);
                    list2.add(Float.valueOf(weightSum += weight));
                }
                return new SetSkillFunction(List.of(), list1, list2);
            }
        };
    }

    public static LootItemFunction.Builder builder(final Object ... skillAndWeight) {
        return new LootItemFunction.Builder(){

            public LootItemFunction build() {
                int i;
                ArrayList<Holder<Skill>> list1 = new ArrayList<Holder<Skill>>();
                ArrayList<Float> list2 = new ArrayList<Float>();
                float weightTotal = 0.0f;
                float weightSum = 0.0f;
                for (i = 0; i < skillAndWeight.length / 2; ++i) {
                    weightTotal += ((Float)skillAndWeight[i * 2]).floatValue();
                }
                for (i = 0; i < skillAndWeight.length / 2; ++i) {
                    list1.add((Holder<Skill>)((Holder)skillAndWeight[i * 2 + 1]));
                    list2.add(Float.valueOf((weightSum += ((Float)skillAndWeight[i * 2]).floatValue()) / weightTotal));
                }
                return new SetSkillFunction(List.of(), list1, list2);
            }
        };
    }
}

