/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.common;

import java.util.ArrayList;
import java.util.List;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.network.ManagedCustomPacketPayload;
import yesman.epicfight.network.common.BiDirectionalAnimationVariable;
import yesman.epicfight.network.server.SPAnimatorControl;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public abstract class AbstractAnimatorControl
implements ManagedCustomPacketPayload {
    protected final Action action;
    protected final AssetAccessor<? extends StaticAnimation> animation;
    protected final float transitionTimeModifier;
    protected final boolean pause;
    protected final List<BiDirectionalAnimationVariable> animationVariables;

    public AbstractAnimatorControl(Action action, AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier, boolean pause) {
        this(action, animation, transitionTimeModifier, pause, new ArrayList<BiDirectionalAnimationVariable>());
    }

    public AbstractAnimatorControl(Action action, AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier, boolean pause, List<BiDirectionalAnimationVariable> animationVariables) {
        this.action = action;
        this.animation = animation;
        this.transitionTimeModifier = transitionTimeModifier;
        this.pause = pause;
        this.animationVariables = animationVariables;
    }

    public Action action() {
        return this.action;
    }

    public AssetAccessor<? extends StaticAnimation> animation() {
        return this.animation;
    }

    public float transitionTimeModifier() {
        return this.transitionTimeModifier;
    }

    public boolean pause() {
        return this.pause;
    }

    public List<BiDirectionalAnimationVariable> animationVariables() {
        return this.animationVariables;
    }

    public <T extends SPAnimatorControl> void commonProcess(LivingEntityPatch<?> entitypatch) {
        try {
            switch (this.action.ordinal()) {
                case 0: {
                    ((Animator)entitypatch.getAnimator()).playAnimation(this.animation, this.transitionTimeModifier);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    ((Animator)entitypatch.getAnimator()).playAnimationInstantly(this.animation);
                    break;
                }
                case 3: {
                    ((Animator)entitypatch.getAnimator()).reserveAnimation(this.animation);
                    break;
                }
                case 4: {
                    ((Animator)entitypatch.getAnimator()).stopPlaying(this.animation);
                    break;
                }
                case 5: {
                    ((Animator)entitypatch.getAnimator()).playShootingAnimation();
                    break;
                }
                case 6: {
                    ((Animator)entitypatch.getAnimator()).setSoftPause(this.pause);
                    break;
                }
                case 7: {
                    ((Animator)entitypatch.getAnimator()).setHardPause(this.pause);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Layer.Priority getPriority(Priority priority) {
        switch (priority.ordinal()) {
            case 1: {
                return Layer.Priority.LOWEST;
            }
            case 2: {
                return Layer.Priority.LOW;
            }
            case 3: {
                return Layer.Priority.MIDDLE;
            }
            case 4: {
                return Layer.Priority.HIGH;
            }
            case 5: {
                return Layer.Priority.HIGHEST;
            }
        }
        return null;
    }

    public static enum Action {
        PLAY(true),
        PLAY_CLIENT(true),
        PLAY_INSTANTLY(true),
        RESERVE(true),
        STOP(false),
        SHOT(true),
        SOFT_PAUSE(false),
        HARD_PAUSE(false);

        boolean syncVariables;

        private Action(boolean syncVariables) {
            this.syncVariables = syncVariables;
        }

        public boolean syncVariables() {
            return this.syncVariables;
        }
    }

    public static enum Priority {
        ANIMATION,
        LOWEST,
        LOW,
        MIDDLE,
        HIGH,
        HIGHEST;

    }

    public static enum Layer {
        ANIMATION,
        BASE_LAYER,
        COMPOSITE_LAYER;

    }
}

