/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.dodge;

import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class DodgeSkill
extends Skill {
    protected final AnimationManager.AnimationAccessor<? extends StaticAnimation>[] animations;

    public static <B extends Builder<B>> B createDodgeBuilder(Function<B, ? extends DodgeSkill> constructor) {
        return (B)((Builder)((Builder)((Builder)new Builder<B>(constructor).setCategory(SkillCategories.DODGE)).setActivateType(Skill.ActivateType.ONE_SHOT)).setResource(Skill.Resource.STAMINA));
    }

    public DodgeSkill(Builder<?> builder) {
        super(builder);
        this.animations = builder.animations;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void gatherArguments(SkillContainer container, ControlEngine controlEngine, CompoundTag arguments) {
        LocalPlayerPatch executor = container.getClientExecutor();
        Input input = ((LocalPlayer)executor.getOriginal()).input;
        float sneakingSpeed = (float)((LocalPlayer)executor.getOriginal()).getAttributeValue(Attributes.SNEAKING_SPEED);
        input.tick(false, sneakingSpeed);
        int forward = input.up ? 1 : 0;
        int backward = input.down ? -1 : 0;
        int left = input.left ? 1 : 0;
        int right = input.right ? -1 : 0;
        int vertic = forward + backward;
        int horizon = left + right;
        float yRot = Minecraft.getInstance().gameRenderer.getMainCamera().getYRot();
        float degree = Mth.wrapDegrees((float)((float)(-(90 * horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon)) + yRot));
        arguments.putInt("direction", vertic >= 0 ? 0 : 1);
        arguments.putFloat("yRot", degree);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(this.consumption));
        return list;
    }

    @Override
    public void executeOnServer(SkillContainer skillContainer, CompoundTag args) {
        super.executeOnServer(skillContainer, args);
        ServerPlayerPatch executor = skillContainer.getServerExecutor();
        int i = args.getInt("direction");
        float yRot = args.getFloat("yRot");
        executor.playAnimationSynchronized(this.animations[i], 0.0f);
        executor.setModelYRot(yRot, true);
    }

    @Override
    public boolean isExecutableState(PlayerPatch<?> executor) {
        EntityState playerState = executor.getEntityState();
        return !executor.isInAir() && playerState.canUseSkill() && !((Player)executor.getOriginal()).isInWater() && !((Player)executor.getOriginal()).onClimbable() && ((Player)executor.getOriginal()).getVehicle() == null;
    }

    public static class Builder<B extends Builder<B>>
    extends SkillBuilder<B> {
        protected AnimationManager.AnimationAccessor<? extends StaticAnimation>[] animations;

        public Builder(Function<B, ? extends DodgeSkill> constructor) {
            super(constructor);
        }

        @SafeVarargs
        public final B setAnimations(AnimationManager.AnimationAccessor<? extends StaticAnimation> ... animations) {
            this.animations = animations;
            return (B)this;
        }
    }
}

