/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.neoevent.playerpatch.PlayerKilledEvent;
import yesman.epicfight.api.neoevent.playerpatch.StartActionEvent;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.registry.entries.EpicFightSkillDataKeys;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class AdrenalineFiendSkill
extends PassiveSkill {
    public AdrenalineFiendSkill(SkillBuilder<?> builder) {
        super((SkillBuilder<? extends SkillBuilder>)builder);
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void playerKilledEvent(PlayerKilledEvent event, SkillContainer container) {
        if (!container.getExecutor().isLogicalClient() && ((ServerPlayerPatch)event.getPlayerPatch()).getStaminaRegenAwaitTicks() > 0 && ((ServerPlayerPatch)event.getPlayerPatch()).getStamina() < ((ServerPlayerPatch)event.getPlayerPatch()).getMaxStamina()) {
            ((ServerPlayerPatch)event.getPlayerPatch()).setStaminaRegenAwaitTicks(0);
            container.getDataManager().setData(EpicFightSkillDataKeys.TICK_RECORD, ((Player)container.getExecutor().getOriginal()).tickCount);
            container.getExecutor().sendToAllPlayersTrackingMe(new SPEntityPairingPacket(((Player)container.getExecutor().getOriginal()).getId(), EntityPairingPacketTypes.ADRENALINE_ACTIVATED), new CustomPacketPayload[0]);
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void modifyBaseDamageEvent(StartActionEvent event, SkillContainer container) {
        if (container.getDataManager().getDataValue(EpicFightSkillDataKeys.TICK_RECORD) + 30 > ((Player)container.getExecutor().getOriginal()).tickCount) {
            event.resetActionTick(false);
        }
    }
}

