/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.registry.entries.EpicFightEntityTypes;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class DeathHarvestOrb
extends Entity {
    private Player dest;
    private Vec3 randVec;
    private float value;

    public DeathHarvestOrb(EntityType<?> type, Level level) {
        super(type, level);
    }

    public DeathHarvestOrb(Player dest, double x, double y, double z, int value) {
        this((EntityType)EpicFightEntityTypes.DEATH_HARVEST_ORB.get(), dest.level());
        this.setPos(x, y, z);
        this.dest = dest;
        this.value = value;
        Vec3 toContrast = this.dest.position().add(0.0, (double)this.dest.getBbHeight() * 0.5, 0.0).subtract(this.position()).scale(-1.0);
        double randX = this.random.nextDouble() * (toContrast.x > 0.0 ? 1.0 : -1.0);
        double randY = this.random.nextDouble() * (toContrast.y > 0.0 ? 0.75 : -0.75);
        double randZ = this.random.nextDouble() * (toContrast.z > 0.0 ? 1.0 : -1.0);
        this.randVec = new Vec3(randX, randY, randZ).normalize();
    }

    public void tick() {
        this.noPhysics = true;
        if (!this.level().isClientSide()) {
            double scaleFactor = Math.pow(Math.max(0.0, (double)(this.tickCount - 10) / 10.0), 2.0);
            Vec3 destCenter = this.dest.position().add(0.0, (double)this.dest.getBbHeight() * 0.5, 0.0);
            Vec3 v1 = destCenter.subtract(this.position()).scale(scaleFactor);
            Vec3 v2 = this.randVec.scale(1.0 - scaleFactor);
            this.move(MoverType.SELF, v1.add(v2).scale(0.23));
            if (this.position().distanceToSqr(destCenter) < 0.5625 || this.tickCount > 40) {
                EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)this.dest, ServerPlayerPatch.class).ifPresent(playerpatch -> {
                    SkillContainer container = playerpatch.getSkill(SkillSlots.WEAPON_INNATE);
                    container.getSkill().setConsumptionSynchronize(container, container.getResource() + this.value);
                });
                this.discard();
            }
        } else {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
    }

    public void addAdditionalSaveData(CompoundTag tag) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }
}

