/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.entity.ai.goal;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

public class TargetChasingGoal
extends MeleeAttackGoal {
    protected final MobPatch<? extends PathfinderMob> mobpatch;
    protected final double attackRadiusSqr;

    public TargetChasingGoal(MobPatch<? extends PathfinderMob> mobpatch, PathfinderMob pathfinderMob, double speedModifier, boolean longMemory) {
        this(mobpatch, pathfinderMob, speedModifier, longMemory, 0.0);
    }

    public TargetChasingGoal(MobPatch<? extends PathfinderMob> mobpatch, PathfinderMob pathfinderMob, double speedModifier, boolean longMemory, double attackRadius) {
        super(pathfinderMob, speedModifier, longMemory);
        this.mobpatch = mobpatch;
        this.attackRadiusSqr = attackRadius * attackRadius;
    }

    public void tick() {
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity != null) {
            double d0 = this.mob.distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
            if (!(d0 > this.attackRadiusSqr)) {
                this.mob.getNavigation().stop();
                this.mob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
            } else {
                super.tick();
            }
        }
    }

    protected void checkAndPerformAttack(LivingEntity target) {
    }
}

