/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.entity.data;

import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.ApiStatus;
import yesman.epicfight.api.utils.datastructure.ParameterizedHolderHashMap;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPModifyExpandedEntityData;
import yesman.epicfight.world.entity.data.ExpandedEntityDataAccessor;

public final class ExpandedSyncedData {
    private final Set<Holder<ExpandedEntityDataAccessor<?>>> registeredKeys = new HashSet();
    private final ParameterizedHolderHashMap<ExpandedEntityDataAccessor<?>> dataMap = new ParameterizedHolderHashMap();
    private final Map<Holder<ExpandedEntityDataAccessor<?>>, Object> pendingDirtyData = new HashMap();
    private final Supplier<Integer> entityIdProvider;
    private final boolean isLogicalServer;

    public ExpandedSyncedData(Supplier<Integer> entityIdProvider, boolean isServer) {
        this.entityIdProvider = entityIdProvider;
        this.isLogicalServer = isServer;
    }

    public void register(Holder<ExpandedEntityDataAccessor<?>> key) {
        this.registeredKeys.add(key);
        this.dataMap.put(key, ((ExpandedEntityDataAccessor)key.value()).defaultValue());
    }

    @ApiStatus.Internal
    public void load(CompoundTag compound) {
        CompoundTag synchedDataCompound = compound.getCompound("expanded_sycned_data");
        if (synchedDataCompound != null) {
            MapLike compoundConverted = (MapLike)NbtOps.INSTANCE.getMap((Tag)synchedDataCompound).result().orElseThrow();
            this.registeredKeys.stream().forEach(holder -> {
                Object data = ((ExpandedEntityDataAccessor)holder.value()).readFromTag((MapLike<Tag>)compoundConverted);
                if (data != null) {
                    this.dataMap.put((Holder<ExpandedEntityDataAccessor<?>>)holder, data);
                    this.pendingDirtyData.put((Holder<ExpandedEntityDataAccessor<?>>)holder, data);
                }
            });
        }
    }

    @ApiStatus.Internal
    public void saveData(CompoundTag compound) {
        RecordBuilder recordBuilder = NbtOps.INSTANCE.mapBuilder();
        this.dataMap.forEach((k, v) -> ((ExpandedEntityDataAccessor)k.value()).saveData(v, (RecordBuilder<Tag>)recordBuilder));
        recordBuilder.build((Object)new CompoundTag()).result().ifPresent(result -> compound.put("expanded_sycned_data", result));
    }

    @ApiStatus.Internal
    public <T> void setRaw(Holder<ExpandedEntityDataAccessor<?>> key, @NonNull Object val) {
        if (!this.registeredKeys.contains(key)) {
            throw new IllegalArgumentException("Unregistered key " + key.getRegisteredName());
        }
        this.dataMap.put(key, val);
    }

    public <T> void set(DeferredHolder<ExpandedEntityDataAccessor<?>, ExpandedEntityDataAccessor<T>> key, @NonNull T val) {
        if (!this.registeredKeys.contains(key)) {
            throw new IllegalArgumentException("Unregistered key " + key.getRegisteredName());
        }
        this.dataMap.put((Holder<ExpandedEntityDataAccessor<?>>)key, val);
        if (this.isLogicalServer) {
            this.pendingDirtyData.put((Holder<ExpandedEntityDataAccessor<?>>)key, val);
        }
    }

    public <T> T get(DeferredHolder<ExpandedEntityDataAccessor<?>, ExpandedEntityDataAccessor<T>> key) {
        if (!this.registeredKeys.contains(key)) {
            throw new IllegalArgumentException("Unregistered key " + key.getRegisteredName());
        }
        return this.dataMap.get((Holder<ExpandedEntityDataAccessor<?>>)key);
    }

    @Nullable
    public EpicFightNetworkManager.PayloadBundleBuilder prepareDataToSend() {
        if (this.pendingDirtyData.isEmpty()) {
            return null;
        }
        EpicFightNetworkManager.PayloadBundleBuilder payloadBundleBuilder = EpicFightNetworkManager.PayloadBundleBuilder.create();
        for (Map.Entry<Holder<ExpandedEntityDataAccessor<?>>, Object> dirtyData : this.pendingDirtyData.entrySet()) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            ((ExpandedEntityDataAccessor)dirtyData.getKey().value()).streamCodec().encode((Object)buf, dirtyData.getValue());
            SPModifyExpandedEntityData payload = new SPModifyExpandedEntityData((int)this.entityIdProvider.get(), dirtyData.getKey(), buf);
            payloadBundleBuilder.and(payload);
        }
        this.pendingDirtyData.clear();
        return payloadBundleBuilder;
    }
}

