package yesman.epicfight.mixin.client;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

@Mixin(value = Minecraft.class)
public class MixinMinecraft {
	@Shadow
	private LocalPlayer player;
	
	@Inject(at = @At(value = "HEAD"), method = "handleKeybinds()V", cancellable = true)
	private void epicfight$handleKeybinds(CallbackInfo info) {
		ControlEngine.getInstance().handleEpicFightKeyMappings();
	}
	
	@Inject(at = @At(value = "HEAD"), method = "shouldEntityAppearGlowing(Lnet/minecraft/world/entity/Entity;)Z", cancellable = true)
	private void epicfight$shouldEntityAppearGlowing(Entity entity, CallbackInfoReturnable<Boolean> callbackInfo) {
		EpicFightCapabilities.getUnparameterizedEntityPatch(this.player, LocalPlayerPatch.class).ifPresent(playerpatch -> {
			if (playerpatch.shouldHighlightTarget(entity)) {
				callbackInfo.setReturnValue(true);
				callbackInfo.cancel();
			}
		});
	}

    @Inject(at = @At("HEAD"), method = "startAttack", cancellable = true)
    private void onStartVanillaAttack(CallbackInfoReturnable<Boolean> cir) {
        if (ControlEngine.shouldDisableVanillaAttack()) {
            // Prevents the player from performing vanilla attack actions while in Epic Fight mode.
            cir.cancel();
        }
    }

    @Inject(at = @At("HEAD"), method = "continueAttack", cancellable = true)
    private void onContinueVanillaAttack(boolean leftClick, CallbackInfo ci) {
        if (ControlEngine.shouldDisableVanillaAttack()) {
            // Prevents the player from breaking blocks such as grass while in Epic Fight mode.
            ci.cancel();
        }
    }
}
