/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.asset;

import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public interface AssetAccessor<O>
extends Supplier<O> {
    @Override
    public O get();

    public ResourceLocation registryName();

    default public boolean isPresent() {
        return this.get() != null;
    }

    default public boolean isEmpty() {
        return !this.isPresent();
    }

    public boolean inRegistry();

    default public boolean checkType(Class<?> cls) {
        return cls.isAssignableFrom(this.get().getClass());
    }

    default public O orElse(O whenNull) {
        return this.isPresent() ? this.get() : whenNull;
    }

    default public void ifPresent(Consumer<O> action) {
        if (this.isPresent()) {
            action.accept(this.get());
        }
    }

    default public void ifPresentOrElse(Consumer<O> action, Runnable whenNull) {
        if (this.isPresent()) {
            action.accept(this.get());
        } else {
            whenNull.run();
        }
    }

    default public void doOrThrow(Consumer<O> action) {
        if (!this.isPresent()) {
            throw new NoSuchElementException("No asset " + String.valueOf(this.registryName()));
        }
        action.accept(this.get());
    }

    default public void checkNotNull() {
        if (!this.isPresent()) {
            throw new NoSuchElementException("No asset " + String.valueOf(this.registryName()));
        }
    }
}

