/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.input.handlers;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.InputEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import yesman.epicfight.api.client.input.InputMode;
import yesman.epicfight.api.client.input.PlayerInputState;
import yesman.epicfight.api.client.input.action.EpicFightInputActions;
import yesman.epicfight.api.client.input.controller.EpicFightControllerModProvider;
import yesman.epicfight.api.client.input.controller.IEpicFightControllerMod;
import yesman.epicfight.api.client.input.handlers.DiscreteActionHandler;
import yesman.epicfight.api.client.input.handlers.DiscreteInputActionTrigger;

@ApiStatus.Experimental
public final class InputManager {
    private InputManager() {
    }

    @Nullable
    private static IEpicFightControllerMod getControllerModApi() {
        return EpicFightControllerModProvider.get();
    }

    public static boolean supportsControllerInput() {
        IEpicFightControllerMod controllerMod = InputManager.getControllerModApi();
        if (controllerMod == null) {
            return false;
        }
        return controllerMod.getInputMode().supportsController();
    }

    public static boolean isActionActive(@NotNull EpicFightInputActions action) {
        IEpicFightControllerMod controllerMod = InputManager.getControllerModApi();
        if (controllerMod == null) {
            return InputManager.isKeyDown(action.keyMapping());
        }
        return switch (controllerMod.getInputMode()) {
            default -> throw new MatchException(null, null);
            case InputMode.KEYBOARD_MOUSE -> InputManager.isKeyDown(action.keyMapping());
            case InputMode.CONTROLLER -> controllerMod.getBinding(action).isDigitalActiveNow();
            case InputMode.MIXED -> InputManager.isKeyDown(action.keyMapping()) || controllerMod.getBinding(action).isDigitalActiveNow();
        };
    }

    public static void triggerOnPress(@NotNull EpicFightInputActions action, boolean interactionKeyEventCheck, @NotNull DiscreteActionHandler handler) {
        DiscreteInputActionTrigger.triggerOnPress(action, context -> {
            if (context.triggeredByController() || !interactionKeyEventCheck) {
                handler.onAction(context);
                return;
            }
            InputManager.runKeyboardMouseEvent(action, handler);
        });
    }

    public static void triggerOnPress(@NotNull EpicFightInputActions action, boolean interactionKeyEventCheck, @NotNull Runnable runnable) {
        InputManager.triggerOnPress(action, interactionKeyEventCheck, (DiscreteActionHandler.Context context) -> runnable.run());
    }

    public static boolean isBoundToSamePhysicalInput(@NotNull EpicFightInputActions action, @NotNull EpicFightInputActions action2) {
        IEpicFightControllerMod controllerMod = InputManager.getControllerModApi();
        if (controllerMod != null && controllerMod.getInputMode() == InputMode.CONTROLLER) {
            return controllerMod.isBoundToSameButton(action, action2);
        }
        KeyMapping keyMapping1 = action.keyMapping();
        KeyMapping keyMapping2 = action2.keyMapping();
        return keyMapping1.getKey() == keyMapping2.getKey();
    }

    @NotNull
    public static PlayerInputState getInputState(@NotNull Input vanillaInput) {
        IEpicFightControllerMod controllerMod = InputManager.getControllerModApi();
        if (controllerMod != null && controllerMod.getInputMode() == InputMode.CONTROLLER) {
            return controllerMod.getInputState();
        }
        return PlayerInputState.fromVanillaInput(vanillaInput);
    }

    @NotNull
    public static PlayerInputState getInputState(@NotNull LocalPlayer localPlayer) {
        return InputManager.getInputState(localPlayer.input);
    }

    public static void setInputState(@NotNull PlayerInputState inputState) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            Input input = player.input;
            PlayerInputState.applyToVanillaInput(inputState, input);
        }
    }

    private static void runKeyboardMouseEvent(@NotNull EpicFightInputActions action, @NotNull DiscreteActionHandler handler) {
        KeyMapping keyMapping = action.keyMapping();
        InputConstants.Key key = keyMapping.getKey();
        boolean isMouse = InputConstants.Type.MOUSE == key.getType();
        int mouseButton = isMouse ? key.getValue() : -1;
        InputEvent.InteractionKeyMappingTriggered inputEvent = ClientHooks.onClickInput((int)mouseButton, (KeyMapping)keyMapping, (InteractionHand)InteractionHand.MAIN_HAND);
        if (!inputEvent.isCanceled()) {
            handler.onAction(new DiscreteActionHandler.Context(false));
        }
    }

    private static boolean isKeyDown(@NotNull KeyMapping keyMapping) {
        if (keyMapping.isDown()) {
            return true;
        }
        InputConstants.Key key = keyMapping.getKey();
        int keyValue = key.getValue();
        long windowPointer = Minecraft.getInstance().getWindow().getWindow();
        if (key.getType() == InputConstants.Type.KEYSYM) {
            return GLFW.glfwGetKey((long)windowPointer, (int)keyValue) > 0;
        }
        if (key.getType() == InputConstants.Type.MOUSE) {
            return GLFW.glfwGetMouseButton((long)windowPointer, (int)keyValue) > 0;
        }
        return false;
    }
}

