/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.asset.JsonAssetLoader;
import yesman.epicfight.api.client.model.ClassicMesh;
import yesman.epicfight.api.client.model.CompositeMesh;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.model.MeshPart;
import yesman.epicfight.api.client.model.MeshPartDefinition;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.client.model.SoftBodyTranslatable;
import yesman.epicfight.api.client.model.StaticMesh;
import yesman.epicfight.api.client.model.VertexBuilder;
import yesman.epicfight.api.client.physics.cloth.ClothSimulatable;
import yesman.epicfight.api.client.physics.cloth.ClothSimulator;
import yesman.epicfight.client.mesh.CreeperMesh;
import yesman.epicfight.client.mesh.DragonMesh;
import yesman.epicfight.client.mesh.EndermanMesh;
import yesman.epicfight.client.mesh.HoglinMesh;
import yesman.epicfight.client.mesh.HumanoidMesh;
import yesman.epicfight.client.mesh.IronGolemMesh;
import yesman.epicfight.client.mesh.PiglinMesh;
import yesman.epicfight.client.mesh.RavagerMesh;
import yesman.epicfight.client.mesh.SpiderMesh;
import yesman.epicfight.client.mesh.VexMesh;
import yesman.epicfight.client.mesh.VillagerMesh;
import yesman.epicfight.client.mesh.WitherMesh;

@OnlyIn(value=Dist.CLIENT)
public class Meshes
implements PreparableReloadListener {
    private static final Map<ResourceLocation, MeshAccessor<? extends Mesh>> ACCESSORS = new HashMap<ResourceLocation, MeshAccessor<? extends Mesh>>();
    private static final Map<MeshAccessor<? extends Mesh>, Mesh> MESHES = new HashMap<MeshAccessor<? extends Mesh>, Mesh>();
    private static ResourceManager resourceManager = null;
    public static final Meshes INSTANCE = new Meshes();
    public static final MeshAccessor<HumanoidMesh> ALEX = MeshAccessor.create("epicfight", "entity/biped_slim_arm", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(HumanoidMesh::new));
    public static final MeshAccessor<HumanoidMesh> BIPED = MeshAccessor.create("epicfight", "entity/biped", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(HumanoidMesh::new));
    public static final MeshAccessor<HumanoidMesh> BIPED_OLD_TEX = MeshAccessor.create("epicfight", "entity/biped_old_texture", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(HumanoidMesh::new));
    public static final MeshAccessor<HumanoidMesh> BIPED_OUTLAYER = MeshAccessor.create("epicfight", "entity/biped_outlayer", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(HumanoidMesh::new));
    public static final MeshAccessor<VillagerMesh> VILLAGER_ZOMBIE = MeshAccessor.create("epicfight", "entity/zombie_villager", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(VillagerMesh::new));
    public static final MeshAccessor<CreeperMesh> CREEPER = MeshAccessor.create("epicfight", "entity/creeper", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(CreeperMesh::new));
    public static final MeshAccessor<EndermanMesh> ENDERMAN = MeshAccessor.create("epicfight", "entity/enderman", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(EndermanMesh::new));
    public static final MeshAccessor<HumanoidMesh> SKELETON = MeshAccessor.create("epicfight", "entity/skeleton", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(HumanoidMesh::new));
    public static final MeshAccessor<SpiderMesh> SPIDER = MeshAccessor.create("epicfight", "entity/spider", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SpiderMesh::new));
    public static final MeshAccessor<IronGolemMesh> IRON_GOLEM = MeshAccessor.create("epicfight", "entity/iron_golem", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(IronGolemMesh::new));
    public static final MeshAccessor<HumanoidMesh> ILLAGER = MeshAccessor.create("epicfight", "entity/illager", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(VillagerMesh::new));
    public static final MeshAccessor<VillagerMesh> WITCH = MeshAccessor.create("epicfight", "entity/witch", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(VillagerMesh::new));
    public static final MeshAccessor<RavagerMesh> RAVAGER = MeshAccessor.create("epicfight", "entity/ravager", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(RavagerMesh::new));
    public static final MeshAccessor<VexMesh> VEX = MeshAccessor.create("epicfight", "entity/vex", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(VexMesh::new));
    public static final MeshAccessor<PiglinMesh> PIGLIN = MeshAccessor.create("epicfight", "entity/piglin", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(PiglinMesh::new));
    public static final MeshAccessor<HoglinMesh> HOGLIN = MeshAccessor.create("epicfight", "entity/hoglin", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(HoglinMesh::new));
    public static final MeshAccessor<DragonMesh> DRAGON = MeshAccessor.create("epicfight", "entity/dragon", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(DragonMesh::new));
    public static final MeshAccessor<WitherMesh> WITHER = MeshAccessor.create("epicfight", "entity/wither", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(WitherMesh::new));
    public static final MeshAccessor<SkinnedMesh> HELMET = MeshAccessor.create("epicfight", "armor/helmet", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    public static final MeshAccessor<SkinnedMesh> HELMET_PIGLIN = MeshAccessor.create("epicfight", "armor/piglin_helmet", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    public static final MeshAccessor<SkinnedMesh> HELMET_VILLAGER = MeshAccessor.create("epicfight", "armor/villager_helmet", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    public static final MeshAccessor<SkinnedMesh> CHESTPLATE = MeshAccessor.create("epicfight", "armor/chestplate", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    public static final MeshAccessor<SkinnedMesh> LEGGINS = MeshAccessor.create("epicfight", "armor/leggins", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    public static final MeshAccessor<SkinnedMesh> BOOTS = MeshAccessor.create("epicfight", "armor/boots", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    public static final MeshAccessor<ClassicMesh> AIR_BURST = MeshAccessor.create("epicfight", "particle/air_burst", jsonModelLoader -> jsonModelLoader.loadClassicMesh(ClassicMesh::new));
    public static final MeshAccessor<ClassicMesh> FORCE_FIELD = MeshAccessor.create("epicfight", "particle/force_field", jsonModelLoader -> jsonModelLoader.loadClassicMesh(ClassicMesh::new));
    public static final MeshAccessor<ClassicMesh> LASER = MeshAccessor.create("epicfight", "particle/laser", jsonModelLoader -> jsonModelLoader.loadClassicMesh(ClassicMesh::new));
    public static final MeshAccessor<SkinnedMesh> CAPE_DEFAULT = MeshAccessor.create("epicfight", "layer/default_cape", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));

    public static void reload(ResourceManager resourceManager) {
        Meshes.resourceManager = resourceManager;
        ACCESSORS.entrySet().removeIf(entry -> !((MeshAccessor)entry.getValue()).inRegistry);
        MESHES.values().forEach(mesh -> {
            if (mesh instanceof SkinnedMesh) {
                SkinnedMesh skinnedMesh = (SkinnedMesh)mesh;
                skinnedMesh.destroy();
            }
        });
        MESHES.clear();
    }

    @Nullable
    public static <M extends Mesh> AssetAccessor<M> get(ResourceLocation id) {
        return ACCESSORS.get(id);
    }

    public static <M extends Mesh> AssetAccessor<M> getOrCreate(ResourceLocation id, Function<JsonAssetLoader, M> jsonLoader) {
        return ACCESSORS.containsKey(id) ? (MeshAccessor<M>)ACCESSORS.get(id) : MeshAccessor.create(id, jsonLoader, false);
    }

    public static <M extends Mesh> Set<AssetAccessor<M>> entry(Class<? extends Mesh> filter) {
        return ACCESSORS.values().stream().filter(accessor -> filter.isAssignableFrom(accessor.get().getClass())).map(accessor -> accessor).collect(Collectors.toSet());
    }

    public static ResourceLocation wrapLocation(ResourceLocation rl) {
        return rl.getPath().matches("animmodels/.*\\.json") ? rl : ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)("animmodels/" + rl.getPath() + ".json"));
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.runAsync(() -> Meshes.reload(resourceManager), gameExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public record MeshAccessor<M extends Mesh>(ResourceLocation registryName, Function<JsonAssetLoader, M> jsonLoader, boolean inRegistry) implements AssetAccessor<M>,
    SoftBodyTranslatable
    {
        public static <M extends Mesh> MeshAccessor<M> create(String namespaceId, String path, Function<JsonAssetLoader, M> jsonLoader) {
            return MeshAccessor.create(ResourceLocation.fromNamespaceAndPath((String)namespaceId, (String)path), jsonLoader, true);
        }

        private static <M extends Mesh> MeshAccessor<M> create(ResourceLocation id, Function<JsonAssetLoader, M> jsonLoader, boolean inRegistry) {
            MeshAccessor<M> accessor = new MeshAccessor<M>(id, jsonLoader, inRegistry);
            ACCESSORS.put(id, accessor);
            return accessor;
        }

        @Override
        public M get() {
            if (!MESHES.containsKey(this)) {
                JsonAssetLoader jsonModelLoader = new JsonAssetLoader(resourceManager, Meshes.wrapLocation(this.registryName));
                MESHES.put(this, (Mesh)this.jsonLoader.apply(jsonModelLoader));
            }
            return (M)MESHES.get(this);
        }

        @Override
        public String toString() {
            return this.registryName.toString();
        }

        @Override
        public int hashCode() {
            return this.registryName.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof MeshAccessor) {
                MeshAccessor armatureAccessor = (MeshAccessor)obj;
                return this.registryName.equals((Object)armatureAccessor.registryName());
            }
            if (obj instanceof ResourceLocation) {
                ResourceLocation rl = (ResourceLocation)obj;
                return this.registryName.equals((Object)rl);
            }
            if (obj instanceof String) {
                String name = (String)obj;
                return this.registryName.toString().equals(name);
            }
            return false;
        }

        @Override
        public boolean canStartSoftBodySimulation() {
            Object mesh = this.get();
            if (mesh instanceof StaticMesh) {
                StaticMesh staticMesh = (StaticMesh)mesh;
                return staticMesh.canStartSoftBodySimulation();
            }
            if (mesh instanceof CompositeMesh) {
                CompositeMesh compositeMesh = (CompositeMesh)mesh;
                return compositeMesh.canStartSoftBodySimulation();
            }
            return false;
        }

        @Override
        public ClothSimulator.ClothObject createSimulationData(SoftBodyTranslatable provider, ClothSimulatable simOwner, ClothSimulator.ClothObjectBuilder simBuilder) {
            Object mesh = this.get();
            if (mesh instanceof StaticMesh) {
                StaticMesh staticMesh = (StaticMesh)mesh;
                return staticMesh.createSimulationData(provider, simOwner, simBuilder);
            }
            if (mesh instanceof CompositeMesh) {
                CompositeMesh compositeMesh = (CompositeMesh)mesh;
                return compositeMesh.createSimulationData(provider, simOwner, simBuilder);
            }
            return null;
        }

        @Override
        public void putSoftBodySimulationInfo(Map<String, SoftBodyTranslatable.ClothSimulationInfo> sofyBodySimulationInfo) {
            Object mesh = this.get();
            if (mesh instanceof SoftBodyTranslatable) {
                SoftBodyTranslatable softBodyTranslatable = (SoftBodyTranslatable)mesh;
                softBodyTranslatable.putSoftBodySimulationInfo(sofyBodySimulationInfo);
            }
        }

        @Override
        public Map<String, SoftBodyTranslatable.ClothSimulationInfo> getSoftBodySimulationInfo() {
            Object mesh = this.get();
            if (mesh instanceof SoftBodyTranslatable) {
                SoftBodyTranslatable softBodyTranslatable = (SoftBodyTranslatable)mesh;
                return softBodyTranslatable.getSoftBodySimulationInfo();
            }
            return null;
        }
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface MeshContructor<P extends MeshPart, V extends VertexBuilder, M extends StaticMesh<P>> {
        public M invoke(Map<String, Number[]> var1, Map<MeshPartDefinition, List<V>> var2, M var3, Mesh.RenderProperties var4);
    }
}

