/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import yesman.epicfight.api.client.model.SoftBodyTranslatable;
import yesman.epicfight.api.client.physics.cloth.ClothSimulatable;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.particle.AirBurstParticle;
import yesman.epicfight.client.particle.AnimationTrailParticle;
import yesman.epicfight.client.particle.AshDirectionalParticle;
import yesman.epicfight.client.particle.BladeRushParticle;
import yesman.epicfight.client.particle.BloodParticle;
import yesman.epicfight.client.particle.CatharsisParticle;
import yesman.epicfight.client.particle.CutParticle;
import yesman.epicfight.client.particle.DustParticle;
import yesman.epicfight.client.particle.EnderParticle;
import yesman.epicfight.client.particle.EntityAfterimageParticle;
import yesman.epicfight.client.particle.EviscerateParticle;
import yesman.epicfight.client.particle.FeatherParticle;
import yesman.epicfight.client.particle.ForceFieldEndParticle;
import yesman.epicfight.client.particle.ForceFieldParticle;
import yesman.epicfight.client.particle.GroundSlamParticle;
import yesman.epicfight.client.particle.HitBluntParticle;
import yesman.epicfight.client.particle.HitCutParticle;
import yesman.epicfight.client.particle.LaserParticle;
import yesman.epicfight.client.particle.ProjectileTrailParticle;
import yesman.epicfight.client.particle.TsunamiSplashParticle;
import yesman.epicfight.client.renderer.blockentity.FractureBlockRenderer;
import yesman.epicfight.client.renderer.entity.DroppedNetherStarRenderer;
import yesman.epicfight.client.renderer.entity.WitherGhostRenderer;
import yesman.epicfight.client.renderer.entity.WitherSkeletonMinionRenderer;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.client.renderer.patched.layer.WearableItemLayer;
import yesman.epicfight.registry.entries.EpicFightBlockEntities;
import yesman.epicfight.registry.entries.EpicFightEntityTypes;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.skill.SkillCategory;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
public final class ClientModBusEvent {
    private ClientModBusEvent() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void epicfight$registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)EpicFightParticles.ENDERMAN_DEATH_EMIT.get(), EnderParticle.EndermanDeathEmitProvider::new);
        event.registerSpriteSet((ParticleType)EpicFightParticles.HIT_BLUNT.get(), HitBluntParticle.Provider::new);
        event.registerSpecial((ParticleType)EpicFightParticles.HIT_BLADE.get(), (ParticleProvider)new HitCutParticle.Provider());
        event.registerSpriteSet((ParticleType)EpicFightParticles.CUT.get(), CutParticle.Provider::new);
        event.registerSpriteSet((ParticleType)EpicFightParticles.NORMAL_DUST.get(), DustParticle.NormalDustProvider::new);
        event.registerSpriteSet((ParticleType)EpicFightParticles.DUST_EXPANSIVE.get(), DustParticle.ExpansiveDustProvider::new);
        event.registerSpriteSet((ParticleType)EpicFightParticles.DUST_CONTRACTIVE.get(), DustParticle.ContractiveDustProvider::new);
        event.registerSpecial((ParticleType)EpicFightParticles.EVISCERATE.get(), (ParticleProvider)new EviscerateParticle.Provider());
        event.registerSpriteSet((ParticleType)EpicFightParticles.BLOOD.get(), BloodParticle.Provider::new);
        event.registerSpriteSet((ParticleType)EpicFightParticles.BLADE_RUSH_SKILL.get(), BladeRushParticle.Provider::new);
        event.registerSpecial((ParticleType)EpicFightParticles.GROUND_SLAM.get(), (ParticleProvider)new GroundSlamParticle.Provider());
        event.registerSpriteSet((ParticleType)EpicFightParticles.BREATH_FLAME.get(), EnderParticle.BreathFlameProvider::new);
        event.registerSpecial((ParticleType)EpicFightParticles.FORCE_FIELD.get(), (ParticleProvider)new ForceFieldParticle.Provider());
        event.registerSpecial((ParticleType)EpicFightParticles.FORCE_FIELD_END.get(), (ParticleProvider)new ForceFieldEndParticle.Provider());
        event.registerSpecial((ParticleType)EpicFightParticles.ADRENALINE_PLAYER_BEATING.get(), (ParticleProvider)new EntityAfterimageParticle.AdrenalineParticleProvider());
        event.registerSpecial((ParticleType)EpicFightParticles.WHITE_AFTERIMAGE.get(), (ParticleProvider)new EntityAfterimageParticle.WhiteAfterimageProvider());
        event.registerSpecial((ParticleType)EpicFightParticles.LASER.get(), (ParticleProvider)new LaserParticle.Provider());
        event.registerSpecial((ParticleType)EpicFightParticles.NEUTRALIZE.get(), (ParticleProvider)new DustParticle.ExpansiveMetaParticle.Provider());
        event.registerSpecial((ParticleType)EpicFightParticles.BOSS_CASTING.get(), (ParticleProvider)new DustParticle.ContractiveMetaParticle.Provider());
        event.registerSpriteSet((ParticleType)EpicFightParticles.TSUNAMI_SPLASH.get(), TsunamiSplashParticle.Provider::new);
        event.registerSpecial((ParticleType)EpicFightParticles.SWING_TRAIL.get(), (ParticleProvider)new AnimationTrailParticle.Provider());
        event.registerSpecial((ParticleType)EpicFightParticles.PROJECTILE_TRAIL.get(), (ParticleProvider)new ProjectileTrailParticle.Provider());
        event.registerSpriteSet((ParticleType)EpicFightParticles.FEATHER.get(), FeatherParticle.Provider::new);
        event.registerSpecial((ParticleType)EpicFightParticles.AIR_BURST.get(), (ParticleProvider)new AirBurstParticle.Provider());
        event.registerSpriteSet((ParticleType)EpicFightParticles.ASH_DIRECTIONAL.get(), AshDirectionalParticle.Provider::new);
        event.registerSpriteSet((ParticleType)EpicFightParticles.CATHARSIS.get(), CatharsisParticle.Provider::new);
    }

    @SubscribeEvent
    public static void epicfight$registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EpicFightEntityTypes.AREA_EFFECT_BREATH.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)EpicFightEntityTypes.DROPPED_NETHER_STAR.get(), DroppedNetherStarRenderer::new);
        event.registerEntityRenderer((EntityType)EpicFightEntityTypes.DEATH_HARVEST_ORB.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)EpicFightEntityTypes.DODGE_LOCATION_INDICATOR.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)EpicFightEntityTypes.WITHER_GHOST_CLONE.get(), WitherGhostRenderer::new);
        event.registerEntityRenderer((EntityType)EpicFightEntityTypes.WITHER_SKELETON_MINION.get(), WitherSkeletonMinionRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)EpicFightBlockEntities.FRACTURE.get(), FractureBlockRenderer::new);
    }

    @SubscribeEvent
    public static void epicfight$registerStage(RenderLevelStageEvent.RegisterStageEvent event) {
        RenderItemBase.initItemRenderers(Minecraft.getInstance());
    }

    @SubscribeEvent
    public static void epicfight$addLayers(EntityRenderersEvent.AddLayers event) {
        WearableItemLayer.clearModels();
        SoftBodyTranslatable.TRACKING_SIMULATION_SUBJECTS.removeIf(ClothSimulatable::invalid);
        for (ClothSimulatable simOwner : SoftBodyTranslatable.TRACKING_SIMULATION_SUBJECTS) {
            simOwner.getClothSimulator().getAllRunningObjects().forEach(entry -> simOwner.getClothSimulator().restart((ResourceLocation)entry.getKey()));
        }
    }

    @SubscribeEvent
    public static void epicfight$registerGuiOverlaysEvent(RegisterGuiLayersEvent event) {
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"stamina_bar"), RenderEngine.getInstance().battleModeHUD::renderStaminaBar);
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"skills"), RenderEngine.getInstance().battleModeHUD::renderNormalSkills);
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"weapon_innate"), RenderEngine.getInstance().battleModeHUD::renderWeaponInnateSkill);
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"charging_bar"), RenderEngine.getInstance().battleModeHUD::renderChargingBar);
    }

    private static ResourceLocation wrapItemModelPath(ResourceLocation rl) {
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)("item/" + rl.getPath()));
    }

    @SubscribeEvent
    public static void registerAdditionalEvent(ModelEvent.RegisterAdditional event) {
        SkillCategory.ENUM_MANAGER.universalValues().stream().filter(skillCategory -> !skillCategory.bookIcon().equals((Object)SkillCategory.DEFAULT_BOOK_ICON)).forEach(skillCategory -> event.register(new ModelResourceLocation(ClientModBusEvent.wrapItemModelPath(skillCategory.bookIcon()), "standalone")));
    }

    @SubscribeEvent
    public static void modifyBakingResultEvent(ModelEvent.ModifyBakingResult event) {
        ModelResourceLocation skillbookLocation = new ModelResourceLocation(SkillCategory.DEFAULT_BOOK_ICON, "inventory");
        if (event.getModels().containsKey(skillbookLocation)) {
            ArrayList skillCategoryOverrides = new ArrayList();
            SkillCategory.ENUM_MANAGER.universalValues().stream().filter(skillCategory -> !skillCategory.bookIcon().equals((Object)SkillCategory.DEFAULT_BOOK_ICON)).sorted((c1, c2) -> Integer.compare(c2.universalOrdinal(), c1.universalOrdinal())).forEach(skillCategory -> {
                ModelResourceLocation model = new ModelResourceLocation(ClientModBusEvent.wrapItemModelPath(skillCategory.bookIcon()), "standalone");
                ItemOverrides.PropertyMatcher[] propertyMatchers = new ItemOverrides.PropertyMatcher[]{new ItemOverrides.PropertyMatcher(0, (float)skillCategory.universalOrdinal())};
                BakedModel bakedModel = (BakedModel)event.getModelBakery().getBakedTopLevelModels().get(model);
                skillCategoryOverrides.add(new ItemOverrides.BakedOverride(propertyMatchers, bakedModel));
            });
            ItemOverrides overrides = ((BakedModel)event.getModels().get(skillbookLocation)).getOverrides();
            overrides.overrides = (ItemOverrides.BakedOverride[])skillCategoryOverrides.toArray(ItemOverrides.BakedOverride[]::new);
            overrides.properties = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"skill")};
        }
    }
}

