/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events.engine;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.client.input.PlayerInputState;
import yesman.epicfight.api.client.input.action.EpicFightInputActions;
import yesman.epicfight.api.client.input.handlers.InputManager;
import yesman.epicfight.api.client.neoevent.MappedMovementInputUpdateEvent;
import yesman.epicfight.api.neoevent.playerpatch.SkillCastEvent;
import yesman.epicfight.api.utils.FakeLevel;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.IEventBasedEngine;
import yesman.epicfight.client.gui.screen.SkillEditScreen;
import yesman.epicfight.client.gui.screen.config.IngameConfigurationScreen;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.modules.ChargeableSkill;
import yesman.epicfight.skill.modules.HoldableSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.skill.PlayerSkills;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public class ControlEngine
implements IEventBasedEngine {
    private static final ControlEngine INSTANCE = new ControlEngine();
    private final Set<CustomPacketPayload> packetsToSend = new HashSet<CustomPacketPayload>();
    private final Minecraft minecraft = Minecraft.getInstance();
    private LocalPlayer player;
    private LocalPlayerPatch playerpatch;
    private int weaponInnatePressCounter = 0;
    private int sneakPressCounter = 0;
    private int moverPressCounter = 0;
    private int tickSinceLastJump = 0;
    private int lastHotbarLockedTime;
    private boolean weaponInnatePressToggle = false;
    private boolean sneakPressToggle = false;
    private boolean moverPressToggle = false;
    private boolean attackLightPressToggle = false;
    private boolean hotbarLocked;
    private boolean holdingFinished;
    private int reserveCounter;
    @Deprecated
    private KeyMapping reservedKey;
    private SkillSlot reservedOrHoldingSkillSlot;
    @Deprecated
    private KeyMapping currentHoldingKey;
    public Options options;

    public static ControlEngine getInstance() {
        return INSTANCE;
    }

    private ControlEngine() {
        if (this.minecraft != null) {
            this.options = this.minecraft.options;
        }
    }

    public void reloadPlayerPatch(LocalPlayerPatch playerpatch) {
        this.weaponInnatePressCounter = 0;
        this.weaponInnatePressToggle = false;
        this.sneakPressCounter = 0;
        this.sneakPressToggle = false;
        this.attackLightPressToggle = false;
        this.player = (LocalPlayer)playerpatch.getOriginal();
        this.playerpatch = playerpatch;
    }

    public LocalPlayerPatch getPlayerPatch() {
        return this.playerpatch;
    }

    public boolean canPlayerMove(EntityState playerState) {
        return !playerState.movementLocked() || this.player.jumpableVehicle() != null;
    }

    public boolean canPlayerRotate(EntityState playerState) {
        return !playerState.turningLocked() || this.player.jumpableVehicle() != null;
    }

    public void handleEpicFightKeyMappings() {
        SkillContainer container;
        Object skillCastEvent;
        if (this.playerpatch == null) {
            return;
        }
        InputManager.triggerOnPress(EpicFightInputActions.OPEN_SKILL_SCREEN, false, this::openSkillEditor);
        InputManager.triggerOnPress(EpicFightInputActions.OPEN_CONFIG_SCREEN, false, this::openConfig);
        InputManager.triggerOnPress(EpicFightInputActions.SWITCH_VANILLA_MODEL_DEBUGGING, false, this::switchVanillaModelDebugging);
        InputManager.triggerOnPress(EpicFightInputActions.ATTACK, true, this::maybeAttack);
        InputManager.triggerOnPress(EpicFightInputActions.DODGE, true, this::maybeDodge);
        if (InputManager.isActionActive(EpicFightInputActions.GUARD)) {
            this.maybeGuard();
        }
        InputManager.triggerOnPress(EpicFightInputActions.WEAPON_INNATE_SKILL, true, this::handleSeparateWeaponInnateSkill);
        InputManager.triggerOnPress(EpicFightInputActions.MOBILITY, true, this::maybePerformMoverSkill);
        InputManager.triggerOnPress(EpicFightInputActions.SWITCH_MODE, false, this::switchMode);
        InputManager.triggerOnPress(EpicFightInputActions.LOCK_ON, false, this.playerpatch::toggleLockOn);
        if (ControlEngine.shouldDisableSwapHandItems()) {
            ControlEngine.consumeSwapOffhandKeyClicks();
        }
        if (!this.playerpatch.isEpicFightMode() || Minecraft.getInstance().isPaused()) {
            return;
        }
        if (this.player.tickCount - this.lastHotbarLockedTime > 20 && this.hotbarLocked) {
            this.unlockHotkeys();
        }
        if (this.weaponInnatePressToggle) {
            if (!InputManager.isActionActive(EpicFightInputActions.WEAPON_INNATE_SKILL)) {
                this.attackLightPressToggle = true;
                this.weaponInnatePressToggle = false;
                this.weaponInnatePressCounter = 0;
            } else if (InputManager.isBoundToSamePhysicalInput(EpicFightInputActions.WEAPON_INNATE_SKILL, EpicFightInputActions.ATTACK)) {
                if (this.weaponInnatePressCounter > ClientConfig.longPressCounter) {
                    if (this.playerpatch.getSkill(SkillSlots.WEAPON_INNATE).sendCastRequest(this.playerpatch, this).shouldReserveKey()) {
                        if (!this.player.isSpectator()) {
                            this.reserveKey((SkillSlot)SkillSlots.WEAPON_INNATE, EpicFightInputActions.WEAPON_INNATE_SKILL);
                        }
                    } else {
                        this.lockHotkeys();
                    }
                    this.weaponInnatePressToggle = false;
                    this.weaponInnatePressCounter = 0;
                } else {
                    ++this.weaponInnatePressCounter;
                }
            }
        }
        if (this.attackLightPressToggle) {
            SkillContainer airSlash = this.playerpatch.getSkill(SkillSlots.AIR_SLASH);
            SkillSlots slot = this.tickSinceLastJump > 0 && airSlash.getSkill() != null && airSlash.getSkill().canExecute(airSlash) ? SkillSlots.AIR_SLASH : SkillSlots.COMBO_ATTACKS;
            skillCastEvent = this.playerpatch.getSkill(slot).sendCastRequest(this.playerpatch, this);
            if (skillCastEvent.isExecutable()) {
                this.player.resetAttackStrengthTicker();
                this.releaseAllServedKeys();
            } else if (!this.player.isSpectator() && slot == SkillSlots.COMBO_ATTACKS) {
                this.reserveKey((SkillSlot)slot, EpicFightInputActions.ATTACK);
            }
            this.lockHotkeys();
            this.attackLightPressToggle = false;
            this.weaponInnatePressToggle = false;
            this.weaponInnatePressCounter = 0;
        }
        if (this.sneakPressToggle) {
            if (!InputManager.isActionActive(EpicFightInputActions.SNEAK)) {
                SkillSlots skillSlot = this.playerpatch.getEntityState().knockDown() ? SkillSlots.KNOCKDOWN_WAKEUP : SkillSlots.DODGE;
                SkillContainer skill = this.playerpatch.getSkill(skillSlot);
                if (skill.sendCastRequest(this.playerpatch, this).shouldReserveKey()) {
                    this.reserveKey((SkillSlot)skillSlot, EpicFightInputActions.SNEAK);
                }
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else if (this.sneakPressCounter > ClientConfig.longPressCounter) {
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else {
                ++this.sneakPressCounter;
            }
        }
        if (this.currentHoldingKey != null && !(container = this.playerpatch.getSkill(this.reservedOrHoldingSkillSlot)).isEmpty()) {
            if (container.getSkill() instanceof HoldableSkill) {
                if (!this.isCurrentHoldingActionActive()) {
                    this.holdingFinished = true;
                }
                if ((skillCastEvent = container.getSkill()) instanceof ChargeableSkill) {
                    ChargeableSkill chargingSkill = (ChargeableSkill)skillCastEvent;
                    if (this.holdingFinished) {
                        if (this.playerpatch.getSkillChargingTicks() > chargingSkill.getMinChargingTicks()) {
                            container.sendCastRequest(this.playerpatch, this);
                            this.releaseAllServedKeys();
                        }
                    } else if (this.playerpatch.getSkillChargingTicks() >= chargingSkill.getAllowedMaxChargingTicks()) {
                        this.releaseAllServedKeys();
                    }
                } else if (this.holdingFinished) {
                    this.playerpatch.resetHolding();
                    CompoundTag arguments = new CompoundTag();
                    container.getSkill().gatherArguments(container, this, arguments);
                    container.getSkill().cancelOnClient(container, arguments);
                    container.sendCancelRequest(this.playerpatch, this);
                    this.releaseAllServedKeys();
                }
            } else {
                this.releaseAllServedKeys();
            }
        }
        if (this.reservedKey != null) {
            if (this.reserveCounter > 0) {
                SkillContainer skill = this.playerpatch.getSkill(this.reservedOrHoldingSkillSlot);
                --this.reserveCounter;
                if (skill.getSkill() != null && skill.sendCastRequest(this.playerpatch, this).isExecutable()) {
                    this.releaseAllServedKeys();
                    this.lockHotkeys();
                }
            } else {
                this.releaseAllServedKeys();
            }
        }
        if (this.isSwitchOrDropBlocked()) {
            ControlEngine.disableHotbarSlotPresses();
            ControlEngine.consumeDropKeyClicks();
        }
    }

    private void openSkillEditor() {
        PlayerSkills playerSkills = this.playerpatch.getPlayerSkills();
        if (playerSkills == null) {
            return;
        }
        this.minecraft.setScreen((Screen)new SkillEditScreen((Player)this.player, playerSkills));
    }

    private void openConfig() {
        this.minecraft.setScreen((Screen)new IngameConfigurationScreen(null, null));
    }

    private void switchVanillaModelDebugging() {
        boolean flag = ClientEngine.getInstance().switchVanillaModelDebuggingMode();
        this.minecraft.keyboardHandler.debugFeedbackTranslated(flag ? "debug.vanilla_model_debugging.on" : "debug.vanilla_model_debugging.off", new Object[0]);
    }

    private void maybeAttack() {
        if (!this.playerpatch.isEpicFightMode() || this.isCurrentHoldingAction(EpicFightInputActions.ATTACK)) {
            return;
        }
        EpicFightInputActions vanillaAttack = EpicFightInputActions.VANILLA_ATTACK_DESTROY;
        EpicFightInputActions epicFightAttack = EpicFightInputActions.ATTACK;
        boolean shouldPlayAttackAnimation = this.playerpatch.canPlayAttackAnimation();
        if (vanillaAttack.keyMapping().getKey() == epicFightAttack.keyMapping().getKey() && Minecraft.getInstance().hitResult != null && shouldPlayAttackAnimation) {
            ControlEngine.consumeVanillaAttackKeyClicks();
        }
        if (shouldPlayAttackAnimation) {
            if (!InputManager.isBoundToSamePhysicalInput(epicFightAttack, EpicFightInputActions.WEAPON_INNATE_SKILL)) {
                SkillContainer airSlash = this.playerpatch.getSkill(SkillSlots.AIR_SLASH);
                SkillSlots slot = this.tickSinceLastJump > 0 && airSlash.getSkill() != null && airSlash.getSkill().canExecute(airSlash) ? SkillSlots.AIR_SLASH : SkillSlots.COMBO_ATTACKS;
                SkillCastEvent skillCastEvent = this.playerpatch.getSkill(slot).sendCastRequest(this.playerpatch, this);
                if (skillCastEvent.isExecutable()) {
                    this.player.resetAttackStrengthTicker();
                    this.attackLightPressToggle = false;
                    this.releaseAllServedKeys();
                } else if (!this.player.isSpectator() && slot == SkillSlots.COMBO_ATTACKS) {
                    this.reserveKey((SkillSlot)slot, epicFightAttack);
                }
                this.lockHotkeys();
                this.attackLightPressToggle = false;
                this.weaponInnatePressToggle = false;
                this.weaponInnatePressCounter = 0;
            } else if (!this.weaponInnatePressToggle) {
                this.weaponInnatePressToggle = true;
            }
        }
    }

    private void maybeDodge() {
        if (!this.playerpatch.isEpicFightMode() || this.isCurrentHoldingAction(EpicFightInputActions.DODGE)) {
            return;
        }
        if (InputManager.isBoundToSamePhysicalInput(EpicFightInputActions.DODGE, EpicFightInputActions.SNEAK)) {
            if (this.player.getVehicle() == null && !this.sneakPressToggle) {
                this.sneakPressToggle = true;
            }
        } else {
            SkillSlots skillCategory = this.playerpatch.getEntityState().knockDown() ? SkillSlots.KNOCKDOWN_WAKEUP : SkillSlots.DODGE;
            SkillContainer skill = this.playerpatch.getSkill(skillCategory);
            if (!skill.isEmpty() && skill.sendCastRequest(this.playerpatch, this).shouldReserveKey()) {
                this.reserveKey((SkillSlot)SkillSlots.DODGE, EpicFightInputActions.DODGE);
            }
        }
    }

    private void maybeGuard() {
        if (!this.playerpatch.isEpicFightMode() || this.isCurrentHoldingAction(EpicFightInputActions.GUARD)) {
            return;
        }
        boolean shouldCancelGuard = false;
        if (this.playerpatch.isHoldingAny()) {
            shouldCancelGuard = true;
        } else if (ShieldItem.class.isAssignableFrom(this.player.getMainHandItem().getItem().getClass()) || ShieldItem.class.isAssignableFrom(this.player.getOffhandItem().getItem().getClass())) {
            shouldCancelGuard = true;
        }
        if (!shouldCancelGuard) {
            SkillCastEvent skillCastEvent = this.playerpatch.getSkill(SkillSlots.GUARD).sendCastRequest(this.playerpatch, this);
            if (skillCastEvent.shouldReserveKey()) {
                if (!this.player.isSpectator()) {
                    this.reserveKey((SkillSlot)SkillSlots.GUARD, EpicFightInputActions.GUARD);
                }
            } else {
                this.lockHotkeys();
            }
        }
    }

    private void handleSeparateWeaponInnateSkill() {
        if (!this.playerpatch.isEpicFightMode() || this.isCurrentHoldingAction(EpicFightInputActions.WEAPON_INNATE_SKILL)) {
            return;
        }
        if (!InputManager.isBoundToSamePhysicalInput(EpicFightInputActions.ATTACK, EpicFightInputActions.WEAPON_INNATE_SKILL)) {
            if (this.playerpatch.getSkill(SkillSlots.WEAPON_INNATE).sendCastRequest(this.playerpatch, this).shouldReserveKey()) {
                if (!this.player.isSpectator()) {
                    this.reserveKey((SkillSlot)SkillSlots.WEAPON_INNATE, EpicFightInputActions.WEAPON_INNATE_SKILL);
                }
            } else {
                this.lockHotkeys();
            }
        }
    }

    private void maybePerformMoverSkill() {
        if (!this.playerpatch.isEpicFightMode() || this.playerpatch.isHoldingAny()) {
            return;
        }
        if (InputManager.isBoundToSamePhysicalInput(EpicFightInputActions.MOBILITY, EpicFightInputActions.JUMP)) {
            SkillCastEvent event;
            SkillContainer skillContainer = this.playerpatch.getSkill(SkillSlots.MOVER);
            if (!skillContainer.isEmpty() && skillContainer.canUse(this.playerpatch, event = new SkillCastEvent(this.playerpatch, skillContainer, null)) && this.player.getVehicle() == null && !this.moverPressToggle) {
                this.moverPressToggle = true;
            }
        } else {
            SkillContainer skill = this.playerpatch.getSkill(SkillSlots.MOVER);
            skill.sendCastRequest(this.playerpatch, this);
        }
    }

    private void switchMode() {
        boolean canSwitch = EpicFightGameRules.CAN_SWITCH_PLAYER_MODE.getRuleValue(((LocalPlayer)this.playerpatch.getOriginal()).level());
        if (!canSwitch) {
            this.minecraft.gui.getChat().addMessage((Component)Component.translatable((String)"epicfight.messages.mode_switching_disabled").withStyle(ChatFormatting.RED));
            return;
        }
        this.playerpatch.toggleMode();
    }

    private PlayerInputState inputTick(Input input) {
        if (this.tickSinceLastJump > 0) {
            --this.tickSinceLastJump;
        }
        PlayerInputState inputState = InputManager.getInputState(input);
        if (this.moverPressToggle) {
            if (!InputManager.isActionActive(EpicFightInputActions.JUMP)) {
                this.moverPressToggle = false;
                this.moverPressCounter = 0;
                if (this.player.onGround()) {
                    this.player.noJumpDelay = 0;
                    inputState = inputState.withJumping(true);
                    InputManager.setInputState(inputState);
                }
            } else if (this.moverPressCounter > ClientConfig.longPressCounter) {
                SkillContainer skill = this.playerpatch.getSkill(SkillSlots.MOVER);
                skill.sendCastRequest(this.playerpatch, this);
                this.moverPressToggle = false;
                this.moverPressCounter = 0;
            } else {
                this.player.noJumpDelay = 2;
                ++this.moverPressCounter;
            }
        }
        if (!this.canPlayerMove(this.playerpatch.getEntityState())) {
            inputState = inputState.copyWith(Float.valueOf(0.0f), Float.valueOf(0.0f), false, false, false, false, false, false);
            InputManager.setInputState(inputState);
            this.player.sprintTriggerTime = -1;
            this.player.setSprinting(false);
        }
        return inputState;
    }

    @Deprecated(forRemoval=true)
    private void reserveKey(SkillSlot slot, KeyMapping keyMapping) {
        this.reservedKey = keyMapping;
        this.reservedOrHoldingSkillSlot = slot;
        this.reserveCounter = 8;
    }

    private void reserveKey(SkillSlot slot, EpicFightInputActions action) {
        this.reserveKey(slot, action.keyMapping());
    }

    public void releaseAllServedKeys() {
        this.holdingFinished = true;
        this.currentHoldingKey = null;
        this.reservedOrHoldingSkillSlot = null;
        this.reserveCounter = -1;
        this.reservedKey = null;
    }

    public void setHoldingKey(SkillSlot chargingSkillSlot, KeyMapping keyMapping) {
        this.holdingFinished = false;
        this.currentHoldingKey = keyMapping;
        this.reservedOrHoldingSkillSlot = chargingSkillSlot;
        this.reserveCounter = -1;
        this.reservedKey = null;
    }

    public void lockHotkeys() {
        this.hotbarLocked = true;
        this.lastHotbarLockedTime = this.player.tickCount;
        ControlEngine.disableHotbarSlotPresses();
    }

    public void unlockHotkeys() {
        this.hotbarLocked = false;
    }

    public void addPacketToSend(CustomPacketPayload packet) {
        this.packetsToSend.add(packet);
    }

    @Deprecated(forRemoval=true)
    public static boolean isKeyDown(KeyMapping key) {
        if (key.getKey().getType() == InputConstants.Type.KEYSYM) {
            return key.isDown() || GLFW.glfwGetKey((long)Minecraft.getInstance().getWindow().getWindow(), (int)key.getKey().getValue()) > 0;
        }
        if (key.getKey().getType() == InputConstants.Type.MOUSE) {
            return key.isDown() || GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)key.getKey().getValue()) > 0;
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    private static boolean isKeyPressed(KeyMapping key, boolean eventCheck) {
        int mouseButton;
        InputEvent.InteractionKeyMappingTriggered inputEvent;
        boolean consumes = key.consumeClick();
        if (consumes && eventCheck && (inputEvent = ClientHooks.onClickInput((int)(mouseButton = InputConstants.Type.MOUSE == key.getKey().getType() ? key.getKey().getValue() : -1), (KeyMapping)key, (InteractionHand)InteractionHand.MAIN_HAND)).isCanceled()) {
            return false;
        }
        return consumes;
    }

    @Deprecated(forRemoval=false)
    public static void makeUnpressed(KeyMapping keyMapping) {
        while (keyMapping.consumeClick()) {
        }
        KeyMapping.set((InputConstants.Key)keyMapping.getKey(), (boolean)false);
    }

    @Deprecated(forRemoval=true)
    public static void setKeyBind(KeyMapping key, boolean setter) {
        KeyMapping.set((InputConstants.Key)key.getKey(), (boolean)setter);
    }

    public static void setSprintingKeyStateNotDown() {
        KeyMapping.set((InputConstants.Key)EpicFightInputActions.SPRINT.keyMapping().getKey(), (boolean)false);
    }

    @ApiStatus.Internal
    public static boolean shouldDisableVanillaAttack() {
        LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerpatch == null) {
            return false;
        }
        return playerpatch.isEpicFightMode() && playerpatch.canPlayAttackAnimation();
    }

    @ApiStatus.Internal
    public static boolean shouldDisableSwapHandItems() {
        LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerpatch == null) {
            return false;
        }
        return playerpatch.getEntityState().inaction() || !playerpatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).canBePlacedOffhand();
    }

    private static void consumeVanillaAttackKeyClicks() {
        ControlEngine.makeUnpressed(EpicFightInputActions.VANILLA_ATTACK_DESTROY.keyMapping());
    }

    private static void consumeSwapOffhandKeyClicks() {
        ControlEngine.makeUnpressed(EpicFightInputActions.SWAP_OFF_HAND.keyMapping());
    }

    private static void disableHotbarSlotPresses() {
        KeyMapping[] hotbarSlots = Minecraft.getInstance().options.keyHotbarSlots;
        for (int i = 0; i < 9; ++i) {
            KeyMapping hotbarSlot = hotbarSlots[i];
            ControlEngine.makeUnpressed(hotbarSlot);
        }
    }

    private static void consumeDropKeyClicks() {
        ControlEngine.makeUnpressed(EpicFightInputActions.DROP.keyMapping());
    }

    @Nullable
    private static EpicFightInputActions mapKeyMappingToAction(@NotNull KeyMapping keyMapping) {
        return EpicFightInputActions.fromKeyMapping(keyMapping);
    }

    private boolean isCurrentHoldingAction(@NotNull EpicFightInputActions other) {
        if (this.currentHoldingKey == null) {
            return false;
        }
        EpicFightInputActions currentHoldingAction = ControlEngine.mapKeyMappingToAction(this.currentHoldingKey);
        if (currentHoldingAction == null) {
            return this.currentHoldingKey == other.keyMapping();
        }
        return other == currentHoldingAction;
    }

    private boolean isCurrentHoldingActionActive() {
        if (this.currentHoldingKey == null) {
            return false;
        }
        EpicFightInputActions currentHoldingAction = ControlEngine.mapKeyMappingToAction(this.currentHoldingKey);
        if (currentHoldingAction == null) {
            return ControlEngine.isKeyDown(this.currentHoldingKey);
        }
        return InputManager.isActionActive(currentHoldingAction);
    }

    @ApiStatus.Internal
    public static boolean isHotbarCyclingDisabled() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        return minecraft.player != null && localPlayerPatch != null && !localPlayerPatch.getEntityState().canSwitchHoldingItem() && minecraft.screen == null;
    }

    public boolean isSwitchOrDropBlocked() {
        return !this.playerpatch.getEntityState().canSwitchHoldingItem() || this.hotbarLocked;
    }

    public boolean moverToggling() {
        return this.moverPressToggle;
    }

    public boolean sneakToggling() {
        return this.sneakPressToggle;
    }

    public boolean attackToggling() {
        return this.attackLightPressToggle;
    }

    public boolean weaponInnateToggling() {
        return this.weaponInnatePressToggle;
    }

    private void epicfight$mouseScrollEvent(InputEvent.MouseScrollingEvent event) {
        if (ControlEngine.isHotbarCyclingDisabled()) {
            event.setCanceled(true);
        }
    }

    private void epicfight$moveInputEvent(MovementInputUpdateEvent event) {
        if (this.playerpatch == null) {
            return;
        }
        PlayerInputState playerinputstate = this.inputTick(event.getInput());
        MappedMovementInputUpdateEvent wrappedEvent = new MappedMovementInputUpdateEvent(this.playerpatch, playerinputstate);
        this.playerpatch.getPlayerSkills().fireSkillEvents("epicfight", wrappedEvent);
    }

    private void epicfight$clientTickEndEvent(ClientTickEvent.Post event) {
        if (this.player == null) {
            return;
        }
        this.packetsToSend.forEach(x$0 -> EpicFightNetworkManager.sendToServer(x$0, new CustomPacketPayload[0]));
        this.packetsToSend.clear();
    }

    private void epicfight$interactionKeyMappingTriggered(InputEvent.InteractionKeyMappingTriggered event) {
        if (this.minecraft.player == null || this.minecraft.hitResult == null) {
            return;
        }
        EpicFightInputActions triggeredAction = ControlEngine.mapKeyMappingToAction(event.getKeyMapping());
        if (triggeredAction == null) {
            return;
        }
        if (triggeredAction == EpicFightInputActions.VANILLA_ATTACK_DESTROY && InputManager.isBoundToSamePhysicalInput(EpicFightInputActions.ATTACK, EpicFightInputActions.VANILLA_ATTACK_DESTROY) && this.minecraft.hitResult.getType() == HitResult.Type.BLOCK && ClientConfig.combatPreferredItems.contains(this.player.getMainHandItem().getItem())) {
            BlockPos bp = ((BlockHitResult)this.minecraft.hitResult).getBlockPos();
            BlockState bs = this.minecraft.level.getBlockState(bp);
            if (!this.player.getMainHandItem().getItem().canAttackBlock(bs, this.player.level(), bp, (Player)this.player) || this.player.getMainHandItem().getDestroySpeed(bs) <= 1.0f) {
                event.setSwingHand(false);
                event.setCanceled(true);
            }
        }
        if (triggeredAction == EpicFightInputActions.USE && InputManager.isBoundToSamePhysicalInput(EpicFightInputActions.USE, EpicFightInputActions.GUARD) && (ClientConfig.keyConflictResolveScope.cancelInteraction() || ClientConfig.keyConflictResolveScope.cancelItemUse())) {
            MutableBoolean canGuard = new MutableBoolean();
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class).ifPresent(playerpatch -> {
                SkillContainer skillcontainer = playerpatch.getSkill(SkillSlots.GUARD);
                if (skillcontainer.getSkill() != null && skillcontainer.getSkill().canExecute(skillcontainer)) {
                    canGuard.setValue(true);
                }
            });
            if (this.minecraft.hitResult.getType() == HitResult.Type.MISS) {
                if (canGuard.booleanValue() && ClientConfig.keyConflictResolveScope.cancelItemUse()) {
                    event.setSwingHand(false);
                    event.setCanceled(true);
                }
            } else if (canGuard.booleanValue()) {
                InteractionResult interactionResult = switch (this.minecraft.hitResult.getType()) {
                    case HitResult.Type.ENTITY -> ((EntityHitResult)this.minecraft.hitResult).getEntity().interact((Player)this.minecraft.player, event.getHand());
                    case HitResult.Type.BLOCK -> {
                        BlockHitResult blockHitResult = (BlockHitResult)this.minecraft.hitResult;
                        BlockPos blockpos = blockHitResult.getBlockPos();
                        BlockState blockstate = this.minecraft.level.getBlockState(blockpos);
                        FakeLevel fakeLevelForSimulation = FakeLevel.getFakeLevel(this.minecraft.level);
                        FakeLevel.FakeClientPlayer fakePlayerForSimulation = FakeLevel.getFakePlayer(this.minecraft.player.getGameProfile());
                        InteractionResult useItemInteractionResult = blockstate.useItemOn(this.player.getItemInHand(event.getHand()), (Level)fakeLevelForSimulation, (Player)fakePlayerForSimulation, event.getHand(), blockHitResult).result();
                        if (useItemInteractionResult != InteractionResult.PASS) {
                            yield useItemInteractionResult;
                        }
                        yield blockstate.useWithoutItem((Level)fakeLevelForSimulation, (Player)fakePlayerForSimulation, blockHitResult);
                    }
                    default -> throw new IllegalArgumentException();
                };
                if (interactionResult != InteractionResult.PASS && ClientConfig.keyConflictResolveScope.cancelInteraction()) {
                    event.setSwingHand(false);
                    event.setCanceled(true);
                } else if (interactionResult == InteractionResult.PASS && ClientConfig.keyConflictResolveScope.cancelItemUse()) {
                    event.setSwingHand(false);
                    event.setCanceled(true);
                }
            }
        }
    }

    private void epicfight$livingJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() == this.player) {
            this.tickSinceLastJump = 5;
        }
    }

    @Override
    public void gameEventBus(IEventBus gameEventBus) {
        gameEventBus.addListener(this::epicfight$mouseScrollEvent);
        gameEventBus.addListener(this::epicfight$moveInputEvent);
        gameEventBus.addListener(this::epicfight$clientTickEndEvent);
        gameEventBus.addListener(this::epicfight$interactionKeyMappingTriggered);
        gameEventBus.addListener(this::epicfight$livingJumpEvent);
    }

    @Override
    public void modEventBus(IEventBus modEventBus) {
    }
}

