/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.compat;

import mod.azure.azurelib.neoforge.event.GeoRenderEvent;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import yesman.epicfight.api.client.model.transformer.AzureModelTransformer;
import yesman.epicfight.api.client.model.transformer.HumanoidModelBaker;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.gui.EntityUI;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.compat.ICompatModule;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public class AzureLibCompat
implements ICompatModule {
    @Override
    public void onModEventBus(IEventBus eventBus) {
    }

    @Override
    public void onGameEventBus(IEventBus eventBus) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onModEventBusClient(IEventBus eventBus) {
        HumanoidModelBaker.registerNewTransformer(new AzureModelTransformer());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onGameEventBusClient(IEventBus eventBus) {
        eventBus.addListener(AzureModelTransformer::getGeoArmorTexturePath);
        eventBus.addListener(this::geoEntityRenderPreEvent);
        eventBus.addListener(this::geoEntityRenderPostEvent);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void geoEntityRenderPreEvent(GeoRenderEvent.Entity.Pre event) {
        Entity entity = event.getEntity();
        if (entity.level() == null) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            RenderEngine renderEngine = RenderEngine.getInstance();
            if (renderEngine.hasRendererFor((Entity)livingentity)) {
                LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)livingentity, LivingEntityPatch.class);
                LocalPlayerPatch playerpatch = null;
                float originalYRot = 0.0f;
                if ((event.getPartialTick() == 0.0f || event.getPartialTick() == 1.0f) && entitypatch instanceof LocalPlayerPatch) {
                    LocalPlayerPatch localPlayerPatch;
                    playerpatch = localPlayerPatch = (LocalPlayerPatch)entitypatch;
                    originalYRot = playerpatch.getModelYRot();
                    playerpatch.setModelYRotInGui(livingentity.getYRot());
                    event.getPoseStack().translate(0.0, 0.1, 0.0);
                }
                if (entitypatch != null && entitypatch.overrideRender()) {
                    event.setCanceled(true);
                    renderEngine.renderEntityArmatureModel(livingentity, entitypatch, (EntityRenderer<? extends Entity>)event.getRenderer(), event.getBufferSource(), event.getPoseStack(), event.getPackedLight(), event.getPartialTick());
                    if (ClientEngine.getInstance().getPlayerPatch() != null && !renderEngine.minecraft.options.hideGui && !EpicFightGameRules.DISABLE_ENTITY_UI.getRuleValue(livingentity.level()).booleanValue()) {
                        for (EntityUI entityIndicator : EntityUI.ENTITY_UI_LIST) {
                            if (!entityIndicator.shouldDraw(livingentity, entitypatch, ClientEngine.getInstance().getPlayerPatch(), event.getPartialTick())) continue;
                            entityIndicator.draw(livingentity, entitypatch, ClientEngine.getInstance().getPlayerPatch(), event.getPoseStack(), event.getBufferSource(), event.getPartialTick());
                        }
                    }
                }
                if (playerpatch != null) {
                    playerpatch.disableModelYRotInGui(originalYRot);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void geoEntityRenderPostEvent(GeoRenderEvent.Entity.Post event) {
        Entity entity = event.getEntity();
        if (entity.level() == null) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            RenderEngine renderEngine = RenderEngine.getInstance();
            if (ClientEngine.getInstance().getPlayerPatch() != null && !renderEngine.minecraft.options.hideGui && !EpicFightGameRules.DISABLE_ENTITY_UI.getRuleValue(livingentity.level()).booleanValue()) {
                LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)livingentity, LivingEntityPatch.class);
                for (EntityUI entityIndicator : EntityUI.ENTITY_UI_LIST) {
                    if (!entityIndicator.shouldDraw(livingentity, entitypatch, ClientEngine.getInstance().getPlayerPatch(), event.getPartialTick())) continue;
                    entityIndicator.draw(livingentity, entitypatch, ClientEngine.getInstance().getPlayerPatch(), event.getPoseStack(), event.getBufferSource(), event.getPartialTick());
                }
            }
        }
    }
}

