/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.client.model.WerewolfEarsModel;
import de.teamlapen.werewolves.client.render.layer.HumanWerewolfLayer;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.util.Helper;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.client.model.transformer.HumanoidModelBaker;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PPlayerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.client.world.capabilites.entitypatch.player.AbstractClientPlayerPatch;
import yesman.epicfight.compat.ICompatModule;
import yesman.epicfight.mixin.teamlapen.MixinHumanWerewolfLayer;

public class WerewolvesCompat
implements ICompatModule {
    @Override
    public void onModEventBus(IEventBus eventBus) {
    }

    @Override
    public void onGameEventBus(IEventBus eventBus) {
        eventBus.addListener(event -> {
            WerewolfForm form = WerewolfPlayer.get((Player)((Player)event.getPlayerPatch().getOriginal())).getForm();
            if (form == WerewolfForm.SURVIVALIST || form == WerewolfForm.BEAST) {
                event.setCanceled(true);
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onModEventBusClient(IEventBus eventBus) {
        eventBus.addListener(event -> {
            PatchedEntityRenderer patt0$temp = event.get(EntityType.PLAYER);
            if (patt0$temp instanceof PPlayerRenderer) {
                PPlayerRenderer playerrenderer = (PPlayerRenderer)patt0$temp;
                playerrenderer.addPatchedLayerAlways(HumanWerewolfLayer.class, new EpicFightHumanWerewolfLayer());
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onGameEventBusClient(IEventBus eventBus) {
        eventBus.addListener(event -> {
            WerewolfForm form = WerewolfPlayer.get((Player)((Player)event.getPlayerPatch().getOriginal())).getForm();
            if (form == WerewolfForm.SURVIVALIST || form == WerewolfForm.BEAST) {
                event.setShouldRender(false);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class EpicFightHumanWerewolfLayer<A extends HumanoidModel<AbstractClientPlayer>>
    extends PatchedLayer<AbstractClientPlayer, AbstractClientPlayerPatch<AbstractClientPlayer>, PlayerModel<AbstractClientPlayer>, HumanWerewolfLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>, A>> {
        private SkinnedMesh mesh;
        private SkinnedMesh slimMesh;

        @Override
        protected void renderLayer(AbstractClientPlayerPatch<AbstractClientPlayer> entitypatch, AbstractClientPlayer entityliving, HumanWerewolfLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>, A> vanillaLayer, PoseStack poseStack, MultiBufferSource buffer, int packedLight, OpenMatrix4f[] poses, float bob, float yRot, float xRot, float partialTicks) {
            SkinnedMesh mesh;
            MixinHumanWerewolfLayer accessor = (MixinHumanWerewolfLayer)vanillaLayer;
            String modelType = entityliving.getSkin().model().id();
            Object vanillaModel = accessor.getModel();
            if (vanillaModel instanceof WerewolfEarsModel) {
                WerewolfEarsModel werewolfEars = (WerewolfEarsModel)vanillaModel;
                werewolfEars.head.loadPose(werewolfEars.head.getInitialPose());
                werewolfEars.hat.loadPose(werewolfEars.hat.getInitialPose());
                werewolfEars.body.loadPose(werewolfEars.body.getInitialPose());
                werewolfEars.leftArm.loadPose(werewolfEars.leftArm.getInitialPose());
                werewolfEars.rightArm.loadPose(werewolfEars.rightArm.getInitialPose());
                werewolfEars.leftLeg.loadPose(werewolfEars.leftLeg.getInitialPose());
                werewolfEars.rightLeg.loadPose(werewolfEars.rightLeg.getInitialPose());
            }
            if ("default".equals(modelType)) {
                if (this.mesh == null) {
                    this.mesh = HumanoidModelBaker.VANILLA_TRANSFORMER.transformArmorModel((HumanoidModel<?>)vanillaModel);
                }
                mesh = this.mesh;
            } else {
                if (this.slimMesh == null) {
                    this.slimMesh = HumanoidModelBaker.VANILLA_TRANSFORMER.transformArmorModel((HumanoidModel<?>)vanillaModel);
                }
                mesh = this.slimMesh;
            }
            Helper.asIWerewolf((LivingEntity)entityliving).filter(werewolf -> werewolf.getForm() == WerewolfForm.HUMAN).ifPresent(werewolf -> {
                ResourceLocation texture = accessor.getTextures().get(werewolf.getSkinType() % accessor.getTextures().size());
                RenderType rendertype = EpicFightRenderTypes.getTriangulated(RenderType.entityCutoutNoCull((ResourceLocation)texture));
                mesh.draw(poseStack, buffer, rendertype, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, LivingEntityRenderer.getOverlayCoords((LivingEntity)entityliving, (float)0.0f), entitypatch.getArmature(), poses);
            });
        }
    }
}

