/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.data.loot;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.neoevent.SkillLootTableRegistryEvent;

public class OnSkillBookDroppedByEntity
extends LootModifier {
    public static final MapCodec<OnSkillBookDroppedByEntity> SKILL_CODEC = RecordCodecBuilder.mapCodec(instance -> OnSkillBookDroppedByEntity.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, OnSkillBookDroppedByEntity::new));
    private static final Map<EntityType<?>, LootTable> SKILL_LOOT_TABLE = Maps.newHashMap();

    public static void registerEntitySkillLootTable() {
        HashMap builders = new HashMap();
        SkillLootTableRegistryEvent entitySkillLootTable = new SkillLootTableRegistryEvent(builders);
        NeoForge.EVENT_BUS.post((Event)entitySkillLootTable);
        SKILL_LOOT_TABLE.clear();
        builders.forEach((k, v) -> SKILL_LOOT_TABLE.put((EntityType<?>)k, v.build()));
    }

    public OnSkillBookDroppedByEntity(LootItemCondition[] lootItemConditions) {
        super(lootItemConditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (entity != null && SKILL_LOOT_TABLE.containsKey(entity.getType())) {
            SKILL_LOOT_TABLE.get(entity.getType()).getRandomItemsRaw(context, arg_0 -> generatedLoot.add(arg_0));
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return SKILL_CODEC;
    }
}

